/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.util.stdlib;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.mwe.core.WorkflowContext;
import org.eclipse.emf.mwe.core.issues.Issues;
import org.eclipse.emf.mwe.core.lib.AbstractWorkflowComponent2;
import org.eclipse.emf.mwe.core.monitor.ProgressMonitor;
import org.eclipse.emf.mwe.core.resources.ResourceLoader;
import org.eclipse.emf.mwe.core.resources.ResourceLoaderFactory;
import org.eclipse.xtend.util.stdlib.PropertiesExtension;

public class PropertiesReader
extends AbstractWorkflowComponent2 {
    private static final Log LOG = LogFactory.getLog(PropertiesReader.class);
    private static final String COMPONENT_NAME = "Properties Reader";
    private List<String> propertiesFile;

    protected void checkConfigurationInternal(Issues issues) {
        if (this.propertiesFile == null || this.propertiesFile.isEmpty()) {
            issues.addError("propertiesFile not set. ");
        } else {
            for (String uri : this.propertiesFile) {
                URL url = ResourceLoaderFactory.createResourceLoader().getResource(uri);
                if (url != null) continue;
                issues.addError("propertiesFile '" + uri + "' not found.");
            }
        }
    }

    protected void invokeInternal(WorkflowContext ctx, ProgressMonitor monitor, Issues issues) {
        ResourceLoader rl = ResourceLoaderFactory.createResourceLoader();
        for (String uri : this.propertiesFile) {
            try {
                Properties p = new Properties();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Reading properties file " + uri);
                }
                p.load(rl.getResourceAsStream(uri));
                PropertiesExtension.setProperties(p);
            }
            catch (Exception e) {
                issues.addError(e.getMessage(), e);
            }
        }
    }

    public final void addPropertiesFile(String propFile) {
        if (this.propertiesFile == null) {
            this.propertiesFile = new ArrayList<String>();
        }
        this.propertiesFile.add(propFile);
    }

    public String getComponentName() {
        return COMPONENT_NAME;
    }
}

