/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.expression;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.mwe.core.WorkflowContext;
import org.eclipse.emf.mwe.core.WorkflowInterruptedException;
import org.eclipse.emf.mwe.core.issues.Issues;
import org.eclipse.emf.mwe.core.lib.AbstractWorkflowComponent2;
import org.eclipse.emf.mwe.core.monitor.ProgressMonitor;
import org.eclipse.internal.xtend.expression.ast.SyntaxElement;
import org.eclipse.internal.xtend.util.Pair;
import org.eclipse.xtend.expression.Callback;
import org.eclipse.xtend.expression.EvaluationException;
import org.eclipse.xtend.expression.ExceptionHandler;
import org.eclipse.xtend.expression.ExceptionRaisingNullEvaluationHandler;
import org.eclipse.xtend.expression.ExecutionContext;
import org.eclipse.xtend.expression.ExecutionContextImpl;
import org.eclipse.xtend.expression.ExpressionFacade;
import org.eclipse.xtend.expression.NullEvaluationHandler;
import org.eclipse.xtend.expression.ResourceManager;
import org.eclipse.xtend.expression.ResourceManagerDefaultImpl;
import org.eclipse.xtend.expression.TypeSystemImpl;
import org.eclipse.xtend.expression.Variable;
import org.eclipse.xtend.expression.VetoableCallback;
import org.eclipse.xtend.expression.VetoableCallbackAdapter;
import org.eclipse.xtend.type.impl.java.JavaBeansMetaModel;
import org.eclipse.xtend.typesystem.MetaModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractExpressionsUsingWorkflowComponent
extends AbstractWorkflowComponent2 {
    protected final Log log = LogFactory.getLog(this.getClass());
    protected final List<MetaModel> metaModels = new ArrayList<MetaModel>();
    private List<GlobalVarDef> globalVarDefs = new ArrayList<GlobalVarDef>();
    private List<GlobalVar> globalVars = new ArrayList<GlobalVar>();
    protected final List<String> _advice = new ArrayList<String>();
    protected VetoableCallback callback;
    private List<Debug> debugExpressions = new ArrayList<Debug>();
    private boolean dumpContext = false;
    protected boolean exceptionsOnNullEvaluation = false;
    protected ExceptionHandler exceptionHandler = null;
    private ResourceManager resourceManager;

    public void addAdvice(String advice) {
        String[] stringArray = advice.split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String singleAdvice = stringArray[n2];
            if ((singleAdvice = singleAdvice.trim()).length() != 0 && !this._advice.contains(singleAdvice)) {
                this._advice.add(singleAdvice);
            }
            ++n2;
        }
    }

    public void addAdvices(String advice) {
        this.addAdvice(advice);
    }

    public void addExtensionAdvice(String advice) {
        this.addAdvice(advice);
    }

    public void addExtensionAdvices(String advice) {
        this.addExtensionAdvice(advice);
    }

    public void addMetaModel(MetaModel metaModel) {
        assert (metaModel != null);
        this.metaModels.add(metaModel);
    }

    public void addGlobalVarDef(GlobalVarDef def) {
        this.globalVarDefs.add(def);
    }

    public void addGlobalVar(GlobalVar var) {
        this.globalVars.add(var);
    }

    protected Map<String, Variable> getGlobalVars(WorkflowContext ctx) {
        HashMap<String, Variable> result = new HashMap<String, Variable>();
        if (!this.globalVarDefs.isEmpty()) {
            ExecutionContextImpl ec = new ExecutionContextImpl();
            String[] stringArray = ctx.getSlotNames();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String slot = stringArray[n2];
                ec = (ExecutionContextImpl)ec.cloneWithVariable(new Variable(slot, ctx.get(slot)));
                ++n2;
            }
            for (MetaModel mm : this.metaModels) {
                ec.registerMetaModel(mm);
            }
            ExpressionFacade ef = new ExpressionFacade(ec);
            for (GlobalVarDef def : this.globalVarDefs) {
                Object value = ef.evaluate(def.getValue());
                result.put(def.getName(), new Variable(def.getName(), value));
            }
        }
        for (GlobalVar gv : this.globalVars) {
            result.put(gv.getName(), new Variable(gv.getName(), gv.getValue()));
        }
        return result;
    }

    @Deprecated
    public void setCallback(Callback callback) {
        this.callback = new VetoableCallbackAdapter(callback);
    }

    public void setVetoableCallback(VetoableCallback callback) {
        this.callback = callback;
    }

    protected ExecutionContextImpl getExecutionContext(WorkflowContext ctx) {
        ExecutionContextImpl executionContext = new ExecutionContextImpl(this.getResourceManager(), null, new TypeSystemImpl(), new HashMap<String, Variable>(), this.getGlobalVars(ctx), null, this.exceptionHandler, null, this.getNullEvaluationHandler(), null, this.callback, null, null);
        for (MetaModel mm : this.metaModels) {
            executionContext.registerMetaModel(mm);
        }
        return executionContext;
    }

    public NullEvaluationHandler getNullEvaluationHandler() {
        if (this.exceptionsOnNullEvaluation) {
            return new ExceptionRaisingNullEvaluationHandler();
        }
        return null;
    }

    @Override
    protected void checkConfigurationInternal(Issues issues) {
        if (this.metaModels.isEmpty()) {
            this.log.info("No meta models configured, using JavaBeans as default.");
            this.metaModels.add(new JavaBeansMetaModel());
        }
    }

    public void addDebug(Debug expr) {
        this.debugExpressions.add(expr);
    }

    public void setDumpContext(boolean dumpContext) {
        this.dumpContext = dumpContext;
    }

    @Override
    protected void invokeInternal(WorkflowContext ctx, ProgressMonitor monitor, final Issues issues) {
        try {
            if (this.exceptionHandler == null) {
                this.exceptionHandler = new ExceptionHandler(){

                    @Override
                    public void handleRuntimeException(RuntimeException ex, SyntaxElement element, ExecutionContext ctx, Map<String, Object> additionalContextInfo) {
                        issues.addError(AbstractExpressionsUsingWorkflowComponent.this, ex.getMessage(), element);
                        throw ex;
                    }
                };
            }
            this.invokeInternal2(ctx, monitor, issues);
        }
        catch (EvaluationException e) {
            if (e.getCause() != null) {
                this.log.error(e.getMessage(), e.getCause());
            }
            this.log.error("Error in Component" + (this.getId() == null ? " " : " " + this.getId()) + " of type " + this.getClass().getName() + ": \n\t" + this.toString(e, this.debugExpressions));
            throw new WorkflowInterruptedException(e.getMessage());
        }
    }

    public String toString(EvaluationException ex, List<Debug> debugEntries) {
        StringBuffer result = new StringBuffer("EvaluationException : " + ex.getMessage() + "\n");
        int widest = 0;
        for (Pair<SyntaxElement, ExecutionContext> ele : ex.getXtendStackTrace()) {
            int temp = EvaluationException.getLocationString(ele.getFirst()).length();
            if (temp <= widest) continue;
            widest = temp;
        }
        String indent = "";
        int l = 0;
        while (l < widest + 7) {
            indent = String.valueOf(indent) + " ";
            ++l;
        }
        int i = 0;
        int x = ex.getXtendStackTrace().size();
        while (i < x) {
            Pair<SyntaxElement, ExecutionContext> ele = ex.getXtendStackTrace().get(i);
            StringBuffer msg = new StringBuffer(EvaluationException.getLocationString(ele.getFirst()));
            int j = msg.length();
            while (j < widest) {
                msg.append(" ");
                ++j;
            }
            if (debugEntries.size() > i && debugEntries.get(i).getExpression() != null) {
                Debug d = debugEntries.get(i);
                try {
                    msg.append(" -- debug '").append(d.getExpression()).append("' = ");
                    msg.append(new ExpressionFacade(ele.getSecond()).evaluate("let x = " + d.getExpression() + " : x!=null ? x.toString() : 'null'"));
                }
                catch (Exception e) {
                    msg.append("Exception : ").append(e.getMessage());
                }
                msg.append("\n");
            }
            if (this.dumpContext || debugEntries.size() > i && debugEntries.get(i).isDumpContext()) {
                ExpressionFacade f = new ExpressionFacade(ele.getSecond());
                msg.append(" -- context dump : ");
                Iterator<String> iter = ele.getSecond().getVisibleVariables().keySet().iterator();
                while (iter.hasNext()) {
                    String v = iter.next();
                    msg.append(v).append(" = ").append(f.evaluate(String.valueOf(v) + "!=null?" + v + ".toString():'null'"));
                    if (!iter.hasNext()) continue;
                    msg.append(", \n");
                }
                msg.append("\n");
            }
            String[] evals = msg.toString().split("\n");
            int j2 = 0;
            while (j2 < evals.length) {
                String string = evals[j2];
                result.append(string);
                if (j2 + 1 < evals.length) {
                    result.append("\n").append(indent);
                }
                ++j2;
            }
            result.append("\n");
            ++i;
        }
        return result.toString();
    }

    protected void invokeInternal2(WorkflowContext ctx, ProgressMonitor monitor, Issues issues) {
    }

    public void setExceptionsOnNullEvaluation(boolean exceptionsOnNullEvaluation) {
        this.exceptionsOnNullEvaluation = exceptionsOnNullEvaluation;
    }

    public void setExceptionHandler(ExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    public ResourceManager getResourceManager() {
        if (this.resourceManager == null) {
            this.resourceManager = new ResourceManagerDefaultImpl();
        }
        return this.resourceManager;
    }

    public void setResourceManager(ResourceManager resourceManager) {
        this.resourceManager = resourceManager;
    }

    public static class Debug {
        private String expression;
        private boolean dumpContext = false;

        public void setDumpContext(boolean dumpContext) {
            this.dumpContext = dumpContext;
        }

        public boolean isDumpContext() {
            return this.dumpContext;
        }

        public void setExpression(String expression) {
            this.expression = expression;
        }

        public String getExpression() {
            return this.expression;
        }
    }

    public static class GlobalVar {
        private String name;
        private Object value;

        public void setName(String name) {
            this.name = name;
        }

        public void setValue(Object value) {
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public Object getValue() {
            return this.value;
        }
    }

    public static class GlobalVarDef {
        private String name;
        private String value;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }
}

