/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.check;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.mwe.core.WorkflowContext;
import org.eclipse.emf.mwe.core.WorkflowInterruptedException;
import org.eclipse.emf.mwe.core.issues.Issues;
import org.eclipse.emf.mwe.core.monitor.ProgressMonitor;
import org.eclipse.xtend.check.CheckFacade;
import org.eclipse.xtend.expression.AbstractExpressionsUsingWorkflowComponent;
import org.eclipse.xtend.expression.ExecutionContext;
import org.eclipse.xtend.expression.ExecutionContextImpl;
import org.eclipse.xtend.expression.ExpressionFacade;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckComponent
extends AbstractExpressionsUsingWorkflowComponent {
    private static final String COMPONENT_NAME = "Check component";
    private String expression = null;
    private List<String> checkFiles = new ArrayList<String>();
    private boolean abortOnError = true;
    private boolean warnIfNothingChecked = false;
    private String emfAllChildrenSlot;

    public void setAbortOnError(boolean abortOnError) {
        this.abortOnError = abortOnError;
    }

    public void addCheckFile(String checkFile) {
        this.checkFiles.add(checkFile);
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public void setWarnIfNothingChecked(boolean warn) {
        this.warnIfNothingChecked = warn;
    }

    public void setEmfAllChildrenSlot(String childExpression) {
        this.emfAllChildrenSlot = childExpression;
    }

    @Override
    public String getLogMessage() {
        StringBuilder b2 = new StringBuilder();
        if (this.emfAllChildrenSlot != null) {
            b2.append("slot " + this.emfAllChildrenSlot + " ");
        } else {
            b2.append("expression " + this.expression + " ");
        }
        b2.append("check file(s): ");
        for (String f : this.checkFiles) {
            b2.append(String.valueOf(f) + " ");
        }
        return b2.toString();
    }

    @Override
    public String getComponentName() {
        return COMPONENT_NAME;
    }

    @Override
    protected void invokeInternal2(WorkflowContext ctx, ProgressMonitor monitor, Issues issues) {
        ExecutionContextImpl executionContext = this.getExecutionContext(ctx);
        if (monitor != null) {
            executionContext.setMonitor(monitor);
        }
        Collection<?> model = this.getExpressionResult(executionContext, ctx, this.expression);
        for (String checkFile : this.checkFiles) {
            CheckFacade.checkAll(checkFile, model, executionContext, issues, this.warnIfNothingChecked);
        }
        if (this.abortOnError && issues.hasErrors()) {
            throw new WorkflowInterruptedException("Errors during validation.");
        }
    }

    @Override
    protected void checkConfigurationInternal(Issues issues) {
        super.checkConfigurationInternal(issues);
        if (this.expression == null && this.emfAllChildrenSlot != null) {
            this.expression = String.valueOf(this.emfAllChildrenSlot) + ".eAllContents.union( {" + this.emfAllChildrenSlot + "} )";
        } else if (this.expression == null || this.emfAllChildrenSlot != null) {
            issues.addError(this, "You have to set one of the properties 'expression' and 'emfAllChildrenSlot'!");
        }
        if (this.checkFiles.isEmpty()) {
            issues.addError(this, "Property 'checkFile' not set!");
        }
    }

    private Collection<?> getExpressionResult(ExecutionContext exeCtx, WorkflowContext context, String expression2) {
        ExpressionFacade f = new ExpressionFacade(exeCtx);
        HashMap<String, Object> ctx = new HashMap<String, Object>();
        String[] names = context.getSlotNames();
        int i = 0;
        while (i < names.length) {
            String name = names[i];
            ctx.put(name, context.get(name));
            ++i;
        }
        Object result = f.evaluate(expression2, ctx);
        if (result instanceof Collection) {
            return (Collection)result;
        }
        if (result == null) {
            return Collections.EMPTY_SET;
        }
        return Collections.singleton(result);
    }
}

