/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.mwe.core.WorkflowContext;
import org.eclipse.emf.mwe.core.issues.Issues;
import org.eclipse.emf.mwe.core.monitor.ProgressMonitor;
import org.eclipse.emf.mwe.core.resources.ResourceLoaderFactory;
import org.eclipse.internal.xtend.util.ProfileCollector;
import org.eclipse.xtend.expression.AbstractExpressionsUsingWorkflowComponent;
import org.eclipse.xtend.expression.ExecutionContextImpl;
import org.eclipse.xtend.expression.ExpressionFacade;
import org.eclipse.xtend.expression.Resource;
import org.eclipse.xtend.expression.Variable;

public class XtendComponent
extends AbstractExpressionsUsingWorkflowComponent {
    private static final String COMPONENT_NAME = "Xtend Component";
    private final Log log = LogFactory.getLog(this.getClass());
    String extensionFile = null;
    private final List<String> extensionAdvices = new ArrayList<String>();
    private String invokeExpression;
    private String expression = null;
    private String collectProfileSummary = null;
    private String verboseProfileFilename = null;
    private String outputSlot = "default";

    public void addExtensionAdvice(String extensionAdvice) {
        if (!this.extensionAdvices.contains(extensionAdvice)) {
            this.extensionAdvices.add(extensionAdvice);
        }
    }

    public void checkConfigurationInternal(Issues issues) {
        String compPrefix;
        super.checkConfigurationInternal(issues);
        String string = compPrefix = this.getId() != null ? String.valueOf(this.getId()) + ": " : "";
        if (this.invokeExpression == null || this.invokeExpression.trim().length() == 0) {
            issues.addError(String.valueOf(compPrefix) + "Property 'invoke' not specified.");
            return;
        }
        if (this.extensionFile == null) {
            issues.addError(String.valueOf(compPrefix) + "Error parsing property 'invoke': Could not extract name of the extension file.");
            return;
        }
        InputStream in = this.getExtFileIS();
        if (in == null || this.expression == null) {
            issues.addError(String.valueOf(compPrefix) + "Property 'invoke' not specified properly. AbstractExtension file '" + this.extensionFile + "' not found.");
            return;
        }
        try {
            in.close();
        }
        catch (IOException e) {
            this.log.error("I/O exception", e);
        }
        if (this.expression == null) {
            issues.addError(String.valueOf(compPrefix) + "Error parsing property 'invoke': Could not extract the expression to invoke in extension file '" + this.extensionFile + "'.");
            return;
        }
    }

    public String getLogMessage() {
        return "executing '" + this.extensionFile + "'";
    }

    public void invokeInternal2(WorkflowContext ctx, ProgressMonitor monitor, Issues issues) {
        String[] slots;
        InputStream in = this.getExtFileIS();
        if (in == null) {
            issues.addError("Cannot find extension file: " + this.extensionFile);
            return;
        }
        try {
            in.close();
        }
        catch (IOException e) {
            this.log.error("I/O exception", e);
        }
        BufferedOutputStream verboseProfileOutputStream = null;
        if (this.verboseProfileFilename != null) {
            try {
                verboseProfileOutputStream = new BufferedOutputStream(new FileOutputStream(this.verboseProfileFilename));
                ProfileCollector.getInstance().setDetailedLoggingWriter(verboseProfileOutputStream);
            }
            catch (IOException exc) {
                this.log.warn("could not open profiling log file", exc);
            }
        }
        ExecutionContextImpl ec = this.getExecutionContext(ctx);
        for (String advice : this.extensionAdvices) {
            String[] allAdvices;
            String[] stringArray = allAdvices = advice.split(",");
            int n = allAdvices.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                ec.registerExtensionAdvices(string.trim());
                ++n2;
            }
        }
        ec = (ExecutionContextImpl)ec.cloneWithResource(new Resource(){
            private String name = "noName";

            public String getFullyQualifiedName() {
                return this.name;
            }

            public String[] getImportedExtensions() {
                return new String[]{XtendComponent.this.extensionFile};
            }

            public String[] getImportedNamespaces() {
                return new String[0];
            }

            public void setFullyQualifiedName(String fqn) {
                this.name = fqn;
            }
        });
        String[] stringArray = slots = ctx.getSlotNames();
        int n = slots.length;
        int allAdvices = 0;
        while (allAdvices < n) {
            String slot = stringArray[allAdvices];
            ec = (ExecutionContextImpl)ec.cloneWithVariable(new Variable(slot, ctx.get(slot)));
            ++allAdvices;
        }
        if (monitor != null) {
            ec.setMonitor(monitor);
        }
        Object result = new ExpressionFacade(ec).evaluate(this.expression);
        ctx.set(this.outputSlot, result);
        ProfileCollector.getInstance().finish();
        if ("true".equalsIgnoreCase(this.collectProfileSummary)) {
            this.log.info("profiling info: \n" + ProfileCollector.getInstance().toString());
        }
        if (verboseProfileOutputStream != null) {
            try {
                ((OutputStream)verboseProfileOutputStream).close();
            }
            catch (IOException exc) {
                this.log.warn("problem closing profile log file", exc);
            }
        }
    }

    public void setCollectProfileSummary(String summary) {
        this.collectProfileSummary = summary;
    }

    public void setInvoke(String invokeExpr) {
        this.invokeExpression = invokeExpr;
        int i = invokeExpr.lastIndexOf("::");
        if (i != -1) {
            this.extensionFile = invokeExpr.substring(0, i);
            this.expression = invokeExpr.substring(i + 2);
        } else {
            this.expression = invokeExpr;
        }
    }

    public void setOutputSlot(String outputSlot) {
        this.outputSlot = outputSlot;
    }

    public void setVerboseProfileFilename(String fileName) {
        this.verboseProfileFilename = fileName;
    }

    public String getComponentName() {
        return COMPONENT_NAME;
    }

    private InputStream getExtFileIS() {
        InputStream in = ResourceLoaderFactory.createResourceLoader().getResourceAsStream(String.valueOf(this.extensionFile.replace("::", "/")) + ".ext");
        return in;
    }
}

