/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpand2.output;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.internal.xpand2.ast.Statement;
import org.eclipse.internal.xpand2.ast.TextStatement;
import org.eclipse.internal.xtend.expression.ast.SyntaxElement;
import org.eclipse.internal.xtend.util.Pair;
import org.eclipse.xpand2.XpandExecutionContext;
import org.eclipse.xpand2.output.FileHandle;
import org.eclipse.xpand2.output.InsertionPointSupport;
import org.eclipse.xpand2.output.Outlet;
import org.eclipse.xpand2.output.Output;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutputImpl
implements Output,
InsertionPointSupport {
    private boolean automaticHyphenation = false;
    private static ThreadLocal<Stack<FileHandle>> fileHandles = new ThreadLocal();
    private final Map<String, Outlet> outlets = new HashMap<String, Outlet>();
    private boolean deleteLine = false;
    private static final Pattern p = Pattern.compile("(.+)://(.+)");
    private final Stack<SyntaxElement> s = new Stack();

    public void setAutomaticHyphens(boolean automaticHyphenation) {
        this.automaticHyphenation = automaticHyphenation;
    }

    @Override
    public void addOutlet(Outlet outlet) {
        if (this.outlets.containsKey(outlet.getName())) {
            if (outlet.getName() == null) {
                throw new IllegalArgumentException("A default outlet is already registered!");
            }
            throw new IllegalArgumentException("An outlet with name " + outlet.getName() + " is already registered!");
        }
        this.outlets.put(outlet.getName(), outlet);
    }

    @Override
    public Outlet getOutlet(String name) {
        return this.outlets.get(name);
    }

    protected FileHandle current() {
        return this.getFileHandles().isEmpty() ? null : this.getFileHandles().peek();
    }

    public FileHandle current__testONLY() {
        return this.current();
    }

    @Override
    public void write(String bytes) {
        if (this.current() != null) {
            if (this.deleteLine) {
                String temp = this.trimUntilNewline(bytes);
                this.removeWSAfterLastNewline(this.current().getBuffer());
                try {
                    ((Appendable)((Object)this.current().getBuffer())).append(temp);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            try {
                ((Appendable)((Object)this.current().getBuffer())).append(bytes);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        this.deleteLine = false;
    }

    public void removeWSAfterLastNewline(CharSequence cs) {
        int i = cs.length();
        boolean wsOnly = true;
        while (i > 0 && wsOnly) {
            char c2 = cs.charAt(i - 1);
            wsOnly = Character.isWhitespace(c2);
            if (wsOnly && this.isNewLine(c2)) {
                this.deleteFromCharSequence(cs, i, cs.length());
                return;
            }
            --i;
        }
    }

    private void deleteFromCharSequence(CharSequence cs, int start, int end) {
        if (cs instanceof StringBuilder) {
            ((StringBuilder)cs).delete(start, end);
        } else if (cs instanceof StringBuffer) {
            ((StringBuffer)cs).delete(start, end);
        } else {
            throw new IllegalArgumentException("Unsupported CharSequence type " + cs.getClass().getName());
        }
    }

    protected boolean isNewLine(char c2) {
        return c2 == '\n' || c2 == '\r';
    }

    public String trimUntilNewline(String bytes) {
        int i = 0;
        boolean wsOnly = true;
        while (i < bytes.length() && wsOnly) {
            char c2 = bytes.charAt(i);
            wsOnly = Character.isWhitespace(c2);
            if (wsOnly && this.isNewLine(c2)) {
                if (c2 == '\r' && i + 1 < bytes.length() && bytes.charAt(i + 1) == '\n') {
                    ++i;
                }
                return bytes.substring(i + 1);
            }
            ++i;
        }
        return bytes;
    }

    public static Pair<Outlet, String> resolveOutlet(Map<String, Outlet> allOutlets, String path, String outletName) {
        Outlet o;
        Matcher m;
        if (outletName == null && (m = p.matcher(path)).matches()) {
            outletName = m.group(1);
            path = m.group(2);
        }
        if ((o = allOutlets.get(outletName)) == null) {
            if (outletName == null) {
                throw new IllegalArgumentException("No default outlet was configured!");
            }
            throw new IllegalArgumentException("No outlet with the name " + outletName + " could be found!");
        }
        return new Pair<Outlet, String>(o, path);
    }

    @Override
    public void openFile(String path, String outletName) {
        Pair<Outlet, String> raw = OutputImpl.resolveOutlet(this.outlets, path, outletName);
        Outlet actualOutlet = raw.getFirst();
        String actualPath = raw.getSecond();
        this.getFileHandles().push(actualOutlet.createFileHandle(actualPath));
    }

    @Override
    public void closeFile() {
        FileHandle fi = this.getFileHandles().pop();
        fi.writeAndClose();
    }

    @Override
    public void pushStatement(SyntaxElement stmt, XpandExecutionContext ctx) {
        if (stmt instanceof TextStatement) {
            this.deleteLine = ((TextStatement)stmt).isDeleteLine();
            if (this.automaticHyphenation) {
                this.deleteLine = true;
            }
        }
        this.s.push(stmt);
    }

    @Override
    public SyntaxElement popStatement() {
        SyntaxElement se = this.s.pop();
        return se;
    }

    protected Stack<FileHandle> getFileHandles() {
        Stack<FileHandle> result = fileHandles.get();
        if (result == null) {
            result = new Stack();
            fileHandles.set(result);
        }
        return result;
    }

    @Override
    public void activateInsertionPoint(Statement stmt) {
        if (this.current() != null) {
            if (!(this.current() instanceof InsertionPointSupport)) {
                throw new IllegalStateException("Current handle does not implement InsertionPointSupport.");
            }
            ((InsertionPointSupport)((Object)this.current())).activateInsertionPoint(stmt);
        }
    }

    @Override
    public void deactivateInsertionPoint(Statement stmt) {
        if (this.current() != null) {
            if (!(this.current() instanceof InsertionPointSupport)) {
                throw new IllegalStateException("Current handle does not implement InsertionPointSupport.");
            }
            ((InsertionPointSupport)((Object)this.current())).deactivateInsertionPoint(stmt);
        }
    }

    @Override
    public void registerInsertionPoint(Statement stmt) {
        if (!(this.current() instanceof InsertionPointSupport)) {
            throw new IllegalStateException("Current handle does not implement InsertionPointSupport.");
        }
        ((InsertionPointSupport)((Object)this.current())).registerInsertionPoint(stmt);
    }
}

