/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpand2;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.mwe.core.WorkflowComponent;
import org.eclipse.emf.mwe.core.ao.AbstractWorkflowAdvice;
import org.eclipse.emf.mwe.core.issues.Issues;
import org.eclipse.xpand2.Generator;

public class GeneratorAdvice
extends AbstractWorkflowAdvice {
    private List<String> advices = new ArrayList<String>();
    private List<String> extensionAdvices = new ArrayList<String>();
    private String fileEncoding;

    public void addAdvices(String advices) {
        this.advices.add(advices);
    }

    public void addExtensionAdvices(String extensionAdvices) {
        this.extensionAdvices.add(extensionAdvices);
    }

    public void addAdvice(String advices) {
        this.advices.add(advices);
    }

    public void addExtensionAdvice(String extensionAdvices) {
        this.extensionAdvices.add(extensionAdvices);
    }

    public void setFileEncoding(String fileEncoding) {
        this.fileEncoding = fileEncoding;
    }

    public void checkConfiguration(Issues issues) {
        super.checkConfiguration(issues);
        if (this.advices.isEmpty() && this.extensionAdvices.isEmpty()) {
            issues.addError("Neither 'advices' nor 'extensionAdvices' configured.");
        }
    }

    public void weave(WorkflowComponent c2, Issues issues) {
        if (!(c2 instanceof Generator)) {
            issues.addError(this, "advice target is not a Generator component.");
        } else {
            Generator gen = (Generator)c2;
            for (String advice : this.advices) {
                gen.addAdvice(advice);
            }
            for (String advice : this.extensionAdvices) {
                gen.addExtensionAdvice(advice);
            }
            if (this.fileEncoding != null) {
                gen.setFileEncoding(this.fileEncoding);
            }
        }
    }

    public String getLogMessage() {
        return "extension-advices: " + this.buildList(this.extensionAdvices) + "   template-advices: " + this.buildList(this.advices);
    }
}

