/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.internal.xtend.expression.codeassist;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.internal.xtend.expression.codeassist.ProposalComputer;
import org.eclipse.internal.xtend.expression.codeassist.ProposalFactory;
import org.eclipse.xtend.expression.ExecutionContext;
import org.eclipse.xtend.expression.TypeNameUtil;
import org.eclipse.xtend.typesystem.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeProposalComputer
implements ProposalComputer {
    @Override
    public List<Object> computeProposals(String txt, ExecutionContext ctx, ProposalFactory factory) {
        String prefix = this.findPrefix(txt);
        Type[] types = ctx.findTypesForPrefix(prefix);
        ArrayList<Object> result = new ArrayList<Object>();
        List<String> namespaces = Arrays.asList(ctx.currentResource().getImportedNamespaces());
        int i = 0;
        while (i < types.length) {
            Type type = types[i];
            String insertString = type.getName();
            if (insertString.startsWith(prefix)) {
                result.add(factory.createTypeProposal(insertString, type, prefix));
            } else {
                String simpleName = TypeNameUtil.getSimpleName(insertString);
                if (simpleName.startsWith(prefix) && namespaces.contains(TypeNameUtil.getPackage(insertString))) {
                    result.add(factory.createTypeProposal(simpleName, type, prefix));
                }
            }
            ++i;
        }
        return result;
    }

    public String findPrefix(String txt) {
        StringBuffer result = new StringBuffer();
        int i = txt.length() - 1;
        char c2 = txt.charAt(i);
        while (i > 0 && (Character.isJavaIdentifierStart(c2) || c2 == ':')) {
            result.append(c2);
            c2 = txt.charAt(--i);
        }
        return result.reverse().toString();
    }
}

