/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.internal.xtend.expression.ast;

import java.util.Set;
import org.eclipse.internal.xtend.expression.ast.Expression;
import org.eclipse.internal.xtend.expression.ast.Identifier;
import org.eclipse.internal.xtend.expression.ast.SyntaxElement;
import org.eclipse.xtend.expression.AnalysationIssue;
import org.eclipse.xtend.expression.EvaluationException;
import org.eclipse.xtend.expression.ExecutionContext;
import org.eclipse.xtend.typesystem.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BooleanOperation
extends Expression {
    private static final String IMPLIES = "implies";
    private static final String OR = "||";
    private static final String AND = "&&";
    private Expression left;
    private Expression right;
    private Identifier operator;

    public BooleanOperation(Identifier operator, Expression e, Expression r) {
        this.operator = operator;
        this.left = e;
        this.right = r;
    }

    public Expression getLeft() {
        return this.left;
    }

    public Identifier getOperator() {
        return this.operator;
    }

    public Expression getRight() {
        return this.right;
    }

    @Override
    protected Object evaluateInternal(ExecutionContext ctx) {
        Boolean l = this.evaluateToBoolean(this.left, ctx);
        if (l == null) {
            return ctx.handleNullEvaluation(this);
        }
        if (this.operator.getValue().equals(AND)) {
            if (!l.booleanValue()) {
                return Boolean.FALSE;
            }
            Boolean r = this.evaluateToBoolean(this.right, ctx);
            if (r == null) {
                return ctx.handleNullEvaluation(this);
            }
            return l != false && r != false;
        }
        if (this.operator.getValue().equals(OR)) {
            if (l.booleanValue()) {
                return Boolean.TRUE;
            }
            Boolean r = this.evaluateToBoolean(this.right, ctx);
            if (r == null) {
                return ctx.handleNullEvaluation(this);
            }
            return l != false || r != false;
        }
        if (this.operator.getValue().equals(IMPLIES)) {
            if (!l.booleanValue()) {
                return Boolean.TRUE;
            }
            Boolean b2 = this.evaluateToBoolean(this.right, ctx);
            if (b2 == null) {
                return ctx.handleNullEvaluation(this);
            }
            return b2;
        }
        throw new EvaluationException("Unknown Boolean operator " + this.operator.getValue(), (SyntaxElement)this, ctx);
    }

    private Boolean evaluateToBoolean(Expression expr, ExecutionContext ctx) {
        Object l = expr.evaluate(ctx);
        if (l == null) {
            return null;
        }
        if (!(l instanceof Boolean)) {
            Type t = ctx.getType(l);
            throw new EvaluationException("Boolean expected but was " + t.getName(), (SyntaxElement)expr, ctx);
        }
        Boolean result = (Boolean)l;
        return result;
    }

    @Override
    public Type analyzeInternal(ExecutionContext ctx, Set<AnalysationIssue> issues) {
        Type l = this.left.analyze(ctx, issues);
        Type r = this.right.analyze(ctx, issues);
        if (l == null || r == null) {
            return null;
        }
        if (!ctx.getBooleanType().equals(l)) {
            issues.add(new AnalysationIssue(AnalysationIssue.INCOMPATIBLE_TYPES, "Boolean expected! Found : " + l.getName(), this.left));
        }
        if (!ctx.getBooleanType().equals(r)) {
            issues.add(new AnalysationIssue(AnalysationIssue.INCOMPATIBLE_TYPES, "Boolean expected! Found : " + r.getName(), this.right));
        }
        return ctx.getBooleanType();
    }

    @Override
    protected String toStringInternal() {
        return String.valueOf(this.left.toStringInternal()) + this.operator.getValue() + this.right.toStringInternal();
    }
}

