/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.internal.xpand2;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.mwe.core.WorkflowComponent;
import org.eclipse.emf.mwe.core.issues.Issues;
import org.eclipse.xpand2.Generator;
import org.eclipse.xtend.expression.AbstractExpressionsUsingWorkflowAdvice;

public class GeneratorAdvice
extends AbstractExpressionsUsingWorkflowAdvice {
    private static final String COMPONENT_NAME = "Xpand Generator Advice";
    private final List<String> advices = new ArrayList<String>();
    private final List<String> extensionAdvices = new ArrayList<String>();
    private String fileEncoding;

    public void addAdvice(String advice) {
        this.advices.add(advice);
    }

    public void addExtensionAdvice(String extensionAdvice) {
        this.extensionAdvices.add(extensionAdvice);
    }

    public void setFileEncoding(String fileEncoding) {
        this.fileEncoding = fileEncoding;
    }

    public void checkConfiguration(Issues issues) {
        super.checkConfiguration(issues);
        if (this.advices.isEmpty() && this.extensionAdvices.isEmpty()) {
            issues.addError("Neither 'advices' nor 'extensionAdvices' configured.");
        }
    }

    public void weave(WorkflowComponent c2, Issues issues) {
        super.weave(c2, issues);
        if (!(c2 instanceof Generator)) {
            issues.addError(this, "advice target is not a Generator component.");
        } else {
            Generator gen = (Generator)c2;
            for (String advice : this.advices) {
                gen.addAdvice(advice);
            }
            for (String advice : this.extensionAdvices) {
                gen.addExtensionAdvice(advice);
            }
            if (this.fileEncoding != null) {
                gen.setFileEncoding(this.fileEncoding);
            }
        }
    }

    public String getLogMessage() {
        return "extension-advices: " + this.buildList(this.extensionAdvices) + "   template-advices: " + this.buildList(this.advices);
    }

    public String getComponentName() {
        return COMPONENT_NAME;
    }
}

