/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.mwe2.language.serializer;

import com.google.inject.Inject;
import com.google.inject.Provider;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.mwe2.language.mwe2.Assignment;
import org.eclipse.emf.mwe2.language.mwe2.BooleanLiteral;
import org.eclipse.emf.mwe2.language.mwe2.Component;
import org.eclipse.emf.mwe2.language.mwe2.DeclaredProperty;
import org.eclipse.emf.mwe2.language.mwe2.Import;
import org.eclipse.emf.mwe2.language.mwe2.Module;
import org.eclipse.emf.mwe2.language.mwe2.Mwe2Package;
import org.eclipse.emf.mwe2.language.mwe2.PlainString;
import org.eclipse.emf.mwe2.language.mwe2.PropertyReference;
import org.eclipse.emf.mwe2.language.mwe2.Reference;
import org.eclipse.emf.mwe2.language.mwe2.StringLiteral;
import org.eclipse.emf.mwe2.language.services.Mwe2GrammarAccess;
import org.eclipse.xtext.serializer.acceptor.ISemanticSequenceAcceptor;
import org.eclipse.xtext.serializer.acceptor.SequenceFeeder;
import org.eclipse.xtext.serializer.diagnostic.ISemanticSequencerDiagnosticProvider;
import org.eclipse.xtext.serializer.diagnostic.ISerializationDiagnostic;
import org.eclipse.xtext.serializer.sequencer.AbstractSemanticSequencer;
import org.eclipse.xtext.serializer.sequencer.GenericSequencer;
import org.eclipse.xtext.serializer.sequencer.ISemanticNodeProvider;
import org.eclipse.xtext.serializer.sequencer.ISemanticSequencer;
import org.eclipse.xtext.serializer.sequencer.ITransientValueService;

public class AbstractMwe2SemanticSequencer
extends AbstractSemanticSequencer {
    @Inject
    protected Mwe2GrammarAccess grammarAccess;
    @Inject
    protected ISemanticSequencerDiagnosticProvider diagnosticProvider;
    @Inject
    protected ITransientValueService transientValues;
    @Inject
    @GenericSequencer
    protected Provider<ISemanticSequencer> genericSequencerProvider;
    protected ISemanticSequencer genericSequencer;

    public void init(ISemanticSequencer sequencer, ISemanticSequenceAcceptor sequenceAcceptor, ISerializationDiagnostic.Acceptor errorAcceptor) {
        super.init(sequencer, sequenceAcceptor, errorAcceptor);
        this.genericSequencer = this.genericSequencerProvider.get();
        this.genericSequencer.init(sequencer, sequenceAcceptor, errorAcceptor);
    }

    public void createSequence(EObject context, EObject semanticObject) {
        if (semanticObject.eClass().getEPackage() == Mwe2Package.eINSTANCE) {
            switch (semanticObject.eClass().getClassifierID()) {
                case 5: {
                    if (context != this.grammarAccess.getAssignmentRule()) break;
                    this.sequence_Assignment_Assignment(context, (Assignment)semanticObject);
                    return;
                }
                case 7: {
                    if (context != this.grammarAccess.getValueRule() && context != this.grammarAccess.getBooleanLiteralRule()) break;
                    this.sequence_BooleanLiteral_BooleanLiteral(context, (BooleanLiteral)semanticObject);
                    return;
                }
                case 3: {
                    if (context == this.grammarAccess.getComponentRule() || context == this.grammarAccess.getValueRule()) {
                        this.sequence_Component_Component(context, (Component)semanticObject);
                        return;
                    }
                    if (context != this.grammarAccess.getRootComponentRule()) break;
                    this.sequence_RootComponent_Component(context, (Component)semanticObject);
                    return;
                }
                case 2: {
                    if (context != this.grammarAccess.getDeclaredPropertyRule()) break;
                    this.sequence_DeclaredProperty_DeclaredProperty(context, (DeclaredProperty)semanticObject);
                    return;
                }
                case 4: {
                    if (context != this.grammarAccess.getImportRule()) break;
                    this.sequence_Import_Import(context, (Import)semanticObject);
                    return;
                }
                case 0: {
                    if (context != this.grammarAccess.getModuleRule()) break;
                    this.sequence_Module_Module(context, (Module)semanticObject);
                    return;
                }
                case 12: {
                    if (context != this.grammarAccess.getPlainStringRule()) break;
                    this.sequence_PlainString_PlainString(context, (PlainString)semanticObject);
                    return;
                }
                case 11: {
                    if (context != this.grammarAccess.getPropertyReferenceRule() && context != this.grammarAccess.getPropertyReferenceImplRule()) break;
                    this.sequence_PropertyReferenceImpl_PropertyReference(context, (PropertyReference)semanticObject);
                    return;
                }
                case 8: {
                    if (context != this.grammarAccess.getValueRule() && context != this.grammarAccess.getReferenceRule()) break;
                    this.sequence_Reference_Reference(context, (Reference)semanticObject);
                    return;
                }
                case 9: {
                    if (context != this.grammarAccess.getValueRule() && context != this.grammarAccess.getStringLiteralRule()) break;
                    this.sequence_StringLiteral_StringLiteral(context, (StringLiteral)semanticObject);
                    return;
                }
            }
        }
        if (this.errorAcceptor != null) {
            this.errorAcceptor.accept(this.diagnosticProvider.createInvalidContextOrTypeDiagnostic(semanticObject, context));
        }
    }

    protected void sequence_Assignment_Assignment(EObject context, Assignment semanticObject) {
        this.genericSequencer.createSequence(context, semanticObject);
    }

    protected void sequence_BooleanLiteral_BooleanLiteral(EObject context, BooleanLiteral semanticObject) {
        this.genericSequencer.createSequence(context, semanticObject);
    }

    protected void sequence_Component_Component(EObject context, Component semanticObject) {
        this.genericSequencer.createSequence(context, semanticObject);
    }

    protected void sequence_DeclaredProperty_DeclaredProperty(EObject context, DeclaredProperty semanticObject) {
        this.genericSequencer.createSequence(context, semanticObject);
    }

    protected void sequence_Import_Import(EObject context, Import semanticObject) {
        if (this.errorAcceptor != null && this.transientValues.isValueTransient(semanticObject, Mwe2Package.Literals.IMPORT__IMPORTED_NAMESPACE) == ITransientValueService.ValueTransient.YES) {
            this.errorAcceptor.accept(this.diagnosticProvider.createFeatureValueMissing(semanticObject, Mwe2Package.Literals.IMPORT__IMPORTED_NAMESPACE));
        }
        ISemanticNodeProvider.INodesForEObjectProvider nodes = this.createNodeProvider(semanticObject);
        SequenceFeeder feeder = this.createSequencerFeeder(semanticObject, nodes);
        feeder.accept(this.grammarAccess.getImportAccess().getImportedNamespaceImportedFQNParserRuleCall_1_0(), (Object)semanticObject.getImportedNamespace());
        feeder.finish();
    }

    protected void sequence_Module_Module(EObject context, Module semanticObject) {
        this.genericSequencer.createSequence(context, semanticObject);
    }

    protected void sequence_PlainString_PlainString(EObject context, PlainString semanticObject) {
        if (this.errorAcceptor != null && this.transientValues.isValueTransient(semanticObject, Mwe2Package.Literals.PLAIN_STRING__VALUE) == ITransientValueService.ValueTransient.YES) {
            this.errorAcceptor.accept(this.diagnosticProvider.createFeatureValueMissing(semanticObject, Mwe2Package.Literals.PLAIN_STRING__VALUE));
        }
        ISemanticNodeProvider.INodesForEObjectProvider nodes = this.createNodeProvider(semanticObject);
        SequenceFeeder feeder = this.createSequencerFeeder(semanticObject, nodes);
        feeder.accept(this.grammarAccess.getPlainStringAccess().getValueConstantValueParserRuleCall_0(), (Object)semanticObject.getValue());
        feeder.finish();
    }

    protected void sequence_PropertyReferenceImpl_PropertyReference(EObject context, PropertyReference semanticObject) {
        if (this.errorAcceptor != null && this.transientValues.isValueTransient(semanticObject, Mwe2Package.Literals.ABSTRACT_REFERENCE__REFERABLE) == ITransientValueService.ValueTransient.YES) {
            this.errorAcceptor.accept(this.diagnosticProvider.createFeatureValueMissing(semanticObject, Mwe2Package.Literals.ABSTRACT_REFERENCE__REFERABLE));
        }
        ISemanticNodeProvider.INodesForEObjectProvider nodes = this.createNodeProvider(semanticObject);
        SequenceFeeder feeder = this.createSequencerFeeder(semanticObject, nodes);
        feeder.accept(this.grammarAccess.getPropertyReferenceImplAccess().getReferableDeclaredPropertyFQNParserRuleCall_0_1(), (Object)semanticObject.getReferable());
        feeder.finish();
    }

    protected void sequence_Reference_Reference(EObject context, Reference semanticObject) {
        if (this.errorAcceptor != null && this.transientValues.isValueTransient(semanticObject, Mwe2Package.Literals.ABSTRACT_REFERENCE__REFERABLE) == ITransientValueService.ValueTransient.YES) {
            this.errorAcceptor.accept(this.diagnosticProvider.createFeatureValueMissing(semanticObject, Mwe2Package.Literals.ABSTRACT_REFERENCE__REFERABLE));
        }
        ISemanticNodeProvider.INodesForEObjectProvider nodes = this.createNodeProvider(semanticObject);
        SequenceFeeder feeder = this.createSequencerFeeder(semanticObject, nodes);
        feeder.accept(this.grammarAccess.getReferenceAccess().getReferableReferrableFQNParserRuleCall_0_1(), (Object)semanticObject.getReferable());
        feeder.finish();
    }

    protected void sequence_RootComponent_Component(EObject context, Component semanticObject) {
        this.genericSequencer.createSequence(context, semanticObject);
    }

    protected void sequence_StringLiteral_StringLiteral(EObject context, StringLiteral semanticObject) {
        this.genericSequencer.createSequence(context, semanticObject);
    }
}

