/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.mwe.utils;

import java.io.IOException;
import java.util.Collections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.mwe.core.WorkflowContext;
import org.eclipse.emf.mwe.core.WorkflowInterruptedException;
import org.eclipse.emf.mwe.core.issues.Issues;
import org.eclipse.emf.mwe.core.monitor.ProgressMonitor;
import org.eclipse.emf.mwe.utils.AbstractEMFWorkflowComponent;

public class Reader
extends AbstractEMFWorkflowComponent {
    private static final String COMPONENT_NAME = "Reader";
    private boolean makeEPackagesGlobal = true;
    private boolean firstElementOnly = true;
    private boolean ignoreMissingModel = false;

    public void invokeInternal(WorkflowContext ctx, ProgressMonitor monitor, Issues issues) {
        ctx.set(this.getModelSlot(), Reader.load(this.resourceSet, this.uri, this.firstElementOnly, this.ignoreMissingModel));
        if (this.makeEPackagesGlobal) {
            for (String k : this.resourceSet.getPackageRegistry().keySet()) {
                EPackage.Registry.INSTANCE.put(k, this.resourceSet.getPackageRegistry().get(k));
            }
        }
    }

    public void checkConfiguration(Issues issues) {
        super.checkConfiguration(issues);
        if (this.uri == null) {
            issues.addError("URI not set");
        }
    }

    public static Object load(ResourceSet resourceSet, String uri, boolean firstElementOnly) {
        return Reader.load(resourceSet, uri, firstElementOnly, false);
    }

    public static Object load(ResourceSet resourceSet, String uri, boolean firstElementOnly, boolean ignoreMissingModel) {
        Resource res;
        try {
            res = resourceSet.getResource(URI.createURI(uri), true);
            if (res == null) {
                throw new WorkflowInterruptedException("Couldn't find resource under " + uri);
            }
            if (!res.isLoaded()) {
                res.load(Collections.EMPTY_MAP);
            }
        }
        catch (WrappedException e) {
            if (ignoreMissingModel) {
                return null;
            }
            throw new WorkflowInterruptedException("Couldn't load resource under " + uri + " : " + e.getMessage());
        }
        catch (IOException e) {
            if (ignoreMissingModel) {
                return null;
            }
            throw new WorkflowInterruptedException("Couldn't load resource under " + uri + " : " + e.getMessage());
        }
        EList<EObject> result = res.getContents();
        if (firstElementOnly) {
            if (result.isEmpty()) {
                return null;
            }
            return result.iterator().next();
        }
        return result;
    }

    public void setFirstElementOnly(boolean firstElementOnly) {
        this.firstElementOnly = firstElementOnly;
    }

    public void setMakeEPackagesGlobal(boolean makeEPackagesGlobal) {
        this.makeEPackagesGlobal = makeEPackagesGlobal;
    }

    public void setIgnoreMissingModel(boolean ignoreMissingModel) {
        this.ignoreMissingModel = ignoreMissingModel;
    }

    public String getLogMessage() {
        return "Loading model from " + this.uri;
    }

    public String getComponentName() {
        return COMPONENT_NAME;
    }
}

