/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.mwe.core.container;

import org.eclipse.emf.mwe.core.WorkflowComponent;
import org.eclipse.emf.mwe.core.WorkflowContext;
import org.eclipse.emf.mwe.core.WorkflowInterruptedException;
import org.eclipse.emf.mwe.core.container.CompositeComponent;
import org.eclipse.emf.mwe.core.container.ConditionEvaluationException;
import org.eclipse.emf.mwe.core.container.WorkflowConditional;
import org.eclipse.emf.mwe.core.issues.Issues;
import org.eclipse.emf.mwe.core.monitor.ProgressMonitor;
import org.eclipse.emf.mwe.internal.core.util.ComponentPrinter;

public abstract class ConditionalComponent
extends CompositeComponent
implements WorkflowConditional {
    private WorkflowComponent elseComp;

    public ConditionalComponent(String name) {
        super(name);
    }

    public void setElse(CompositeComponent comp) {
        this.elseComp = comp;
    }

    public void invoke(WorkflowContext ctx, ProgressMonitor monitor, Issues issues) {
        this.internalInvoke(ctx, monitor, issues);
    }

    private void internalInvoke(WorkflowContext model, ProgressMonitor monitor, Issues issues) {
        block8: {
            try {
                if (this.evaluate()) {
                    for (WorkflowComponent comp : this.components) {
                        try {
                            log.info(ComponentPrinter.getString(comp));
                        }
                        catch (WorkflowInterruptedException wfi) {
                            throw wfi;
                        }
                        catch (Throwable t) {
                            issues.addError(comp, "Error during execution: " + t.getMessage());
                            log.error("Exception occured: ", t);
                        }
                        comp.invoke(model, monitor, issues);
                    }
                    break block8;
                }
                if (this.elseComp != null) {
                    this.elseComp.invoke(model, monitor, issues);
                }
            }
            catch (ConditionEvaluationException ex) {
                issues.addError(this, "cannot evaluate condition: " + ex.getMessage());
            }
        }
    }
}

