/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.mwe.core;

import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.eclipse.emf.mwe.core.WorkflowContext;
import org.eclipse.emf.mwe.core.WorkflowEngine;
import org.eclipse.emf.mwe.core.monitor.ProgressMonitor;
import org.eclipse.emf.mwe.core.resources.ResourceLoaderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkflowRunner {
    private static final String PARAM = "p";
    private static final String MONITOR = "m";
    private static final String ANT = "a";
    private static final String CMDL = "c";
    private static final String ENGINE = "e";

    public static void main(String[] args) throws Exception {
        new Object();
        CommandLine line = WorkflowRunner.getCommandLine(args);
        boolean success = new WorkflowRunner().doRun(line, args);
        if (!success && line.hasOption(ANT)) {
            System.exit(1);
        }
    }

    @Deprecated
    public boolean run(String workFlowFile, ProgressMonitor theMonitor, Map<String, String> theParams, Map<String, ?> externalSlotContents) {
        return new WorkflowEngine().run(workFlowFile, theMonitor, theParams, externalSlotContents);
    }

    public boolean doRun(CommandLine line, String[] args) throws Exception {
        URL wfUrl;
        Method method;
        WorkflowEngine runner = new WorkflowEngine();
        if (line.hasOption(ENGINE)) {
            try {
                runner = (WorkflowEngine)Class.forName(line.getOptionValue(ENGINE)).newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        HashMap<String, String> params = new HashMap();
        String wfFile = null;
        String[] monitorOptValues = line.getOptionValues(MONITOR);
        if (line.hasOption(CMDL)) {
            ArrayList<String> unprocessedArgs = new ArrayList<String>();
            int i = 0;
            while (i < args.length) {
                String arg = args[i];
                if (arg.equals("-c") || arg.equals("--cmdLineProcessor")) {
                    ++i;
                } else if (arg.equals("-m") || arg.equals("--monitorClass")) {
                    i += monitorOptValues.length;
                } else if (arg.endsWith(".oaw") || arg.endsWith(".mwe")) {
                    if (wfFile != null) {
                        throw new IllegalStateException("Workflow file already defined as '" + wfFile + "'!");
                    }
                    wfFile = arg;
                } else {
                    unprocessedArgs.add(arg);
                }
                ++i;
            }
            Class<?> cmdLineProcessor = ResourceLoaderFactory.createResourceLoader().loadClass(line.getOptionValue(CMDL));
            if (cmdLineProcessor == null) {
                throw new IllegalStateException("cannot find class '" + line.getOptionValue(CMDL) + "' for command line processing.");
            }
            method = cmdLineProcessor.getMethod("processCmdLine", String[].class, Map.class, WorkflowContext.class);
            method.invoke(cmdLineProcessor.newInstance(), unprocessedArgs.toArray(new String[0]), params, runner.getContext());
        } else {
            params = this.resolveParams(line.getOptionValues(PARAM));
            wfFile = line.getArgs()[0];
        }
        if (wfFile == null || !wfFile.endsWith(".oaw") && !wfFile.endsWith(".mwe")) {
            this.wrongCall(line);
            return false;
        }
        ProgressMonitor monitor = null;
        if (monitorOptValues != null) {
            Class<?> clazz = ResourceLoaderFactory.createResourceLoader().loadClass(monitorOptValues[0]);
            if (clazz == null) {
                throw new ClassNotFoundException("Didn't find class " + monitorOptValues[0]);
            }
            monitor = (ProgressMonitor)clazz.newInstance();
            method = monitor.getClass().getMethod("init", String[].class);
            if (method != null) {
                method.invoke((Object)monitor, new Object[]{monitorOptValues});
            }
        }
        int index = 0;
        do {
            if ((wfUrl = ResourceLoaderFactory.createResourceLoader().getResource(wfFile)) != null || (index = wfFile.indexOf(47)) < 0) continue;
            wfFile = wfFile.substring(index + 1);
        } while (wfUrl == null && index >= 0);
        if (wfUrl == null) {
            String msg = "can't find the workflow file '" + line.getArgs()[0] + "' in the current class path";
            throw new IllegalStateException(msg);
        }
        return runner.run(wfFile, monitor, params, null);
    }

    protected static CommandLine getCommandLine(String[] args) throws ParseException {
        Options options = new Options();
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName("className,moreArgs");
        OptionBuilder.withDescription("the name of a class that implements ProgressMonitor. More arguments can be appended that will be injected to the monitor, if it has a init(String[] args) method.");
        OptionBuilder.withLongOpt("monitorClass");
        OptionBuilder.withValueSeparator(',');
        options.addOption(OptionBuilder.create(MONITOR));
        OptionBuilder.withLongOpt("ant");
        OptionBuilder.withDescription("must be set when using in Ant context");
        options.addOption(OptionBuilder.create(ANT));
        OptionBuilder.withArgName("key=value");
        OptionBuilder.withDescription("external property that is handled as workflow property");
        OptionBuilder.hasArgs();
        Option paramOption = OptionBuilder.create(PARAM);
        paramOption.setLongOpt("param");
        options.addOption(paramOption);
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName("className");
        OptionBuilder.withDescription("the name of a class that implements a public method 'public void processCmdLine(String[] cmdLineArgs, Map paramsToUseInWorkflow, WorkflowContext ctx)'.");
        OptionBuilder.withLongOpt("cmdLineProcessor");
        options.addOption(OptionBuilder.create(CMDL));
        OptionBuilder.withArgName("className");
        OptionBuilder.withDescription("WorkflowRunnerEngine class");
        OptionBuilder.hasArgs();
        Option runnerOption = OptionBuilder.create(ENGINE);
        runnerOption.setLongOpt("engine");
        options.addOption(runnerOption);
        PosixParser parser = new PosixParser();
        CommandLine line = parser.parse(options, args);
        return line;
    }

    protected Map<String, String> resolveParams(String[] args) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (args == null) {
            return params;
        }
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            String[] string = element.split("=", 2);
            if (string.length != 2) {
                throw new IllegalArgumentException("wrong param syntax (-pkey=value). was : " + element);
            }
            params.put(string[0], string[1]);
            ++n2;
        }
        return params;
    }

    protected void wrongCall(CommandLine line) {
        Options options = new Options();
        Option[] optionArray = line.getOptions();
        int n = optionArray.length;
        int n2 = 0;
        while (n2 < n) {
            Option o = optionArray[n2];
            options.addOption(o);
            ++n2;
        }
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("java " + WorkflowRunner.class.getName() + " some_workflow_file.mwe [options]\nor\njava " + WorkflowRunner.class.getName() + " some_workflow_file.oaw [options]\n", options);
        System.exit(0);
    }
}

