/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.codegen.ecore.generator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.codegen.ecore.CodeGenEcorePlugin;
import org.eclipse.emf.codegen.ecore.generator.GeneratorAdapter;
import org.eclipse.emf.codegen.ecore.generator.GeneratorAdapterFactory;
import org.eclipse.emf.codegen.merge.java.JControlModel;
import org.eclipse.emf.codegen.merge.java.facade.FacadeHelper;
import org.eclipse.emf.codegen.util.CodeGenUtil;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Generator {
    private static final boolean SYSOUT_BEGIN_END = false;
    protected GeneratorAdapterFactory.Descriptor.Registry adapterFactoryDescriptorRegistry;
    protected Map<String, Collection<GeneratorAdapterFactory>> packageIDToAdapterFactories;
    protected Object input;
    protected Options options;
    protected boolean initializeNeeded = true;
    protected JControlModel jControlModel;
    protected Set<String> badFacadeHelperClasses = new HashSet<String>();

    public Generator() {
    }

    public Generator(GeneratorAdapterFactory.Descriptor.Registry adapterFactoryDescriptorRegistry) {
        this.adapterFactoryDescriptorRegistry = adapterFactoryDescriptorRegistry;
    }

    public Object getInput() {
        return this.input;
    }

    public void setInput(Object input) {
        this.input = input;
        this.initialize();
        this.initializeNeeded = true;
    }

    public void requestInitialize() {
        this.initializeNeeded = true;
    }

    protected void initialize() {
        for (GeneratorAdapterFactory adapterFactory : this.getAdapterFactories(this.input)) {
            adapterFactory.initialize(this.input);
        }
    }

    public Options getOptions() {
        if (this.options == null) {
            this.options = new Options();
        }
        return this.options;
    }

    public JControlModel getJControlModel() {
        String facadeHelperClass;
        if (this.jControlModel == null) {
            this.jControlModel = new JControlModel();
        }
        if (!(this.badFacadeHelperClasses.contains(facadeHelperClass = this.options.mergerFacadeHelperClass) || this.jControlModel.getFacadeHelper() != null && this.jControlModel.getFacadeHelper().getClass().getName().equals(facadeHelperClass))) {
            FacadeHelper facadeHelper = CodeGenUtil.instantiateFacadeHelper(facadeHelperClass);
            if (facadeHelper == null) {
                this.badFacadeHelperClasses.add(facadeHelperClass);
            }
            this.jControlModel.initialize(facadeHelper, this.options.mergeRulesURI);
        }
        return this.jControlModel;
    }

    public GeneratorAdapterFactory.Descriptor.Registry getAdapterFactoryDescriptorRegistry() {
        if (this.adapterFactoryDescriptorRegistry == null) {
            this.adapterFactoryDescriptorRegistry = new GeneratorAdapterFactory.Descriptor.DelegatingRegistry(GeneratorAdapterFactory.Descriptor.Registry.INSTANCE);
        }
        return this.adapterFactoryDescriptorRegistry;
    }

    protected Collection<GeneratorAdapterFactory> getAdapterFactories(Object object) {
        String packageID;
        Collection<GeneratorAdapterFactory> result;
        if (this.packageIDToAdapterFactories == null) {
            this.packageIDToAdapterFactories = new HashMap<String, Collection<GeneratorAdapterFactory>>();
        }
        if ((result = this.packageIDToAdapterFactories.get(packageID = this.getPackageID(object))) == null) {
            Collection<GeneratorAdapterFactory.Descriptor> descriptors = this.getAdapterFactoryDescriptorRegistry().getDescriptors(packageID);
            result = new ArrayList<GeneratorAdapterFactory>(descriptors.size());
            for (GeneratorAdapterFactory.Descriptor descriptor : descriptors) {
                GeneratorAdapterFactory adapterFactory = descriptor.createAdapterFactory();
                adapterFactory.setGenerator(this);
                result.add(adapterFactory);
            }
            this.packageIDToAdapterFactories.put(packageID, result);
        }
        return result;
    }

    protected String getPackageID(Object object) {
        return object instanceof EObject ? ((EObject)object).eClass().getEPackage().getNsURI() : object.getClass().getPackage().getName();
    }

    protected Collection<GeneratorAdapter> getAdapters(Object object) {
        Collection<GeneratorAdapterFactory> adapterFactories = this.getAdapterFactories(object);
        ArrayList<GeneratorAdapter> result = new ArrayList<GeneratorAdapter>(adapterFactories.size());
        for (AdapterFactory adapterFactory : adapterFactories) {
            Object adapter;
            if (!adapterFactory.isFactoryForType(GeneratorAdapter.class) || (adapter = adapterFactory.adapt(object, GeneratorAdapter.class)) == null) continue;
            result.add((GeneratorAdapter)adapter);
        }
        return result;
    }

    private GeneratorData[] getGeneratorData(Object object, Object projectType, boolean forGenerate) {
        HashSet<Object> objects = new HashSet<Object>();
        List<GeneratorData> childrenData = this.getGeneratorData(object, projectType, forGenerate, true, false, objects);
        List<GeneratorData> parentsData = this.getGeneratorData(object, projectType, forGenerate, false, true, objects);
        ArrayList<GeneratorData> result = new ArrayList<GeneratorData>(parentsData.size() + childrenData.size());
        Collections.reverse(parentsData);
        result.addAll(parentsData);
        result.addAll(childrenData);
        return result.toArray(new GeneratorData[result.size()]);
    }

    private List<GeneratorData> getGeneratorData(Object object, Object projectType, boolean forGenerate, boolean forChildren, boolean skipFirst, Set<Object> objects) {
        ArrayList<GeneratorData> result = new ArrayList<GeneratorData>();
        result.add((GeneratorData)object);
        int i = 0;
        while (i < result.size()) {
            Object o = result.get(i);
            Collection<GeneratorAdapter> adapters = this.getAdapters(o);
            result.remove(i);
            if (!adapters.isEmpty()) {
                for (GeneratorAdapter adapter : adapters) {
                    if (forChildren) {
                        Collection<?> children = forGenerate ? adapter.getGenerateChildren(o, projectType) : adapter.getCanGenerateChildren(o, projectType);
                        for (Object child : children) {
                            if (!objects.add(child)) continue;
                            result.add((GeneratorData)child);
                        }
                    } else {
                        Object parent;
                        Object object2 = parent = forGenerate ? adapter.getGenerateParent(o, projectType) : adapter.getCanGenerateParent(o, projectType);
                        if (parent != null && objects.add(parent)) {
                            result.add((GeneratorData)parent);
                        }
                    }
                    if (skipFirst) continue;
                    result.add(i++, new GeneratorData(o, adapter));
                }
            }
            skipFirst = false;
        }
        ArrayList<GeneratorData> list = result;
        return list;
    }

    public boolean canGenerate(Object object, Object projectType) {
        GeneratorData[] data = this.getGeneratorData(object, projectType, false);
        int i = 0;
        while (i < data.length) {
            if (data[i].adapter.canGenerate(data[i].object, projectType)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public Diagnostic generate(Object object, Object projectType, Monitor monitor) {
        return this.generate(object, projectType, null, monitor);
    }

    public Diagnostic generate(Object object, Object projectType, String projectTypeName, Monitor monitor) {
        try {
            String message = projectTypeName != null ? CodeGenEcorePlugin.INSTANCE.getString("_UI_Generating_message", new Object[]{projectTypeName}) : CodeGenEcorePlugin.INSTANCE.getString("_UI_GeneratingCode_message");
            BasicDiagnostic result = new BasicDiagnostic("org.eclipse.emf.codegen.ecore", 0, message, null);
            GeneratorData[] data = this.getGeneratorData(object, projectType, true);
            monitor.beginTask("", data.length + 2);
            monitor.subTask(message);
            if (this.initializeNeeded) {
                this.initializeNeeded = false;
                this.initialize();
            }
            int preIndex = 0;
            while (preIndex < data.length && this.canContinue(result)) {
                result.add(data[preIndex].adapter.preGenerate(data[preIndex].object, projectType));
                ++preIndex;
            }
            monitor.worked(1);
            int i = 0;
            while (i < data.length && this.canContinue(result)) {
                result.add(data[i].adapter.generate(data[i].object, projectType, CodeGenUtil.createMonitor(monitor, 1)));
                if (monitor.isCanceled()) {
                    result.add(Diagnostic.CANCEL_INSTANCE);
                }
                ++i;
            }
            i = 0;
            while (i < preIndex) {
                result.add(data[i].adapter.postGenerate(data[i].object, projectType));
                ++i;
            }
            BasicDiagnostic basicDiagnostic = result;
            return basicDiagnostic;
        }
        finally {
            monitor.done();
        }
    }

    protected boolean canContinue(Diagnostic diagnostic) {
        return diagnostic.getSeverity() != 8;
    }

    public void dispose() {
        if (this.packageIDToAdapterFactories != null) {
            for (Collection<GeneratorAdapterFactory> adapterFactories : this.packageIDToAdapterFactories.values()) {
                for (GeneratorAdapterFactory adapterFactory : adapterFactories) {
                    adapterFactory.dispose();
                }
            }
        }
    }

    private static class GeneratorData {
        public Object object;
        public GeneratorAdapter adapter;

        public GeneratorData(Object object, GeneratorAdapter adapter) {
            this.object = object;
            this.adapter = adapter;
        }
    }

    public static class Options {
        public String redirectionPattern;
        public boolean forceOverwrite;
        public boolean dynamicTemplates;
        @Deprecated
        public String[] templatePath;
        public String mergerFacadeHelperClass;
        public String mergeRulesURI;
        public boolean codeFormatting;
        public Map<?, ?> codeFormatterOptions;
        public ResourceSet resourceSet;
        public List<String> templateClasspath;
        public Object[] data;
    }
}

