/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.grammar.v2;

import antlr.CommonToken;
import antlr.MismatchedTokenException;
import antlr.NoViableAltException;
import antlr.RecognitionException;
import antlr.Token;
import antlr.TokenWithIndex;
import antlr.TreeParser;
import antlr.collections.AST;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.antlr.analysis.DFA;
import org.antlr.analysis.LookaheadSet;
import org.antlr.analysis.NFAState;
import org.antlr.codegen.CodeGenerator;
import org.antlr.grammar.v2.CodeGenTreeWalkerTokenTypes;
import org.antlr.misc.IntSet;
import org.antlr.misc.Utils;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.antlr.tool.ErrorManager;
import org.antlr.tool.Grammar;
import org.antlr.tool.GrammarAST;
import org.antlr.tool.Rule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CodeGenTreeWalker
extends TreeParser
implements CodeGenTreeWalkerTokenTypes {
    protected static final int RULE_BLOCK_NESTING_LEVEL = 0;
    protected static final int OUTER_REWRITE_NESTING_LEVEL = 0;
    protected String currentRuleName = null;
    protected int blockNestingLevel = 0;
    protected int rewriteBlockNestingLevel = 0;
    protected int outerAltNum = 0;
    protected StringTemplate currentBlockST = null;
    protected boolean currentAltHasASTRewrite = false;
    protected int rewriteTreeNestingLevel = 0;
    protected Set rewriteRuleRefs = null;
    protected CodeGenerator generator;
    protected Grammar grammar;
    protected StringTemplateGroup templates;
    protected StringTemplate recognizerST;
    protected StringTemplate outputFileST;
    protected StringTemplate headerFileST;
    protected String outputOption = "";
    public static final String[] _tokenNames = new String[]{"<0>", "EOF", "<2>", "NULL_TREE_LOOKAHEAD", "\"options\"", "\"tokens\"", "\"parser\"", "LEXER", "RULE", "BLOCK", "OPTIONAL", "CLOSURE", "POSITIVE_CLOSURE", "SYNPRED", "RANGE", "CHAR_RANGE", "EPSILON", "ALT", "EOR", "EOB", "EOA", "ID", "ARG", "ARGLIST", "RET", "LEXER_GRAMMAR", "PARSER_GRAMMAR", "TREE_GRAMMAR", "COMBINED_GRAMMAR", "INITACTION", "FORCED_ACTION", "LABEL", "TEMPLATE", "\"scope\"", "\"import\"", "GATED_SEMPRED", "SYN_SEMPRED", "BACKTRACK_SEMPRED", "\"fragment\"", "DOT", "ACTION", "DOC_COMMENT", "SEMI", "\"lexer\"", "\"tree\"", "\"grammar\"", "AMPERSAND", "COLON", "RCURLY", "ASSIGN", "STRING_LITERAL", "CHAR_LITERAL", "INT", "STAR", "COMMA", "TOKEN_REF", "\"protected\"", "\"public\"", "\"private\"", "BANG", "ARG_ACTION", "\"returns\"", "\"throws\"", "LPAREN", "OR", "RPAREN", "\"catch\"", "\"finally\"", "PLUS_ASSIGN", "SEMPRED", "IMPLIES", "ROOT", "WILDCARD", "RULE_REF", "NOT", "TREE_BEGIN", "QUESTION", "PLUS", "OPEN_ELEMENT_OPTION", "CLOSE_ELEMENT_OPTION", "REWRITE", "ETC", "DOLLAR", "DOUBLE_QUOTE_STRING_LITERAL", "DOUBLE_ANGLE_STRING_LITERAL", "WS", "COMMENT", "SL_COMMENT", "ML_COMMENT", "STRAY_BRACKET", "ESC", "DIGIT", "XDIGIT", "NESTED_ARG_ACTION", "NESTED_ACTION", "ACTION_CHAR_LITERAL", "ACTION_STRING_LITERAL", "ACTION_ESC", "WS_LOOP", "INTERNAL_RULE_REF", "WS_OPT", "SRC"};

    public String getCurrentRuleName() {
        return this.currentRuleName;
    }

    public void setCurrentRuleName(String currentRuleName) {
        this.currentRuleName = currentRuleName;
    }

    public int getOuterAltNum() {
        return this.outerAltNum;
    }

    public void setOuterAltNum(int outerAltNum) {
        this.outerAltNum = outerAltNum;
    }

    @Override
    public void reportError(RecognitionException ex) {
        Token token = null;
        if (ex instanceof MismatchedTokenException) {
            token = ((MismatchedTokenException)ex).token;
        } else if (ex instanceof NoViableAltException) {
            token = ((NoViableAltException)ex).token;
        }
        ErrorManager.syntaxError(100, this.grammar, token, "codegen: " + ex.toString(), ex);
    }

    @Override
    public void reportError(String s) {
        System.out.println("codegen: error: " + s);
    }

    protected StringTemplate getWildcardST(GrammarAST elementAST, GrammarAST ast_suffix, String label) {
        String name = "wildcard";
        if (this.grammar.type == 1) {
            name = "wildcardChar";
        }
        return this.getTokenElementST(name, name, elementAST, ast_suffix, label);
    }

    protected StringTemplate getRuleElementST(String name, String ruleTargetName, GrammarAST elementAST, GrammarAST ast_suffix, String label) {
        String suffix = this.getSTSuffix(elementAST, ast_suffix, label);
        name = name + suffix;
        Rule r = this.grammar.getRule(this.currentRuleName);
        if (!(!this.grammar.buildAST() && suffix.length() <= 0 || label != null || r != null && r.isSynPred)) {
            label = this.generator.createUniqueLabel(ruleTargetName);
            CommonToken labelTok = new CommonToken(21, label);
            this.grammar.defineRuleRefLabel(this.currentRuleName, labelTok, elementAST);
        }
        StringTemplate elementST = this.templates.getInstanceOf(name);
        if (label != null) {
            elementST.setAttribute("label", label);
        }
        return elementST;
    }

    protected StringTemplate getTokenElementST(String name, String elementName, GrammarAST elementAST, GrammarAST ast_suffix, String label) {
        String suffix = this.getSTSuffix(elementAST, ast_suffix, label);
        name = name + suffix;
        Rule r = this.grammar.getRule(this.currentRuleName);
        if (!(!this.grammar.buildAST() && suffix.length() <= 0 || label != null || r != null && r.isSynPred)) {
            label = this.generator.createUniqueLabel(elementName);
            CommonToken labelTok = new CommonToken(21, label);
            this.grammar.defineTokenRefLabel(this.currentRuleName, labelTok, elementAST);
        }
        StringTemplate elementST = this.templates.getInstanceOf(name);
        if (label != null) {
            elementST.setAttribute("label", label);
        }
        return elementST;
    }

    public boolean isListLabel(String label) {
        boolean hasListLabel = false;
        if (label != null) {
            Grammar.LabelElementPair pair;
            Rule r = this.grammar.getRule(this.currentRuleName);
            Object stName = null;
            if (r != null && (pair = r.getLabel(label)) != null && (pair.type == 4 || pair.type == 3 || pair.type == 7)) {
                hasListLabel = true;
            }
        }
        return hasListLabel;
    }

    protected String getSTSuffix(GrammarAST elementAST, GrammarAST ast_suffix, String label) {
        if (this.grammar.type == 1) {
            return "";
        }
        String operatorPart = "";
        String rewritePart = "";
        String listLabelPart = "";
        Rule ruleDescr = this.grammar.getRule(this.currentRuleName);
        if (ast_suffix != null && !ruleDescr.isSynPred) {
            if (ast_suffix.getType() == 71) {
                operatorPart = "RuleRoot";
            } else if (ast_suffix.getType() == 59) {
                operatorPart = "Bang";
            }
        }
        if (this.currentAltHasASTRewrite && elementAST.getType() != 72) {
            rewritePart = "Track";
        }
        if (this.isListLabel(label)) {
            listLabelPart = "AndListLabel";
        }
        String STsuffix = operatorPart + rewritePart + listLabelPart;
        return STsuffix;
    }

    protected List<String> getTokenTypesAsTargetLabels(Set<GrammarAST> refs) {
        if (refs == null || refs.size() == 0) {
            return null;
        }
        ArrayList<String> labels = new ArrayList<String>(refs.size());
        for (GrammarAST t : refs) {
            String label = t.getType() == 73 ? t.getText() : (t.getType() == 31 ? t.getText() : this.generator.getTokenTypeAsTargetLabel(this.grammar.getTokenType(t.getText())));
            labels.add(label);
        }
        return labels;
    }

    public void init(Grammar g) {
        this.grammar = g;
        this.generator = this.grammar.getCodeGenerator();
        this.templates = this.generator.getTemplates();
    }

    public CodeGenTreeWalker() {
        this.tokenNames = _tokenNames;
    }

    public final void grammar(AST _t, Grammar g, StringTemplate recognizerST, StringTemplate outputFileST, StringTemplate headerFileST) throws RecognitionException {
        block12: {
            GrammarAST grammar_AST_in = _t == ASTNULL ? null : (GrammarAST)_t;
            this.init(g);
            this.recognizerST = recognizerST;
            this.outputFileST = outputFileST;
            this.headerFileST = headerFileST;
            String superClass = (String)g.getOption("superClass");
            this.outputOption = (String)g.getOption("output");
            recognizerST.setAttribute("superClass", superClass);
            if (g.type != 1) {
                recognizerST.setAttribute("ASTLabelType", g.getOption("ASTLabelType"));
            }
            if (g.type == 3 && g.getOption("ASTLabelType") == null) {
                ErrorManager.grammarWarning(152, g, null, g.name);
            }
            if (g.type != 3) {
                recognizerST.setAttribute("labelType", g.getOption("TokenLabelType"));
            }
            recognizerST.setAttribute("numRules", this.grammar.getRules().size());
            outputFileST.setAttribute("numRules", this.grammar.getRules().size());
            headerFileST.setAttribute("numRules", this.grammar.getRules().size());
            try {
                if (_t == null) {
                    _t = ASTNULL;
                }
                switch (_t.getType()) {
                    case 25: {
                        AST __t3 = _t;
                        GrammarAST tmp1_AST_in = (GrammarAST)_t;
                        this.match(_t, 25);
                        _t = _t.getFirstChild();
                        this.grammarSpec(_t);
                        _t = this._retTree;
                        _t = __t3;
                        _t = _t.getNextSibling();
                        break;
                    }
                    case 26: {
                        AST __t4 = _t;
                        GrammarAST tmp2_AST_in = (GrammarAST)_t;
                        this.match(_t, 26);
                        _t = _t.getFirstChild();
                        this.grammarSpec(_t);
                        _t = this._retTree;
                        _t = __t4;
                        _t = _t.getNextSibling();
                        break;
                    }
                    case 27: {
                        AST __t5 = _t;
                        GrammarAST tmp3_AST_in = (GrammarAST)_t;
                        this.match(_t, 27);
                        _t = _t.getFirstChild();
                        this.grammarSpec(_t);
                        _t = this._retTree;
                        _t = __t5;
                        _t = _t.getNextSibling();
                        break;
                    }
                    case 28: {
                        AST __t6 = _t;
                        GrammarAST tmp4_AST_in = (GrammarAST)_t;
                        this.match(_t, 28);
                        _t = _t.getFirstChild();
                        this.grammarSpec(_t);
                        _t = this._retTree;
                        _t = __t6;
                        _t = _t.getNextSibling();
                        break;
                    }
                    default: {
                        throw new NoViableAltException(_t);
                    }
                }
            }
            catch (RecognitionException ex) {
                this.reportError(ex);
                if (_t == null) break block12;
                _t = _t.getNextSibling();
            }
        }
        this._retTree = _t;
    }

    public final void grammarSpec(AST _t) throws RecognitionException {
        block29: {
            GrammarAST grammarSpec_AST_in = _t == ASTNULL ? null : (GrammarAST)_t;
            GrammarAST name = null;
            GrammarAST cmt = null;
            try {
                name = (GrammarAST)_t;
                this.match(_t, 21);
                _t = _t.getNextSibling();
                if (_t == null) {
                    _t = ASTNULL;
                }
                switch (_t.getType()) {
                    case 41: {
                        cmt = (GrammarAST)_t;
                        this.match(_t, 41);
                        _t = _t.getNextSibling();
                        this.outputFileST.setAttribute("docComment", cmt.getText());
                        this.headerFileST.setAttribute("docComment", cmt.getText());
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 8: 
                    case 33: 
                    case 34: 
                    case 46: {
                        break;
                    }
                    default: {
                        throw new NoViableAltException(_t);
                    }
                }
                this.recognizerST.setAttribute("name", this.grammar.getRecognizerName());
                this.outputFileST.setAttribute("name", this.grammar.getRecognizerName());
                this.headerFileST.setAttribute("name", this.grammar.getRecognizerName());
                this.recognizerST.setAttribute("scopes", this.grammar.getGlobalScopes());
                this.headerFileST.setAttribute("scopes", this.grammar.getGlobalScopes());
                if (_t == null) {
                    _t = ASTNULL;
                }
                switch (_t.getType()) {
                    case 4: {
                        AST __t12 = _t;
                        GrammarAST tmp5_AST_in = (GrammarAST)_t;
                        this.match(_t, 4);
                        _t = _t.getFirstChild();
                        GrammarAST tmp6_AST_in = (GrammarAST)_t;
                        if (_t == null) {
                            throw new MismatchedTokenException();
                        }
                        _t = _t.getNextSibling();
                        _t = __t12;
                        _t = _t.getNextSibling();
                        break;
                    }
                    case 5: 
                    case 8: 
                    case 33: 
                    case 34: 
                    case 46: {
                        break;
                    }
                    default: {
                        throw new NoViableAltException(_t);
                    }
                }
                if (_t == null) {
                    _t = ASTNULL;
                }
                switch (_t.getType()) {
                    case 34: {
                        AST __t14 = _t;
                        GrammarAST tmp7_AST_in = (GrammarAST)_t;
                        this.match(_t, 34);
                        _t = _t.getFirstChild();
                        GrammarAST tmp8_AST_in = (GrammarAST)_t;
                        if (_t == null) {
                            throw new MismatchedTokenException();
                        }
                        _t = _t.getNextSibling();
                        _t = __t14;
                        _t = _t.getNextSibling();
                        break;
                    }
                    case 5: 
                    case 8: 
                    case 33: 
                    case 46: {
                        break;
                    }
                    default: {
                        throw new NoViableAltException(_t);
                    }
                }
                if (_t == null) {
                    _t = ASTNULL;
                }
                switch (_t.getType()) {
                    case 5: {
                        AST __t16 = _t;
                        GrammarAST tmp9_AST_in = (GrammarAST)_t;
                        this.match(_t, 5);
                        _t = _t.getFirstChild();
                        GrammarAST tmp10_AST_in = (GrammarAST)_t;
                        if (_t == null) {
                            throw new MismatchedTokenException();
                        }
                        _t = _t.getNextSibling();
                        _t = __t16;
                        _t = _t.getNextSibling();
                        break;
                    }
                    case 8: 
                    case 33: 
                    case 46: {
                        break;
                    }
                    default: {
                        throw new NoViableAltException(_t);
                    }
                }
                while (true) {
                    if (_t == null) {
                        _t = ASTNULL;
                    }
                    if (_t.getType() != 33) break;
                    this.attrScope(_t);
                    _t = this._retTree;
                }
                while (true) {
                    if (_t == null) {
                        _t = ASTNULL;
                    }
                    if (_t.getType() != 46) break;
                    GrammarAST tmp11_AST_in = (GrammarAST)_t;
                    this.match(_t, 46);
                    _t = _t.getNextSibling();
                }
                this.rules(_t, this.recognizerST);
                _t = this._retTree;
            }
            catch (RecognitionException ex) {
                this.reportError(ex);
                if (_t == null) break block29;
                _t = _t.getNextSibling();
            }
        }
        this._retTree = _t;
    }

    public final void attrScope(AST _t) throws RecognitionException {
        block2: {
            GrammarAST attrScope_AST_in = _t == ASTNULL ? null : (GrammarAST)_t;
            try {
                AST __t8 = _t;
                GrammarAST tmp12_AST_in = (GrammarAST)_t;
                this.match(_t, 33);
                _t = _t.getFirstChild();
                GrammarAST tmp13_AST_in = (GrammarAST)_t;
                this.match(_t, 21);
                _t = _t.getNextSibling();
                GrammarAST tmp14_AST_in = (GrammarAST)_t;
                this.match(_t, 40);
                _t = _t.getNextSibling();
                _t = __t8;
                _t = _t.getNextSibling();
            }
            catch (RecognitionException ex) {
                this.reportError(ex);
                if (_t == null) break block2;
                _t = _t.getNextSibling();
            }
        }
        this._retTree = _t;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void rules(AST _t, StringTemplate recognizerST) throws RecognitionException {
        block10: {
            GrammarAST rules_AST_in = _t == ASTNULL ? null : (GrammarAST)_t;
            try {
                int _cnt24 = 0;
                while (true) {
                    if (_t == null) {
                        _t = ASTNULL;
                    }
                    if (_t.getType() != 8) {
                        if (_cnt24 < 1) {
                            throw new NoViableAltException(_t);
                        }
                        break;
                    }
                    String ruleName = _t.getFirstChild().getText();
                    Rule r = this.grammar.getRule(ruleName);
                    if (_t == null) {
                        _t = ASTNULL;
                    }
                    if (_t.getType() == 8 && this.grammar.generateMethodForRule(ruleName)) {
                        StringTemplate rST = this.rule(_t);
                        _t = this._retTree;
                        if (rST != null) {
                            recognizerST.setAttribute("rules", rST);
                            this.outputFileST.setAttribute("rules", rST);
                            this.headerFileST.setAttribute("rules", rST);
                        }
                    } else {
                        if (_t.getType() != 8) throw new NoViableAltException(_t);
                        GrammarAST tmp15_AST_in = (GrammarAST)_t;
                        this.match(_t, 8);
                        _t = _t.getNextSibling();
                    }
                    ++_cnt24;
                }
            }
            catch (RecognitionException ex) {
                this.reportError(ex);
                if (_t == null) break block10;
                _t = _t.getNextSibling();
            }
        }
        this._retTree = _t;
    }

    public final StringTemplate rule(AST _t) throws RecognitionException {
        StringTemplate code;
        block48: {
            code = null;
            GrammarAST rule_AST_in = _t == ASTNULL ? null : (GrammarAST)_t;
            GrammarAST id = null;
            GrammarAST mod = null;
            Object initAction = null;
            GrammarAST block = rule_AST_in.getFirstChildWithType(9);
            DFA dfa = block.getLookaheadDFA();
            this.blockNestingLevel = -1;
            Rule ruleDescr = this.grammar.getRule(rule_AST_in.getFirstChild().getText());
            StringTemplateGroup saveGroup = this.templates;
            if (ruleDescr.isSynPred) {
                this.templates = this.generator.getBaseTemplates();
            }
            try {
                String r;
                AST __t26 = _t;
                GrammarAST tmp16_AST_in = (GrammarAST)_t;
                this.match(_t, 8);
                _t = _t.getFirstChild();
                id = (GrammarAST)_t;
                this.match(_t, 21);
                _t = _t.getNextSibling();
                this.currentRuleName = r = id.getText();
                if (_t == null) {
                    _t = ASTNULL;
                }
                switch (_t.getType()) {
                    case 38: 
                    case 56: 
                    case 57: 
                    case 58: {
                        mod = _t == ASTNULL ? null : (GrammarAST)_t;
                        this.modifier(_t);
                        _t = this._retTree;
                        break;
                    }
                    case 22: {
                        break;
                    }
                    default: {
                        throw new NoViableAltException(_t);
                    }
                }
                AST __t28 = _t;
                GrammarAST tmp17_AST_in = (GrammarAST)_t;
                this.match(_t, 22);
                _t = _t.getFirstChild();
                if (_t == null) {
                    _t = ASTNULL;
                }
                switch (_t.getType()) {
                    case 60: {
                        GrammarAST tmp18_AST_in = (GrammarAST)_t;
                        this.match(_t, 60);
                        _t = _t.getNextSibling();
                        break;
                    }
                    case 3: {
                        break;
                    }
                    default: {
                        throw new NoViableAltException(_t);
                    }
                }
                _t = __t28;
                AST __t30 = _t = _t.getNextSibling();
                GrammarAST tmp19_AST_in = (GrammarAST)_t;
                this.match(_t, 24);
                _t = _t.getFirstChild();
                if (_t == null) {
                    _t = ASTNULL;
                }
                switch (_t.getType()) {
                    case 60: {
                        GrammarAST tmp20_AST_in = (GrammarAST)_t;
                        this.match(_t, 60);
                        _t = _t.getNextSibling();
                        break;
                    }
                    case 3: {
                        break;
                    }
                    default: {
                        throw new NoViableAltException(_t);
                    }
                }
                _t = __t30;
                _t = _t.getNextSibling();
                if (_t == null) {
                    _t = ASTNULL;
                }
                switch (_t.getType()) {
                    case 4: {
                        AST __t33 = _t;
                        GrammarAST tmp21_AST_in = (GrammarAST)_t;
                        this.match(_t, 4);
                        _t = _t.getFirstChild();
                        GrammarAST tmp22_AST_in = (GrammarAST)_t;
                        if (_t == null) {
                            throw new MismatchedTokenException();
                        }
                        _t = _t.getNextSibling();
                        _t = __t33;
                        _t = _t.getNextSibling();
                        break;
                    }
                    case 9: 
                    case 33: 
                    case 46: {
                        break;
                    }
                    default: {
                        throw new NoViableAltException(_t);
                    }
                }
                if (_t == null) {
                    _t = ASTNULL;
                }
                switch (_t.getType()) {
                    case 33: {
                        this.ruleScopeSpec(_t);
                        _t = this._retTree;
                        break;
                    }
                    case 9: 
                    case 46: {
                        break;
                    }
                    default: {
                        throw new NoViableAltException(_t);
                    }
                }
                while (true) {
                    if (_t == null) {
                        _t = ASTNULL;
                    }
                    if (_t.getType() != 46) break;
                    GrammarAST tmp23_AST_in = (GrammarAST)_t;
                    this.match(_t, 46);
                    _t = _t.getNextSibling();
                }
                StringTemplate b2 = this.block(_t, "ruleBlock", dfa);
                _t = this._retTree;
                String description = this.grammar.grammarTreeToString(rule_AST_in.getFirstChildWithType(9), false);
                description = this.generator.target.getTargetStringLiteralFromString(description);
                b2.setAttribute("description", description);
                String stName = null;
                if (ruleDescr.isSynPred) {
                    stName = "synpredRule";
                } else if (this.grammar.type == 1) {
                    stName = r.equals("Tokens") ? "tokensRule" : "lexerRule";
                } else if (this.grammar.type != 4 || !Character.isUpperCase(r.charAt(0))) {
                    stName = "rule";
                }
                code = this.templates.getInstanceOf(stName);
                if (code.getName().equals("rule")) {
                    code.setAttribute("emptyRule", this.grammar.isEmptyRule(block));
                }
                code.setAttribute("ruleDescriptor", ruleDescr);
                String memo = (String)this.grammar.getBlockOption(rule_AST_in, "memoize");
                if (memo == null) {
                    memo = (String)this.grammar.getOption("memoize");
                }
                if (memo != null && memo.equals("true") && (stName.equals("rule") || stName.equals("lexerRule"))) {
                    code.setAttribute("memoize", memo != null && memo.equals("true"));
                }
                if (_t == null) {
                    _t = ASTNULL;
                }
                switch (_t.getType()) {
                    case 66: 
                    case 67: {
                        this.exceptionGroup(_t, code);
                        _t = this._retTree;
                        break;
                    }
                    case 18: {
                        break;
                    }
                    default: {
                        throw new NoViableAltException(_t);
                    }
                }
                GrammarAST tmp24_AST_in = (GrammarAST)_t;
                this.match(_t, 18);
                _t = _t.getNextSibling();
                _t = __t26;
                _t = _t.getNextSibling();
                if (code != null) {
                    if (this.grammar.type == 1) {
                        boolean naked = r.equals("Tokens") || mod != null && mod.getText().equals("fragment");
                        code.setAttribute("nakedBlock", naked);
                    } else {
                        description = this.grammar.grammarTreeToString(rule_AST_in, false);
                        description = this.generator.target.getTargetStringLiteralFromString(description);
                        code.setAttribute("description", description);
                    }
                    Rule theRule = this.grammar.getRule(r);
                    this.generator.translateActionAttributeReferencesForSingleScope(theRule, theRule.getActions());
                    code.setAttribute("ruleName", r);
                    code.setAttribute("block", b2);
                    if (initAction != null) {
                        code.setAttribute("initAction", (Object)initAction);
                    }
                }
                this.templates = saveGroup;
            }
            catch (RecognitionException ex) {
                this.reportError(ex);
                if (_t == null) break block48;
                _t = _t.getNextSibling();
            }
        }
        this._retTree = _t;
        return code;
    }

    public final void modifier(AST _t) throws RecognitionException {
        block9: {
            GrammarAST modifier_AST_in = _t == ASTNULL ? null : (GrammarAST)_t;
            try {
                if (_t == null) {
                    _t = ASTNULL;
                }
                switch (_t.getType()) {
                    case 56: {
                        GrammarAST tmp25_AST_in = (GrammarAST)_t;
                        this.match(_t, 56);
                        _t = _t.getNextSibling();
                        break;
                    }
                    case 57: {
                        GrammarAST tmp26_AST_in = (GrammarAST)_t;
                        this.match(_t, 57);
                        _t = _t.getNextSibling();
                        break;
                    }
                    case 58: {
                        GrammarAST tmp27_AST_in = (GrammarAST)_t;
                        this.match(_t, 58);
                        _t = _t.getNextSibling();
                        break;
                    }
                    case 38: {
                        GrammarAST tmp28_AST_in = (GrammarAST)_t;
                        this.match(_t, 38);
                        _t = _t.getNextSibling();
                        break;
                    }
                    default: {
                        throw new NoViableAltException(_t);
                    }
                }
            }
            catch (RecognitionException ex) {
                this.reportError(ex);
                if (_t == null) break block9;
                _t = _t.getNextSibling();
            }
        }
        this._retTree = _t;
    }

    public final void ruleScopeSpec(AST _t) throws RecognitionException {
        block9: {
            GrammarAST ruleScopeSpec_AST_in = _t == ASTNULL ? null : (GrammarAST)_t;
            try {
                AST __t40 = _t;
                GrammarAST tmp29_AST_in = (GrammarAST)_t;
                this.match(_t, 33);
                _t = _t.getFirstChild();
                if (_t == null) {
                    _t = ASTNULL;
                }
                switch (_t.getType()) {
                    case 40: {
                        GrammarAST tmp30_AST_in = (GrammarAST)_t;
                        this.match(_t, 40);
                        _t = _t.getNextSibling();
                        break;
                    }
                    case 3: 
                    case 21: {
                        break;
                    }
                    default: {
                        throw new NoViableAltException(_t);
                    }
                }
                while (true) {
                    if (_t == null) {
                        _t = ASTNULL;
                    }
                    if (_t.getType() != 21) break;
                    GrammarAST tmp31_AST_in = (GrammarAST)_t;
                    this.match(_t, 21);
                    _t = _t.getNextSibling();
                }
                _t = __t40;
                _t = _t.getNextSibling();
            }
            catch (RecognitionException ex) {
                this.reportError(ex);
                if (_t == null) break block9;
                _t = _t.getNextSibling();
            }
        }
        this._retTree = _t;
    }

    public final StringTemplate block(AST _t, String blockTemplateName, DFA dfa) throws RecognitionException {
        StringTemplate code;
        block19: {
            code = null;
            GrammarAST block_AST_in = _t == ASTNULL ? null : (GrammarAST)_t;
            StringTemplate decision = null;
            if (dfa != null) {
                code = this.templates.getInstanceOf(blockTemplateName);
                decision = this.generator.genLookaheadDecision(this.recognizerST, dfa);
                code.setAttribute("decision", decision);
                code.setAttribute("decisionNumber", dfa.getDecisionNumber());
                code.setAttribute("maxK", dfa.getMaxLookaheadDepth());
                code.setAttribute("maxAlt", dfa.getNumberOfAlts());
            } else {
                code = this.templates.getInstanceOf(blockTemplateName + "SingleAlt");
            }
            ++this.blockNestingLevel;
            code.setAttribute("blockLevel", this.blockNestingLevel);
            code.setAttribute("enclosingBlockLevel", this.blockNestingLevel - 1);
            StringTemplate alt = null;
            StringTemplate rew = null;
            StringTemplate sb = null;
            GrammarAST r = null;
            int altNum = 1;
            if (this.blockNestingLevel == 0) {
                this.outerAltNum = 1;
            }
            try {
                if (_t == null) {
                    _t = ASTNULL;
                }
                if (_t.getType() == 9 && block_AST_in.getSetValue() != null) {
                    sb = this.setBlock(_t);
                    _t = this._retTree;
                    code.setAttribute("alts", sb);
                    --this.blockNestingLevel;
                    break block19;
                }
                if (_t.getType() == 9) {
                    AST __t45 = _t;
                    GrammarAST tmp32_AST_in = (GrammarAST)_t;
                    this.match(_t, 9);
                    _t = _t.getFirstChild();
                    if (_t == null) {
                        _t = ASTNULL;
                    }
                    switch (_t.getType()) {
                        case 4: {
                            GrammarAST tmp33_AST_in = (GrammarAST)_t;
                            this.match(_t, 4);
                            _t = _t.getNextSibling();
                            break;
                        }
                        case 17: {
                            break;
                        }
                        default: {
                            throw new NoViableAltException(_t);
                        }
                    }
                    int _cnt48 = 0;
                    while (true) {
                        if (_t == null) {
                            _t = ASTNULL;
                        }
                        if (_t.getType() == 17) {
                            boolean etc;
                            alt = this.alternative(_t);
                            _t = this._retTree;
                            r = (GrammarAST)_t;
                            rew = this.rewrite(_t);
                            _t = this._retTree;
                            if (this.blockNestingLevel == 0) {
                                ++this.outerAltNum;
                            }
                            boolean bl = etc = r.getType() == 80 && r.getFirstChild() != null && r.getFirstChild().getType() == 81;
                            if (rew != null && !etc) {
                                alt.setAttribute("rew", rew);
                            }
                            code.setAttribute("alts", alt);
                            alt.setAttribute("altNum", Utils.integer(altNum));
                            alt.setAttribute("outerAlt", this.blockNestingLevel == 0);
                            ++altNum;
                        } else {
                            if (_cnt48 >= 1) break;
                            throw new NoViableAltException(_t);
                        }
                        ++_cnt48;
                    }
                    GrammarAST tmp34_AST_in = (GrammarAST)_t;
                    this.match(_t, 19);
                    _t = _t.getNextSibling();
                    _t = __t45;
                    _t = _t.getNextSibling();
                    --this.blockNestingLevel;
                    break block19;
                }
                throw new NoViableAltException(_t);
            }
            catch (RecognitionException ex) {
                this.reportError(ex);
                if (_t == null) break block19;
                _t = _t.getNextSibling();
            }
        }
        this._retTree = _t;
        return code;
    }

    public final void exceptionGroup(AST _t, StringTemplate ruleST) throws RecognitionException {
        block15: {
            GrammarAST exceptionGroup_AST_in = _t == ASTNULL ? null : (GrammarAST)_t;
            try {
                if (_t == null) {
                    _t = ASTNULL;
                }
                block1 : switch (_t.getType()) {
                    case 66: {
                        int _cnt52 = 0;
                        while (true) {
                            if (_t == null) {
                                _t = ASTNULL;
                            }
                            if (_t.getType() != 66) {
                                if (_cnt52 >= 1) break;
                                throw new NoViableAltException(_t);
                            }
                            this.exceptionHandler(_t, ruleST);
                            _t = this._retTree;
                            ++_cnt52;
                        }
                        if (_t == null) {
                            _t = ASTNULL;
                        }
                        switch (_t.getType()) {
                            case 67: {
                                this.finallyClause(_t, ruleST);
                                _t = this._retTree;
                                break block1;
                            }
                            case 18: {
                                break block1;
                            }
                        }
                        throw new NoViableAltException(_t);
                    }
                    case 67: {
                        this.finallyClause(_t, ruleST);
                        _t = this._retTree;
                        break;
                    }
                    default: {
                        throw new NoViableAltException(_t);
                    }
                }
            }
            catch (RecognitionException ex) {
                this.reportError(ex);
                if (_t == null) break block15;
                _t = _t.getNextSibling();
            }
        }
        this._retTree = _t;
    }

    public final StringTemplate setBlock(AST _t) throws RecognitionException {
        StringTemplate code;
        block6: {
            code = null;
            GrammarAST setBlock_AST_in = _t == ASTNULL ? null : (GrammarAST)_t;
            GrammarAST s = null;
            StringTemplate setcode = null;
            if (this.blockNestingLevel == 0 && this.grammar.buildAST()) {
                Rule r = this.grammar.getRule(this.currentRuleName);
                this.currentAltHasASTRewrite = r.hasRewrite(this.outerAltNum);
                if (this.currentAltHasASTRewrite) {
                    r.trackTokenReferenceInAlt(setBlock_AST_in, this.outerAltNum);
                }
            }
            try {
                s = (GrammarAST)_t;
                this.match(_t, 9);
                _t = _t.getNextSibling();
                int i = ((TokenWithIndex)s.getToken()).getIndex();
                setcode = this.blockNestingLevel == 0 ? this.getTokenElementST("matchRuleBlockSet", "set", s, null, null) : this.getTokenElementST("matchSet", "set", s, null, null);
                setcode.setAttribute("elementIndex", i);
                if (this.grammar.type != 1) {
                    this.generator.generateLocalFOLLOW(s, "set", this.currentRuleName, i);
                }
                setcode.setAttribute("s", this.generator.genSetExpr(this.templates, s.getSetValue(), 1, false));
                StringTemplate altcode = this.templates.getInstanceOf("alt");
                altcode.setAttribute("elements.{el,line,pos}", setcode, Utils.integer(s.getLine()), Utils.integer(s.getColumn()));
                altcode.setAttribute("altNum", Utils.integer(1));
                altcode.setAttribute("outerAlt", this.blockNestingLevel == 0);
                if (!this.currentAltHasASTRewrite && this.grammar.buildAST()) {
                    altcode.setAttribute("autoAST", true);
                }
                altcode.setAttribute("treeLevel", this.rewriteTreeNestingLevel);
                code = altcode;
            }
            catch (RecognitionException ex) {
                this.reportError(ex);
                if (_t == null) break block6;
                _t = _t.getNextSibling();
            }
        }
        this._retTree = _t;
        return code;
    }

    public final StringTemplate alternative(AST _t) throws RecognitionException {
        StringTemplate code;
        block9: {
            code = this.templates.getInstanceOf("alt");
            GrammarAST alternative_AST_in = _t == ASTNULL ? null : (GrammarAST)_t;
            GrammarAST a2 = null;
            if (this.blockNestingLevel == 0 && this.grammar.buildAST()) {
                Rule r = this.grammar.getRule(this.currentRuleName);
                this.currentAltHasASTRewrite = r.hasRewrite(this.outerAltNum);
            }
            String description = this.grammar.grammarTreeToString(alternative_AST_in, false);
            description = this.generator.target.getTargetStringLiteralFromString(description);
            code.setAttribute("description", description);
            code.setAttribute("treeLevel", this.rewriteTreeNestingLevel);
            if (!this.currentAltHasASTRewrite && this.grammar.buildAST()) {
                code.setAttribute("autoAST", true);
            }
            try {
                AST __t59 = _t;
                a2 = _t == ASTNULL ? null : (GrammarAST)_t;
                this.match(_t, 17);
                _t = _t.getFirstChild();
                int _cnt61 = 0;
                while (true) {
                    if (_t == null) {
                        _t = ASTNULL;
                    }
                    if (_t.getType() == 9 || _t.getType() == 10 || _t.getType() == 11 || _t.getType() == 12 || _t.getType() == 15 || _t.getType() == 16 || _t.getType() == 30 || _t.getType() == 35 || _t.getType() == 36 || _t.getType() == 37 || _t.getType() == 39 || _t.getType() == 40 || _t.getType() == 49 || _t.getType() == 50 || _t.getType() == 51 || _t.getType() == 55 || _t.getType() == 59 || _t.getType() == 68 || _t.getType() == 69 || _t.getType() == 71 || _t.getType() == 72 || _t.getType() == 73 || _t.getType() == 74 || _t.getType() == 75) {
                        GrammarAST elAST = (GrammarAST)_t;
                        StringTemplate e = this.element(_t, null, null);
                        _t = this._retTree;
                        if (e != null) {
                            code.setAttribute("elements.{el,line,pos}", e, Utils.integer(elAST.getLine()), Utils.integer(elAST.getColumn()));
                        }
                    } else {
                        if (_cnt61 >= 1) break;
                        throw new NoViableAltException(_t);
                    }
                    ++_cnt61;
                }
                GrammarAST tmp35_AST_in = (GrammarAST)_t;
                this.match(_t, 20);
                _t = _t.getNextSibling();
                _t = __t59;
                _t = _t.getNextSibling();
            }
            catch (RecognitionException ex) {
                this.reportError(ex);
                if (_t == null) break block9;
                _t = _t.getNextSibling();
            }
        }
        this._retTree = _t;
        return code;
    }

    public final StringTemplate rewrite(AST _t) throws RecognitionException {
        StringTemplate code;
        block15: {
            code = null;
            GrammarAST rewrite_AST_in = _t == ASTNULL ? null : (GrammarAST)_t;
            GrammarAST r = null;
            GrammarAST pred = null;
            if (rewrite_AST_in.getType() == 80) {
                if (this.generator.grammar.buildTemplate()) {
                    code = this.templates.getInstanceOf("rewriteTemplate");
                } else {
                    code = this.templates.getInstanceOf("rewriteCode");
                    code.setAttribute("treeLevel", Utils.integer(0));
                    code.setAttribute("rewriteBlockLevel", Utils.integer(0));
                    code.setAttribute("referencedElementsDeep", this.getTokenTypesAsTargetLabels(rewrite_AST_in.rewriteRefsDeep));
                    Set<String> tokenLabels = this.grammar.getLabels(rewrite_AST_in.rewriteRefsDeep, 2);
                    Set<String> tokenListLabels = this.grammar.getLabels(rewrite_AST_in.rewriteRefsDeep, 4);
                    Set<String> ruleLabels = this.grammar.getLabels(rewrite_AST_in.rewriteRefsDeep, 1);
                    Set<String> ruleListLabels = this.grammar.getLabels(rewrite_AST_in.rewriteRefsDeep, 3);
                    Set<String> wildcardLabels = this.grammar.getLabels(rewrite_AST_in.rewriteRefsDeep, 6);
                    Set<String> wildcardListLabels = this.grammar.getLabels(rewrite_AST_in.rewriteRefsDeep, 7);
                    StringTemplate retvalST = this.templates.getInstanceOf("prevRuleRootRef");
                    ruleLabels.add(retvalST.toString());
                    code.setAttribute("referencedTokenLabels", tokenLabels);
                    code.setAttribute("referencedTokenListLabels", tokenListLabels);
                    code.setAttribute("referencedRuleLabels", ruleLabels);
                    code.setAttribute("referencedRuleListLabels", ruleListLabels);
                    code.setAttribute("referencedWildcardLabels", wildcardLabels);
                    code.setAttribute("referencedWildcardListLabels", wildcardListLabels);
                }
            } else {
                code = this.templates.getInstanceOf("noRewrite");
                code.setAttribute("treeLevel", Utils.integer(0));
                code.setAttribute("rewriteBlockLevel", Utils.integer(0));
            }
            try {
                while (true) {
                    if (_t == null) {
                        _t = ASTNULL;
                    }
                    if (_t.getType() == 80) {
                        this.rewriteRuleRefs = new HashSet();
                        AST __t96 = _t;
                        r = _t == ASTNULL ? null : (GrammarAST)_t;
                        this.match(_t, 80);
                        _t = _t.getFirstChild();
                        if (_t == null) {
                            _t = ASTNULL;
                        }
                        switch (_t.getType()) {
                            case 69: {
                                pred = (GrammarAST)_t;
                                this.match(_t, 69);
                                _t = _t.getNextSibling();
                                break;
                            }
                            case 17: 
                            case 32: 
                            case 40: 
                            case 81: {
                                break;
                            }
                            default: {
                                throw new NoViableAltException(_t);
                            }
                        }
                        StringTemplate alt = this.rewrite_alternative(_t);
                        _t = this._retTree;
                        _t = __t96;
                        _t = _t.getNextSibling();
                        this.rewriteBlockNestingLevel = 0;
                        List predChunks = null;
                        if (pred != null) {
                            predChunks = this.generator.translateAction(this.currentRuleName, pred);
                        }
                        String description = this.grammar.grammarTreeToString(r, false);
                        description = this.generator.target.getTargetStringLiteralFromString(description);
                        code.setAttribute("alts.{pred,alt,description}", predChunks, alt, description);
                        pred = null;
                        continue;
                    }
                    break;
                }
            }
            catch (RecognitionException ex) {
                this.reportError(ex);
                if (_t == null) break block15;
                _t = _t.getNextSibling();
            }
        }
        this._retTree = _t;
        return code;
    }

    public final void exceptionHandler(AST _t, StringTemplate ruleST) throws RecognitionException {
        block2: {
            GrammarAST exceptionHandler_AST_in = _t == ASTNULL ? null : (GrammarAST)_t;
            try {
                AST __t55 = _t;
                GrammarAST tmp36_AST_in = (GrammarAST)_t;
                this.match(_t, 66);
                _t = _t.getFirstChild();
                GrammarAST tmp37_AST_in = (GrammarAST)_t;
                this.match(_t, 60);
                _t = _t.getNextSibling();
                GrammarAST tmp38_AST_in = (GrammarAST)_t;
                this.match(_t, 40);
                _t = _t.getNextSibling();
                _t = __t55;
                _t = _t.getNextSibling();
                List chunks = this.generator.translateAction(this.currentRuleName, tmp38_AST_in);
                ruleST.setAttribute("exceptions.{decl,action}", tmp37_AST_in.getText(), chunks);
            }
            catch (RecognitionException ex) {
                this.reportError(ex);
                if (_t == null) break block2;
                _t = _t.getNextSibling();
            }
        }
        this._retTree = _t;
    }

    public final void finallyClause(AST _t, StringTemplate ruleST) throws RecognitionException {
        block2: {
            GrammarAST finallyClause_AST_in = _t == ASTNULL ? null : (GrammarAST)_t;
            try {
                AST __t57 = _t;
                GrammarAST tmp39_AST_in = (GrammarAST)_t;
                this.match(_t, 67);
                _t = _t.getFirstChild();
                GrammarAST tmp40_AST_in = (GrammarAST)_t;
                this.match(_t, 40);
                _t = _t.getNextSibling();
                _t = __t57;
                _t = _t.getNextSibling();
                List chunks = this.generator.translateAction(this.currentRuleName, tmp40_AST_in);
                ruleST.setAttribute("finally", chunks);
            }
            catch (RecognitionException ex) {
                this.reportError(ex);
                if (_t == null) break block2;
                _t = _t.getNextSibling();
            }
        }
        this._retTree = _t;
    }

    public final StringTemplate element(AST _t, GrammarAST label, GrammarAST astSuffix) throws RecognitionException {
        StringTemplate code;
        block26: {
            code = null;
            GrammarAST element_AST_in = _t == ASTNULL ? null : (GrammarAST)_t;
            GrammarAST n = null;
            GrammarAST alabel = null;
            GrammarAST label2 = null;
            GrammarAST a2 = null;
            GrammarAST b2 = null;
            GrammarAST sp = null;
            GrammarAST gsp = null;
            Object elements = null;
            Object ast = null;
            try {
                if (_t == null) {
                    _t = ASTNULL;
                }
                switch (_t.getType()) {
                    case 71: {
                        AST __t63 = _t;
                        GrammarAST tmp41_AST_in = (GrammarAST)_t;
                        this.match(_t, 71);
                        _t = _t.getFirstChild();
                        code = this.element(_t, label, tmp41_AST_in);
                        _t = this._retTree;
                        _t = __t63;
                        _t = _t.getNextSibling();
                        break;
                    }
                    case 59: {
                        AST __t64 = _t;
                        GrammarAST tmp42_AST_in = (GrammarAST)_t;
                        this.match(_t, 59);
                        _t = _t.getFirstChild();
                        code = this.element(_t, label, tmp42_AST_in);
                        _t = this._retTree;
                        _t = __t64;
                        _t = _t.getNextSibling();
                        break;
                    }
                    case 74: {
                        AST __t65 = _t;
                        n = _t == ASTNULL ? null : (GrammarAST)_t;
                        this.match(_t, 74);
                        _t = _t.getFirstChild();
                        code = this.notElement(_t, n, label, astSuffix);
                        _t = this._retTree;
                        _t = __t65;
                        _t = _t.getNextSibling();
                        break;
                    }
                    case 49: {
                        AST __t66 = _t;
                        GrammarAST tmp43_AST_in = (GrammarAST)_t;
                        this.match(_t, 49);
                        _t = _t.getFirstChild();
                        alabel = (GrammarAST)_t;
                        this.match(_t, 21);
                        _t = _t.getNextSibling();
                        code = this.element(_t, alabel, astSuffix);
                        _t = this._retTree;
                        _t = __t66;
                        _t = _t.getNextSibling();
                        break;
                    }
                    case 68: {
                        AST __t67 = _t;
                        GrammarAST tmp44_AST_in = (GrammarAST)_t;
                        this.match(_t, 68);
                        _t = _t.getFirstChild();
                        label2 = (GrammarAST)_t;
                        this.match(_t, 21);
                        _t = _t.getNextSibling();
                        code = this.element(_t, label2, astSuffix);
                        _t = this._retTree;
                        _t = __t67;
                        _t = _t.getNextSibling();
                        break;
                    }
                    case 15: {
                        AST __t68 = _t;
                        GrammarAST tmp45_AST_in = (GrammarAST)_t;
                        this.match(_t, 15);
                        _t = _t.getFirstChild();
                        a2 = (GrammarAST)_t;
                        this.match(_t, 51);
                        _t = _t.getNextSibling();
                        b2 = (GrammarAST)_t;
                        this.match(_t, 51);
                        _t = _t.getNextSibling();
                        _t = __t68;
                        _t = _t.getNextSibling();
                        code = this.templates.getInstanceOf("charRangeRef");
                        String low = this.generator.target.getTargetCharLiteralFromANTLRCharLiteral(this.generator, a2.getText());
                        String high = this.generator.target.getTargetCharLiteralFromANTLRCharLiteral(this.generator, b2.getText());
                        code.setAttribute("a", low);
                        code.setAttribute("b", high);
                        if (label != null) {
                            code.setAttribute("label", label.getText());
                        }
                        break;
                    }
                    case 75: {
                        code = this.tree(_t);
                        _t = this._retTree;
                        break;
                    }
                    case 30: 
                    case 40: {
                        code = this.element_action(_t);
                        _t = this._retTree;
                        break;
                    }
                    case 35: 
                    case 69: {
                        if (_t == null) {
                            _t = ASTNULL;
                        }
                        switch (_t.getType()) {
                            case 69: {
                                sp = (GrammarAST)_t;
                                this.match(_t, 69);
                                _t = _t.getNextSibling();
                                break;
                            }
                            case 35: {
                                gsp = (GrammarAST)_t;
                                this.match(_t, 35);
                                _t = _t.getNextSibling();
                                sp = gsp;
                                break;
                            }
                            default: {
                                throw new NoViableAltException(_t);
                            }
                        }
                        code = this.templates.getInstanceOf("validateSemanticPredicate");
                        code.setAttribute("pred", this.generator.translateAction(this.currentRuleName, sp));
                        String description = this.generator.target.getTargetStringLiteralFromString(sp.getText());
                        code.setAttribute("description", description);
                        break;
                    }
                    case 36: {
                        GrammarAST tmp46_AST_in = (GrammarAST)_t;
                        this.match(_t, 36);
                        _t = _t.getNextSibling();
                        break;
                    }
                    case 37: {
                        GrammarAST tmp47_AST_in = (GrammarAST)_t;
                        this.match(_t, 37);
                        _t = _t.getNextSibling();
                        break;
                    }
                    case 16: {
                        GrammarAST tmp48_AST_in = (GrammarAST)_t;
                        this.match(_t, 16);
                        _t = _t.getNextSibling();
                        break;
                    }
                    default: {
                        if (_t == null) {
                            _t = ASTNULL;
                        }
                        if (_t.getType() >= 9 && _t.getType() <= 12 && element_AST_in.getSetValue() == null) {
                            code = this.ebnf(_t);
                            _t = this._retTree;
                            break;
                        }
                        if (_t.getType() == 9 || _t.getType() == 39 || _t.getType() == 50 || _t.getType() == 51 || _t.getType() == 55 || _t.getType() == 72 || _t.getType() == 73) {
                            code = this.atom(_t, null, label, astSuffix);
                            _t = this._retTree;
                            break;
                        }
                        throw new NoViableAltException(_t);
                    }
                }
            }
            catch (RecognitionException ex) {
                this.reportError(ex);
                if (_t == null) break block26;
                _t = _t.getNextSibling();
            }
        }
        this._retTree = _t;
        return code;
    }

    public final StringTemplate notElement(AST _t, GrammarAST n, GrammarAST label, GrammarAST astSuffix) throws RecognitionException {
        StringTemplate code;
        block12: {
            code = null;
            GrammarAST notElement_AST_in = _t == ASTNULL ? null : (GrammarAST)_t;
            GrammarAST assign_c = null;
            GrammarAST assign_s = null;
            GrammarAST assign_t = null;
            GrammarAST assign_st = null;
            IntSet elements = null;
            String labelText = null;
            if (label != null) {
                labelText = label.getText();
            }
            try {
                if (_t == null) {
                    _t = ASTNULL;
                }
                switch (_t.getType()) {
                    case 51: {
                        assign_c = (GrammarAST)_t;
                        this.match(_t, 51);
                        _t = _t.getNextSibling();
                        int ttype = 0;
                        ttype = this.grammar.type == 1 ? Grammar.getCharValueFromGrammarCharLiteral(assign_c.getText()) : this.grammar.getTokenType(assign_c.getText());
                        elements = this.grammar.complement(ttype);
                        break;
                    }
                    case 50: {
                        assign_s = (GrammarAST)_t;
                        this.match(_t, 50);
                        _t = _t.getNextSibling();
                        int ttype = 0;
                        if (this.grammar.type != 1) {
                            ttype = this.grammar.getTokenType(assign_s.getText());
                        }
                        elements = this.grammar.complement(ttype);
                        break;
                    }
                    case 55: {
                        assign_t = (GrammarAST)_t;
                        this.match(_t, 55);
                        _t = _t.getNextSibling();
                        int ttype = this.grammar.getTokenType(assign_t.getText());
                        elements = this.grammar.complement(ttype);
                        break;
                    }
                    case 9: {
                        assign_st = (GrammarAST)_t;
                        this.match(_t, 9);
                        _t = _t.getNextSibling();
                        elements = assign_st.getSetValue();
                        elements = this.grammar.complement(elements);
                        break;
                    }
                    default: {
                        throw new NoViableAltException(_t);
                    }
                }
                code = this.getTokenElementST("matchSet", "set", (GrammarAST)n.getFirstChild(), astSuffix, labelText);
                code.setAttribute("s", this.generator.genSetExpr(this.templates, elements, 1, false));
                int i = ((TokenWithIndex)n.getToken()).getIndex();
                code.setAttribute("elementIndex", i);
                if (this.grammar.type != 1) {
                    this.generator.generateLocalFOLLOW(n, "set", this.currentRuleName, i);
                }
            }
            catch (RecognitionException ex) {
                this.reportError(ex);
                if (_t == null) break block12;
                _t = _t.getNextSibling();
            }
        }
        this._retTree = _t;
        return code;
    }

    public final StringTemplate ebnf(AST _t) throws RecognitionException {
        StringTemplate code;
        block9: {
            code = null;
            GrammarAST ebnf_AST_in = _t == ASTNULL ? null : (GrammarAST)_t;
            DFA dfa = null;
            GrammarAST b2 = (GrammarAST)ebnf_AST_in.getFirstChild();
            GrammarAST eob = b2.getLastChild();
            try {
                if (_t == null) {
                    _t = ASTNULL;
                }
                switch (_t.getType()) {
                    case 9: {
                        dfa = ebnf_AST_in.getLookaheadDFA();
                        code = this.block(_t, "block", dfa);
                        _t = this._retTree;
                        break;
                    }
                    case 10: {
                        dfa = ebnf_AST_in.getLookaheadDFA();
                        AST __t75 = _t;
                        GrammarAST tmp49_AST_in = (GrammarAST)_t;
                        this.match(_t, 10);
                        _t = _t.getFirstChild();
                        code = this.block(_t, "optionalBlock", dfa);
                        _t = this._retTree;
                        _t = __t75;
                        _t = _t.getNextSibling();
                        break;
                    }
                    case 11: {
                        dfa = eob.getLookaheadDFA();
                        AST __t76 = _t;
                        GrammarAST tmp50_AST_in = (GrammarAST)_t;
                        this.match(_t, 11);
                        _t = _t.getFirstChild();
                        code = this.block(_t, "closureBlock", dfa);
                        _t = this._retTree;
                        _t = __t76;
                        _t = _t.getNextSibling();
                        break;
                    }
                    case 12: {
                        dfa = eob.getLookaheadDFA();
                        AST __t77 = _t;
                        GrammarAST tmp51_AST_in = (GrammarAST)_t;
                        this.match(_t, 12);
                        _t = _t.getFirstChild();
                        code = this.block(_t, "positiveClosureBlock", dfa);
                        _t = this._retTree;
                        _t = __t77;
                        _t = _t.getNextSibling();
                        break;
                    }
                    default: {
                        throw new NoViableAltException(_t);
                    }
                }
                String description = this.grammar.grammarTreeToString(ebnf_AST_in, false);
                description = this.generator.target.getTargetStringLiteralFromString(description);
                code.setAttribute("description", description);
            }
            catch (RecognitionException ex) {
                this.reportError(ex);
                if (_t == null) break block9;
                _t = _t.getNextSibling();
            }
        }
        this._retTree = _t;
        return code;
    }

    public final StringTemplate atom(AST _t, GrammarAST scope, GrammarAST label, GrammarAST astSuffix) throws RecognitionException {
        StringTemplate code;
        block52: {
            Rule encRule;
            code = null;
            GrammarAST atom_AST_in = _t == ASTNULL ? null : (GrammarAST)_t;
            GrammarAST r = null;
            GrammarAST rarg = null;
            GrammarAST t = null;
            GrammarAST targ = null;
            GrammarAST c2 = null;
            GrammarAST s = null;
            GrammarAST w = null;
            String labelText = null;
            if (label != null) {
                labelText = label.getText();
            }
            if (this.grammar.type != 1 && (atom_AST_in.getType() == 73 || atom_AST_in.getType() == 55 || atom_AST_in.getType() == 51 || atom_AST_in.getType() == 50) && (encRule = this.grammar.getRule(atom_AST_in.enclosingRuleName)) != null && encRule.hasRewrite(this.outerAltNum) && astSuffix != null) {
                ErrorManager.grammarError(165, this.grammar, atom_AST_in.getToken(), atom_AST_in.enclosingRuleName, new Integer(this.outerAltNum));
                astSuffix = null;
            }
            try {
                if (_t == null) {
                    _t = ASTNULL;
                }
                switch (_t.getType()) {
                    case 73: {
                        Rule rdef;
                        AST __t85 = _t;
                        r = _t == ASTNULL ? null : (GrammarAST)_t;
                        this.match(_t, 73);
                        _t = _t.getFirstChild();
                        if (_t == null) {
                            _t = ASTNULL;
                        }
                        switch (_t.getType()) {
                            case 60: {
                                rarg = (GrammarAST)_t;
                                this.match(_t, 60);
                                _t = _t.getNextSibling();
                                break;
                            }
                            case 3: {
                                break;
                            }
                            default: {
                                throw new NoViableAltException(_t);
                            }
                        }
                        _t = __t85;
                        _t = _t.getNextSibling();
                        this.grammar.checkRuleReference(scope, r, rarg, this.currentRuleName);
                        String scopeName = null;
                        if (scope != null) {
                            scopeName = scope.getText();
                        }
                        if (!(rdef = this.grammar.getRule(scopeName, r.getText())).getHasReturnValue()) {
                            labelText = null;
                        }
                        code = this.getRuleElementST("ruleRef", r.getText(), r, astSuffix, labelText);
                        code.setAttribute("rule", rdef);
                        if (scope != null) {
                            Grammar scopeG = this.grammar.composite.getGrammar(scope.getText());
                            code.setAttribute("scope", scopeG);
                        } else if (rdef.grammar != this.grammar) {
                            List<Grammar> rdefDelegates = rdef.grammar.getDelegates();
                            if (rdefDelegates.contains(this.grammar)) {
                                code.setAttribute("scope", rdef.grammar);
                            } else if (this.grammar != rdef.grammar.composite.delegateGrammarTreeRoot.grammar) {
                                code.setAttribute("scope", rdef.grammar.composite.delegateGrammarTreeRoot.grammar);
                            }
                        }
                        if (rarg != null) {
                            List args = this.generator.translateAction(this.currentRuleName, rarg);
                            code.setAttribute("args", args);
                        }
                        int i = ((TokenWithIndex)r.getToken()).getIndex();
                        code.setAttribute("elementIndex", i);
                        this.generator.generateLocalFOLLOW(r, r.getText(), this.currentRuleName, i);
                        r.code = code;
                        break;
                    }
                    case 55: {
                        AST __t87 = _t;
                        t = _t == ASTNULL ? null : (GrammarAST)_t;
                        this.match(_t, 55);
                        _t = _t.getFirstChild();
                        if (_t == null) {
                            _t = ASTNULL;
                        }
                        switch (_t.getType()) {
                            case 60: {
                                targ = (GrammarAST)_t;
                                this.match(_t, 60);
                                _t = _t.getNextSibling();
                                break;
                            }
                            case 3: {
                                break;
                            }
                            default: {
                                throw new NoViableAltException(_t);
                            }
                        }
                        _t = __t87;
                        _t = _t.getNextSibling();
                        if (this.currentAltHasASTRewrite && t.terminalOptions != null && t.terminalOptions.get("node") != null) {
                            ErrorManager.grammarError(155, this.grammar, t.getToken(), t.getText());
                        }
                        this.grammar.checkRuleReference(scope, t, targ, this.currentRuleName);
                        if (this.grammar.type == 1) {
                            if (this.grammar.getTokenType(t.getText()) == -1) {
                                code = this.templates.getInstanceOf("lexerMatchEOF");
                            } else {
                                code = this.templates.getInstanceOf("lexerRuleRef");
                                if (this.isListLabel(labelText)) {
                                    code = this.templates.getInstanceOf("lexerRuleRefAndListLabel");
                                }
                                String scopeName = null;
                                if (scope != null) {
                                    scopeName = scope.getText();
                                }
                                Rule rdef2 = this.grammar.getRule(scopeName, t.getText());
                                code.setAttribute("rule", rdef2);
                                if (scope != null) {
                                    Grammar scopeG = this.grammar.composite.getGrammar(scope.getText());
                                    code.setAttribute("scope", scopeG);
                                } else if (rdef2.grammar != this.grammar) {
                                    code.setAttribute("scope", rdef2.grammar);
                                }
                                if (targ != null) {
                                    List args = this.generator.translateAction(this.currentRuleName, targ);
                                    code.setAttribute("args", args);
                                }
                            }
                            int i = ((TokenWithIndex)t.getToken()).getIndex();
                            code.setAttribute("elementIndex", i);
                            if (label != null) {
                                code.setAttribute("label", labelText);
                            }
                        } else {
                            code = this.getTokenElementST("tokenRef", t.getText(), t, astSuffix, labelText);
                            String tokenLabel = this.generator.getTokenTypeAsTargetLabel(this.grammar.getTokenType(t.getText()));
                            code.setAttribute("token", tokenLabel);
                            if (!this.currentAltHasASTRewrite && t.terminalOptions != null) {
                                code.setAttribute("hetero", t.terminalOptions.get("node"));
                            }
                            int i = ((TokenWithIndex)t.getToken()).getIndex();
                            code.setAttribute("elementIndex", i);
                            this.generator.generateLocalFOLLOW(t, tokenLabel, this.currentRuleName, i);
                        }
                        t.code = code;
                        break;
                    }
                    case 51: {
                        c2 = (GrammarAST)_t;
                        this.match(_t, 51);
                        _t = _t.getNextSibling();
                        if (this.grammar.type == 1) {
                            code = this.templates.getInstanceOf("charRef");
                            code.setAttribute("char", this.generator.target.getTargetCharLiteralFromANTLRCharLiteral(this.generator, c2.getText()));
                            if (label != null) {
                                code.setAttribute("label", labelText);
                            }
                            break;
                        }
                        code = this.getTokenElementST("tokenRef", "char_literal", c2, astSuffix, labelText);
                        String tokenLabel = this.generator.getTokenTypeAsTargetLabel(this.grammar.getTokenType(c2.getText()));
                        code.setAttribute("token", tokenLabel);
                        if (c2.terminalOptions != null) {
                            code.setAttribute("hetero", c2.terminalOptions.get("node"));
                        }
                        int i = ((TokenWithIndex)c2.getToken()).getIndex();
                        code.setAttribute("elementIndex", i);
                        this.generator.generateLocalFOLLOW(c2, tokenLabel, this.currentRuleName, i);
                        break;
                    }
                    case 50: {
                        s = (GrammarAST)_t;
                        this.match(_t, 50);
                        _t = _t.getNextSibling();
                        if (this.grammar.type == 1) {
                            code = this.templates.getInstanceOf("lexerStringRef");
                            code.setAttribute("string", this.generator.target.getTargetStringLiteralFromANTLRStringLiteral(this.generator, s.getText()));
                            if (label != null) {
                                code.setAttribute("label", labelText);
                            }
                            break;
                        }
                        code = this.getTokenElementST("tokenRef", "string_literal", s, astSuffix, labelText);
                        String tokenLabel = this.generator.getTokenTypeAsTargetLabel(this.grammar.getTokenType(s.getText()));
                        code.setAttribute("token", tokenLabel);
                        if (s.terminalOptions != null) {
                            code.setAttribute("hetero", s.terminalOptions.get("node"));
                        }
                        int i = ((TokenWithIndex)s.getToken()).getIndex();
                        code.setAttribute("elementIndex", i);
                        this.generator.generateLocalFOLLOW(s, tokenLabel, this.currentRuleName, i);
                        break;
                    }
                    case 72: {
                        w = (GrammarAST)_t;
                        this.match(_t, 72);
                        _t = _t.getNextSibling();
                        code = this.getWildcardST(w, astSuffix, labelText);
                        code.setAttribute("elementIndex", ((TokenWithIndex)w.getToken()).getIndex());
                        break;
                    }
                    case 39: {
                        AST __t89 = _t;
                        GrammarAST tmp52_AST_in = (GrammarAST)_t;
                        this.match(_t, 39);
                        _t = _t.getFirstChild();
                        GrammarAST tmp53_AST_in = (GrammarAST)_t;
                        this.match(_t, 21);
                        _t = _t.getNextSibling();
                        code = this.atom(_t, tmp53_AST_in, label, astSuffix);
                        _t = this._retTree;
                        _t = __t89;
                        _t = _t.getNextSibling();
                        break;
                    }
                    case 9: {
                        code = this.set(_t, label, astSuffix);
                        _t = this._retTree;
                        break;
                    }
                    default: {
                        throw new NoViableAltException(_t);
                    }
                }
            }
            catch (RecognitionException ex) {
                this.reportError(ex);
                if (_t == null) break block52;
                _t = _t.getNextSibling();
            }
        }
        this._retTree = _t;
        return code;
    }

    public final StringTemplate tree(AST _t) throws RecognitionException {
        StringTemplate code;
        block8: {
            code = this.templates.getInstanceOf("tree");
            GrammarAST tree_AST_in = _t == ASTNULL ? null : (GrammarAST)_t;
            StringTemplate el = null;
            StringTemplate act = null;
            GrammarAST elAST = null;
            GrammarAST actAST = null;
            NFAState afterDOWN = (NFAState)tree_AST_in.NFATreeDownState.transition((int)0).target;
            LookaheadSet s = this.grammar.LOOK(afterDOWN);
            if (s.member(3)) {
                code.setAttribute("nullableChildList", "true");
            }
            ++this.rewriteTreeNestingLevel;
            code.setAttribute("enclosingTreeLevel", this.rewriteTreeNestingLevel - 1);
            code.setAttribute("treeLevel", this.rewriteTreeNestingLevel);
            Rule r = this.grammar.getRule(this.currentRuleName);
            GrammarAST rootSuffix = null;
            if (this.grammar.buildAST() && !r.hasRewrite(this.outerAltNum)) {
                rootSuffix = new GrammarAST(71, "ROOT");
            }
            try {
                AST __t79 = _t;
                GrammarAST tmp54_AST_in = (GrammarAST)_t;
                this.match(_t, 75);
                _t = _t.getFirstChild();
                elAST = (GrammarAST)_t;
                el = this.element(_t, null, rootSuffix);
                _t = this._retTree;
                code.setAttribute("root.{el,line,pos}", el, Utils.integer(elAST.getLine()), Utils.integer(elAST.getColumn()));
                while (true) {
                    if (_t == null) {
                        _t = ASTNULL;
                    }
                    if (_t.getType() != 30 && _t.getType() != 40) break;
                    actAST = (GrammarAST)_t;
                    act = this.element_action(_t);
                    _t = this._retTree;
                    code.setAttribute("actionsAfterRoot.{el,line,pos}", act, Utils.integer(actAST.getLine()), Utils.integer(actAST.getColumn()));
                }
                while (true) {
                    if (_t == null) {
                        _t = ASTNULL;
                    }
                    if (_t.getType() != 9 && _t.getType() != 10 && _t.getType() != 11 && _t.getType() != 12 && _t.getType() != 15 && _t.getType() != 16 && _t.getType() != 30 && _t.getType() != 35 && _t.getType() != 36 && _t.getType() != 37 && _t.getType() != 39 && _t.getType() != 40 && _t.getType() != 49 && _t.getType() != 50 && _t.getType() != 51 && _t.getType() != 55 && _t.getType() != 59 && _t.getType() != 68 && _t.getType() != 69 && _t.getType() != 71 && _t.getType() != 72 && _t.getType() != 73 && _t.getType() != 74 && _t.getType() != 75) break;
                    elAST = (GrammarAST)_t;
                    el = this.element(_t, null, null);
                    _t = this._retTree;
                    code.setAttribute("children.{el,line,pos}", el, Utils.integer(elAST.getLine()), Utils.integer(elAST.getColumn()));
                }
                _t = __t79;
                _t = _t.getNextSibling();
                --this.rewriteTreeNestingLevel;
            }
            catch (RecognitionException ex) {
                this.reportError(ex);
                if (_t == null) break block8;
                _t = _t.getNextSibling();
            }
        }
        this._retTree = _t;
        return code;
    }

    public final StringTemplate element_action(AST _t) throws RecognitionException {
        StringTemplate code;
        block7: {
            code = null;
            GrammarAST element_action_AST_in = _t == ASTNULL ? null : (GrammarAST)_t;
            GrammarAST act = null;
            GrammarAST act2 = null;
            try {
                if (_t == null) {
                    _t = ASTNULL;
                }
                switch (_t.getType()) {
                    case 40: {
                        act = (GrammarAST)_t;
                        this.match(_t, 40);
                        _t = _t.getNextSibling();
                        code = this.templates.getInstanceOf("execAction");
                        code.setAttribute("action", this.generator.translateAction(this.currentRuleName, act));
                        break;
                    }
                    case 30: {
                        act2 = (GrammarAST)_t;
                        this.match(_t, 30);
                        _t = _t.getNextSibling();
                        code = this.templates.getInstanceOf("execForcedAction");
                        code.setAttribute("action", this.generator.translateAction(this.currentRuleName, act2));
                        break;
                    }
                    default: {
                        throw new NoViableAltException(_t);
                    }
                }
            }
            catch (RecognitionException ex) {
                this.reportError(ex);
                if (_t == null) break block7;
                _t = _t.getNextSibling();
            }
        }
        this._retTree = _t;
        return code;
    }

    public final StringTemplate set(AST _t, GrammarAST label, GrammarAST astSuffix) throws RecognitionException {
        StringTemplate code;
        block4: {
            code = null;
            GrammarAST set_AST_in = _t == ASTNULL ? null : (GrammarAST)_t;
            GrammarAST s = null;
            String labelText = null;
            if (label != null) {
                labelText = label.getText();
            }
            try {
                s = (GrammarAST)_t;
                this.match(_t, 9);
                _t = _t.getNextSibling();
                code = this.getTokenElementST("matchSet", "set", s, astSuffix, labelText);
                int i = ((TokenWithIndex)s.getToken()).getIndex();
                code.setAttribute("elementIndex", i);
                if (this.grammar.type != 1) {
                    this.generator.generateLocalFOLLOW(s, "set", this.currentRuleName, i);
                }
                code.setAttribute("s", this.generator.genSetExpr(this.templates, s.getSetValue(), 1, false));
            }
            catch (RecognitionException ex) {
                this.reportError(ex);
                if (_t == null) break block4;
                _t = _t.getNextSibling();
            }
        }
        this._retTree = _t;
        return code;
    }

    public final void ast_suffix(AST _t) throws RecognitionException {
        block7: {
            GrammarAST ast_suffix_AST_in = _t == ASTNULL ? null : (GrammarAST)_t;
            try {
                if (_t == null) {
                    _t = ASTNULL;
                }
                switch (_t.getType()) {
                    case 71: {
                        GrammarAST tmp55_AST_in = (GrammarAST)_t;
                        this.match(_t, 71);
                        _t = _t.getNextSibling();
                        break;
                    }
                    case 59: {
                        GrammarAST tmp56_AST_in = (GrammarAST)_t;
                        this.match(_t, 59);
                        _t = _t.getNextSibling();
                        break;
                    }
                    default: {
                        throw new NoViableAltException(_t);
                    }
                }
            }
            catch (RecognitionException ex) {
                this.reportError(ex);
                if (_t == null) break block7;
                _t = _t.getNextSibling();
            }
        }
        this._retTree = _t;
    }

    public final void setElement(AST _t) throws RecognitionException {
        block9: {
            GrammarAST setElement_AST_in = _t == ASTNULL ? null : (GrammarAST)_t;
            GrammarAST c2 = null;
            GrammarAST t = null;
            GrammarAST s = null;
            GrammarAST c1 = null;
            GrammarAST c22 = null;
            try {
                if (_t == null) {
                    _t = ASTNULL;
                }
                switch (_t.getType()) {
                    case 51: {
                        c2 = (GrammarAST)_t;
                        this.match(_t, 51);
                        _t = _t.getNextSibling();
                        break;
                    }
                    case 55: {
                        t = (GrammarAST)_t;
                        this.match(_t, 55);
                        _t = _t.getNextSibling();
                        break;
                    }
                    case 50: {
                        s = (GrammarAST)_t;
                        this.match(_t, 50);
                        _t = _t.getNextSibling();
                        break;
                    }
                    case 15: {
                        AST __t93 = _t;
                        GrammarAST tmp57_AST_in = (GrammarAST)_t;
                        this.match(_t, 15);
                        _t = _t.getFirstChild();
                        c1 = (GrammarAST)_t;
                        this.match(_t, 51);
                        _t = _t.getNextSibling();
                        c22 = (GrammarAST)_t;
                        this.match(_t, 51);
                        _t = _t.getNextSibling();
                        _t = __t93;
                        _t = _t.getNextSibling();
                        break;
                    }
                    default: {
                        throw new NoViableAltException(_t);
                    }
                }
            }
            catch (RecognitionException ex) {
                this.reportError(ex);
                if (_t == null) break block9;
                _t = _t.getNextSibling();
            }
        }
        this._retTree = _t;
    }

    public final StringTemplate rewrite_alternative(AST _t) throws RecognitionException {
        StringTemplate code;
        block14: {
            code = null;
            GrammarAST rewrite_alternative_AST_in = _t == ASTNULL ? null : (GrammarAST)_t;
            GrammarAST a2 = null;
            try {
                if (_t == null) {
                    _t = ASTNULL;
                }
                if (_t.getType() == 17 && this.generator.grammar.buildAST()) {
                    AST __t102 = _t;
                    a2 = _t == ASTNULL ? null : (GrammarAST)_t;
                    this.match(_t, 17);
                    _t = _t.getFirstChild();
                    code = this.templates.getInstanceOf("rewriteElementList");
                    if (_t == null) {
                        _t = ASTNULL;
                    }
                    block1 : switch (_t.getType()) {
                        case 10: 
                        case 11: 
                        case 12: 
                        case 31: 
                        case 40: 
                        case 50: 
                        case 51: 
                        case 55: 
                        case 73: 
                        case 75: {
                            int _cnt105 = 0;
                            while (true) {
                                if (_t == null) {
                                    _t = ASTNULL;
                                }
                                if (_t.getType() != 10 && _t.getType() != 11 && _t.getType() != 12 && _t.getType() != 31 && _t.getType() != 40 && _t.getType() != 50 && _t.getType() != 51 && _t.getType() != 55 && _t.getType() != 73 && _t.getType() != 75) {
                                    if (_cnt105 >= 1) break block1;
                                    throw new NoViableAltException(_t);
                                }
                                GrammarAST elAST = (GrammarAST)_t;
                                StringTemplate el = this.rewrite_element(_t);
                                _t = this._retTree;
                                code.setAttribute("elements.{el,line,pos}", el, Utils.integer(elAST.getLine()), Utils.integer(elAST.getColumn()));
                                ++_cnt105;
                            }
                        }
                        case 16: {
                            GrammarAST tmp58_AST_in = (GrammarAST)_t;
                            this.match(_t, 16);
                            _t = _t.getNextSibling();
                            code.setAttribute("elements.{el,line,pos}", this.templates.getInstanceOf("rewriteEmptyAlt"), Utils.integer(a2.getLine()), Utils.integer(a2.getColumn()));
                            break;
                        }
                        default: {
                            throw new NoViableAltException(_t);
                        }
                    }
                    GrammarAST tmp59_AST_in = (GrammarAST)_t;
                    this.match(_t, 20);
                    _t = _t.getNextSibling();
                    _t = __t102;
                    _t = _t.getNextSibling();
                    break block14;
                }
                if ((_t.getType() == 17 || _t.getType() == 32 || _t.getType() == 40) && this.generator.grammar.buildTemplate()) {
                    code = this.rewrite_template(_t);
                    _t = this._retTree;
                    break block14;
                }
                if (_t.getType() == 81) {
                    GrammarAST tmp60_AST_in = (GrammarAST)_t;
                    this.match(_t, 81);
                    _t = _t.getNextSibling();
                    break block14;
                }
                throw new NoViableAltException(_t);
            }
            catch (RecognitionException ex) {
                this.reportError(ex);
                if (_t == null) break block14;
                _t = _t.getNextSibling();
            }
        }
        this._retTree = _t;
        return code;
    }

    public final StringTemplate rewrite_block(AST _t, String blockTemplateName) throws RecognitionException {
        StringTemplate code;
        block2: {
            code = null;
            GrammarAST rewrite_block_AST_in = _t == ASTNULL ? null : (GrammarAST)_t;
            ++this.rewriteBlockNestingLevel;
            code = this.templates.getInstanceOf(blockTemplateName);
            StringTemplate save_currentBlockST = this.currentBlockST;
            this.currentBlockST = code;
            code.setAttribute("rewriteBlockLevel", this.rewriteBlockNestingLevel);
            StringTemplate alt = null;
            try {
                AST __t100 = _t;
                GrammarAST tmp61_AST_in = (GrammarAST)_t;
                this.match(_t, 9);
                _t = _t.getFirstChild();
                this.currentBlockST.setAttribute("referencedElementsDeep", this.getTokenTypesAsTargetLabels(tmp61_AST_in.rewriteRefsDeep));
                this.currentBlockST.setAttribute("referencedElements", this.getTokenTypesAsTargetLabels(tmp61_AST_in.rewriteRefsShallow));
                alt = this.rewrite_alternative(_t);
                _t = this._retTree;
                GrammarAST tmp62_AST_in = (GrammarAST)_t;
                this.match(_t, 19);
                _t = _t.getNextSibling();
                _t = __t100;
                _t = _t.getNextSibling();
                code.setAttribute("alt", alt);
                --this.rewriteBlockNestingLevel;
                this.currentBlockST = save_currentBlockST;
            }
            catch (RecognitionException ex) {
                this.reportError(ex);
                if (_t == null) break block2;
                _t = _t.getNextSibling();
            }
        }
        this._retTree = _t;
        return code;
    }

    public final StringTemplate rewrite_element(AST _t) throws RecognitionException {
        StringTemplate code;
        block8: {
            code = null;
            GrammarAST rewrite_element_AST_in = _t == ASTNULL ? null : (GrammarAST)_t;
            Object elements = null;
            Object ast = null;
            try {
                if (_t == null) {
                    _t = ASTNULL;
                }
                switch (_t.getType()) {
                    case 31: 
                    case 40: 
                    case 50: 
                    case 51: 
                    case 55: 
                    case 73: {
                        code = this.rewrite_atom(_t, false);
                        _t = this._retTree;
                        break;
                    }
                    case 10: 
                    case 11: 
                    case 12: {
                        code = this.rewrite_ebnf(_t);
                        _t = this._retTree;
                        break;
                    }
                    case 75: {
                        code = this.rewrite_tree(_t);
                        _t = this._retTree;
                        break;
                    }
                    default: {
                        throw new NoViableAltException(_t);
                    }
                }
            }
            catch (RecognitionException ex) {
                this.reportError(ex);
                if (_t == null) break block8;
                _t = _t.getNextSibling();
            }
        }
        this._retTree = _t;
        return code;
    }

    public final StringTemplate rewrite_template(AST _t) throws RecognitionException {
        StringTemplate code;
        block26: {
            code = null;
            GrammarAST rewrite_template_AST_in = _t == ASTNULL ? null : (GrammarAST)_t;
            GrammarAST id = null;
            GrammarAST ind = null;
            GrammarAST arg = null;
            GrammarAST a2 = null;
            GrammarAST act = null;
            try {
                if (_t == null) {
                    _t = ASTNULL;
                }
                switch (_t.getType()) {
                    case 17: {
                        AST __t120 = _t;
                        GrammarAST tmp63_AST_in = (GrammarAST)_t;
                        this.match(_t, 17);
                        _t = _t.getFirstChild();
                        GrammarAST tmp64_AST_in = (GrammarAST)_t;
                        this.match(_t, 16);
                        _t = _t.getNextSibling();
                        GrammarAST tmp65_AST_in = (GrammarAST)_t;
                        this.match(_t, 20);
                        _t = _t.getNextSibling();
                        _t = __t120;
                        _t = _t.getNextSibling();
                        code = this.templates.getInstanceOf("rewriteEmptyTemplate");
                        break;
                    }
                    case 32: {
                        AST __t121 = _t;
                        GrammarAST tmp66_AST_in = (GrammarAST)_t;
                        this.match(_t, 32);
                        _t = _t.getFirstChild();
                        if (_t == null) {
                            _t = ASTNULL;
                        }
                        switch (_t.getType()) {
                            case 21: {
                                id = (GrammarAST)_t;
                                this.match(_t, 21);
                                _t = _t.getNextSibling();
                                break;
                            }
                            case 40: {
                                ind = (GrammarAST)_t;
                                this.match(_t, 40);
                                _t = _t.getNextSibling();
                                break;
                            }
                            default: {
                                throw new NoViableAltException(_t);
                            }
                        }
                        if (id != null && id.getText().equals("template")) {
                            code = this.templates.getInstanceOf("rewriteInlineTemplate");
                        } else if (id != null) {
                            code = this.templates.getInstanceOf("rewriteExternalTemplate");
                            code.setAttribute("name", id.getText());
                        } else if (ind != null) {
                            code = this.templates.getInstanceOf("rewriteIndirectTemplate");
                            List chunks = this.generator.translateAction(this.currentRuleName, ind);
                            code.setAttribute("expr", chunks);
                        }
                        AST __t123 = _t;
                        GrammarAST tmp67_AST_in = (GrammarAST)_t;
                        this.match(_t, 23);
                        _t = _t.getFirstChild();
                        while (true) {
                            if (_t == null) {
                                _t = ASTNULL;
                            }
                            if (_t.getType() != 22) break;
                            AST __t125 = _t;
                            GrammarAST tmp68_AST_in = (GrammarAST)_t;
                            this.match(_t, 22);
                            _t = _t.getFirstChild();
                            arg = (GrammarAST)_t;
                            this.match(_t, 21);
                            _t = _t.getNextSibling();
                            a2 = (GrammarAST)_t;
                            this.match(_t, 40);
                            _t = _t.getNextSibling();
                            a2.outerAltNum = this.outerAltNum;
                            List chunks = this.generator.translateAction(this.currentRuleName, a2);
                            code.setAttribute("args.{name,value}", arg.getText(), chunks);
                            _t = __t125;
                            _t = _t.getNextSibling();
                        }
                        _t = __t123;
                        if ((_t = _t.getNextSibling()) == null) {
                            _t = ASTNULL;
                        }
                        switch (_t.getType()) {
                            case 83: {
                                GrammarAST tmp69_AST_in = (GrammarAST)_t;
                                this.match(_t, 83);
                                _t = _t.getNextSibling();
                                String sl = tmp69_AST_in.getText();
                                String t = sl.substring(1, sl.length() - 1);
                                t = this.generator.target.getTargetStringLiteralFromString(t);
                                code.setAttribute("template", t);
                                break;
                            }
                            case 84: {
                                GrammarAST tmp70_AST_in = (GrammarAST)_t;
                                this.match(_t, 84);
                                _t = _t.getNextSibling();
                                String sl = tmp70_AST_in.getText();
                                String t = sl.substring(2, sl.length() - 2);
                                t = this.generator.target.getTargetStringLiteralFromString(t);
                                code.setAttribute("template", t);
                                break;
                            }
                            case 3: {
                                break;
                            }
                            default: {
                                throw new NoViableAltException(_t);
                            }
                        }
                        _t = __t121;
                        _t = _t.getNextSibling();
                        break;
                    }
                    case 40: {
                        act = (GrammarAST)_t;
                        this.match(_t, 40);
                        _t = _t.getNextSibling();
                        act.outerAltNum = this.outerAltNum;
                        code = this.templates.getInstanceOf("rewriteAction");
                        code.setAttribute("action", this.generator.translateAction(this.currentRuleName, act));
                        break;
                    }
                    default: {
                        throw new NoViableAltException(_t);
                    }
                }
            }
            catch (RecognitionException ex) {
                this.reportError(ex);
                if (_t == null) break block26;
                _t = _t.getNextSibling();
            }
        }
        this._retTree = _t;
        return code;
    }

    public final StringTemplate rewrite_atom(AST _t, boolean isRoot) throws RecognitionException {
        StringTemplate code;
        block41: {
            code = null;
            GrammarAST rewrite_atom_AST_in = _t == ASTNULL ? null : (GrammarAST)_t;
            GrammarAST r = null;
            GrammarAST tk = null;
            GrammarAST arg = null;
            GrammarAST cl = null;
            GrammarAST sl = null;
            try {
                if (_t == null) {
                    _t = ASTNULL;
                }
                switch (_t.getType()) {
                    case 73: {
                        r = (GrammarAST)_t;
                        this.match(_t, 73);
                        _t = _t.getNextSibling();
                        String ruleRefName = r.getText();
                        String stName = "rewriteRuleRef";
                        if (isRoot) {
                            stName = stName + "Root";
                        }
                        code = this.templates.getInstanceOf(stName);
                        code.setAttribute("rule", ruleRefName);
                        if (this.grammar.getRule(ruleRefName) == null) {
                            ErrorManager.grammarError(106, this.grammar, r.getToken(), ruleRefName);
                            code = new StringTemplate();
                            break;
                        }
                        if (this.grammar.getRule(this.currentRuleName).getRuleRefsInAlt(ruleRefName, this.outerAltNum) == null) {
                            ErrorManager.grammarError(136, this.grammar, r.getToken(), ruleRefName);
                            code = new StringTemplate();
                            break;
                        }
                        if (!this.rewriteRuleRefs.contains(ruleRefName)) {
                            this.rewriteRuleRefs.add(ruleRefName);
                        }
                        break;
                    }
                    case 50: 
                    case 51: 
                    case 55: {
                        GrammarAST term = (GrammarAST)_t;
                        if (_t == null) {
                            _t = ASTNULL;
                        }
                        switch (_t.getType()) {
                            case 55: {
                                AST __t117 = _t;
                                tk = _t == ASTNULL ? null : (GrammarAST)_t;
                                this.match(_t, 55);
                                _t = _t.getFirstChild();
                                if (_t == null) {
                                    _t = ASTNULL;
                                }
                                switch (_t.getType()) {
                                    case 60: {
                                        arg = (GrammarAST)_t;
                                        this.match(_t, 60);
                                        _t = _t.getNextSibling();
                                        break;
                                    }
                                    case 3: {
                                        break;
                                    }
                                    default: {
                                        throw new NoViableAltException(_t);
                                    }
                                }
                                _t = __t117;
                                _t = _t.getNextSibling();
                                break;
                            }
                            case 51: {
                                cl = (GrammarAST)_t;
                                this.match(_t, 51);
                                _t = _t.getNextSibling();
                                break;
                            }
                            case 50: {
                                sl = (GrammarAST)_t;
                                this.match(_t, 50);
                                _t = _t.getNextSibling();
                                break;
                            }
                            default: {
                                throw new NoViableAltException(_t);
                            }
                        }
                        String tokenName = rewrite_atom_AST_in.getText();
                        String stName = "rewriteTokenRef";
                        Rule rule = this.grammar.getRule(this.currentRuleName);
                        Set tokenRefsInAlt = rule.getTokenRefsInAlt(this.outerAltNum);
                        boolean createNewNode = !tokenRefsInAlt.contains(tokenName) || arg != null;
                        Object hetero = null;
                        if (term.terminalOptions != null) {
                            hetero = term.terminalOptions.get("node");
                        }
                        if (createNewNode) {
                            stName = "rewriteImaginaryTokenRef";
                        }
                        if (isRoot) {
                            stName = stName + "Root";
                        }
                        code = this.templates.getInstanceOf(stName);
                        code.setAttribute("hetero", hetero);
                        if (arg != null) {
                            List args = this.generator.translateAction(this.currentRuleName, arg);
                            code.setAttribute("args", args);
                        }
                        code.setAttribute("elementIndex", ((TokenWithIndex)rewrite_atom_AST_in.getToken()).getIndex());
                        int ttype = this.grammar.getTokenType(tokenName);
                        String tok = this.generator.getTokenTypeAsTargetLabel(ttype);
                        code.setAttribute("token", tok);
                        if (this.grammar.getTokenType(tokenName) == -7) {
                            ErrorManager.grammarError(135, this.grammar, rewrite_atom_AST_in.getToken(), tokenName);
                            code = new StringTemplate();
                        }
                        break;
                    }
                    case 31: {
                        GrammarAST tmp71_AST_in = (GrammarAST)_t;
                        this.match(_t, 31);
                        _t = _t.getNextSibling();
                        String labelName = tmp71_AST_in.getText();
                        Rule rule = this.grammar.getRule(this.currentRuleName);
                        Grammar.LabelElementPair pair = rule.getLabel(labelName);
                        if (labelName.equals(this.currentRuleName)) {
                            if (rule.hasRewrite(this.outerAltNum) && rule.getRuleRefsInAlt(this.outerAltNum).contains(labelName)) {
                                ErrorManager.grammarError(132, this.grammar, tmp71_AST_in.getToken(), labelName);
                            }
                            StringTemplate labelST = this.templates.getInstanceOf("prevRuleRootRef");
                            code = this.templates.getInstanceOf("rewriteRuleLabelRef" + (isRoot ? "Root" : ""));
                            code.setAttribute("label", labelST);
                            break;
                        }
                        if (pair == null) {
                            ErrorManager.grammarError(137, this.grammar, tmp71_AST_in.getToken(), labelName);
                            code = new StringTemplate();
                            break;
                        }
                        String stName = null;
                        switch (pair.type) {
                            case 2: {
                                stName = "rewriteTokenLabelRef";
                                break;
                            }
                            case 6: {
                                stName = "rewriteWildcardLabelRef";
                                break;
                            }
                            case 7: {
                                stName = "rewriteRuleListLabelRef";
                                break;
                            }
                            case 1: {
                                stName = "rewriteRuleLabelRef";
                                break;
                            }
                            case 4: {
                                stName = "rewriteTokenListLabelRef";
                                break;
                            }
                            case 3: {
                                stName = "rewriteRuleListLabelRef";
                            }
                        }
                        if (isRoot) {
                            stName = stName + "Root";
                        }
                        code = this.templates.getInstanceOf(stName);
                        code.setAttribute("label", labelName);
                        break;
                    }
                    case 40: {
                        GrammarAST tmp72_AST_in = (GrammarAST)_t;
                        this.match(_t, 40);
                        _t = _t.getNextSibling();
                        String actText = tmp72_AST_in.getText();
                        List chunks = this.generator.translateAction(this.currentRuleName, tmp72_AST_in);
                        code = this.templates.getInstanceOf("rewriteNodeAction" + (isRoot ? "Root" : ""));
                        code.setAttribute("action", chunks);
                        break;
                    }
                    default: {
                        throw new NoViableAltException(_t);
                    }
                }
            }
            catch (RecognitionException ex) {
                this.reportError(ex);
                if (_t == null) break block41;
                _t = _t.getNextSibling();
            }
        }
        this._retTree = _t;
        return code;
    }

    public final StringTemplate rewrite_ebnf(AST _t) throws RecognitionException {
        StringTemplate code;
        block8: {
            code = null;
            GrammarAST rewrite_ebnf_AST_in = _t == ASTNULL ? null : (GrammarAST)_t;
            try {
                if (_t == null) {
                    _t = ASTNULL;
                }
                switch (_t.getType()) {
                    case 10: {
                        AST __t108 = _t;
                        GrammarAST tmp73_AST_in = (GrammarAST)_t;
                        this.match(_t, 10);
                        _t = _t.getFirstChild();
                        code = this.rewrite_block(_t, "rewriteOptionalBlock");
                        _t = this._retTree;
                        _t = __t108;
                        _t = _t.getNextSibling();
                        String description = this.grammar.grammarTreeToString(rewrite_ebnf_AST_in, false);
                        description = this.generator.target.getTargetStringLiteralFromString(description);
                        code.setAttribute("description", description);
                        break;
                    }
                    case 11: {
                        AST __t109 = _t;
                        GrammarAST tmp74_AST_in = (GrammarAST)_t;
                        this.match(_t, 11);
                        _t = _t.getFirstChild();
                        code = this.rewrite_block(_t, "rewriteClosureBlock");
                        _t = this._retTree;
                        _t = __t109;
                        _t = _t.getNextSibling();
                        String description = this.grammar.grammarTreeToString(rewrite_ebnf_AST_in, false);
                        description = this.generator.target.getTargetStringLiteralFromString(description);
                        code.setAttribute("description", description);
                        break;
                    }
                    case 12: {
                        AST __t110 = _t;
                        GrammarAST tmp75_AST_in = (GrammarAST)_t;
                        this.match(_t, 12);
                        _t = _t.getFirstChild();
                        code = this.rewrite_block(_t, "rewritePositiveClosureBlock");
                        _t = this._retTree;
                        _t = __t110;
                        _t = _t.getNextSibling();
                        String description = this.grammar.grammarTreeToString(rewrite_ebnf_AST_in, false);
                        description = this.generator.target.getTargetStringLiteralFromString(description);
                        code.setAttribute("description", description);
                        break;
                    }
                    default: {
                        throw new NoViableAltException(_t);
                    }
                }
            }
            catch (RecognitionException ex) {
                this.reportError(ex);
                if (_t == null) break block8;
                _t = _t.getNextSibling();
            }
        }
        this._retTree = _t;
        return code;
    }

    public final StringTemplate rewrite_tree(AST _t) throws RecognitionException {
        StringTemplate code;
        block4: {
            code = this.templates.getInstanceOf("rewriteTree");
            GrammarAST rewrite_tree_AST_in = _t == ASTNULL ? null : (GrammarAST)_t;
            ++this.rewriteTreeNestingLevel;
            code.setAttribute("treeLevel", this.rewriteTreeNestingLevel);
            code.setAttribute("enclosingTreeLevel", this.rewriteTreeNestingLevel - 1);
            GrammarAST elAST = null;
            try {
                AST __t112 = _t;
                GrammarAST tmp76_AST_in = (GrammarAST)_t;
                this.match(_t, 75);
                _t = _t.getFirstChild();
                elAST = (GrammarAST)_t;
                StringTemplate r = this.rewrite_atom(_t, true);
                _t = this._retTree;
                code.setAttribute("root.{el,line,pos}", r, Utils.integer(elAST.getLine()), Utils.integer(elAST.getColumn()));
                while (true) {
                    if (_t == null) {
                        _t = ASTNULL;
                    }
                    if (_t.getType() != 10 && _t.getType() != 11 && _t.getType() != 12 && _t.getType() != 31 && _t.getType() != 40 && _t.getType() != 50 && _t.getType() != 51 && _t.getType() != 55 && _t.getType() != 73 && _t.getType() != 75) break;
                    elAST = (GrammarAST)_t;
                    StringTemplate el = this.rewrite_element(_t);
                    _t = this._retTree;
                    code.setAttribute("children.{el,line,pos}", el, Utils.integer(elAST.getLine()), Utils.integer(elAST.getColumn()));
                }
                _t = __t112;
                _t = _t.getNextSibling();
                String description = this.grammar.grammarTreeToString(rewrite_tree_AST_in, false);
                description = this.generator.target.getTargetStringLiteralFromString(description);
                code.setAttribute("description", description);
                --this.rewriteTreeNestingLevel;
            }
            catch (RecognitionException ex) {
                this.reportError(ex);
                if (_t == null) break block4;
                _t = _t.getNextSibling();
            }
        }
        this._retTree = _t;
        return code;
    }
}

