/*
 * Decompiled with CFR 0.152.
 */
package javax.media.opengl;

import com.sun.opengl.impl.Debug;
import com.sun.opengl.impl.GLContextImpl;
import com.sun.opengl.impl.GLDrawableFactoryImpl;
import com.sun.opengl.impl.GLDrawableHelper;
import com.sun.opengl.impl.GLDrawableImpl;
import com.sun.opengl.impl.Java2D;
import com.sun.opengl.impl.Java2DGLContext;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.beans.Beans;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javax.media.opengl.DebugGL;
import javax.media.opengl.DefaultGLCapabilitiesChooser;
import javax.media.opengl.GL;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesChooser;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawable;
import javax.media.opengl.GLDrawableFactory;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.GLException;
import javax.media.opengl.GLPbuffer;
import javax.swing.JPanel;

public class GLJPanel
extends JPanel
implements GLAutoDrawable {
    private static final boolean DEBUG = Debug.debug("GLJPanel");
    private static final boolean VERBOSE = Debug.verbose();
    private GLDrawableHelper drawableHelper = new GLDrawableHelper();
    private volatile boolean isInitialized;
    private volatile boolean shouldInitialize = false;
    private GLCapabilities offscreenCaps;
    private GLCapabilitiesChooser chooser;
    private GLContext shareWith;
    private BufferedImage offscreenImage;
    private ByteBuffer readBackBytes;
    private IntBuffer readBackInts;
    private int readBackWidthInPixels;
    private int readBackHeightInPixels;
    private int panelWidth = 0;
    private int panelHeight = 0;
    private Updater updater;
    private int awtFormat;
    private int glFormat;
    private int glType;
    private boolean handleReshape = false;
    private boolean sendReshape = true;
    private static boolean hardwareAccelerationDisabled = Debug.isPropertyDefined("jogl.gljpanel.nohw");
    private static boolean softwareRenderingDisabled = Debug.isPropertyDefined("jogl.gljpanel.nosw");
    private GLPbuffer pbuffer;
    private int pbufferWidth = 256;
    private int pbufferHeight = 256;
    private GLDrawableImpl offscreenDrawable;
    private GLContextImpl offscreenContext;
    private int reshapeX;
    private int reshapeY;
    private int reshapeWidth;
    private int reshapeHeight;
    private int[] swapbytes = new int[1];
    private int[] rowlength = new int[1];
    private int[] skiprows = new int[1];
    private int[] skippixels = new int[1];
    private int[] alignment = new int[1];
    private boolean oglPipelineEnabled = Java2D.isOGLPipelineActive() && !Debug.isPropertyDefined("jogl.gljpanel.noogl");
    private Object j2dSurface;
    private Graphics cached2DGraphics;
    private GLContext j2dContext;
    private GLDrawable joglDrawable;
    private GLContext joglContext;
    private int[] drawBuffer = new int[1];
    private int[] readBuffer = new int[1];
    private int[] frameBuffer = new int[1];
    private boolean checkedForFBObjectWorkarounds;
    private boolean fbObjectWorkarounds;
    private int[] frameBufferDepthBuffer;
    private int[] frameBufferTexture;
    private boolean createNewDepthBuffer;
    private boolean checkedGLVendor;
    private boolean vendorIsATI;
    private GraphicsConfiguration workaroundConfig;
    private int viewportX;
    private int viewportY;
    private InitAction initAction = new InitAction();
    private DisplayAction displayAction = new DisplayAction();
    private SwapBuffersAction swapBuffersAction = new SwapBuffersAction();
    private PaintImmediatelyAction paintImmediatelyAction = new PaintImmediatelyAction();

    public GLJPanel() {
        this((GLCapabilities)null);
    }

    public GLJPanel(GLCapabilities gLCapabilities) {
        this(gLCapabilities, null, null);
    }

    public GLJPanel(GLCapabilities gLCapabilities, GLCapabilitiesChooser gLCapabilitiesChooser, GLContext gLContext) {
        this.offscreenCaps = gLCapabilities != null ? (GLCapabilities)gLCapabilities.clone() : new GLCapabilities();
        this.offscreenCaps.setDoubleBuffered(false);
        this.chooser = gLCapabilitiesChooser != null ? gLCapabilitiesChooser : new DefaultGLCapabilitiesChooser();
        this.shareWith = gLContext;
    }

    public void display() {
        if (EventQueue.isDispatchThread()) {
            this.paintImmediately(0, 0, this.getWidth(), this.getHeight());
        } else {
            try {
                EventQueue.invokeAndWait(this.paintImmediatelyAction);
            }
            catch (Exception exception) {
                throw new GLException(exception);
            }
        }
    }

    private void captureJ2DState(GL gL, Graphics graphics) {
        gL.glGetIntegerv(3073, this.drawBuffer, 0);
        gL.glGetIntegerv(3074, this.readBuffer, 0);
        if (Java2D.isFBOEnabled() && Java2D.getOGLSurfaceType(graphics) == Java2D.FBOBJECT) {
            if (DEBUG && VERBOSE) {
                System.err.println("GLJPanel: Fetching GL_FRAMEBUFFER_BINDING_EXT");
            }
            gL.glGetIntegerv(36006, this.frameBuffer, 0);
            if (this.fbObjectWorkarounds || !this.checkedForFBObjectWorkarounds) {
                if (this.frameBufferTexture == null) {
                    this.frameBufferTexture = new int[1];
                }
                gL.glGetFramebufferAttachmentParameterivEXT(36160, 36064, 36049, this.frameBufferTexture, 0);
                if (DEBUG && VERBOSE) {
                    System.err.println("GLJPanel: FBO COLOR_ATTACHMENT0: " + this.frameBufferTexture[0]);
                }
            }
            if (!this.checkedGLVendor) {
                this.checkedGLVendor = true;
                String string = gL.glGetString(7936);
                if (string != null && string.startsWith("ATI")) {
                    this.vendorIsATI = true;
                }
            }
            if (this.vendorIsATI) {
                gL.glBindFramebufferEXT(36160, 0);
            }
        }
    }

    private boolean preGL(Graphics graphics) {
        GL gL = this.joglContext.getGL();
        gL.glEnable(3089);
        Rectangle rectangle = Java2D.getOGLScissorBox(graphics);
        if (rectangle == null) {
            if (DEBUG && VERBOSE) {
                System.err.println("Java2D.getOGLScissorBox() returned null");
            }
            return false;
        }
        if (DEBUG && VERBOSE) {
            System.err.println("GLJPanel: gl.glScissor(" + rectangle.x + ", " + rectangle.y + ", " + rectangle.width + ", " + rectangle.height + ")");
        }
        gL.glScissor(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        Rectangle rectangle2 = Java2D.getOGLViewport(graphics, this.panelWidth, this.panelHeight);
        if (this.viewportX != rectangle2.x || this.viewportY != rectangle2.y) {
            this.sendReshape = true;
            if (DEBUG) {
                System.err.println("Sending reshape because viewport changed");
                System.err.println("  viewportX (" + this.viewportX + ") ?= oglViewport.x (" + rectangle2.x + ")");
                System.err.println("  viewportY (" + this.viewportY + ") ?= oglViewport.y (" + rectangle2.y + ")");
            }
        }
        this.viewportX = rectangle2.x;
        this.viewportY = rectangle2.y;
        if (Java2D.isFBOEnabled() && Java2D.getOGLSurfaceType(graphics) == Java2D.FBOBJECT) {
            int n;
            if (DEBUG && VERBOSE) {
                System.err.println("GLJPanel: Binding to framebuffer object " + this.frameBuffer[0]);
            }
            int n2 = Java2D.getOGLTextureType(graphics);
            if (!this.checkedForFBObjectWorkarounds) {
                this.checkedForFBObjectWorkarounds = true;
                gL.glBindTexture(n2, 0);
                gL.glBindFramebufferEXT(36160, this.frameBuffer[0]);
                if (gL.glCheckFramebufferStatusEXT(36160) != 36053) {
                    this.fbObjectWorkarounds = true;
                    this.createNewDepthBuffer = true;
                    if (DEBUG) {
                        System.err.println("-- GLJPanel: discovered frame_buffer_object workarounds to be necessary");
                    }
                } else {
                    this.frameBufferTexture = null;
                }
            }
            if (this.fbObjectWorkarounds && this.createNewDepthBuffer) {
                if (this.frameBufferDepthBuffer == null) {
                    this.frameBufferDepthBuffer = new int[1];
                }
                if (this.frameBufferDepthBuffer[0] != 0) {
                    gL.glDeleteRenderbuffersEXT(1, this.frameBufferDepthBuffer, 0);
                    this.frameBufferDepthBuffer[0] = 0;
                }
                gL.glBindTexture(n2, this.frameBufferTexture[0]);
                int[] nArray = new int[1];
                int[] nArray2 = new int[1];
                gL.glGetTexLevelParameteriv(n2, 0, 4096, nArray, 0);
                gL.glGetTexLevelParameteriv(n2, 0, 4097, nArray2, 0);
                gL.glGenRenderbuffersEXT(1, this.frameBufferDepthBuffer, 0);
                if (DEBUG) {
                    System.err.println("GLJPanel: Generated frameBufferDepthBuffer " + this.frameBufferDepthBuffer[0] + " with width " + nArray[0] + ", height " + nArray2[0]);
                }
                gL.glBindRenderbufferEXT(36161, this.frameBufferDepthBuffer[0]);
                gL.glRenderbufferStorageEXT(36161, 33190, nArray[0], nArray2[0]);
                gL.glBindRenderbufferEXT(36161, 0);
                this.createNewDepthBuffer = false;
            }
            gL.glBindTexture(n2, 0);
            gL.glBindFramebufferEXT(36160, this.frameBuffer[0]);
            if (this.fbObjectWorkarounds) {
                gL.glFramebufferTexture2DEXT(36160, 36064, n2, this.frameBufferTexture[0], 0);
                if (DEBUG && VERBOSE) {
                    System.err.println("GLJPanel: frameBufferDepthBuffer: " + this.frameBufferDepthBuffer[0]);
                }
                gL.glFramebufferRenderbufferEXT(36160, 36096, 36161, this.frameBufferDepthBuffer[0]);
            }
            if (DEBUG && (n = gL.glCheckFramebufferStatusEXT(36160)) != 36053) {
                throw new GLException("Error: framebuffer was incomplete: status = 0x" + Integer.toHexString(n));
            }
        } else {
            if (DEBUG && VERBOSE) {
                System.err.println("GLJPanel: Setting up drawBuffer " + this.drawBuffer[0] + " and readBuffer " + this.readBuffer[0]);
            }
            gL.glDrawBuffer(this.drawBuffer[0]);
            gL.glReadBuffer(this.readBuffer[0]);
        }
        return true;
    }

    private void postGL(Graphics graphics) {
        if (Java2D.isFBOEnabled() && Java2D.getOGLSurfaceType(graphics) == Java2D.FBOBJECT) {
            GL gL = this.joglContext.getGL();
            gL.glBindFramebufferEXT(36160, 0);
        }
    }

    protected void paintComponent(final Graphics graphics) {
        if (Beans.isDesignTime()) {
            int n;
            graphics.setColor(Color.BLACK);
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            FontMetrics fontMetrics = graphics.getFontMetrics();
            String string = this.getName();
            if (string == null && (n = (string = this.getClass().getName()).lastIndexOf(46)) >= 0) {
                string = string.substring(n + 1);
            }
            Rectangle2D rectangle2D = fontMetrics.getStringBounds(string, graphics);
            graphics.setColor(Color.WHITE);
            graphics.drawString(string, (int)(((double)this.getWidth() - rectangle2D.getWidth()) / 2.0), (int)(((double)this.getHeight() + rectangle2D.getHeight()) / 2.0));
            return;
        }
        if (this.shouldInitialize) {
            this.initialize();
        }
        if (!this.isInitialized) {
            return;
        }
        if (this.handleReshape) {
            this.handleReshape();
        }
        this.updater.setGraphics(graphics);
        if (this.oglPipelineEnabled) {
            if (Java2D.isFBOEnabled()) {
                if (this.workaroundConfig == null) {
                    this.workaroundConfig = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
                }
                Java2D.invokeWithOGLSharedContextCurrent(this.workaroundConfig, new Runnable(){

                    public void run() {
                    }
                });
            }
            Java2D.invokeWithOGLContextCurrent(graphics, new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    Object object;
                    if (DEBUG && VERBOSE) {
                        System.err.println("-- In invokeWithOGLContextCurrent");
                    }
                    if (GLJPanel.this.j2dContext == null) {
                        GLJPanel.this.j2dContext = GLDrawableFactory.getFactory().createExternalGLContext();
                        if (DEBUG) {
                            GLJPanel.this.j2dContext.setGL(new DebugGL(GLJPanel.this.j2dContext.getGL()));
                        }
                        GLJPanel.this.j2dContext.makeCurrent();
                        object = GLJPanel.this.j2dContext.getGL();
                        if (GLJPanel.this.getGLInteger((GL)object, 3410) < GLJPanel.this.offscreenCaps.getRedBits() || GLJPanel.this.getGLInteger((GL)object, 3411) < GLJPanel.this.offscreenCaps.getGreenBits() || GLJPanel.this.getGLInteger((GL)object, 3412) < GLJPanel.this.offscreenCaps.getBlueBits() || GLJPanel.this.getGLInteger((GL)object, 3416) < GLJPanel.this.offscreenCaps.getAccumRedBits() || GLJPanel.this.getGLInteger((GL)object, 3417) < GLJPanel.this.offscreenCaps.getAccumGreenBits() || GLJPanel.this.getGLInteger((GL)object, 3418) < GLJPanel.this.offscreenCaps.getAccumBlueBits() || GLJPanel.this.getGLInteger((GL)object, 3419) < GLJPanel.this.offscreenCaps.getAccumAlphaBits() || GLJPanel.this.getGLInteger((GL)object, 3415) < GLJPanel.this.offscreenCaps.getStencilBits()) {
                            if (DEBUG) {
                                System.err.println("GLJPanel: Falling back to pbuffer-based support because Java2D context insufficient");
                                System.err.println("                    Available              Required");
                                System.err.println("GL_RED_BITS         " + GLJPanel.this.getGLInteger((GL)object, 3410) + "              " + GLJPanel.this.offscreenCaps.getRedBits());
                                System.err.println("GL_GREEN_BITS       " + GLJPanel.this.getGLInteger((GL)object, 3411) + "              " + GLJPanel.this.offscreenCaps.getGreenBits());
                                System.err.println("GL_BLUE_BITS        " + GLJPanel.this.getGLInteger((GL)object, 3412) + "              " + GLJPanel.this.offscreenCaps.getBlueBits());
                                System.err.println("GL_ALPHA_BITS       " + GLJPanel.this.getGLInteger((GL)object, 3413) + "              " + GLJPanel.this.offscreenCaps.getAlphaBits());
                                System.err.println("GL_ACCUM_RED_BITS   " + GLJPanel.this.getGLInteger((GL)object, 3416) + "              " + GLJPanel.this.offscreenCaps.getAccumRedBits());
                                System.err.println("GL_ACCUM_GREEN_BITS " + GLJPanel.this.getGLInteger((GL)object, 3417) + "              " + GLJPanel.this.offscreenCaps.getAccumGreenBits());
                                System.err.println("GL_ACCUM_BLUE_BITS  " + GLJPanel.this.getGLInteger((GL)object, 3418) + "              " + GLJPanel.this.offscreenCaps.getAccumBlueBits());
                                System.err.println("GL_ACCUM_ALPHA_BITS " + GLJPanel.this.getGLInteger((GL)object, 3419) + "              " + GLJPanel.this.offscreenCaps.getAccumAlphaBits());
                                System.err.println("GL_DEPTH_BITS       " + GLJPanel.this.getGLInteger((GL)object, 3414) + "              " + GLJPanel.this.offscreenCaps.getDepthBits());
                                System.err.println("GL_STENCIL_BITS     " + GLJPanel.this.getGLInteger((GL)object, 3415) + "              " + GLJPanel.this.offscreenCaps.getStencilBits());
                            }
                            GLJPanel.this.isInitialized = false;
                            GLJPanel.this.shouldInitialize = true;
                            GLJPanel.this.oglPipelineEnabled = false;
                            GLJPanel.this.handleReshape = true;
                            GLJPanel.this.j2dContext.release();
                            GLJPanel.this.j2dContext.destroy();
                            GLJPanel.this.j2dContext = null;
                            return;
                        }
                        GLJPanel.this.j2dContext.release();
                    }
                    GLJPanel.this.j2dContext.makeCurrent();
                    try {
                        GLJPanel.this.captureJ2DState(GLJPanel.this.j2dContext.getGL(), graphics);
                        object = Java2D.getOGLSurfaceIdentifier(graphics);
                        if (object != null) {
                            if (GLJPanel.this.j2dSurface != object) {
                                if (GLJPanel.this.joglContext != null) {
                                    GLJPanel.this.joglContext.destroy();
                                    GLJPanel.this.joglContext = null;
                                    GLJPanel.this.joglDrawable = null;
                                    GLJPanel.this.sendReshape = true;
                                    if (DEBUG) {
                                        System.err.println("Sending reshape because surface changed");
                                        System.err.println("New surface = " + object);
                                    }
                                }
                                GLJPanel.this.j2dSurface = object;
                            }
                            if (GLJPanel.this.joglContext == null) {
                                if (GLDrawableFactory.getFactory().canCreateExternalGLDrawable()) {
                                    GLJPanel.this.joglDrawable = GLDrawableFactory.getFactory().createExternalGLDrawable();
                                    GLJPanel.this.joglContext = GLJPanel.this.joglDrawable.createContext(GLJPanel.this.shareWith);
                                } else if (GLDrawableFactoryImpl.getFactoryImpl().canCreateContextOnJava2DSurface()) {
                                    GLJPanel.this.joglContext = GLDrawableFactoryImpl.getFactoryImpl().createContextOnJava2DSurface(graphics, GLJPanel.this.shareWith);
                                }
                                if (DEBUG) {
                                    GLJPanel.this.joglContext.setGL(new DebugGL(GLJPanel.this.joglContext.getGL()));
                                }
                                if (Java2D.isFBOEnabled() && Java2D.getOGLSurfaceType(graphics) == Java2D.FBOBJECT && GLJPanel.this.fbObjectWorkarounds) {
                                    GLJPanel.this.createNewDepthBuffer = true;
                                }
                            }
                            if (GLJPanel.this.joglContext instanceof Java2DGLContext) {
                                ((Java2DGLContext)((Object)GLJPanel.this.joglContext)).setGraphics(graphics);
                            }
                            if (DEBUG && VERBOSE && Java2D.isFBOEnabled()) {
                                System.err.print("-- Surface type: ");
                                int n = Java2D.getOGLSurfaceType(graphics);
                                if (n == Java2D.UNDEFINED) {
                                    System.err.println("UNDEFINED");
                                } else if (n == Java2D.WINDOW) {
                                    System.err.println("WINDOW");
                                } else if (n == Java2D.PBUFFER) {
                                    System.err.println("PBUFFER");
                                } else if (n == Java2D.TEXTURE) {
                                    System.err.println("TEXTURE");
                                } else if (n == Java2D.FLIP_BACKBUFFER) {
                                    System.err.println("FLIP_BACKBUFFER");
                                } else if (n == Java2D.FBOBJECT) {
                                    System.err.println("FBOBJECT");
                                } else {
                                    System.err.println("(Unknown surface type " + n + ")");
                                }
                            }
                            GLJPanel.this.drawableHelper.invokeGL(GLJPanel.this.joglDrawable, GLJPanel.this.joglContext, GLJPanel.this.displayAction, GLJPanel.this.initAction);
                        }
                    }
                    finally {
                        GLJPanel.this.j2dContext.release();
                    }
                }
            });
        } else {
            if (!hardwareAccelerationDisabled) {
                this.pbuffer.display();
            } else {
                this.drawableHelper.invokeGL(this.offscreenDrawable, this.offscreenContext, this.displayAction, this.initAction);
            }
            if (this.offscreenImage != null) {
                graphics.drawImage(this.offscreenImage, 0, 0, this.offscreenImage.getWidth(), this.offscreenImage.getHeight(), this);
            }
        }
    }

    public void addNotify() {
        super.addNotify();
        this.shouldInitialize = true;
        if (DEBUG) {
            System.err.println("GLJPanel.addNotify()");
        }
    }

    public void removeNotify() {
        if (DEBUG) {
            System.err.println("GLJPanel.removeNotify()");
        }
        if (this.oglPipelineEnabled) {
            Java2D.invokeWithOGLContextCurrent(null, new Runnable(){

                public void run() {
                    if (GLJPanel.this.joglContext != null) {
                        GLJPanel.this.joglContext.destroy();
                        GLJPanel.this.joglContext = null;
                    }
                    GLJPanel.this.joglDrawable = null;
                    if (GLJPanel.this.j2dContext != null) {
                        GLJPanel.this.j2dContext.destroy();
                        GLJPanel.this.j2dContext = null;
                    }
                }
            });
        } else if (!hardwareAccelerationDisabled) {
            if (this.pbuffer != null) {
                this.pbuffer.destroy();
                this.pbuffer = null;
            }
        } else {
            if (this.offscreenContext != null) {
                this.offscreenContext.destroy();
                this.offscreenContext = null;
            }
            if (this.offscreenDrawable != null) {
                this.offscreenDrawable.destroy();
                this.offscreenDrawable = null;
            }
        }
        this.isInitialized = false;
        super.removeNotify();
    }

    public void reshape(int n, int n2, int n3, int n4) {
        super.reshape(n, n2, n3, n4);
        this.reshapeX = n;
        this.reshapeY = n2;
        this.reshapeWidth = n3;
        this.reshapeHeight = n4;
        this.handleReshape = true;
    }

    public void setOpaque(boolean bl) {
        if (bl != this.isOpaque() && this.offscreenImage != null) {
            this.offscreenImage.flush();
            this.offscreenImage = null;
        }
        super.setOpaque(bl);
    }

    public void addGLEventListener(GLEventListener gLEventListener) {
        this.drawableHelper.addGLEventListener(gLEventListener);
    }

    public void removeGLEventListener(GLEventListener gLEventListener) {
        this.drawableHelper.removeGLEventListener(gLEventListener);
    }

    public GLContext createContext(GLContext gLContext) {
        if (!hardwareAccelerationDisabled) {
            return this.pbuffer.createContext(gLContext);
        }
        return this.offscreenDrawable.createContext(gLContext);
    }

    public void setRealized(boolean bl) {
    }

    public GLContext getContext() {
        if (this.oglPipelineEnabled) {
            return this.joglContext;
        }
        if (!hardwareAccelerationDisabled) {
            if (this.pbuffer == null && Beans.isDesignTime()) {
                return null;
            }
            return this.pbuffer.getContext();
        }
        return this.offscreenContext;
    }

    public GL getGL() {
        GLContext gLContext = this.getContext();
        return gLContext == null ? null : gLContext.getGL();
    }

    public void setGL(GL gL) {
        GLContext gLContext = this.getContext();
        if (gLContext != null) {
            gLContext.setGL(gL);
        }
    }

    public void setAutoSwapBufferMode(boolean bl) {
    }

    public boolean getAutoSwapBufferMode() {
        return true;
    }

    public void swapBuffers() {
    }

    public boolean shouldPreserveColorBufferIfTranslucent() {
        return this.oglPipelineEnabled;
    }

    public GLCapabilities getChosenGLCapabilities() {
        if (this.oglPipelineEnabled) {
            return new GLCapabilities();
        }
        if (hardwareAccelerationDisabled) {
            if (this.offscreenDrawable != null) {
                return this.offscreenDrawable.getChosenGLCapabilities();
            }
        } else if (this.pbuffer != null) {
            return this.pbuffer.getChosenGLCapabilities();
        }
        return null;
    }

    private void initialize() {
        if (this.panelWidth == 0 || this.panelHeight == 0) {
            if (this.reshapeWidth == 0 || this.reshapeHeight == 0) {
                return;
            }
            this.panelWidth = this.reshapeWidth;
            this.panelHeight = this.reshapeHeight;
        }
        if (!this.oglPipelineEnabled) {
            if (!hardwareAccelerationDisabled) {
                if (GLDrawableFactory.getFactory().canCreateGLPbuffer()) {
                    if (this.pbuffer != null) {
                        throw new InternalError("Creating pbuffer twice without destroying it (memory leak / correctness bug)");
                    }
                    try {
                        this.pbuffer = GLDrawableFactory.getFactory().createGLPbuffer(this.offscreenCaps, null, this.pbufferWidth, this.pbufferHeight, this.shareWith);
                        this.updater = new Updater();
                        this.pbuffer.addGLEventListener(this.updater);
                        this.shouldInitialize = false;
                        this.isInitialized = true;
                        return;
                    }
                    catch (GLException gLException) {
                        if (DEBUG) {
                            gLException.printStackTrace();
                            System.err.println("GLJPanel: Falling back on software rendering because of problems creating pbuffer");
                        }
                        hardwareAccelerationDisabled = true;
                    }
                } else {
                    if (DEBUG) {
                        System.err.println("GLJPanel: Falling back on software rendering because no pbuffer support");
                    }
                    hardwareAccelerationDisabled = true;
                }
            }
            if (softwareRenderingDisabled) {
                throw new GLException("Fallback to software rendering disabled by user");
            }
            this.offscreenDrawable = GLDrawableFactoryImpl.getFactoryImpl().createOffscreenDrawable(this.offscreenCaps, this.chooser);
            this.offscreenDrawable.setSize(Math.max(1, this.panelWidth), Math.max(1, this.panelHeight));
            this.offscreenContext = (GLContextImpl)this.offscreenDrawable.createContext(this.shareWith);
            this.offscreenContext.setSynchronized(true);
        }
        this.updater = new Updater();
        this.shouldInitialize = false;
        this.isInitialized = true;
    }

    private void handleReshape() {
        this.readBackWidthInPixels = 0;
        this.readBackHeightInPixels = 0;
        this.panelWidth = this.reshapeWidth;
        this.panelHeight = this.reshapeHeight;
        if (DEBUG) {
            System.err.println("GLJPanel.handleReshape: (w,h) = (" + this.panelWidth + "," + this.panelHeight + ")");
        }
        this.sendReshape = true;
        if (!this.oglPipelineEnabled) {
            if (!hardwareAccelerationDisabled) {
                float f = 2.5f;
                if (this.panelWidth > this.pbufferWidth || this.panelHeight > this.pbufferHeight || (float)this.panelWidth < (float)this.pbufferWidth / f || (float)this.panelHeight < (float)this.pbufferHeight / f) {
                    block13: {
                        if (DEBUG) {
                            System.err.println("Resizing pbuffer from (" + this.pbufferWidth + ", " + this.pbufferHeight + ") " + " to fit (" + this.panelWidth + ", " + this.panelHeight + ")");
                        }
                        if (this.pbuffer != null) {
                            try {
                                this.pbuffer.destroy();
                            }
                            catch (GLException gLException) {
                                hardwareAccelerationDisabled = true;
                                if (!DEBUG) break block13;
                                System.err.println("WARNING: falling back to software rendering due to bugs in OpenGL drivers");
                                gLException.printStackTrace();
                            }
                        }
                    }
                    this.pbuffer = null;
                    this.isInitialized = false;
                    this.pbufferWidth = this.getNextPowerOf2(this.panelWidth);
                    this.pbufferHeight = this.getNextPowerOf2(this.panelHeight);
                    if (DEBUG && !hardwareAccelerationDisabled) {
                        System.err.println("New pbuffer size is (" + this.pbufferWidth + ", " + this.pbufferHeight + ")");
                    }
                    this.initialize();
                }
                if (!hardwareAccelerationDisabled) {
                    this.readBackWidthInPixels = this.pbufferWidth;
                    this.readBackHeightInPixels = this.panelHeight;
                } else {
                    this.readBackWidthInPixels = Math.max(1, this.panelWidth);
                    this.readBackHeightInPixels = Math.max(1, this.panelHeight);
                }
            } else {
                this.offscreenContext.destroy();
                this.offscreenDrawable.setSize(Math.max(1, this.panelWidth), Math.max(1, this.panelHeight));
                this.readBackWidthInPixels = Math.max(1, this.panelWidth);
                this.readBackHeightInPixels = Math.max(1, this.panelHeight);
            }
            if (this.offscreenImage != null) {
                this.offscreenImage.flush();
                this.offscreenImage = null;
            }
        }
        this.handleReshape = false;
    }

    private int getNextPowerOf2(int n) {
        if (n == 0) {
            return 2;
        }
        if ((n - 1 & n) == 0) {
            return n;
        }
        int n2 = 0;
        while (n > 0) {
            n >>= 1;
            ++n2;
        }
        return 1 << n2;
    }

    private int getGLInteger(GL gL, int n) {
        int[] nArray = new int[1];
        gL.glGetIntegerv(n, nArray, 0);
        return nArray[0];
    }

    static {
        if (Java2D.isOGLPipelineActive() && Java2D.isFBOEnabled()) {
            Java2D.getShareContext(GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration());
        }
    }

    class DisplayAction
    implements Runnable {
        DisplayAction() {
        }

        public void run() {
            GLJPanel.this.updater.display(GLJPanel.this);
        }
    }

    class InitAction
    implements Runnable {
        InitAction() {
        }

        public void run() {
            GLJPanel.this.updater.init(GLJPanel.this);
        }
    }

    class PaintImmediatelyAction
    implements Runnable {
        PaintImmediatelyAction() {
        }

        public void run() {
            GLJPanel.this.paintImmediately(0, 0, GLJPanel.this.getWidth(), GLJPanel.this.getHeight());
        }
    }

    class SwapBuffersAction
    implements Runnable {
        SwapBuffersAction() {
        }

        public void run() {
            GLJPanel.this.offscreenDrawable.swapBuffers();
        }
    }

    class Updater
    implements GLEventListener {
        private Graphics g;

        Updater() {
        }

        public void setGraphics(Graphics graphics) {
            this.g = graphics;
        }

        public void init(GLAutoDrawable gLAutoDrawable) {
            if (GLJPanel.this.oglPipelineEnabled && !GLJPanel.this.preGL(this.g)) {
                return;
            }
            GLJPanel.this.drawableHelper.init(GLJPanel.this);
            if (GLJPanel.this.oglPipelineEnabled) {
                GLJPanel.this.postGL(this.g);
            }
        }

        public void display(GLAutoDrawable gLAutoDrawable) {
            if (GLJPanel.this.oglPipelineEnabled && !GLJPanel.this.preGL(this.g)) {
                return;
            }
            if (GLJPanel.this.sendReshape) {
                if (DEBUG) {
                    System.err.println("glViewport(" + GLJPanel.this.viewportX + ", " + GLJPanel.this.viewportY + ", " + GLJPanel.this.panelWidth + ", " + GLJPanel.this.panelHeight + ")");
                }
                GLJPanel.this.getGL().glViewport(GLJPanel.this.viewportX, GLJPanel.this.viewportY, GLJPanel.this.panelWidth, GLJPanel.this.panelHeight);
                GLJPanel.this.drawableHelper.reshape(GLJPanel.this, GLJPanel.this.viewportX, GLJPanel.this.viewportY, GLJPanel.this.panelWidth, GLJPanel.this.panelHeight);
                GLJPanel.this.sendReshape = false;
            }
            GLJPanel.this.drawableHelper.display(GLJPanel.this);
            if (!GLJPanel.this.oglPipelineEnabled) {
                if (GLJPanel.this.offscreenImage == null && GLJPanel.this.panelWidth > 0 && GLJPanel.this.panelHeight > 0) {
                    int n = 0;
                    int n2 = 0;
                    if (!hardwareAccelerationDisabled) {
                        n2 = 33639;
                    }
                    n = GLJPanel.this.isOpaque() ? 1 : 2;
                    GLJPanel.this.offscreenImage = new BufferedImage(GLJPanel.this.panelWidth, GLJPanel.this.panelHeight, n);
                    switch (n) {
                        case 5: {
                            GLJPanel.this.glFormat = 32992;
                            GLJPanel.this.glType = 5121;
                            GLJPanel.this.readBackBytes = ByteBuffer.allocate(GLJPanel.this.readBackWidthInPixels * GLJPanel.this.readBackHeightInPixels * 3);
                            break;
                        }
                        case 1: 
                        case 2: {
                            GLJPanel.this.glFormat = 32993;
                            GLJPanel.this.glType = hardwareAccelerationDisabled ? GLJPanel.this.offscreenContext.getOffscreenContextPixelDataType() : n2;
                            GLJPanel.this.readBackInts = IntBuffer.allocate(GLJPanel.this.readBackWidthInPixels * GLJPanel.this.readBackHeightInPixels);
                            break;
                        }
                        default: {
                            throw new GLException("Unsupported offscreen image type " + n);
                        }
                    }
                }
                if (GLJPanel.this.offscreenImage != null) {
                    GL gL = GLJPanel.this.getGL();
                    gL.glGetIntegerv(3328, GLJPanel.this.swapbytes, 0);
                    gL.glGetIntegerv(3330, GLJPanel.this.rowlength, 0);
                    gL.glGetIntegerv(3331, GLJPanel.this.skiprows, 0);
                    gL.glGetIntegerv(3332, GLJPanel.this.skippixels, 0);
                    gL.glGetIntegerv(3333, GLJPanel.this.alignment, 0);
                    gL.glPixelStorei(3328, 0);
                    gL.glPixelStorei(3330, GLJPanel.this.readBackWidthInPixels);
                    gL.glPixelStorei(3331, 0);
                    gL.glPixelStorei(3332, 0);
                    gL.glPixelStorei(3333, 1);
                    gL.glReadBuffer(1028);
                    if (GLJPanel.this.readBackBytes != null) {
                        gL.glReadPixels(0, 0, GLJPanel.this.readBackWidthInPixels, GLJPanel.this.readBackHeightInPixels, GLJPanel.this.glFormat, GLJPanel.this.glType, GLJPanel.this.readBackBytes);
                    } else if (GLJPanel.this.readBackInts != null) {
                        gL.glReadPixels(0, 0, GLJPanel.this.readBackWidthInPixels, GLJPanel.this.readBackHeightInPixels, GLJPanel.this.glFormat, GLJPanel.this.glType, GLJPanel.this.readBackInts);
                    }
                    gL.glPixelStorei(3328, GLJPanel.this.swapbytes[0]);
                    gL.glPixelStorei(3330, GLJPanel.this.rowlength[0]);
                    gL.glPixelStorei(3331, GLJPanel.this.skiprows[0]);
                    gL.glPixelStorei(3332, GLJPanel.this.skippixels[0]);
                    gL.glPixelStorei(3333, GLJPanel.this.alignment[0]);
                    if (GLJPanel.this.readBackBytes != null || GLJPanel.this.readBackInts != null) {
                        Object[] objectArray = null;
                        Object[] objectArray2 = null;
                        int n = 0;
                        int n3 = 0;
                        if (GLJPanel.this.readBackBytes != null) {
                            objectArray = GLJPanel.this.readBackBytes.array();
                            objectArray2 = ((DataBufferByte)GLJPanel.this.offscreenImage.getRaster().getDataBuffer()).getData();
                            n = GLJPanel.this.readBackWidthInPixels * 3;
                            n3 = GLJPanel.this.offscreenImage.getWidth() * 3;
                        } else {
                            objectArray = GLJPanel.this.readBackInts.array();
                            objectArray2 = ((DataBufferInt)GLJPanel.this.offscreenImage.getRaster().getDataBuffer()).getData();
                            n = GLJPanel.this.readBackWidthInPixels;
                            n3 = GLJPanel.this.offscreenImage.getWidth();
                        }
                        if (!hardwareAccelerationDisabled || GLJPanel.this.offscreenContext.offscreenImageNeedsVerticalFlip()) {
                            int n4 = 0;
                            for (int i = (GLJPanel.this.offscreenImage.getHeight() - 1) * n3; i >= 0; i -= n3) {
                                System.arraycopy(objectArray, n4, objectArray2, i, n3);
                                n4 += n;
                            }
                        } else {
                            int n5 = 0;
                            int n6 = n3 * GLJPanel.this.offscreenImage.getHeight();
                            for (int i = 0; i < n6; i += n3) {
                                System.arraycopy(objectArray, n5, objectArray2, i, n3);
                                n5 += n;
                            }
                        }
                    }
                }
            } else {
                GL gL = GLJPanel.this.getGL();
                gL.glFinish();
                GLJPanel.this.postGL(this.g);
            }
        }

        public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
        }

        public void displayChanged(GLAutoDrawable gLAutoDrawable, boolean bl, boolean bl2) {
        }
    }
}

