/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.jgl3dchart;

import fr.esrf.tangoatk.widget.util.Gradient;
import fr.esrf.tangoatk.widget.util.JGradientViewer;
import fr.esrf.tangoatk.widget.util.jgl3dchart.JGL3DAxis;
import fr.esrf.tangoatk.widget.util.jgl3dchart.JGL3DView;
import fr.esrf.tangoatk.widget.util.jgl3dchart.SettingsFrame;
import fr.esrf.tangoatk.widget.util.jgl3dchart.Utils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JToolBar;

public class JGL3DChart
extends JPanel
implements ActionListener {
    private JGL3DView j3dView;
    private Gradient gColor;
    JGradientViewer gradientViewer;
    private JButton resetRotBtn;
    private JButton rotationYXBtn;
    private JButton rotationYZBtn;
    private JButton rotationXZBtn;
    private JButton autoScaleCameraBtn;
    private JButton zoomBackBtn;
    private JButton settingsBtn;
    private SettingsFrame settingsFrame;

    public JGL3DChart() {
        this.setLayout(new BorderLayout());
        this.j3dView = new JGL3DView(this);
        this.add((Component)this.j3dView, "Center");
        this.gColor = new Gradient();
        this.gColor.buildRainbowGradient();
        int[] nArray = this.gColor.buildColorMap(65536);
        this.j3dView.setColorMap(nArray);
        this.gradientViewer = new JGradientViewer();
        this.gradientViewer.setGradient(this.gColor);
        this.add((Component)this.gradientViewer, "East");
        JToolBar jToolBar = new JToolBar();
        jToolBar.setOrientation(0);
        this.resetRotBtn = Utils.createIconButton("jgl3dchart_resetrot", false, "Reset rotation", this);
        jToolBar.add(this.resetRotBtn);
        this.rotationYXBtn = Utils.createIconButton("jgl3dchart_rotYX", false, "Align to YX plane", this);
        jToolBar.add(this.rotationYXBtn);
        this.rotationYZBtn = Utils.createIconButton("jgl3dchart_rotYZ", false, "Align to YZ plane", this);
        jToolBar.add(this.rotationYZBtn);
        this.rotationXZBtn = Utils.createIconButton("jgl3dchart_rotXZ", false, "Align to XZ plane", this);
        jToolBar.add(this.rotationXZBtn);
        this.autoScaleCameraBtn = Utils.createIconButton("jgl3dchart_autosccam", false, "Auto scale camera", this);
        jToolBar.add(this.autoScaleCameraBtn);
        this.zoomBackBtn = Utils.createIconButton("jgl3dchart_zoomback", false, "Zoom back", this);
        jToolBar.add(this.zoomBackBtn);
        this.settingsBtn = Utils.createIconButton("jgl3dchart_settings", false, "Show settings", this);
        jToolBar.add(this.settingsBtn);
        this.add((Component)jToolBar, "North");
    }

    public void setData(double[][] dArray) {
        this.j3dView.setData(dArray);
    }

    public void resetRotation() {
        this.j3dView.resetRotation();
    }

    public void rotateYX() {
        this.j3dView.rotateYX();
    }

    public void rotateYZ() {
        this.j3dView.rotateYZ();
    }

    public void rotateXZ() {
        this.j3dView.rotateXZ();
    }

    public void rotate(double d, double d2) {
        this.j3dView.rotate(d, d2);
    }

    public void autoScaleCamera() {
        this.j3dView.autoScaleCameraRequest();
        this.j3dView.display();
    }

    public void setGradient(Gradient gradient) {
        this.gColor = gradient;
        int[] nArray = gradient.buildColorMap(65536);
        this.gradientViewer.setGradient(gradient);
        this.j3dView.setColorMap(nArray);
        this.j3dView.computeScale();
    }

    public Gradient getGradient() {
        return this.gColor;
    }

    public JGL3DAxis getXAxis() {
        return this.j3dView.getXAxis();
    }

    public JGL3DAxis getYAxis() {
        return this.j3dView.getYAxis();
    }

    public JGL3DAxis getZAxis() {
        return this.j3dView.getZAxis();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.resetRotBtn) {
            this.resetRotation();
        } else if (object == this.rotationYXBtn) {
            this.rotateYX();
        } else if (object == this.rotationYZBtn) {
            this.rotateYZ();
        } else if (object == this.rotationXZBtn) {
            this.rotateXZ();
        } else if (object == this.autoScaleCameraBtn) {
            this.autoScaleCamera();
        } else if (object == this.zoomBackBtn) {
            this.j3dView.zoomBack();
        } else if (object == this.settingsBtn) {
            if (this.settingsFrame == null) {
                this.settingsFrame = new SettingsFrame(this);
            }
            this.settingsFrame.setVisible(true);
        }
    }

    public static void main(String[] stringArray) {
        JGL3DChart jGL3DChart = new JGL3DChart();
        double[][] dArray = new double[1000][1000];
        for (int i = -500; i < 500; ++i) {
            for (int j = -500; j < 500; ++j) {
                double d = (double)((i - 100) * (i - 100)) / 100.0 + (double)((j - 5) * (j - 5)) / 100.0;
                double d2 = (double)((i + 100) * (i + 100)) / 100.0 + (double)((j + 5) * (j + 5)) / 100.0;
                dArray[i + 500][j + 500] = 150.0 * Math.exp(-d) - 150.0 * Math.exp(-d2);
            }
        }
        jGL3DChart.setData(dArray);
        JFrame jFrame = new JFrame();
        jFrame.setTitle("JOGL Chart");
        jFrame.setContentPane(jGL3DChart);
        jFrame.setDefaultCloseOperation(3);
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

