/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.jdraw;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.AttributeInfo;
import fr.esrf.TangoApi.CommandInfo;
import fr.esrf.tangoatk.core.ConnectionException;
import fr.esrf.tangoatk.core.Device;
import fr.esrf.tangoatk.core.DeviceFactory;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import fr.esrf.tangoatk.widget.util.jdraw.JDEntityNode;
import fr.esrf.tangoatk.widget.util.jdraw.JDNode;

class MemberNode
extends JDNode {
    private String domain;
    private String family;
    private String member;

    MemberNode(String string, String string2, String string3) {
        this.domain = string;
        this.family = string2;
        this.member = string3;
    }

    void populateNode() throws DevFailed {
        String string = this.domain + "/" + this.family + "/" + this.member;
        try {
            Device device = DeviceFactory.getInstance().getDevice(string);
            AttributeInfo[] attributeInfoArray = device.get_attribute_info();
            for (int i = 0; i < attributeInfoArray.length; ++i) {
                if (attributeInfoArray[i].data_format.value() == 0) {
                    switch (attributeInfoArray[i].data_type) {
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: 
                        case 21: 
                        case 22: {
                            this.add(new JDEntityNode(1, string, "[number scalar]", attributeInfoArray[i].name));
                            break;
                        }
                        case 8: {
                            this.add(new JDEntityNode(1, string, "[string scalar]", attributeInfoArray[i].name));
                            break;
                        }
                        case 1: {
                            this.add(new JDEntityNode(1, string, "[boolean scalar]", attributeInfoArray[i].name));
                            break;
                        }
                        default: {
                            this.add(new JDEntityNode(1, string, "[scalar]", attributeInfoArray[i].name));
                            break;
                        }
                    }
                    continue;
                }
                if (attributeInfoArray[i].data_format.value() == 1) {
                    switch (attributeInfoArray[i].data_type) {
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: 
                        case 21: 
                        case 22: {
                            this.add(new JDEntityNode(1, string, "[number spectrum]", attributeInfoArray[i].name));
                            break;
                        }
                        case 8: {
                            this.add(new JDEntityNode(1, string, "[string spectrum]", attributeInfoArray[i].name));
                            break;
                        }
                        case 1: {
                            this.add(new JDEntityNode(1, string, "[boolean spectrum]", attributeInfoArray[i].name));
                            break;
                        }
                        default: {
                            this.add(new JDEntityNode(1, string, "[spectrum]", attributeInfoArray[i].name));
                            break;
                        }
                    }
                    continue;
                }
                if (attributeInfoArray[i].data_format.value() == 2) {
                    switch (attributeInfoArray[i].data_type) {
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: 
                        case 21: 
                        case 22: {
                            this.add(new JDEntityNode(1, string, "[number image]", attributeInfoArray[i].name));
                            break;
                        }
                        case 8: {
                            this.add(new JDEntityNode(1, string, "[string image]", attributeInfoArray[i].name));
                            break;
                        }
                        case 1: {
                            this.add(new JDEntityNode(1, string, "[boolean image]", attributeInfoArray[i].name));
                            break;
                        }
                        default: {
                            this.add(new JDEntityNode(1, string, "[image]", attributeInfoArray[i].name));
                            break;
                        }
                    }
                    continue;
                }
                this.add(new JDEntityNode(1, string, "[unknown]", attributeInfoArray[i].name));
            }
            attributeInfoArray = null;
            CommandInfo[] commandInfoArray = device.command_list_query();
            for (int i = 0; i < commandInfoArray.length; ++i) {
                this.add(new JDEntityNode(2, string, "[command]", commandInfoArray[i].cmd_name));
            }
        }
        catch (ConnectionException connectionException) {
            ErrorPane.showErrorMessage(null, string, connectionException);
        }
    }

    public boolean isLeaf() {
        return false;
    }

    public String toString() {
        return this.member;
    }
}

