/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.jdraw;

import fr.esrf.tangoatk.widget.util.jdraw.JDEllipse;
import fr.esrf.tangoatk.widget.util.jdraw.JDGroup;
import fr.esrf.tangoatk.widget.util.jdraw.JDImage;
import fr.esrf.tangoatk.widget.util.jdraw.JDLabel;
import fr.esrf.tangoatk.widget.util.jdraw.JDLine;
import fr.esrf.tangoatk.widget.util.jdraw.JDObject;
import fr.esrf.tangoatk.widget.util.jdraw.JDPolyline;
import fr.esrf.tangoatk.widget.util.jdraw.JDRectangle;
import fr.esrf.tangoatk.widget.util.jdraw.JDRoundRectangle;
import fr.esrf.tangoatk.widget.util.jdraw.JDSpline;
import fr.esrf.tangoatk.widget.util.jdraw.JDValueProgram;
import fr.esrf.tangoatk.widget.util.jdraw.JLXObject;
import fr.esrf.tangoatk.widget.util.jdraw.JLXPath;
import fr.esrf.tangoatk.widget.util.jdraw.JLXStyle;
import java.awt.Color;
import java.awt.Font;
import java.io.FileReader;
import java.io.IOException;
import java.util.Vector;

class JLXFileLoader {
    private int CrtLine;
    private int StartLine;
    private char CurrentChar;
    String version;
    private String word;
    FileReader f;
    static final int[] ToJDTextAlign = new int[]{1, 0, 2};
    static String[] extNames = new String[]{"className", "classParam"};

    public JLXFileLoader(FileReader fileReader) {
        this.f = fileReader;
        this.CrtLine = 1;
        this.CurrentChar = (char)32;
    }

    private void read_char() throws IOException {
        this.CurrentChar = this.f.ready() ? (char)this.f.read() : (char)'\u0000';
        if (this.CurrentChar == '\n') {
            ++this.CrtLine;
        }
    }

    String read_safe_word() throws IOException {
        this.word = this.read_word(false);
        if (this.word == null) {
            throw new IOException("Unexpected end of file " + this.CrtLine);
        }
        return this.word;
    }

    String read_safe_full_word() throws IOException {
        this.word = this.read_word(true);
        if (this.word == null) {
            throw new IOException("Unexpected end of file " + this.CrtLine);
        }
        return this.word;
    }

    void jump_space() throws IOException {
        while (this.CurrentChar <= ' ' && this.CurrentChar > '\u0000') {
            this.read_char();
        }
    }

    String read_word(boolean bl) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        this.jump_space();
        this.StartLine = this.CrtLine;
        if (!bl && this.CurrentChar == ';') {
            stringBuffer.append(this.CurrentChar);
            this.read_char();
            return stringBuffer.toString();
        }
        if (this.CurrentChar == '\"') {
            stringBuffer.append(this.CurrentChar);
            this.read_char();
            while (this.CurrentChar != '\"' && this.CurrentChar != '\u0000') {
                stringBuffer.append(this.CurrentChar);
                this.read_char();
            }
            if (this.CurrentChar == '\u0000' || this.CurrentChar == '\n') {
                IOException iOException = new IOException("String too long at line " + this.StartLine);
                throw iOException;
            }
            stringBuffer.append(this.CurrentChar);
            this.read_char();
            return stringBuffer.toString();
        }
        if (bl) {
            while (this.CurrentChar > ' ' && this.CurrentChar != '\n') {
                stringBuffer.append(this.CurrentChar);
                this.read_char();
            }
        } else {
            while (this.CurrentChar > ' ' && this.CurrentChar != '\n' && this.CurrentChar != ';') {
                stringBuffer.append(this.CurrentChar);
                this.read_char();
            }
        }
        if (stringBuffer.length() == 0) {
            return null;
        }
        return stringBuffer.toString();
    }

    public int getCurrentLine() {
        return this.StartLine;
    }

    int read_int() throws IOException {
        int n;
        String string = this.read_safe_word();
        if (string.equals("!") || string.equals("$")) {
            return 0;
        }
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException("Bad integer format at line " + this.CrtLine + "\n" + numberFormatException.getMessage());
        }
        return n;
    }

    double read_double() throws IOException {
        double d;
        String string = this.read_safe_word();
        if (string.equals("!") || string.equals("$")) {
            return 0.0;
        }
        try {
            d = Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException("Bad double format at line " + this.CrtLine + "\n" + numberFormatException.getMessage());
        }
        return d;
    }

    Color read_color() throws IOException {
        String string = this.read_safe_word();
        if (string.equals("!") || string.equals("$")) {
            return null;
        }
        try {
            int n = (int)Long.parseLong(string, 16);
            int n2 = n >>> 24;
            int n3 = (n & 0xFF0000) >>> 16;
            int n4 = (n & 0xFF00) >>> 8;
            int n5 = n & 0xFF;
            return new Color(n3, n4, n5, n2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException("Bad color format at line " + this.CrtLine + "\n" + numberFormatException.getMessage());
        }
    }

    void jump_colon() throws IOException {
        String string = this.read_safe_word();
        if (!string.equals(";")) {
            throw new IOException("';' expected at line " + this.CrtLine + "\n");
        }
    }

    double[] parseDouleArray() throws IOException {
        String string = this.read_safe_full_word();
        if (string.equals("!") || string.equals("$")) {
            double[] dArray = new double[2];
            dArray[1] = 0.0;
            dArray[0] = 0.0;
            return dArray;
        }
        String[] stringArray = string.split(";");
        double[] dArray = new double[stringArray.length];
        try {
            for (int i = 0; i < dArray.length; ++i) {
                dArray[i] = Double.parseDouble(stringArray[i]);
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException("Number expected at line " + this.getCurrentLine() + "\n" + numberFormatException.getMessage());
        }
        return dArray;
    }

    private String extractQuote(String string) {
        if (string.charAt(0) == '\"') {
            return string.substring(1, string.length() - 1);
        }
        return string;
    }

    String read_string() throws IOException {
        String string = this.read_safe_word();
        return this.extractQuote(string);
    }

    JDObject parseLxRectangle(double d, double d2) throws IOException {
        JLXObject jLXObject = new JLXObject("Rectangle");
        jLXObject.parse(this, false);
        jLXObject.correct(d, d2);
        int n = (int)this.read_double();
        this.read_double();
        int n2 = this.read_int();
        if (n2 == 0) {
            return new JDRectangle(jLXObject);
        }
        return new JDRoundRectangle(jLXObject, n);
    }

    JDObject parseLxCircle(double d, double d2) throws IOException {
        JLXObject jLXObject = new JLXObject("Ellipse");
        jLXObject.parse(this, false);
        jLXObject.correct(d, d2);
        int n = (int)this.read_double();
        int n2 = (int)this.read_double();
        int n3 = this.read_int();
        return new JDEllipse(jLXObject, 360 - (n + n2), n2, n3);
    }

    JDObject parseLxLine(double d, double d2) throws IOException {
        JLXObject jLXObject = new JLXObject("Line");
        jLXObject.parse(this, false);
        jLXObject.correct(d, d2);
        JLXPath jLXPath = new JLXPath();
        jLXPath.parse(this, false, true);
        return new JDLine(jLXObject, jLXPath);
    }

    JDObject parseLxParallelogram(double d, double d2) throws IOException {
        JLXObject jLXObject = new JLXObject("Polyline");
        jLXObject.parse(this, false);
        jLXObject.correct(d, d2);
        JLXPath jLXPath = new JLXPath();
        jLXPath.parse(this, true, false);
        this.read_int();
        this.read_int();
        return new JDPolyline(jLXObject, jLXPath);
    }

    JDObject parseLxPolyline(double d, double d2) throws IOException {
        JLXObject jLXObject = new JLXObject("Polyline");
        jLXObject.parse(this, false);
        jLXObject.correct(d, d2);
        JLXPath jLXPath = new JLXPath();
        jLXPath.parse(this, true, true);
        return new JDPolyline(jLXObject, jLXPath);
    }

    JDObject parseLxText(double d, double d2) throws IOException {
        JLXObject jLXObject = new JLXObject("Text");
        jLXObject.parse(this, false);
        jLXObject.correct(d, d2);
        this.read_int();
        this.read_double();
        String string = this.read_string();
        int n = this.read_int();
        int n2 = this.read_int();
        String string2 = this.read_string();
        jLXObject.style.fillStyle = 0;
        jLXObject.style.lineWidth = 0;
        return new JDLabel(jLXObject, new Font(string, n, n2), string2, 0, true);
    }

    JDObject parseLxTextArea(double d, double d2) throws IOException {
        JLXObject jLXObject = new JLXObject("Text");
        jLXObject.parse(this, false);
        jLXObject.correct(d, d2);
        JLXPath jLXPath = new JLXPath();
        jLXPath.parse(this, true, false);
        this.read_int();
        this.read_double();
        String string = this.read_string();
        int n = this.read_int();
        int n2 = this.read_int();
        String string2 = this.read_string();
        this.read_int();
        this.read_int();
        this.read_int();
        this.read_int();
        int n3 = this.read_int();
        Color color = this.read_color();
        jLXObject.style.lineColor = color == null ? Color.BLACK : color;
        this.read_double();
        return new JDLabel(jLXObject, new Font(string, n, n2), string2, ToJDTextAlign[n3], false);
    }

    JDObject parseLxGeneralPath(double d, double d2) throws IOException {
        JLXObject jLXObject = new JLXObject("Polyline");
        jLXObject.parse(this, false);
        jLXObject.correct(d, d2);
        JLXPath jLXPath = new JLXPath();
        jLXPath.parse(this, true, false);
        switch (jLXPath.pathType) {
            case 0: 
            case 1: {
                return new JDPolyline(jLXObject, jLXPath);
            }
            case 2: 
            case 3: {
                return new JDSpline(jLXObject, jLXPath);
            }
        }
        throw new IOException("Bad path format at line " + this.CrtLine);
    }

    JDObject parseLxImage(double d, double d2) throws IOException {
        JLXObject jLXObject = new JLXObject("Image");
        jLXObject.parse(this, false);
        jLXObject.correct(d, d2);
        this.read_int();
        if (this.version.compareTo("0.3.0") >= 0) {
            this.read_int();
            this.read_int();
        }
        this.read_double();
        if (this.version.compareTo("1.0.1") >= 0) {
            this.read_int();
        }
        String string = this.read_string();
        return new JDImage(jLXObject, string);
    }

    JDObject parseLxGroup(double d, double d2) throws IOException {
        JLXObject jLXObject = new JLXObject("Group");
        jLXObject.parse(this, true);
        jLXObject.correct(d, d2);
        Vector<JDObject> vector = new Vector<JDObject>();
        int n = this.read_int();
        for (int i = 0; i < n; ++i) {
            JDObject jDObject = this.parseObject(jLXObject.boundRect.getX(), jLXObject.boundRect.getY());
            if (jDObject == null) continue;
            vector.add(jDObject);
        }
        return new JDGroup(jLXObject, vector);
    }

    JDObject parseLxPushButton(double d, double d2) throws IOException {
        Object object;
        JLXObject jLXObject = new JLXObject("Button");
        jLXObject.parse(this, true);
        jLXObject.correct(d, d2);
        Vector<Object> vector = new Vector<Object>();
        int n = this.read_int();
        for (int i = 0; i < n; ++i) {
            object = this.parseObject(jLXObject.boundRect.getX(), jLXObject.boundRect.getY());
            if (object == null) continue;
            vector.add(object);
        }
        JDGroup jDGroup = new JDGroup(jLXObject, vector);
        object = new JDValueProgram(3);
        ((JDValueProgram)object).addNewEntry();
        ((JDValueProgram)object).setDefaultMapping("false");
        ((JDValueProgram)object).setMappingAt(0, "true");
        ((JDValueProgram)object).setValueAt(0, "1");
        jDGroup.setInvertShadowMapper((JDValueProgram)object);
        ((JDObject)jDGroup).setMinValue(0);
        ((JDObject)jDGroup).setMaxValue(1);
        ((JDObject)jDGroup).setInitValue(0);
        jDGroup.setValueChangeMode(1);
        boolean bl = false;
        if (this.version.compareTo("1.3.0") >= 0) {
            bl = this.read_int() == 1;
        }
        jDGroup.setInteractive(bl);
        return jDGroup;
    }

    private Vector findObjects(String string, Vector vector) {
        int n = vector.size();
        Vector<JDObject> vector2 = new Vector<JDObject>();
        for (int i = 0; i < n; ++i) {
            JDObject jDObject = (JDObject)vector.get(i);
            if (jDObject instanceof JDGroup) {
                if (jDObject.name.equals(string)) {
                    vector2.add(jDObject);
                    continue;
                }
                Vector vector3 = ((JDGroup)jDObject).getChildren();
                Vector vector4 = this.findObjects(string, vector3);
                vector2.addAll(vector4);
                continue;
            }
            boolean bl = jDObject.name.equals(string);
            if (!bl) continue;
            vector2.add((JDObject)vector.get(i));
        }
        return vector2;
    }

    JDObject parseLxMultiState(double d, double d2) throws IOException {
        Object object;
        int n;
        JLXObject jLXObject = new JLXObject("MultiState");
        jLXObject.parse(this, true);
        jLXObject.correct(d, d2);
        Vector<JDObject> vector = new Vector<JDObject>();
        int n2 = this.read_int();
        for (n = 0; n < n2; ++n) {
            JDObject jDObject = this.parseObject(jLXObject.boundRect.getX(), jLXObject.boundRect.getY());
            if (jDObject == null) continue;
            vector.add(jDObject);
        }
        boolean bl = false;
        if (this.version.compareTo("1.3.0") >= 0) {
            bl = this.read_int() == 1;
        }
        int n3 = this.read_int();
        int n4 = this.read_int();
        int n5 = this.read_int();
        for (n = n3; n <= n4; ++n) {
            object = Integer.toString(n);
            Vector vector2 = this.findObjects((String)object, vector);
            if (vector2.size() == 0) {
                System.out.println("JLXFileLoader.parseLxMultiState() : Warning, sub-object '" + (String)object + "' not found in " + jLXObject.name);
                continue;
            }
            JDValueProgram jDValueProgram = new JDValueProgram(3);
            jDValueProgram.addNewEntry();
            jDValueProgram.setDefaultMapping("false");
            jDValueProgram.setMappingAt(0, "true");
            jDValueProgram.setValueAt(0, (String)object);
            for (int i = 0; i < vector2.size(); ++i) {
                ((JDObject)vector2.get(i)).setVisibilityMapper(jDValueProgram.copy());
            }
        }
        object = new JDGroup(jLXObject, vector);
        ((JDObject)object).setMinValue(n3);
        ((JDObject)object).setMaxValue(n4);
        ((JDObject)object).setInitValue(n5);
        ((JDObject)object).setInteractive(bl);
        ((JDObject)object).setValueChangeMode(0);
        return object;
    }

    JDObject parseLxToggle(double d, double d2) throws IOException {
        JLXObject jLXObject = new JLXObject("Toggle");
        jLXObject.parse(this, true);
        jLXObject.correct(d, d2);
        Vector<JDObject> vector = new Vector<JDObject>();
        int n = this.read_int();
        for (int i = 0; i < n; ++i) {
            JDObject jDObject = this.parseObject(jLXObject.boundRect.getX(), jLXObject.boundRect.getY());
            if (jDObject == null) continue;
            vector.add(jDObject);
        }
        boolean bl = false;
        if (this.version.compareTo("1.3.0") >= 0) {
            bl = this.read_int() == 1;
        }
        int n2 = this.read_int();
        Vector vector2 = this.findObjects("OFF", vector);
        Vector vector3 = this.findObjects("ON", vector);
        if (vector2.size() == 0) {
            throw new IOException("Toggle sub-object 'OFF' not found in " + jLXObject.name);
        }
        if (vector3.size() == 0) {
            throw new IOException("Toggle sub-object 'ON' not found in " + jLXObject.name);
        }
        JDValueProgram jDValueProgram = new JDValueProgram(3);
        jDValueProgram.addNewEntry();
        jDValueProgram.setDefaultMapping("false");
        jDValueProgram.setMappingAt(0, "true");
        jDValueProgram.setValueAt(0, "1");
        for (int i = 0; i < vector2.size(); ++i) {
            ((JDObject)vector2.get(i)).setVisibilityMapper(jDValueProgram);
        }
        JDValueProgram jDValueProgram2 = new JDValueProgram(3);
        jDValueProgram2.addNewEntry();
        jDValueProgram2.setDefaultMapping("true");
        jDValueProgram2.setMappingAt(0, "false");
        jDValueProgram2.setValueAt(0, "1");
        for (int i = 0; i < vector3.size(); ++i) {
            ((JDObject)vector3.get(i)).setVisibilityMapper(jDValueProgram2);
        }
        JDGroup jDGroup = new JDGroup(jLXObject, vector);
        ((JDObject)jDGroup).setMinValue(0);
        ((JDObject)jDGroup).setMaxValue(1);
        ((JDObject)jDGroup).setInitValue(n2);
        jDGroup.setInteractive(bl);
        jDGroup.setValueChangeMode(0);
        return jDGroup;
    }

    JDObject parseLxCustomShape(double d, double d2) throws IOException {
        Vector vector = new Vector();
        JLXObject jLXObject = new JLXObject("Custom shape");
        jLXObject.parse(this, false);
        jLXObject.correct(d, d2);
        if (this.version.compareTo("1.1.0") >= 0) {
            this.read_int();
            this.read_double();
        }
        int n = this.read_int();
        JLXPath jLXPath = new JLXPath();
        block5: for (int i = 0; i < n; ++i) {
            int n2 = this.read_int();
            if (n2 == 991) {
                this.read_int();
            }
            switch (n2) {
                case 990: {
                    jLXPath.parseCustom(this, jLXObject, vector);
                    continue block5;
                }
                case 991: {
                    jLXPath.parseCustom(this, jLXObject, null);
                    continue block5;
                }
                case 992: {
                    System.out.println("JLXFileLoader.parseLxCustomShape() Not supported custom shape type :" + n2);
                    jLXPath.parseCustom(this, jLXObject, null);
                    continue block5;
                }
                default: {
                    System.out.println("Invalid custom shape type :" + n2);
                }
            }
        }
        if (vector.size() == 1) {
            return (JDObject)vector.get(0);
        }
        return new JDGroup(jLXObject, vector);
    }

    JDObject parseObject(double d, double d2) throws IOException {
        String string = this.read_safe_word();
        if (string.equals("com.loox.jloox.LxRectangle")) {
            return this.parseLxRectangle(d, d2);
        }
        if (string.equals("com.loox.jloox.LxCircle")) {
            return this.parseLxCircle(d, d2);
        }
        if (string.equals("com.loox.jloox.LxLine")) {
            return this.parseLxLine(d, d2);
        }
        if (string.equals("com.loox.jloox.LxPolyline")) {
            return this.parseLxPolyline(d, d2);
        }
        if (string.equals("com.loox.jloox.LxParallelogram")) {
            return this.parseLxParallelogram(d, d2);
        }
        if (string.equals("com.loox.jloox.LxText")) {
            return this.parseLxText(d, d2);
        }
        if (string.equals("com.loox.jloox.LxTextArea")) {
            return this.parseLxTextArea(d, d2);
        }
        if (string.equals("com.loox.jloox.LxGeneralPath")) {
            return this.parseLxGeneralPath(d, d2);
        }
        if (string.equals("com.loox.jloox.LxImage")) {
            return this.parseLxImage(d, d2);
        }
        if (string.equals("com.loox.jloox.LxGroup")) {
            return this.parseLxGroup(d, d2);
        }
        if (string.equals("com.loox.jloox.LxPushButton")) {
            return this.parseLxPushButton(d, d2);
        }
        if (string.equals("com.loox.jloox.LxMultiState")) {
            return this.parseLxMultiState(d, d2);
        }
        if (string.equals("com.loox.jloox.LxCustomShape")) {
            return this.parseLxCustomShape(d, d2);
        }
        if (string.equals("com.loox.jloox.LxToggle")) {
            return this.parseLxToggle(d, d2);
        }
        if (string.startsWith("com")) {
            System.out.println("JLXFileLoader.parseObject() Unknown class found:" + string + " at line " + this.StartLine);
            char c2 = this.CurrentChar;
            this.read_char();
            while (c2 != '\n' || this.CurrentChar != '\n') {
                c2 = this.CurrentChar;
                this.read_char();
                if (this.CurrentChar != '\u0000') continue;
                throw new IOException("Unexpected end of file while trying to trigger to the next LxClass after : " + string);
            }
        }
        return null;
    }

    Vector parseFile() throws IOException {
        Object object;
        int n;
        Vector<JDObject> vector = new Vector<JDObject>();
        this.word = this.read_word(false);
        if (this.word == null) {
            throw new IOException("File empty !");
        }
        if (!this.word.equalsIgnoreCase("JLoox")) {
            throw new IOException("Invalid header !");
        }
        this.version = this.read_safe_word();
        if (this.version.compareTo("1.3.1") >= 0) {
            this.read_safe_word();
        }
        new JLXStyle().parse(this);
        new JLXStyle().parse(this);
        this.read_string();
        this.read_int();
        this.read_int();
        this.read_int();
        this.read_int();
        this.read_safe_word();
        int n2 = this.read_int();
        for (n = 0; n < n2; ++n) {
            this.read_string();
            this.read_int();
        }
        int n3 = this.read_int();
        for (n = 0; n < n3; ++n) {
            object = this.parseObject(0.0, 0.0);
            if (object == null) continue;
            vector.add((JDObject)object);
        }
        this.read_int();
        this.word = this.read_word(false);
        if (this.word != null && this.word.equalsIgnoreCase("\"UserData\"")) {
            for (n = 0; n < n3; ++n) {
                object = this.read_string();
                if (!((String)object).equalsIgnoreCase("ud")) continue;
                this.read_int();
                ((JDObject)vector.get(n)).setExtensionList(extNames);
                ((JDObject)vector.get(n)).setExtendedParam(0, this.read_string());
                ((JDObject)vector.get(n)).setExtendedParam(1, this.read_string());
            }
        }
        return vector;
    }

    public static void main(String[] stringArray) {
        try {
            FileReader fileReader = new FileReader(stringArray[0]);
            JLXFileLoader jLXFileLoader = new JLXFileLoader(fileReader);
            jLXFileLoader.parseFile();
            fileReader.close();
        }
        catch (IOException iOException) {
            System.out.println("Reading of " + stringArray[0] + " failed " + iOException.getMessage());
        }
        System.exit(0);
    }
}

