/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.chart;

import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.JTableRow;
import fr.esrf.tangoatk.widget.util.MultiExtFileFilter;
import fr.esrf.tangoatk.widget.util.chart.CfFileReader;
import fr.esrf.tangoatk.widget.util.chart.DataList;
import fr.esrf.tangoatk.widget.util.chart.IJLChartActionListener;
import fr.esrf.tangoatk.widget.util.chart.IJLChartListener;
import fr.esrf.tangoatk.widget.util.chart.JLAxis;
import fr.esrf.tangoatk.widget.util.chart.JLChartActionEvent;
import fr.esrf.tangoatk.widget.util.chart.JLChartEvent;
import fr.esrf.tangoatk.widget.util.chart.JLChartOption;
import fr.esrf.tangoatk.widget.util.chart.JLDataView;
import fr.esrf.tangoatk.widget.util.chart.JLDataViewOption;
import fr.esrf.tangoatk.widget.util.chart.JLTable;
import fr.esrf.tangoatk.widget.util.chart.LabelRect;
import fr.esrf.tangoatk.widget.util.chart.OFormat;
import fr.esrf.tangoatk.widget.util.chart.SearchInfo;
import fr.esrf.tangoatk.widget.util.chart.TabbedLine;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.event.EventListenerList;
import javax.swing.filechooser.FileFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JLChart
extends JComponent
implements MouseListener,
MouseMotionListener,
ActionListener {
    public static final int LABEL_DOWN = 0;
    public static final int LABEL_UP = 1;
    public static final int LABEL_RIGHT = 2;
    public static final int LABEL_LEFT = 3;
    public static final int LABEL_ROW = 4;
    public static final int MENU_CHARTPROP = 0;
    public static final int MENU_DVPROP = 1;
    public static final int MENU_TABLE = 2;
    public static final int MENU_DATASAVE = 3;
    public static final int MENU_PRINT = 4;
    public static final int MENU_STAT = 5;
    public static final String US_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss.SSS";
    public static final String FR_DATE_FORMAT = "dd-MM-yyyy HH:mm:ss.SSS";
    private String header = null;
    private boolean headerVisible = false;
    private Font headerFont;
    private Color headerColor;
    private boolean labelVisible = true;
    private int labelMode = 4;
    private Font labelFont;
    protected Vector<LabelRect> labelRect;
    private boolean ipanelVisible = false;
    private boolean paintAxisFirst = true;
    private Color chartBackground;
    private double displayDuration;
    protected double maxDisplayDuration;
    protected JPopupMenu chartMenu;
    private JMenuItem optionMenuItem;
    private JMenuItem saveFileMenuItem;
    private JMenuItem zoomBackMenuItem;
    private JMenuItem printMenuItem;
    private JSeparator sepMenuItem;
    private JMenu tableMenu;
    private JMenuItem tableAllMenuItem;
    private JMenuItem[] tableSingleY1MenuItem = new JMenuItem[0];
    private JMenuItem[] tableSingleY2MenuItem = new JMenuItem[0];
    private JMenu dvMenu;
    private JMenuItem[] dvY1MenuItem = new JMenuItem[0];
    private JMenuItem[] dvY2MenuItem = new JMenuItem[0];
    private JMenu statMenu;
    private JMenuItem statAllMenuItem;
    private JMenuItem[] statSingleY1MenuItem = new JMenuItem[0];
    private JMenuItem[] statSingleY2MenuItem = new JMenuItem[0];
    private JMenuItem[] userActionMenuItem;
    private String[] userAction;
    private boolean zoomDrag;
    private boolean zoomDragAllowed;
    private int zoomX;
    private int zoomY;
    private JButton zoomButton;
    private int lastX;
    private int lastY;
    private SearchInfo lastSearch;
    private Rectangle headerR;
    private Rectangle labelR;
    private Rectangle viewR;
    private Dimension margin;
    private int labelHeight;
    private int labelWidth;
    private int labelPerLine;
    private int nbLabel;
    private int headerWidth;
    private int axisHeight;
    private int axisWidth;
    private int y1AxisThickness;
    private int y2AxisThickness;
    private int xAxisThickness;
    private int xAxisUpMargin;
    private JLAxis xAxis;
    private JLAxis y1Axis;
    private JLAxis y2Axis;
    private IJLChartListener listener;
    private JLTable theTable = null;
    private int timePrecision = 0;
    private JMenuItem precisionMenuItem;
    private JMenuItem saveSnapshotMenuItem;
    protected boolean preferDialog = false;
    protected boolean modalDialog = false;
    protected JDialog tableDialog = null;
    protected Window dialogParent;
    protected JFrame parentFrame = null;
    protected String lastSnapshotLocation = ".";
    protected String lastDataFileLocation = ".";
    protected FileFilter lastFileFilter = null;
    protected String noValueString = "";

    public JLChart() {
        Color color = Color.WHITE;
        this.setBackground(color);
        this.setChartBackground(color);
        this.setForeground(Color.black);
        this.setOpaque(true);
        this.setFont(new Font("Dialog", 0, 12));
        this.headerFont = this.getFont();
        this.headerColor = this.getForeground();
        this.labelFont = this.getFont();
        this.margin = new Dimension(5, 5);
        this.headerR = new Rectangle(0, 0, 0, 0);
        this.viewR = new Rectangle(0, 0, 0, 0);
        this.labelR = new Rectangle(0, 0, 0, 0);
        this.xAxis = new JLAxis(this, 1);
        this.xAxis.setAnnotation(1);
        this.xAxis.setAutoScale(true);
        this.xAxis.setAxeName("(X)");
        this.y1Axis = new JLAxis(this, 6);
        this.y1Axis.setAxeName("(Y1)");
        this.y2Axis = new JLAxis(this, 5);
        this.y2Axis.setAxeName("(Y2)");
        this.displayDuration = Double.POSITIVE_INFINITY;
        this.maxDisplayDuration = Double.POSITIVE_INFINITY;
        this.labelRect = new Vector();
        this.zoomDrag = false;
        this.zoomDragAllowed = false;
        this.chartMenu = new JPopupMenu();
        this.optionMenuItem = new JMenuItem("Chart properties");
        this.optionMenuItem.addActionListener(this);
        this.saveFileMenuItem = new JMenuItem("Save data File");
        this.saveFileMenuItem.addActionListener(this);
        this.tableMenu = new JMenu("Show table");
        this.tableAllMenuItem = new JMenuItem("All");
        this.tableAllMenuItem.addActionListener(this);
        this.zoomBackMenuItem = new JMenuItem("Zoom back");
        this.zoomBackMenuItem.addActionListener(this);
        this.printMenuItem = new JMenuItem("Print Chart");
        this.printMenuItem.addActionListener(this);
        this.precisionMenuItem = new JMenuItem("Abscisse error margin");
        this.precisionMenuItem.addActionListener(this);
        this.saveSnapshotMenuItem = new JMenuItem("Save a snapshot of this chart");
        this.saveSnapshotMenuItem.addActionListener(this);
        this.dvMenu = new JMenu("Data View properties");
        this.statMenu = new JMenu("Show statistics");
        this.statAllMenuItem = new JMenuItem("All");
        this.statAllMenuItem.addActionListener(this);
        this.chartMenu.add(this.zoomBackMenuItem);
        this.chartMenu.add(new JSeparator());
        this.chartMenu.add(this.optionMenuItem);
        this.chartMenu.add(this.dvMenu);
        this.chartMenu.add(this.tableMenu);
        this.chartMenu.add(this.statMenu);
        this.chartMenu.add(new JSeparator());
        this.chartMenu.add(this.saveFileMenuItem);
        this.chartMenu.add(this.printMenuItem);
        this.chartMenu.add(this.saveSnapshotMenuItem);
        this.chartMenu.add(this.precisionMenuItem);
        this.sepMenuItem = new JSeparator();
        this.chartMenu.add(this.sepMenuItem);
        this.userActionMenuItem = new JMenuItem[0];
        this.userAction = new String[0];
        this.sepMenuItem.setVisible(false);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.listener = null;
        this.listenerList = new EventListenerList();
        this.zoomButton = new JButton("Zoom back");
        this.zoomButton.setFont(this.labelFont);
        this.zoomButton.setMargin(new Insets(2, 2, 1, 1));
        this.zoomButton.setVisible(false);
        this.zoomButton.addActionListener(this);
        this.add(this.zoomButton);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void saveSnapshot() {
        Object object;
        int n;
        this.chartMenu.setVisible(false);
        int n2 = 0;
        FileFilter fileFilter = new FileFilter(){

            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                String string = MultiExtFileFilter.getExtension(file);
                return string != null && string.equals("jpg");
            }

            public String getDescription() {
                return "jpg - JPEG pictures";
            }

            public boolean equals(Object object) {
                if (object == null) {
                    return false;
                }
                if (object instanceof FileFilter) {
                    return this.getDescription().equals(((FileFilter)object).getDescription());
                }
                return false;
            }
        };
        FileFilter fileFilter2 = new FileFilter(){

            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                String string = MultiExtFileFilter.getExtension(file);
                return string != null && string.equals("png");
            }

            public String getDescription() {
                return "png - PNG pictures";
            }

            public boolean equals(Object object) {
                if (object == null) {
                    return false;
                }
                if (object instanceof FileFilter) {
                    return this.getDescription().equals(((FileFilter)object).getDescription());
                }
                return false;
            }
        };
        FileFilter[] fileFilterArray = new FileFilter[]{fileFilter, fileFilter2};
        JFileChooser jFileChooser = new JFileChooser(this.lastSnapshotLocation);
        for (n = 0; n < fileFilterArray.length; ++n) {
            if (fileFilterArray[n].equals(this.lastFileFilter)) continue;
            jFileChooser.addChoosableFileFilter(fileFilterArray[n]);
        }
        if (this.lastFileFilter != null) {
            jFileChooser.addChoosableFileFilter(this.lastFileFilter);
        }
        jFileChooser.setDialogTitle("Save snapshot");
        n = jFileChooser.showSaveDialog(this);
        String string = "";
        File file = null;
        if (n != 0) return;
        file = jFileChooser.getSelectedFile();
        if (file != null) {
            this.lastSnapshotLocation = file.getParentFile().getAbsolutePath();
            object = jFileChooser.getFileFilter();
            if (object == fileFilter) {
                if (MultiExtFileFilter.getExtension(file) == null || !MultiExtFileFilter.getExtension(file).equalsIgnoreCase("jpg")) {
                    file = new File(file.getAbsolutePath() + ".jpg");
                }
                this.lastFileFilter = object;
            } else if (object == fileFilter2) {
                if (MultiExtFileFilter.getExtension(file) == null || !MultiExtFileFilter.getExtension(file).equalsIgnoreCase("png")) {
                    file = new File(file.getAbsolutePath() + ".png");
                }
                this.lastFileFilter = object;
            }
            if (file.exists()) {
                n2 = JOptionPane.showConfirmDialog(this, "Do you want to overwrite " + file.getName() + " ?", "Confirm overwrite", 0);
            }
            if (n2 != 0) return;
            this.repaint();
            if (MultiExtFileFilter.getExtension(file) == null) {
                JOptionPane.showMessageDialog(this, "Unknown file type", "Error", 0);
            } else {
                string = MultiExtFileFilter.getExtension(file).equalsIgnoreCase("jpg") ? "jpg" : (MultiExtFileFilter.getExtension(file).equalsIgnoreCase("png") ? "png" : "");
            }
        }
        if (!"".equals(string.trim())) {
            this.revalidate();
            this.repaint();
            object = new BufferedImage(this.getWidth(), this.getHeight(), 1);
            this.paint(((BufferedImage)object).getGraphics());
            try {
                ImageIO.write((RenderedImage)object, string, file);
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(this, "File could not be saved", "Error", 0);
            }
            ((Image)object).flush();
        } else {
            JOptionPane.showMessageDialog(this, "Unknown file type", "Error", 0);
        }
        fileFilter = null;
        fileFilter2 = null;
        for (int i = 0; i < fileFilterArray.length; ++i) {
            fileFilterArray[i] = null;
        }
    }

    public JLAxis getXAxis() {
        return this.xAxis;
    }

    public JLAxis getY1Axis() {
        return this.y1Axis;
    }

    public JLAxis getY2Axis() {
        return this.y2Axis;
    }

    public void setXAxisOnBottom(boolean bl) {
        if (bl) {
            this.getXAxis().setPosition(1);
        } else {
            this.getXAxis().setPosition(3);
        }
    }

    public boolean isXAxisOnBottom() {
        return this.getXAxis().getPosition() == 1;
    }

    public void setHeaderFont(Font font) {
        this.headerFont = font;
    }

    public Font getHeaderFont() {
        return this.headerFont;
    }

    public void setMargin(Dimension dimension) {
        this.margin = dimension;
    }

    public Dimension getMargin() {
        return this.margin;
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
    }

    public void setChartBackground(Color color) {
        this.chartBackground = color;
    }

    public Color getChartBackground() {
        return this.chartBackground;
    }

    public void setPaintAxisFirst(boolean bl) {
        this.paintAxisFirst = bl;
    }

    public boolean isPaintAxisFirst() {
        return this.paintAxisFirst;
    }

    public void setHeaderVisible(boolean bl) {
        this.headerVisible = bl;
    }

    public void setHeader(String string) {
        this.header = string;
        if (string != null && string.length() == 0) {
            this.header = null;
        }
        this.setHeaderVisible(this.header != null);
        if (this.parentFrame != null && this.header != null) {
            this.parentFrame.setTitle(this.header);
        }
    }

    public String getHeader() {
        return this.header;
    }

    public void setFrameParent(JFrame jFrame) {
        this.parentFrame = jFrame;
    }

    public void setDisplayDuration(double d) {
        if (d <= this.maxDisplayDuration) {
            this.displayDuration = d;
            this.getXAxis().setAxisDuration(d);
        } else {
            StringBuffer stringBuffer = new StringBuffer("Duration refused : can not be greater than ");
            if (1 == this.getXAxis().getAnnotation() || 2 == this.getXAxis().getLabelFormat()) {
                String string;
                int n = 86400000;
                int n2 = 3600000;
                int n3 = 60000;
                int n4 = 1000;
                double d2 = this.maxDisplayDuration;
                double d3 = d2 / (double)n;
                double d4 = (d2 -= d3 * (double)n) / (double)n2;
                double d5 = (d2 -= d4 * (double)n2) / (double)n3;
                double d6 = (d2 -= d5 * (double)n3) / (double)n4;
                double d7 = d2 -= d6 * (double)n4;
                if (d3 > 0.0) {
                    string = Double.toString(d3);
                    if (string.endsWith(".0")) {
                        string = string.substring(0, string.indexOf("."));
                    }
                    stringBuffer.append(string).append("day(s) ");
                    string = null;
                }
                if (d4 > 0.0) {
                    string = Double.toString(d4);
                    if (string.endsWith(".0")) {
                        string = string.substring(0, string.indexOf("."));
                    }
                    stringBuffer.append(d4).append("hr ");
                    string = null;
                }
                if (d5 > 0.0) {
                    string = Double.toString(d5);
                    if (string.endsWith(".0")) {
                        string = string.substring(0, string.indexOf("."));
                    }
                    stringBuffer.append(string).append("mn ");
                    string = null;
                }
                if (d6 > 0.0) {
                    string = Double.toString(d6);
                    if (string.endsWith(".0")) {
                        string = string.substring(0, string.indexOf("."));
                    }
                    stringBuffer.append(string).append("s ");
                    string = null;
                }
                if (d7 > 0.0) {
                    string = Double.toString(d7);
                    if (string.endsWith(".0")) {
                        string = string.substring(0, string.indexOf("."));
                    }
                    stringBuffer.append(string).append("ms ");
                    string = null;
                } else if (d3 == 0.0 && d4 == 0.0 && d5 == 0.0 && d6 == 0.0 && d7 == 0.0) {
                    string = Double.toString(d7);
                    if (string.endsWith(".0")) {
                        string = string.substring(0, string.indexOf("."));
                    }
                    stringBuffer.append(string).append("ms ");
                    string = null;
                }
            } else {
                String string = Double.toString(this.maxDisplayDuration);
                if (string.endsWith(".0")) {
                    string = string.substring(0, string.indexOf("."));
                }
                stringBuffer.append(string);
                string = null;
            }
            JOptionPane.showMessageDialog(this, stringBuffer.toString(), "Warning !", 2);
            stringBuffer = null;
        }
    }

    public double getDisplayDuration() {
        return this.displayDuration;
    }

    public double getMaxDisplayDuration() {
        return this.maxDisplayDuration;
    }

    public void setMaxDisplayDuration(double d) {
        this.maxDisplayDuration = d;
    }

    public void setHeaderColor(Color color) {
        this.headerColor = color;
        this.setHeaderVisible(true);
    }

    public void setLabelVisible(boolean bl) {
        this.labelVisible = bl;
    }

    public boolean isLabelVisible() {
        return this.labelVisible;
    }

    public void setLabelPlacement(int n) {
        this.labelMode = n;
    }

    public int getLabelPlacement() {
        return this.labelMode;
    }

    public void setLabelFont(Font font) {
        this.labelFont = font;
    }

    public Font getLabelFont() {
        return this.labelFont;
    }

    public void showOptionDialog() {
        Container container = this.getRootPane().getParent();
        JLChartOption jLChartOption = container instanceof JDialog ? new JLChartOption((JDialog)container, this) : (container instanceof JFrame ? new JLChartOption((JFrame)container, this) : new JLChartOption((JFrame)null, this));
        ATKGraphicsUtils.centerDialog(jLChartOption);
        jLChartOption.setVisible(true);
    }

    public void showDataOptionDialog(JLDataView jLDataView) {
        Container container = this.getRootPane().getParent();
        JLDataViewOption jLDataViewOption = container instanceof JDialog ? new JLDataViewOption((JDialog)container, this, jLDataView) : (container instanceof JFrame ? new JLDataViewOption((JFrame)container, this, jLDataView) : new JLDataViewOption((JFrame)null, this, jLDataView));
        ATKGraphicsUtils.centerDialog(jLDataViewOption);
        jLDataViewOption.setVisible(true);
    }

    public boolean isZoomed() {
        return this.xAxis.isZoomed() || this.y1Axis.isZoomed() || this.y2Axis.isZoomed();
    }

    public void enterZoom() {
        if (!this.zoomDragAllowed) {
            this.zoomDragAllowed = true;
            this.setCursor(new Cursor(1));
        }
    }

    public void setJLChartListener(IJLChartListener iJLChartListener) {
        this.listener = iJLChartListener;
    }

    public void addUserAction(String string) {
        int n;
        String[] stringArray = new String[this.userAction.length + 1];
        for (n = 0; n < this.userAction.length; ++n) {
            stringArray[n] = this.userAction[n];
        }
        stringArray[n] = string;
        for (n = 0; n < this.userActionMenuItem.length; ++n) {
            this.chartMenu.remove(this.userActionMenuItem[n]);
            this.userActionMenuItem[n].removeActionListener(this);
            this.userActionMenuItem[n] = null;
        }
        JMenuItem[] jMenuItemArray = new JMenuItem[stringArray.length];
        for (n = 0; n < stringArray.length; ++n) {
            jMenuItemArray[n] = stringArray[n].startsWith("chk") ? new JCheckBoxMenuItem(stringArray[n].substring(3)) : new JMenuItem(stringArray[n]);
            jMenuItemArray[n].addActionListener(this);
            this.chartMenu.add(jMenuItemArray[n]);
        }
        this.userActionMenuItem = jMenuItemArray;
        this.userAction = stringArray;
        this.sepMenuItem.setVisible(true);
    }

    public void removeUserAction(String string) {
        int n;
        int n2 = -1;
        for (n = 0; n < this.userAction.length; ++n) {
            if (!this.userAction[n].equals(string)) continue;
            n2 = n;
            break;
        }
        if (n2 != -1) {
            String[] stringArray = new String[this.userAction.length - 1];
            for (n = 0; n < n2; ++n) {
                stringArray[n] = this.userAction[n];
            }
            for (n = n2 + 1; n < this.userAction.length; ++n) {
                stringArray[n - 1] = this.userAction[n];
            }
            for (n = 0; n < this.userActionMenuItem.length; ++n) {
                this.chartMenu.remove(this.userActionMenuItem[n]);
                this.userActionMenuItem[n].removeActionListener(this);
                this.userActionMenuItem[n] = null;
            }
            JMenuItem[] jMenuItemArray = new JMenuItem[stringArray.length];
            for (n = 0; n < stringArray.length; ++n) {
                jMenuItemArray[n] = stringArray[n].startsWith("chk") ? new JCheckBoxMenuItem(stringArray[n].substring(3)) : new JMenuItem(stringArray[n]);
                jMenuItemArray[n].addActionListener(this);
                this.chartMenu.add(jMenuItemArray[n]);
            }
            this.userActionMenuItem = jMenuItemArray;
            this.userAction = stringArray;
            this.sepMenuItem.setVisible(true);
        }
    }

    public void addJLChartActionListener(IJLChartActionListener iJLChartActionListener) {
        this.listenerList.add(IJLChartActionListener.class, iJLChartActionListener);
    }

    public void exitZoom() {
        this.xAxis.unzoom();
        this.y1Axis.unzoom();
        this.y2Axis.unzoom();
        this.zoomDragAllowed = false;
        this.setCursor(Cursor.getDefaultCursor());
        this.repaint();
    }

    public void removeMenuItem(int n) {
        switch (n) {
            case 0: {
                this.chartMenu.remove(this.optionMenuItem);
                break;
            }
            case 1: {
                this.chartMenu.remove(this.dvMenu);
                break;
            }
            case 2: {
                this.chartMenu.remove(this.tableMenu);
                break;
            }
            case 3: {
                this.chartMenu.remove(this.saveFileMenuItem);
                break;
            }
            case 4: {
                this.chartMenu.remove(this.printMenuItem);
                break;
            }
            case 5: {
                this.chartMenu.remove(this.statMenu);
            }
        }
    }

    public void addMenuItem(JMenuItem jMenuItem) {
        this.chartMenu.add(jMenuItem);
    }

    public void addSeparator() {
        this.chartMenu.addSeparator();
    }

    public void removeJLChartActionListener(IJLChartActionListener iJLChartActionListener) {
        this.listenerList.remove(IJLChartActionListener.class, iJLChartActionListener);
    }

    public void applyConfiguration(CfFileReader cfFileReader) {
        Vector<String> vector = cfFileReader.getParam("graph_title");
        if (vector != null) {
            this.setHeader(OFormat.getName(vector.get(0).toString()));
        }
        if ((vector = cfFileReader.getParam("label_visible")) != null) {
            this.setLabelVisible(OFormat.getBoolean(vector.get(0).toString()));
        }
        if ((vector = cfFileReader.getParam("label_placement")) != null) {
            this.setLabelPlacement(OFormat.getInt(vector.get(0).toString()));
        }
        if ((vector = cfFileReader.getParam("label_font")) != null) {
            this.setLabelFont(OFormat.getFont(vector));
        }
        if ((vector = cfFileReader.getParam("graph_background")) != null) {
            this.setBackground(OFormat.getColor(vector));
        }
        if ((vector = cfFileReader.getParam("chart_background")) != null) {
            this.setChartBackground(OFormat.getColor(vector));
        }
        if ((vector = cfFileReader.getParam("title_font")) != null) {
            this.setHeaderFont(OFormat.getFont(vector));
        }
        if ((vector = cfFileReader.getParam("display_duration")) != null) {
            this.setDisplayDuration(OFormat.getDouble(vector.get(0).toString()));
        }
        if ((vector = cfFileReader.getParam("precision")) != null) {
            this.setTimePrecision(OFormat.getInt(vector.get(0).toString()));
        }
    }

    public String getConfiguration() {
        String string = "";
        string = string + "graph_title:'" + this.getHeader() + "'\n";
        string = string + "label_visible:" + this.isLabelVisible() + "\n";
        string = string + "label_placement:" + this.getLabelPlacement() + "\n";
        string = string + "label_font:" + OFormat.font(this.getLabelFont()) + "\n";
        string = string + "graph_background:" + OFormat.color(this.getBackground()) + "\n";
        string = string + "chart_background:" + OFormat.color(this.getChartBackground()) + "\n";
        string = string + "title_font:" + OFormat.font(this.getHeaderFont()) + "\n";
        string = string + "display_duration:" + this.getDisplayDuration() + "\n";
        string = string + "precision:" + this.getTimePrecision() + "\n";
        return string;
    }

    public String getHelpString() {
        return "-- Global chart settings --\n\ngraph_title:'title'   Chart title ('null' to disable)\nlabel_visible:true or false  Show legend\nlabel_placement:value   (0 Down,1 Up,2 Right, 3 Left)\nlabel_font:name,style(0 Plain,1 Bold,2 italic),size \ngraph_background:r,g,b   Component background \nchart_background:r,g,b   Graph area background \ntitle_font:name,style(0 Plain,1 Bold,2 italic),size\ndisplay_duration:milliSec   X axis duration (time monitoring)\n\n" + JLAxis.getHelpString() + "\n" + JLDataView.getHelpString();
    }

    public void unselectAll() {
        this.getY1Axis().clearDataView();
        this.getY2Axis().clearDataView();
        this.getXAxis().clearDataView();
    }

    public void printGraph() {
        ATKGraphicsUtils.printComponent(this, "Print Graph", true, 0);
    }

    private void fireActionPerfromed(String string, boolean bl) {
        IJLChartActionListener[] iJLChartActionListenerArray = (IJLChartActionListener[])this.listenerList.getListeners(IJLChartActionListener.class);
        JLChartActionEvent jLChartActionEvent = new JLChartActionEvent(this, string, bl);
        for (int i = 0; i < iJLChartActionListenerArray.length; ++i) {
            iJLChartActionListenerArray[i].actionPerformed(jLChartActionEvent);
        }
    }

    private boolean fireGetActionState(String string) {
        IJLChartActionListener[] iJLChartActionListenerArray = (IJLChartActionListener[])this.listenerList.getListeners(IJLChartActionListener.class);
        JLChartActionEvent jLChartActionEvent = new JLChartActionEvent(this, string);
        boolean bl = true;
        for (int i = 0; i < iJLChartActionListenerArray.length; ++i) {
            bl = iJLChartActionListenerArray[i].getActionState(jLChartActionEvent) && bl;
        }
        return bl;
    }

    private void saveDataFile(String string) {
        try {
            FileWriter fileWriter = new FileWriter(string);
            Vector<JLDataView> vector = new Vector<JLDataView>();
            if (this.xAxis.isXY()) {
                vector.addAll(this.xAxis.getViews());
            }
            vector.addAll(this.y1Axis.getViews());
            vector.addAll(this.y2Axis.getViews());
            TabbedLine tabbedLine = new TabbedLine(vector.size());
            tabbedLine.setPrecision(this.timePrecision);
            tabbedLine.setNoValueString(this.noValueString);
            for (int i = 0; i < vector.size(); ++i) {
                tabbedLine.add(i, (JLDataView)vector.get(i));
            }
            String string2 = tabbedLine.getFirstLine(this.xAxis.getAnnotation());
            while (string2 != null) {
                fileWriter.write(string2);
                string2 = tabbedLine.getNextLine();
            }
            fileWriter.close();
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, "Error during saving file.\n" + exception.getMessage());
        }
    }

    public void loadDataFile(String string) {
        try {
            File file = new File(string);
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            String string2 = "";
            string2 = bufferedReader.readLine();
            if ("".equals(string2.trim())) {
                throw new Exception();
            }
            String[] stringArray = string2.split("\t");
            int n = -1;
            if ("Time (s)".equals(stringArray[0].trim())) {
                n = 1;
            } else if ("Index".equals(stringArray[0].trim())) {
                n = 2;
            } else {
                bufferedReader.close();
                bufferedReader = null;
                file = null;
                string2 = null;
                stringArray = null;
                throw new Exception("Failed to read X Axis annotation type");
            }
            Vector<JLDataView> vector = new Vector<JLDataView>();
            if (this.xAxis.isXY()) {
                vector.addAll(this.xAxis.getViews());
            }
            vector.addAll(this.y1Axis.getViews());
            vector.addAll(this.y2Axis.getViews());
            if (vector.size() != 0 && n != this.getXAxis().getAnnotation()) {
                vector.clear();
                vector = null;
                String string3 = "Loading this file will change X Axis annotation type.\nYour component may not work any more.\nAre you sure to load this file ?";
                int n2 = JOptionPane.showConfirmDialog(this, string3, "Risk of breaking component", 2);
                if (n2 != 0) {
                    bufferedReader.close();
                    bufferedReader = null;
                    file = null;
                    string2 = null;
                    stringArray = null;
                    return;
                }
            }
            this.lastDataFileLocation = file.getParentFile().getAbsolutePath();
            int n3 = stringArray.length - 1;
            if (n3 < 0) {
                throw new Exception();
            }
            JLDataView[] jLDataViewArray = new JLDataView[n3];
            Color[] colorArray = new Color[]{Color.red, Color.blue, Color.cyan, Color.green, Color.magenta, Color.orange, Color.pink, Color.yellow, Color.black};
            for (int i = 0; i < jLDataViewArray.length; ++i) {
                jLDataViewArray[i] = new JLDataView();
                jLDataViewArray[i].setName(stringArray[i + 1].trim());
                jLDataViewArray[i].setLineWidth(1);
                jLDataViewArray[i].setColor(colorArray[i % colorArray.length]);
                jLDataViewArray[i].setStyle(0);
                jLDataViewArray[i].setViewType(0);
                jLDataViewArray[i].setMarkerSize(5);
                jLDataViewArray[i].setMarker(2);
                jLDataViewArray[i].setMarkerColor(jLDataViewArray[i].getColor());
            }
            double d = 0.0;
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(FR_DATE_FORMAT);
            SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat(US_DATE_FORMAT);
            while ((string2 = bufferedReader.readLine()) != null) {
                block26: {
                    stringArray = string2.split("\t");
                    if (stringArray.length - 1 != n3) {
                        throw new Exception();
                    }
                    if (n == 1) {
                        try {
                            d = Double.parseDouble(stringArray[0]) * 1000.0;
                        }
                        catch (NumberFormatException numberFormatException) {
                            if (stringArray[0].indexOf(".") == -1) {
                                stringArray[0] = stringArray[0] + ".000";
                            }
                            if (stringArray[0].indexOf("-") != 4) {
                                simpleDateFormat.parse(stringArray[0]);
                                d = simpleDateFormat.getCalendar().getTimeInMillis();
                                break block26;
                            }
                            simpleDateFormat2.parse(stringArray[0]);
                            d = simpleDateFormat2.getCalendar().getTimeInMillis();
                        }
                    } else {
                        try {
                            d = Double.parseDouble(stringArray[0]);
                        }
                        catch (NumberFormatException numberFormatException) {
                            continue;
                        }
                    }
                }
                for (int i = 0; i < jLDataViewArray.length; ++i) {
                    try {
                        jLDataViewArray[i].add(d, Double.parseDouble(stringArray[i + 1]));
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        if (!"null".equalsIgnoreCase(stringArray[i + 1].trim())) continue;
                        jLDataViewArray[i].add(d, JLDataView.NAN_FOR_NULL);
                    }
                }
            }
            bufferedReader.close();
            bufferedReader = null;
            file = null;
            string2 = null;
            stringArray = null;
            simpleDateFormat = null;
            simpleDateFormat2 = null;
            for (int i = 0; i < jLDataViewArray.length; ++i) {
                this.getY1Axis().addDataView(jLDataViewArray[i]);
            }
            this.getXAxis().setAnnotation(n);
            this.repaint();
            colorArray = null;
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, "Failed to load file: " + string, "Error", 0);
        }
    }

    public void refreshTableSingle(JLDataView jLDataView) {
        if (this.preferDialog) {
            if (this.tableDialog == null) {
                return;
            }
            if (!this.tableDialog.isVisible()) {
                return;
            }
        } else {
            if (this.theTable == null) {
                return;
            }
            if (!this.theTable.isVisible()) {
                return;
            }
        }
        this.updateTableDataSingle(jLDataView);
    }

    private void updateTableDataSingle(JLDataView jLDataView) {
        TabbedLine tabbedLine = new TabbedLine(1);
        tabbedLine.add(0, jLDataView);
        Vector<String[]> vector = new Vector<String[]>();
        String[] stringArray = tabbedLine.getFirstFields(this.xAxis.getAnnotation(), !this.xAxis.isXY());
        String[] stringArray2 = tabbedLine.getNextFields();
        while (stringArray2 != null) {
            vector.add(stringArray2);
            stringArray2 = tabbedLine.getNextFields();
        }
        int n = vector.size();
        int n2 = stringArray.length;
        Object[][] objectArray = new Object[n][n2];
        for (int i = 0; i < n; ++i) {
            Object[] objectArray2 = (Object[])vector.get(i);
            for (int j = 0; j < n2; ++j) {
                objectArray[i][j] = objectArray2[j];
            }
        }
        if (this.preferDialog && this.tableDialog != null) {
            JTableRow jTableRow = null;
            try {
                jTableRow = (JTableRow)this.tableDialog.getContentPane();
            }
            catch (ClassCastException classCastException) {
                if (this.theTable != null) {
                    jTableRow = (JTableRow)this.theTable.getContentPane();
                }
                return;
            }
            jTableRow.setData(objectArray, stringArray);
            jTableRow = null;
        } else {
            this.theTable.setData(objectArray, stringArray);
        }
    }

    private void showTableSingle(JLDataView jLDataView) {
        if (this.theTable == null) {
            this.theTable = new JLTable();
        }
        if (this.tableDialog == null) {
            this.tableDialog = this.dialogParent != null ? (this.dialogParent instanceof Frame ? new JDialog((Frame)this.dialogParent, this.theTable.getTitle(), this.modalDialog) : (this.dialogParent instanceof Dialog ? new JDialog((Dialog)this.dialogParent, this.theTable.getTitle(), this.modalDialog) : new JDialog((Frame)null, this.theTable.getTitle(), this.modalDialog))) : new JDialog((Frame)null, this.theTable.getTitle(), this.modalDialog);
        }
        this.updateTableDataSingle(jLDataView);
        if (this.tableDialog != null && this.tableDialog.getContentPane() instanceof JTableRow) {
            this.theTable.setContentPane(this.tableDialog.getContentPane());
        }
        if (!this.theTable.isVisible()) {
            this.theTable.centerWindow();
        }
        if (this.preferDialog) {
            this.tableDialog.setContentPane(this.theTable.getContentPane());
            this.tableDialog.setBounds(this.theTable.getBounds());
            this.tableDialog.setResizable(this.theTable.isResizable());
            this.theTable.setVisible(false);
            this.theTable = null;
            this.tableDialog.setVisible(true);
        } else {
            this.tableDialog.setVisible(false);
            this.tableDialog = null;
            this.theTable.setVisible(true);
        }
        if (this.preferDialog) {
            this.tableDialog.repaint();
        } else {
            this.theTable.repaint();
        }
    }

    private void displayPrecisionDialog() {
        final JDialog jDialog = new JDialog((Frame)null, "Set error margin", true);
        JLabel jLabel = new JLabel("Set error margin in x units.");
        JLabel jLabel2 = new JLabel("If x represents time, unit is ms.");
        final char[] cArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '\b', '\u007f', '%', '\'', '\u00e2', '\u00e3', '\n', '\t', '\u0010'};
        JTextField jTextField = new JTextField();
        jTextField.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent keyEvent) {
                if (!this.validateChar(keyEvent.getKeyChar())) {
                    keyEvent.consume();
                }
            }

            public void keyReleased(KeyEvent keyEvent) {
                if (!this.validateChar(keyEvent.getKeyChar())) {
                    keyEvent.consume();
                }
            }

            public void keyTyped(KeyEvent keyEvent) {
                if (!this.validateChar(keyEvent.getKeyChar())) {
                    keyEvent.consume();
                }
            }

            private boolean validateChar(char c2) {
                for (int i = 0; i < cArray.length; ++i) {
                    if (c2 != cArray[i]) continue;
                    return true;
                }
                return false;
            }
        });
        jTextField.setColumns(5);
        jTextField.setText("" + this.timePrecision);
        JButton jButton = new JButton("ok");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                jDialog.setVisible(false);
            }
        });
        JPanel jPanel = new JPanel();
        Box box = new Box(1);
        box.add(jLabel);
        box.add(jTextField);
        box.add(jLabel2);
        box.add(jButton);
        jPanel.add(box);
        jDialog.setContentPane(jPanel);
        jDialog.setSize(230, 120);
        jDialog.setResizable(false);
        jDialog.setVisible(true);
        int n = this.timePrecision;
        try {
            this.timePrecision = Integer.parseInt(jTextField.getText());
        }
        catch (Exception exception) {
            this.timePrecision = n;
        }
    }

    protected void showTableAll(Vector<JLDataView> vector) {
        TabbedLine tabbedLine = new TabbedLine(vector.size());
        tabbedLine.setPrecision(this.timePrecision);
        for (int i = 0; i < vector.size(); ++i) {
            tabbedLine.add(i, vector.get(i));
        }
        if (this.theTable == null) {
            this.theTable = new JLTable();
        }
        if (this.tableDialog == null) {
            this.tableDialog = this.dialogParent != null ? (this.dialogParent instanceof Frame ? new JDialog((Frame)this.dialogParent, this.theTable.getTitle(), this.modalDialog) : (this.dialogParent instanceof Dialog ? new JDialog((Dialog)this.dialogParent, this.theTable.getTitle(), this.modalDialog) : new JDialog((Frame)null, this.theTable.getTitle(), this.modalDialog))) : new JDialog((Frame)null, this.theTable.getTitle(), this.modalDialog);
        }
        Vector<String[]> vector2 = new Vector<String[]>();
        String[] stringArray = tabbedLine.getFirstFields(this.xAxis.getAnnotation(), !this.xAxis.isXY());
        String[] stringArray2 = tabbedLine.getNextFields();
        while (stringArray2 != null) {
            vector2.add(stringArray2);
            stringArray2 = tabbedLine.getNextFields();
        }
        int n = vector2.size();
        int n2 = stringArray.length;
        Object[][] objectArray = new Object[n][n2];
        for (int i = 0; i < n; ++i) {
            Object[] objectArray2 = (Object[])vector2.get(i);
            for (int j = 0; j < n2; ++j) {
                objectArray[i][j] = objectArray2[j];
            }
        }
        if (n2 == 1 && n == 0) {
            objectArray = null;
            stringArray = null;
        }
        this.theTable.setData(objectArray, stringArray);
        if (!this.theTable.isVisible()) {
            this.theTable.centerWindow();
        }
        if (this.preferDialog) {
            this.tableDialog.setContentPane(this.theTable.getContentPane());
            this.tableDialog.setBounds(this.theTable.getBounds());
            this.tableDialog.setResizable(this.theTable.isResizable());
            this.theTable.setVisible(false);
            this.theTable = null;
            this.tableDialog.setVisible(true);
        } else {
            this.tableDialog.setVisible(false);
            this.tableDialog = null;
            this.theTable.setVisible(true);
        }
    }

    protected void showTableAll() {
        Vector<JLDataView> vector = new Vector<JLDataView>();
        if (this.xAxis.isXY()) {
            vector.addAll(this.xAxis.getViews());
        }
        vector.addAll(this.y1Axis.getViews());
        vector.addAll(this.y2Axis.getViews());
        this.showTableAll(vector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void showStatAll(Vector<JLDataView> vector) {
        double[][] dArray;
        int n = 0;
        Vector<JLDataView> vector2 = vector;
        synchronized (vector2) {
            int n2;
            for (n2 = 0; n2 < vector.size(); ++n2) {
                n += vector.get(n2).getDataLength();
            }
            dArray = new double[n][2];
            n2 = 0;
            for (int i = 0; i < vector.size(); ++i) {
                DataList dataList = vector.get(i).getData();
                while (dataList != null) {
                    long l;
                    double d = dataList.y;
                    double d2 = dataList.x;
                    if (Double.isNaN(d)) {
                        l = Double.doubleToRawLongBits(dataList.y);
                        if (l == Double.doubleToRawLongBits(JLDataView.NAN_FOR_NEGATIVE_INFINITY)) {
                            d = Double.POSITIVE_INFINITY;
                        } else if (l == Double.doubleToRawLongBits(JLDataView.NAN_FOR_POSITIVE_INFINITY)) {
                            d = Double.NEGATIVE_INFINITY;
                        }
                    }
                    if (Double.isNaN(d)) {
                        l = Double.doubleToRawLongBits(dataList.y);
                        if (l == Double.doubleToRawLongBits(JLDataView.NAN_FOR_NEGATIVE_INFINITY)) {
                            d = Double.POSITIVE_INFINITY;
                        } else if (l == Double.doubleToRawLongBits(JLDataView.NAN_FOR_POSITIVE_INFINITY)) {
                            d = Double.NEGATIVE_INFINITY;
                        }
                    }
                    if (Double.isNaN(d2)) {
                        l = Double.doubleToRawLongBits(dataList.x);
                        if (l == Double.doubleToRawLongBits(JLDataView.NAN_FOR_NEGATIVE_INFINITY)) {
                            d2 = Double.POSITIVE_INFINITY;
                        } else if (l == Double.doubleToRawLongBits(JLDataView.NAN_FOR_POSITIVE_INFINITY)) {
                            d2 = Double.NEGATIVE_INFINITY;
                        }
                    }
                    dArray[n2][0] = d;
                    dArray[n2++][1] = d2;
                    dataList = dataList.next;
                }
            }
        }
        this.showStatistics(dArray, "all");
    }

    protected void showStatAll() {
        Vector<JLDataView> vector = new Vector<JLDataView>();
        if (this.xAxis.isXY()) {
            vector.addAll(this.xAxis.getViews());
        }
        vector.addAll(this.y1Axis.getViews());
        vector.addAll(this.y2Axis.getViews());
        this.showStatAll(vector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showStatSingle(JLDataView jLDataView) {
        double[][] dArray;
        JLDataView jLDataView2 = jLDataView;
        synchronized (jLDataView2) {
            int n = jLDataView.getDataLength();
            DataList dataList = jLDataView.getData();
            dArray = new double[n][2];
            for (int i = 0; i < dArray.length; ++i) {
                long l;
                double d = dataList.y;
                double d2 = dataList.x;
                if (Double.isNaN(d)) {
                    l = Double.doubleToRawLongBits(dataList.y);
                    if (l == Double.doubleToRawLongBits(JLDataView.NAN_FOR_NEGATIVE_INFINITY)) {
                        d = Double.POSITIVE_INFINITY;
                    } else if (l == Double.doubleToRawLongBits(JLDataView.NAN_FOR_POSITIVE_INFINITY)) {
                        d = Double.NEGATIVE_INFINITY;
                    }
                }
                if (Double.isNaN(d2)) {
                    l = Double.doubleToRawLongBits(dataList.x);
                    if (l == Double.doubleToRawLongBits(JLDataView.NAN_FOR_NEGATIVE_INFINITY)) {
                        d2 = Double.POSITIVE_INFINITY;
                    } else if (l == Double.doubleToRawLongBits(JLDataView.NAN_FOR_POSITIVE_INFINITY)) {
                        d2 = Double.NEGATIVE_INFINITY;
                    }
                }
                dArray[i][0] = d;
                dArray[i][1] = d2;
                dataList = dataList.next;
            }
        }
        this.showStatistics(dArray, jLDataView.getName());
    }

    private void showStatistics(double[][] dArray, String string) {
        double d = Double.POSITIVE_INFINITY;
        double d2 = Double.NEGATIVE_INFINITY;
        double d3 = Double.NaN;
        double d4 = Double.NaN;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        try {
            String string2;
            for (int i = 0; i < dArray.length; ++i) {
                if (dArray[i][0] < d) {
                    d = dArray[i][0];
                    d3 = dArray[i][1];
                }
                if (dArray[i][0] > d2) {
                    d2 = dArray[i][0];
                    d4 = dArray[i][1];
                }
                d5 += dArray[i][0];
                double d9 = Double.isInfinite(dArray[i][0]) ? Double.POSITIVE_INFINITY : (Double.isNaN(dArray[i][0]) ? Double.NaN : dArray[i][0] * dArray[i][0]);
                d8 += d9;
            }
            if (Double.isInfinite(d) && d > 0.0) {
                d = Double.NaN;
            }
            if (Double.isInfinite(d2) && d2 < 0.0) {
                d2 = Double.NaN;
            }
            if (dArray.length > 0) {
                d6 = Math.sqrt((d8 /= (double)dArray.length) - (d5 /= (double)dArray.length) * d5);
                d7 = dArray.length > 1 ? Math.sqrt((double)dArray.length / (double)(dArray.length - 1) * (d8 - d5 * d5)) : Double.NaN;
            } else {
                d5 = Double.NaN;
                d6 = Double.NaN;
                d7 = Double.NaN;
                d = Double.NaN;
                d2 = Double.NaN;
            }
            StringBuffer stringBuffer = new StringBuffer("Statistics: ");
            stringBuffer.append(string);
            StringBuffer stringBuffer2 = new StringBuffer("Minimum: ");
            stringBuffer2.append(d);
            if (!Double.isNaN(d3)) {
                string2 = "";
                string2 = this.xAxis.getAnnotation() == 1 ? JLAxis.formatTimeValue(d3) : this.xAxis.formatValue(d3, 0.0);
                stringBuffer2.append(", obtained at X = ");
                stringBuffer2.append(string2);
            }
            stringBuffer2.append("\nMaximum: ").append(d2);
            if (!Double.isNaN(d4)) {
                string2 = "";
                string2 = this.xAxis.getAnnotation() == 1 ? JLAxis.formatTimeValue(d4) : this.xAxis.formatValue(d4, 0.0);
                stringBuffer2.append(", obtained at X = ");
                stringBuffer2.append(string2);
            }
            stringBuffer2.append("\nAverage: ").append(d5);
            stringBuffer2.append("\nStandard Deviation: ");
            stringBuffer2.append(d6);
            stringBuffer2.append("\nSample Standard Deviation: ");
            stringBuffer2.append(d7);
            JOptionPane.showMessageDialog(this, stringBuffer2.toString(), stringBuffer.toString(), -1, null);
            stringBuffer = null;
            stringBuffer2 = null;
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, "Failed to obtain statistics on " + string, "Error", 0);
            exception.printStackTrace();
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.optionMenuItem) {
            this.showOptionDialog();
        } else if (object == this.zoomBackMenuItem || object == this.zoomButton) {
            this.exitZoom();
        } else if (object == this.printMenuItem) {
            this.printGraph();
        } else if (object == this.saveSnapshotMenuItem) {
            this.saveSnapshot();
        } else if (object == this.precisionMenuItem) {
            this.displayPrecisionDialog();
        } else if (object == this.tableAllMenuItem) {
            this.showTableAll();
        } else if (object == this.statAllMenuItem) {
            this.showStatAll();
        } else if (object == this.saveFileMenuItem) {
            File file;
            int n = 0;
            JFileChooser jFileChooser = new JFileChooser(this.lastDataFileLocation);
            jFileChooser.addChoosableFileFilter(new MultiExtFileFilter("Text files", "txt", new String[0]));
            jFileChooser.setDialogTitle("Save Graph Data (Text file with TAB separated fields)");
            int n2 = jFileChooser.showSaveDialog(this);
            if (n2 == 0 && (file = jFileChooser.getSelectedFile()) != null) {
                if (MultiExtFileFilter.getExtension(file) == null) {
                    file = new File(file.getAbsolutePath() + ".txt");
                }
                if (file.exists()) {
                    n = JOptionPane.showConfirmDialog(this, "Do you want to overwrite " + file.getName() + " ?", "Confirm overwrite", 0);
                }
                if (n == 0) {
                    this.lastDataFileLocation = file.getParentFile().getAbsolutePath();
                    this.saveDataFile(file.getAbsolutePath());
                }
            }
        } else {
            boolean bl = false;
            int n = 0;
            while (n < this.userActionMenuItem.length && !bl) {
                bl = this.userActionMenuItem[n] == actionEvent.getSource();
                if (bl) continue;
                ++n;
            }
            if (bl) {
                if (this.userActionMenuItem[n] instanceof JCheckBoxMenuItem) {
                    JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)this.userActionMenuItem[n];
                    this.fireActionPerfromed(jCheckBoxMenuItem.getText(), jCheckBoxMenuItem.getState());
                } else {
                    this.fireActionPerfromed(this.userActionMenuItem[n].getText(), false);
                }
                return;
            }
            n = 0;
            while (n < this.dvY1MenuItem.length && !bl) {
                bl = this.dvY1MenuItem[n] == actionEvent.getSource();
                if (bl) continue;
                ++n;
            }
            if (bl) {
                this.showDataOptionDialog(this.y1Axis.getDataView(n));
                return;
            }
            n = 0;
            while (n < this.dvY2MenuItem.length && !bl) {
                bl = this.dvY2MenuItem[n] == actionEvent.getSource();
                if (bl) continue;
                ++n;
            }
            if (bl) {
                this.showDataOptionDialog(this.y2Axis.getDataView(n));
                return;
            }
            n = 0;
            while (n < this.tableSingleY1MenuItem.length && !bl) {
                bl = this.tableSingleY1MenuItem[n] == actionEvent.getSource();
                if (bl) continue;
                ++n;
            }
            if (bl) {
                this.showTableSingle(this.y1Axis.getDataView(n));
                return;
            }
            n = 0;
            while (n < this.tableSingleY2MenuItem.length && !bl) {
                bl = this.tableSingleY2MenuItem[n] == actionEvent.getSource();
                if (bl) continue;
                ++n;
            }
            if (bl) {
                this.showTableSingle(this.y2Axis.getDataView(n));
                return;
            }
            n = 0;
            while (n < this.statSingleY1MenuItem.length && !bl) {
                bl = this.statSingleY1MenuItem[n] == actionEvent.getSource();
                if (bl) continue;
                ++n;
            }
            if (bl) {
                this.showStatSingle(this.y1Axis.getDataView(n));
                return;
            }
            n = 0;
            while (n < this.statSingleY2MenuItem.length && !bl) {
                bl = this.statSingleY2MenuItem[n] == actionEvent.getSource();
                if (bl) continue;
                ++n;
            }
            if (bl) {
                this.showStatSingle(this.y2Axis.getDataView(n));
                return;
            }
        }
    }

    private void paintLabel(Graphics2D graphics2D, JLDataView jLDataView, JLAxis jLAxis, int n, int n2, int n3, int n4) {
        int n5 = n + (n3 - this.labelWidth) / 2 + 7;
        int n6 = n2 + this.labelHeight / 2 + 2;
        graphics2D.setColor(jLDataView.getColor());
        JLAxis.drawSampleLine(graphics2D, n5, n6 - 2, jLDataView);
        graphics2D.setColor(jLDataView.getLabelColor());
        graphics2D.drawString(jLDataView.getExtendedName() + " " + jLAxis.getAxeName(), n5 + 44, n6 + this.labelHeight - n4);
        this.labelRect.add(new LabelRect(n5, n6 - n4, this.labelWidth, this.labelHeight, jLDataView));
    }

    private void paintLabelAndHeader(Graphics2D graphics2D) {
        block7: {
            int n = this.y1Axis.getViews().size();
            int n2 = this.y2Axis.getViews().size();
            if (this.headerR.width > 0) {
                graphics2D.setFont(this.headerFont);
                int n3 = (this.headerR.width - this.headerWidth) / 2;
                graphics2D.setColor(this.headerColor);
                graphics2D.drawString(this.header, n3, this.headerR.y + graphics2D.getFontMetrics(this.headerFont).getAscent() - 1);
            }
            this.labelRect.clear();
            if (this.labelR.width <= 0) break block7;
            graphics2D.setFont(this.labelFont);
            int n4 = graphics2D.getFontMetrics(this.labelFont).getAscent();
            int n5 = 0;
            if (this.labelMode == 4 && this.labelPerLine > 1) {
                int n6;
                int n7;
                int n8;
                int n9 = this.labelR.width / this.labelPerLine;
                for (n8 = 0; n8 < n; ++n8) {
                    JLDataView jLDataView = this.y1Axis.getViews().get(n8);
                    if (!jLDataView.isLabelVisible()) continue;
                    n7 = n5 % this.labelPerLine * n9 + this.labelR.x;
                    n6 = n5 / this.labelPerLine * this.labelHeight + this.labelR.y;
                    this.paintLabel(graphics2D, jLDataView, this.y1Axis, n7, n6, n9, n4);
                    ++n5;
                }
                for (n8 = 0; n8 < n2; ++n8) {
                    JLDataView jLDataView = this.y2Axis.getViews().get(n8);
                    if (!jLDataView.isLabelVisible()) continue;
                    n7 = n5 % this.labelPerLine * n9 + this.labelR.x;
                    n6 = n5 / this.labelPerLine * this.labelHeight + this.labelR.y;
                    this.paintLabel(graphics2D, jLDataView, this.y2Axis, n7, n6, n9, n4);
                    ++n5;
                }
            } else {
                int n10;
                int n11;
                for (n11 = 0; n11 < n; ++n11) {
                    JLDataView jLDataView = this.y1Axis.getViews().get(n11);
                    if (!jLDataView.isLabelVisible()) continue;
                    n10 = this.labelR.y + (this.labelR.height - this.nbLabel * this.labelHeight) / 2 + this.labelHeight * n5;
                    this.paintLabel(graphics2D, jLDataView, this.y1Axis, this.labelR.x, n10, this.labelR.width, n4);
                    ++n5;
                }
                for (n11 = 0; n11 < n2; ++n11) {
                    JLDataView jLDataView = this.y2Axis.getViews().get(n11);
                    if (!jLDataView.isLabelVisible()) continue;
                    n10 = this.labelR.y + (this.labelR.height - this.nbLabel * this.labelHeight) / 2 + this.labelHeight * n5;
                    this.paintLabel(graphics2D, jLDataView, this.y2Axis, this.labelR.x, n10, this.labelR.width, n4);
                    ++n5;
                }
            }
        }
    }

    private void measureGraphItems(Graphics2D graphics2D, FontRenderContext fontRenderContext, int n, int n2, Vector vector) {
        int n3;
        Rectangle2D rectangle2D = null;
        int n4 = this.margin.width;
        int n5 = this.margin.height;
        int n6 = 0;
        this.headerR.setBounds(0, 0, 0, 10);
        this.viewR.setBounds(0, 0, 0, 0);
        this.labelR.setBounds(0, 0, 0, 0);
        this.labelWidth = 0;
        this.headerWidth = 0;
        this.axisWidth = 0;
        this.axisHeight = 0;
        this.y1AxisThickness = 0;
        this.y2AxisThickness = 0;
        if (this.headerVisible && this.header != null && this.headerFont != null) {
            rectangle2D = this.headerFont.getStringBounds(this.header, fontRenderContext);
            this.headerWidth = (int)rectangle2D.getWidth();
            this.headerR.setBounds(n4, n5, n - 2 * n4, (int)rectangle2D.getHeight() + 5);
        }
        this.nbLabel = 0;
        for (n3 = 0; n3 < this.y1Axis.getViews().size(); ++n3) {
            if (!this.y1Axis.getViews().get(n3).isLabelVisible()) continue;
            ++this.nbLabel;
        }
        for (n3 = 0; n3 < this.y2Axis.getViews().size(); ++n3) {
            if (!this.y2Axis.getViews().get(n3).isLabelVisible()) continue;
            ++this.nbLabel;
        }
        if (this.labelVisible && this.nbLabel > 0 && this.labelFont != null) {
            JLDataView jLDataView;
            n3 = 0;
            double d = 0.0;
            for (n3 = 0; n3 < this.y1Axis.getViews().size(); ++n3) {
                jLDataView = this.y1Axis.getViews().get(n3);
                if (!jLDataView.isLabelVisible() || !((rectangle2D = this.labelFont.getStringBounds(jLDataView.getExtendedName() + " " + this.y1Axis.getAxeName(), fontRenderContext)).getWidth() > d)) continue;
                d = rectangle2D.getWidth();
            }
            for (n3 = 0; n3 < this.y2Axis.getViews().size(); ++n3) {
                jLDataView = this.y2Axis.getViews().get(n3);
                if (!jLDataView.isLabelVisible() || !((rectangle2D = this.labelFont.getStringBounds(jLDataView.getExtendedName() + " " + this.y2Axis.getAxeName(), fontRenderContext)).getWidth() > d)) continue;
                d = rectangle2D.getWidth();
            }
            this.labelHeight = (int)rectangle2D.getHeight() + 2;
            n6 = this.labelHeight * this.nbLabel + 10;
            this.labelWidth = (int)(d + 55.0);
            switch (this.labelMode) {
                case 1: {
                    this.labelR.setBounds(n4, n5 + this.headerR.height, n - 2 * n4, n6);
                    break;
                }
                case 0: {
                    this.labelR.setBounds(n4, n2 - n5 - n6, n - 2 * n4, n6);
                    break;
                }
                case 2: {
                    this.labelR.setBounds(n - n4 - this.labelWidth, n5 + this.headerR.height, this.labelWidth, n2 - 2 * n5 - this.headerR.height);
                    break;
                }
                case 3: {
                    this.labelR.setBounds(n4, n5 + this.headerR.height, this.labelWidth, n2 - 2 * n5 - this.headerR.height);
                    break;
                }
                case 4: {
                    this.labelPerLine = n / this.labelWidth;
                    if (this.labelPerLine > this.nbLabel) {
                        this.labelPerLine = this.nbLabel;
                    }
                    if (this.labelPerLine <= 1) {
                        this.labelR.setBounds(n4, n2 - n5 - n6, n - 2 * n4, n6);
                        break;
                    }
                    n6 = this.labelHeight * (this.nbLabel / this.labelPerLine);
                    if (this.nbLabel % this.labelPerLine != 0) {
                        n6 += this.labelHeight;
                    }
                    this.labelR.setBounds(n4, n2 - n5 - n6, n - 2 * n4, n6);
                }
            }
        }
        switch (this.labelMode) {
            case 1: {
                this.viewR.setBounds(n4, n5 + this.headerR.height + this.labelR.height, n - 2 * n4, n2 - 2 * n5 - this.headerR.height - this.labelR.height);
                break;
            }
            case 0: 
            case 4: {
                this.viewR.setBounds(n4, n5 + this.headerR.height, n - 2 * n4, n2 - 2 * n5 - this.headerR.height - this.labelR.height);
                break;
            }
            case 2: {
                this.viewR.setBounds(n4, n5 + this.headerR.height, n - 2 * n4 - this.labelR.width, n2 - 2 * n5 - this.headerR.height);
                break;
            }
            case 3: {
                this.viewR.setBounds(n4 + this.labelR.width, n5 + this.headerR.height, n - 2 * n4 - this.labelR.width, n2 - 2 * n5 - this.headerR.height);
            }
        }
        this.xAxisThickness = this.xAxis.getLabelFontDimension(fontRenderContext);
        this.xAxisUpMargin = this.xAxis.getOrientation() == 2 ? this.xAxisThickness / 2 : 0;
        this.axisHeight = this.viewR.height - this.xAxisThickness;
        this.xAxis.computeXScale(vector);
        this.y1Axis.measureAxis(fontRenderContext, 0, this.axisHeight);
        this.y2Axis.measureAxis(fontRenderContext, 0, this.axisHeight);
        this.y1AxisThickness = this.y1Axis.getThickness();
        if (this.y1AxisThickness == 0) {
            this.y1AxisThickness = 5;
        }
        this.y2AxisThickness = this.y2Axis.getThickness();
        if (this.y2AxisThickness == 0) {
            this.y2AxisThickness = 5;
        }
        this.axisWidth = this.viewR.width - (this.y1AxisThickness + this.y2AxisThickness);
        this.xAxis.measureAxis(fontRenderContext, this.axisWidth, 0);
    }

    private void paintZoomButton(int n, int n2) {
        if (this.isZoomed()) {
            int n3 = this.zoomButton.getPreferredSize().width;
            int n4 = this.zoomButton.getPreferredSize().height;
            this.zoomButton.setBounds(n + 7, n2 + 5, n3, n4);
            this.zoomButton.setVisible(n3 < this.axisWidth - 7 && n4 < this.axisHeight - 5);
        } else {
            this.zoomButton.setVisible(false);
        }
    }

    private void paintZoomSelection(Graphics graphics) {
        if (this.zoomDrag) {
            graphics.setColor(Color.black);
            Rectangle rectangle = this.buildRect(this.zoomX, this.zoomY, this.lastX, this.lastY);
            graphics.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    @Override
    public void paint(Graphics graphics) {
        int n = this.getWidth();
        int n2 = this.getHeight();
        Vector<JLDataView> vector = new Vector<JLDataView>(this.y1Axis.getViews());
        vector.addAll(this.y2Axis.getViews());
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        graphics.setPaintMode();
        if (this.isOpaque()) {
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, n, n2);
        }
        this.measureGraphItems(graphics2D, fontRenderContext, n, n2, vector);
        this.paintLabelAndHeader(graphics2D);
        int n3 = this.viewR.x + this.y1AxisThickness;
        int n4 = this.viewR.y + this.axisHeight + this.xAxisUpMargin;
        int n5 = this.viewR.x;
        int n6 = this.viewR.x + this.y1AxisThickness + this.axisWidth;
        int n7 = this.viewR.y + this.xAxisUpMargin;
        if (!this.chartBackground.equals(this.getBackground()) && this.axisWidth > 0 && this.axisHeight > 0) {
            graphics.setColor(this.chartBackground);
            graphics.fillRect(n3, n4 - this.axisHeight, this.axisWidth, this.axisHeight);
        }
        this.paintZoomSelection(graphics);
        this.paintZoomButton(n3, n7);
        if (this.paintAxisFirst) {
            this.y1Axis.paintAxis(graphics, fontRenderContext, n5, n7, this.xAxis, n3, n4, this.getBackground(), !this.y2Axis.isVisible() || this.y2Axis.getViewNumber() == 0);
            this.y2Axis.paintAxis(graphics, fontRenderContext, n6, n7, this.xAxis, n3, n4, this.getBackground(), !this.y1Axis.isVisible() || this.y1Axis.getViewNumber() == 0);
            if (this.xAxis.getPosition() == 4) {
                this.xAxis.paintAxis(graphics, fontRenderContext, n3, n4, this.y2Axis, 0, 0, this.getBackground(), true);
            } else {
                this.xAxis.paintAxis(graphics, fontRenderContext, n3, n4, this.y1Axis, 0, 0, this.getBackground(), true);
            }
            Rectangle rectangle = graphics.getClipBounds();
            this.y1Axis.paintDataViews(graphics, this.xAxis, n3, n4);
            this.y2Axis.paintDataViews(graphics, this.xAxis, n3, n4);
            if (rectangle != null) {
                graphics.setClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            } else {
                graphics.setClip(null);
            }
        } else {
            Rectangle rectangle = graphics.getClipBounds();
            this.y1Axis.paintDataViews(graphics, this.xAxis, n3, n4);
            this.y2Axis.paintDataViews(graphics, this.xAxis, n3, n4);
            if (rectangle != null) {
                graphics.setClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            } else {
                graphics.setClip(null);
            }
            this.y1Axis.paintAxis(graphics, fontRenderContext, n5, n7, this.xAxis, n3, n4, this.getBackground(), !this.y2Axis.isVisible() || this.y2Axis.getViewNumber() == 0);
            this.y2Axis.paintAxis(graphics, fontRenderContext, n6, n7, this.xAxis, n3, n4, this.getBackground(), !this.y1Axis.isVisible() || this.y1Axis.getViewNumber() == 0);
            if (this.xAxis.getPosition() == 4) {
                this.xAxis.paintAxis(graphics, fontRenderContext, n3, n4, this.y2Axis, 0, 0, this.getBackground(), true);
            } else {
                this.xAxis.paintAxis(graphics, fontRenderContext, n3, n4, this.y1Axis, 0, 0, this.getBackground(), true);
            }
        }
        this.redrawPanel(graphics);
        this.paintComponents(graphics);
        this.paintBorder(graphics);
    }

    private Rectangle buildRect(int n, int n2, int n3, int n4) {
        Rectangle rectangle = new Rectangle();
        if (n < n3) {
            if (n2 < n4) {
                rectangle.setRect(n, n2, n3 - n, n4 - n2);
            } else {
                rectangle.setRect(n, n4, n3 - n, n2 - n4);
            }
        } else if (n2 < n4) {
            rectangle.setRect(n3, n2, n - n3, n4 - n2);
        } else {
            rectangle.setRect(n3, n4, n - n3, n2 - n4);
        }
        return rectangle;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.zoomDrag) {
            Rectangle rectangle = this.buildRect(this.zoomX, this.zoomY, this.lastX, this.lastY);
            ++rectangle.width;
            ++rectangle.height;
            this.repaint(rectangle);
            this.lastX = mouseEvent.getX();
            this.lastY = mouseEvent.getY();
            rectangle = this.buildRect(this.zoomX, this.zoomY, this.lastX, this.lastY);
            ++rectangle.width;
            ++rectangle.height;
            this.repaint(rectangle);
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.zoomDrag) {
            Rectangle rectangle = this.buildRect(this.zoomX, this.zoomY, mouseEvent.getX(), mouseEvent.getY());
            this.zoomDrag = false;
            this.xAxis.zoom(rectangle.x, rectangle.x + rectangle.width);
            this.y1Axis.zoom(rectangle.y, rectangle.y + rectangle.height);
            this.y2Axis.zoom(rectangle.y, rectangle.y + rectangle.height);
        }
        this.ipanelVisible = false;
        this.repaint();
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        Object object;
        if (mouseEvent.getButton() == 1) {
            if (mouseEvent.isControlDown() || this.zoomDragAllowed) {
                this.zoomDrag = true;
                this.zoomX = mouseEvent.getX();
                this.zoomY = mouseEvent.getY();
                this.lastX = mouseEvent.getX();
                this.lastY = mouseEvent.getY();
                return;
            }
            object = null;
            object = this.y1Axis.searchNearest(mouseEvent.getX(), mouseEvent.getY(), this.xAxis);
            SearchInfo searchInfo = this.y2Axis.searchNearest(mouseEvent.getX(), mouseEvent.getY(), this.xAxis);
            if (searchInfo.found && searchInfo.dist < ((SearchInfo)object).dist) {
                object = searchInfo;
            }
            if (((SearchInfo)object).found) {
                Graphics graphics = this.getGraphics();
                this.showPanel(graphics, (SearchInfo)object);
                graphics.dispose();
                return;
            }
            boolean bl = false;
            for (int i = 0; i < this.labelRect.size() && !bl; ++i) {
                LabelRect labelRect = this.labelRect.get(i);
                bl = labelRect.rect.contains(mouseEvent.getX(), mouseEvent.getY());
                if (!bl) continue;
                this.showDataOptionDialog(labelRect.view);
            }
        }
        if (mouseEvent.getButton() == 3) {
            int n;
            this.zoomBackMenuItem.setEnabled(this.isZoomed());
            for (n = 0; n < this.userActionMenuItem.length; ++n) {
                if (!(this.userActionMenuItem[n] instanceof JCheckBoxMenuItem)) continue;
                object = (JCheckBoxMenuItem)this.userActionMenuItem[n];
                ((AbstractButton)object).setSelected(this.fireGetActionState(((AbstractButton)object).getText()));
            }
            this.tableMenu.removeAll();
            this.tableMenu.add(this.tableAllMenuItem);
            if (this.y1Axis.getViewNumber() > 0) {
                this.tableMenu.add(new JSeparator());
            }
            for (n = 0; n < this.tableSingleY1MenuItem.length; ++n) {
                this.tableSingleY1MenuItem[n].removeActionListener(this);
            }
            this.tableSingleY1MenuItem = new JMenuItem[this.y1Axis.getViewNumber()];
            for (n = 0; n < this.y1Axis.getViewNumber(); ++n) {
                this.tableSingleY1MenuItem[n] = new JMenuItem(this.y1Axis.getDataView(n).getName());
                this.tableSingleY1MenuItem[n].addActionListener(this);
                this.tableMenu.add(this.tableSingleY1MenuItem[n]);
            }
            if (this.y1Axis.getViewNumber() > 0 && this.y2Axis.getViewNumber() > 0) {
                this.tableMenu.add(new JSeparator());
            }
            for (n = 0; n < this.tableSingleY2MenuItem.length; ++n) {
                this.tableSingleY2MenuItem[n].removeActionListener(this);
            }
            this.tableSingleY2MenuItem = new JMenuItem[this.y2Axis.getViewNumber()];
            for (n = 0; n < this.y2Axis.getViewNumber(); ++n) {
                this.tableSingleY2MenuItem[n] = new JMenuItem(this.y2Axis.getDataView(n).getName());
                this.tableSingleY2MenuItem[n].addActionListener(this);
                this.tableMenu.add(this.tableSingleY2MenuItem[n]);
            }
            this.dvMenu.removeAll();
            for (n = 0; n < this.dvY1MenuItem.length; ++n) {
                this.dvY1MenuItem[n].removeActionListener(this);
            }
            for (n = 0; n < this.dvY2MenuItem.length; ++n) {
                this.dvY2MenuItem[n].removeActionListener(this);
            }
            this.dvY1MenuItem = new JMenuItem[this.y1Axis.getViewNumber()];
            this.dvY2MenuItem = new JMenuItem[this.y2Axis.getViewNumber()];
            int n2 = 1;
            for (n = 0; n < this.y1Axis.getViewNumber(); ++n) {
                String string = this.y1Axis.getDataView(n).getName();
                if (string.length() == 0) {
                    string = "Dataview #" + n2;
                    ++n2;
                }
                this.dvY1MenuItem[n] = new JMenuItem(string);
                this.dvY1MenuItem[n].addActionListener(this);
                this.dvMenu.add(this.dvY1MenuItem[n]);
            }
            for (n = 0; n < this.y2Axis.getViewNumber(); ++n) {
                String string = this.y2Axis.getDataView(n).getName();
                if (string.length() == 0) {
                    string = "Dataview #" + n2;
                    ++n2;
                }
                this.dvY2MenuItem[n] = new JMenuItem(string);
                this.dvY2MenuItem[n].addActionListener(this);
                this.dvMenu.add(this.dvY2MenuItem[n]);
            }
            this.statMenu.removeAll();
            this.statMenu.add(this.statAllMenuItem);
            if (this.y1Axis.getViewNumber() > 0) {
                this.statMenu.add(new JSeparator());
            }
            for (n = 0; n < this.statSingleY1MenuItem.length; ++n) {
                this.statSingleY1MenuItem[n].removeActionListener(this);
            }
            this.statSingleY1MenuItem = new JMenuItem[this.y1Axis.getViewNumber()];
            for (n = 0; n < this.y1Axis.getViewNumber(); ++n) {
                this.statSingleY1MenuItem[n] = new JMenuItem(this.y1Axis.getDataView(n).getName());
                this.statSingleY1MenuItem[n].addActionListener(this);
                this.statMenu.add(this.statSingleY1MenuItem[n]);
            }
            if (this.y1Axis.getViewNumber() > 0 && this.y2Axis.getViewNumber() > 0) {
                this.statMenu.add(new JSeparator());
            }
            for (n = 0; n < this.statSingleY2MenuItem.length; ++n) {
                this.statSingleY2MenuItem[n].removeActionListener(this);
            }
            this.statSingleY2MenuItem = new JMenuItem[this.y2Axis.getViewNumber()];
            for (n = 0; n < this.y2Axis.getViewNumber(); ++n) {
                this.statSingleY2MenuItem[n] = new JMenuItem(this.y2Axis.getDataView(n).getName());
                this.statSingleY2MenuItem[n].addActionListener(this);
                this.statMenu.add(this.statSingleY2MenuItem[n]);
            }
            this.chartMenu.show(this, mouseEvent.getX(), mouseEvent.getY());
        }
    }

    private void redrawPanel(Graphics graphics) {
        if (!this.ipanelVisible) {
            return;
        }
        JLDataView jLDataView = this.lastSearch.dataView;
        JLDataView jLDataView2 = this.lastSearch.xdataView;
        DataList dataList = this.lastSearch.value;
        DataList dataList2 = this.lastSearch.xvalue;
        JLAxis jLAxis = this.lastSearch.axis;
        Point point = this.xAxis.isXY() ? jLAxis.transform(jLDataView2.getTransformedValue(dataList2.y), jLDataView.getTransformedValue(dataList.y), this.xAxis) : jLAxis.transform(dataList.x, jLDataView.getTransformedValue(dataList.y), this.xAxis);
        this.lastSearch.x = point.x;
        this.lastSearch.y = point.y;
        this.showPanel(graphics, this.lastSearch);
    }

    protected String[] buildPanelString(SearchInfo searchInfo) {
        String[] stringArray = null;
        String string = this.xAxis.getAnnotation() == 1 ? "Time= " + JLAxis.formatTimeValue(searchInfo.value.x) : "Index= " + searchInfo.value.x;
        stringArray = this.xAxis.isXY() ? new String[]{searchInfo.dataView.getExtendedName() + " " + searchInfo.axis.getAxeName(), string, "X= " + searchInfo.xdataView.formatValue(searchInfo.xdataView.getTransformedValue(searchInfo.xvalue.y)), "Y= " + searchInfo.dataView.formatValue(searchInfo.dataView.getTransformedValue(searchInfo.value.y)) + " " + searchInfo.dataView.getUnit()} : new String[]{searchInfo.dataView.getExtendedName() + " " + searchInfo.axis.getAxeName(), string, "Y= " + searchInfo.dataView.formatValue(searchInfo.dataView.getTransformedValue(searchInfo.value.y)) + " " + searchInfo.dataView.getUnit()};
        return stringArray;
    }

    public void showPanel(Graphics graphics, SearchInfo searchInfo) {
        int n;
        Graphics2D graphics2D = (Graphics2D)graphics;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        String[] stringArray = null;
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        graphics.setPaintMode();
        graphics.setFont(this.labelFont);
        if (this.listener != null) {
            JLChartEvent jLChartEvent = new JLChartEvent(this, searchInfo);
            stringArray = this.listener.clickOnChart(jLChartEvent);
        }
        if (stringArray == null) {
            stringArray = this.buildPanelString(searchInfo);
        }
        if (stringArray.length <= 0) {
            return;
        }
        Rectangle2D rectangle2D = graphics.getFont().getStringBounds(stringArray[0], fontRenderContext);
        n4 = (int)rectangle2D.getWidth();
        n3 = n2 = (int)rectangle2D.getHeight();
        for (n = 1; n < stringArray.length; ++n) {
            rectangle2D = graphics.getFont().getStringBounds(stringArray[n], fontRenderContext);
            if ((int)rectangle2D.getWidth() > n4) {
                n4 = (int)rectangle2D.getWidth();
            }
            n2 = (int)((double)n2 + rectangle2D.getHeight());
        }
        n4 += 10;
        n2 += 10;
        graphics.setColor(Color.black);
        switch (searchInfo.placement) {
            case 3: {
                n5 = searchInfo.x + 10;
                n6 = searchInfo.y + 10;
                graphics.drawLine(searchInfo.x, searchInfo.y, searchInfo.x + 10, searchInfo.y + 10);
                break;
            }
            case 2: {
                n5 = searchInfo.x - 10 - n4;
                n6 = searchInfo.y + 10;
                graphics.drawLine(searchInfo.x, searchInfo.y, searchInfo.x - 10, searchInfo.y + 10);
                break;
            }
            case 1: {
                n5 = searchInfo.x + 10;
                n6 = searchInfo.y - 10 - n2;
                graphics.drawLine(searchInfo.x, searchInfo.y, searchInfo.x + 10, searchInfo.y - 10);
                break;
            }
            case 0: {
                n5 = searchInfo.x - 10 - n4;
                n6 = searchInfo.y - 10 - n2;
                graphics.drawLine(searchInfo.x, searchInfo.y, searchInfo.x - 10, searchInfo.y - 10);
            }
        }
        graphics.setColor(Color.white);
        graphics.fillRect(n5, n6, n4, n2);
        graphics.setColor(Color.black);
        graphics.drawRect(n5, n6, n4, n2);
        graphics.setColor(Color.black);
        for (n = 0; n < stringArray.length; ++n) {
            graphics.drawString(stringArray[n], n5 + 3, n6 + 3 + (n + 1) * n3);
        }
        this.lastSearch = searchInfo;
        this.ipanelVisible = true;
    }

    public int garbageData(JLDataView jLDataView) {
        int n = 0;
        if (this.displayDuration != Double.POSITIVE_INFINITY) {
            n = jLDataView.garbagePointTime(this.displayDuration);
        }
        return n;
    }

    public void addData(JLDataView jLDataView, double d, double d2) {
        DataList dataList = null;
        boolean bl = false;
        if (jLDataView.getDataLength() > 0) {
            dataList = jLDataView.getLastValue();
        }
        if (dataList != null && Double.isNaN(dataList.y)) {
            dataList = null;
        }
        jLDataView.add(d, d2);
        if (this.zoomDrag) {
            return;
        }
        if (this.xAxis.isXY()) {
            this.repaint();
            return;
        }
        JLAxis jLAxis = jLDataView.getAxis();
        if (jLAxis != null) {
            Point point = null;
            Point point2 = jLAxis.transform(d, jLDataView.getTransformedValue(d2), this.xAxis);
            if (dataList != null) {
                point = jLAxis.transform(dataList.x, jLDataView.getTransformedValue(dataList.y), this.xAxis);
            }
            if (jLAxis.getBoundRect().contains(point2) && !bl) {
                Graphics graphics = this.getGraphics();
                jLAxis.drawFast(graphics, point, point2, jLDataView);
                graphics.dispose();
            } else {
                this.garbageData(jLDataView);
                this.repaint();
            }
        }
    }

    public void setTimePrecision(int n) {
        this.timePrecision = n;
    }

    public int getTimePrecision() {
        return this.timePrecision;
    }

    public String getNoValueString() {
        return this.noValueString;
    }

    public void setNoValueString(String string) {
        this.noValueString = string;
    }

    public void setPreferDialogForTable(boolean bl, boolean bl2) {
        this.preferDialog = bl;
        this.modalDialog = bl2;
    }

    public void setParentForTableDialog(Frame frame) {
        this.dialogParent = frame;
    }

    public void setParentForTableDialog(Dialog dialog) {
        this.dialogParent = dialog;
    }

    public void removeDataView(JLDataView jLDataView) {
        JLAxis jLAxis;
        if (jLDataView != null && (jLAxis = jLDataView.getAxis()) != null) {
            jLAxis.removeDataView(jLDataView);
        }
    }

    public void reset() {
        this.reset(true);
    }

    protected void reset(boolean bl) {
        String string;
        int n;
        Vector<JLDataView> vector = new Vector<JLDataView>();
        if (this.xAxis.isXY()) {
            vector.addAll(this.xAxis.getViews());
        }
        vector.addAll(this.y1Axis.getViews());
        vector.addAll(this.y2Axis.getViews());
        if (vector.size() != 0 && bl && (n = JOptionPane.showConfirmDialog(this, string = "Reseting chart will remove all the existing dataviews.\nYour component may not work any more.\nAre you sure to reset chart ?", "Risk of breaking component", 2)) != 0) {
            vector.clear();
            vector = null;
            return;
        }
        this.maxDisplayDuration = Double.POSITIVE_INFINITY;
        this.displayDuration = Double.POSITIVE_INFINITY;
        for (int i = 0; i < vector.size(); ++i) {
            this.removeDataView((JLDataView)vector.get(i));
        }
        this.getY1Axis().setLabels(null, null);
        this.getY1Axis().setScale(0);
        this.getY1Axis().setAutoScale(true);
        this.getY2Axis().setLabels(null, null);
        this.getY2Axis().setScale(0);
        this.getY2Axis().setAutoScale(true);
        this.getXAxis().setLabels(null, null);
        this.getXAxis().setScale(0);
        this.getXAxis().setAutoScale(true);
        vector.clear();
        vector = null;
    }

    protected JMenuItem getUserActionMenuItem(String string) {
        int n = -1;
        for (int i = 0; i < this.userAction.length; ++i) {
            if (!this.userAction[i].equals(string)) continue;
            n = i;
            break;
        }
        if (n == -1) {
            return null;
        }
        return this.userActionMenuItem[n];
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        final JLChart jLChart = new JLChart();
        JLDataView jLDataView = new JLDataView();
        JLDataView jLDataView2 = new JLDataView();
        jLChart.setHeaderFont(new Font("Times", 1, 18));
        jLChart.setLabelFont(new Font("Times", 1, 12));
        jLChart.setHeader("Test DataView");
        jLChart.getXAxis().setName("Values");
        jLChart.getXAxis().setAnnotation(2);
        jLChart.getXAxis().setPercentScrollback(0.0);
        jLChart.getXAxis().setAutoScale(true);
        jLChart.getY1Axis().setName("Counts");
        jLChart.getY1Axis().setAutoScale(true);
        jLChart.getY1Axis().addDataView(jLDataView);
        jLChart.getY1Axis().addDataView(jLDataView2);
        jLDataView.setMarker(9);
        jLDataView.setColor(Color.BLUE);
        jLDataView.setName("Data");
        jLDataView.add(-0.85, 250.0);
        jLDataView.add(-0.8, 253.0);
        jLDataView.add(-0.75, 259.0);
        jLDataView.add(-0.7, 252.0);
        jLDataView.add(-0.65, 257.0);
        jLDataView.add(-0.6, 255.0);
        jLDataView2.setMarker(7);
        jLDataView2.setColor(Color.DARK_GRAY);
        jLDataView2.add(-0.85, 265.0);
        jLDataView2.add(-0.85, 235.0);
        jLDataView2.add(-0.85, Double.NaN);
        jLDataView2.add(-0.8, 268.0);
        jLDataView2.add(-0.8, 237.0);
        jLDataView2.add(-0.8, Double.NaN);
        jLDataView2.add(-0.75, 275.0);
        jLDataView2.add(-0.75, 245.0);
        jLDataView2.add(-0.75, Double.NaN);
        jLDataView2.add(-0.7, 270.0);
        jLDataView2.add(-0.7, 240.0);
        jLDataView2.add(-0.7, Double.NaN);
        jLDataView2.add(-0.65, 268.0);
        jLDataView2.add(-0.65, 245.0);
        jLDataView2.add(-0.65, Double.NaN);
        jLDataView2.add(-0.6, 263.0);
        jLDataView2.add(-0.6, 244.0);
        jLDataView2.add(-0.6, Double.NaN);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout());
        JButton jButton = new JButton("Exit");
        jButton.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                System.exit(0);
            }
        });
        jPanel.add(jButton);
        JButton jButton2 = new JButton("Options");
        jButton2.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                jLChart.showOptionDialog();
            }
        });
        jPanel.add(jButton2);
        jFrame.getContentPane().setLayout(new BorderLayout());
        jFrame.getContentPane().add((Component)jLChart, "Center");
        jFrame.getContentPane().add((Component)jPanel, "South");
        jFrame.setSize(400, 300);
        jFrame.setDefaultCloseOperation(3);
        jFrame.setVisible(true);
    }
}

