/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util;

import com.braju.format.Format;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.IWheelSwitchListener;
import fr.esrf.tangoatk.widget.util.JArrowButton;
import fr.esrf.tangoatk.widget.util.WheelSwitchEvent;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.event.EventListenerList;

public class WheelSwitch
extends JComponent {
    private static Font defaultFont = new Font("Lucida Bright", 0, 16);
    private static Color defaultBackground = new Color(200, 200, 200);
    private static Color defaultSelectionColor = new Color(156, 154, 206);
    private int off_x;
    private int off_y;
    private int intNumber;
    private int fracNumber;
    private int expNumber;
    private double value;
    private double maxValue;
    private double minValue;
    private Dimension dz;
    private boolean editMode;
    private String editValue;
    private EventListenerList listenerList;
    private String format = "%5.2f";
    private boolean editable;
    private JArrowButton[] buttons_up;
    private JArrowButton[] buttons_down;
    private int nbButton = 0;
    private int selButton = 0;
    private Color buttonBackground;
    private Color selectionColor;

    public WheelSwitch() {
        this(true);
    }

    public WheelSwitch(boolean bl) {
        this.setLayout(null);
        this.setForeground(Color.black);
        this.setBackground(defaultBackground);
        this.setBorder(null);
        this.setFont(defaultFont);
        this.buttonBackground = this.getBackground();
        this.selectionColor = defaultSelectionColor;
        this.setOpaque(true);
        this.editable = bl;
        this.setPrecision(3, 2, 0);
        this.value = 0.0;
        this.editMode = false;
        this.editValue = "";
        this.listenerList = new EventListenerList();
        this.addComponentListener(new ComponentListener(){

            public void componentHidden(ComponentEvent componentEvent) {
            }

            public void componentMoved(ComponentEvent componentEvent) {
            }

            public void componentResized(ComponentEvent componentEvent) {
                WheelSwitch.this.placeComponents();
            }

            public void componentShown(ComponentEvent componentEvent) {
                WheelSwitch.this.placeComponents();
            }
        });
        if (bl) {
            this.addKeyListener(new KeyListener(){

                public void keyPressed(KeyEvent keyEvent) {
                    WheelSwitch.this.processKey(keyEvent);
                }

                public void keyReleased(KeyEvent keyEvent) {
                }

                public void keyTyped(KeyEvent keyEvent) {
                }
            });
            this.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent mouseEvent) {
                    WheelSwitch.this.grabFocus();
                }
            });
            this.addFocusListener(new FocusListener(){

                public void focusGained(FocusEvent focusEvent) {
                    WheelSwitch.this.updateButtonFocus();
                    WheelSwitch.this.repaint();
                }

                public void focusLost(FocusEvent focusEvent) {
                    WheelSwitch.this.updateButtonFocus();
                    WheelSwitch.this.repaint();
                }
            });
        }
    }

    public Dimension getPreferredSize() {
        Insets insets = this.hasBorder() ? this.getInsets() : new Insets(1, 1, 1, 1);
        this.computeDigitSize();
        int n = this.expNumber > 0 ? this.dz.width * (this.intNumber + this.fracNumber + this.expNumber + 4) : (this.fracNumber > 0 ? this.dz.width * (this.intNumber + this.fracNumber + 2) : this.dz.width * (this.intNumber + this.fracNumber + 1));
        int n2 = this.editable ? this.dz.width * 2 + this.dz.height : this.dz.height;
        return new Dimension(n + insets.right + insets.left, n2 + insets.top + insets.bottom);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public void setValue(double d) {
        double d2 = 0.0;
        double d3 = 0.0;
        this.value = d;
        if (!Double.isNaN(d)) {
            if (this.format.indexOf(101) > 0) {
                d2 = this.getFloatPart();
                d3 = this.getExpPart();
            } else {
                d2 = this.value;
            }
            double d4 = this.near(d2) * Math.pow(10.0, d3);
            Double d5 = new Double(Double.NaN);
            try {
                Object[] objectArray = new Double[]{new Double(d4)};
                if (this.isGoodFormat()) {
                    String string = Format.sprintf(this.format, objectArray);
                    d5 = Double.valueOf(string);
                } else {
                    d5 = objectArray[0];
                }
            }
            catch (Exception exception) {
                d5 = new Double(Double.NaN);
            }
            this.value = !d5.equals(new Double(Double.NaN)) ? d5 : d4;
        }
        this.updateButtonVisibility();
        this.repaint();
    }

    public double getValue() {
        return this.value;
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.dz = null;
        this.computeDigitSize();
        this.placeComponents();
    }

    public boolean isGoodFormat() {
        if (this.format.indexOf("%") == 0 && this.format.lastIndexOf("%") == this.format.indexOf("%")) {
            if (this.format.indexOf(".") == -1) {
                try {
                    int n = Integer.parseInt(this.format.substring(1, this.format.length() - 1));
                    return n > 0;
                }
                catch (Exception exception) {
                    return false;
                }
            }
            if (this.format.indexOf(".") == this.format.lastIndexOf(".")) {
                if (this.format.toLowerCase().indexOf("f") == this.format.length() - 1 && this.format.toLowerCase().indexOf("f") > 0 || this.format.toLowerCase().indexOf("e") == this.format.length() - 1 && this.format.toLowerCase().indexOf("e") > 0) {
                    try {
                        int n = Integer.parseInt(this.format.substring(1, this.format.indexOf(".")));
                        int n2 = Integer.parseInt(this.format.substring(this.format.indexOf(".") + 1, this.format.length() - 1));
                        return n > n2 && n > 0 && n2 >= 0;
                    }
                    catch (Exception exception) {
                        return false;
                    }
                }
                return false;
            }
            return false;
        }
        return false;
    }

    public Dimension getDigitSize() {
        return this.dz;
    }

    public void setButtonColor(Color color) {
        if (!this.editable) {
            return;
        }
        this.buttonBackground = color;
        for (int i = 0; i < this.nbButton; ++i) {
            this.buttons_up[i].setBackground(this.buttonBackground);
            this.buttons_down[i].setBackground(this.buttonBackground);
        }
    }

    public Color getButtonColor() {
        return this.buttonBackground;
    }

    public void setSelButtonColor(Color color) {
        this.selectionColor = color;
    }

    public Color getSelButtonColor() {
        return this.selectionColor;
    }

    public void setMaxValue(double d) {
        if (this.format.indexOf(101) == -1) {
            this.maxValue = d;
            this.updateButtonVisibility();
        }
    }

    public void setEnabled(boolean bl) {
        int n;
        super.setEnabled(bl);
        if (this.buttons_up == null || this.buttons_down == null) {
            return;
        }
        for (n = 0; n < this.buttons_up.length; ++n) {
            this.buttons_up[n].setEnabled(bl);
        }
        for (n = 0; n < this.buttons_down.length; ++n) {
            this.buttons_down[n].setEnabled(bl);
        }
    }

    public void setMinValue(double d) {
        if (this.format.indexOf(101) == -1) {
            this.minValue = d;
            this.updateButtonVisibility();
        }
    }

    public void setFormat(String string) {
        String string2 = this.format;
        double d = this.value;
        this.format = string;
        if (!this.isGoodFormat()) {
            System.out.println("WheelSwitch: Invalid format \"" + this.format + "\": use %x.yf, %x.yF, %x.ye, %x.yE, %xd or %xD");
            this.format = string2;
            System.out.println("==> WheelSwitch: format used instead: " + this.format);
            return;
        }
        this.format = this.format.toLowerCase();
        String string3 = this.format.replace('.', '_');
        string3 = string3.replace('%', '0');
        string3 = string3.substring(0, string3.length() - 1);
        String[] stringArray = string3.split("_");
        try {
            if (stringArray.length == 2) {
                int n = Integer.parseInt(stringArray[0]);
                int n2 = Integer.parseInt(stringArray[1]);
                if (this.format.indexOf(101) != -1) {
                    String string4 = Format.sprintf(this.format, new Object[]{new Double(this.value)});
                    if (string4 != null) {
                        this.reformat(string4, n - n2, n2);
                    } else {
                        System.out.println("WheelSwitch: Invalid format \"" + this.format + "\": use %x.yf, %x.yF, %x.ye, %x.yE, %xd or %xD");
                        this.format = string2;
                        this.value = d;
                    }
                } else {
                    this.setPrecision(n - n2, n2, 0);
                }
            } else if (stringArray.length == 1) {
                int n = Integer.parseInt(stringArray[0]);
                this.setPrecision(n, 0, 0);
            }
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("WheelSwitch: Invalid format \"" + this.format + "\": use %x.yf, %x.yF, %x.ye, %x.yE, %xd or %xD");
            this.format = string2;
            this.value = d;
        }
    }

    private void reformat(String string, int n, int n2) {
        String string2 = string.toLowerCase();
        int n3 = string2.indexOf(101);
        int n4 = string2.lastIndexOf(43);
        int n5 = string2.lastIndexOf(45);
        if (n4 > n3) {
            n3 = n4;
        } else if (n5 > n3) {
            n3 = n5;
        }
        string2 = string2.substring(n3 + 1, string2.length());
        this.setPrecision(n, n2, string2.length());
    }

    public synchronized void setPrecision(int n, int n2, int n3) {
        int n4;
        int n5 = this.nbButton;
        this.nbButton = 0;
        if (this.editable) {
            for (n4 = 0; n4 < n5; ++n4) {
                this.remove(this.buttons_up[n4]);
                this.remove(this.buttons_down[n4]);
                this.buttons_up[n4] = null;
                this.buttons_down[n4] = null;
            }
        }
        this.intNumber = n;
        if (this.intNumber < 1) {
            this.intNumber = 1;
        }
        this.fracNumber = n2;
        if (this.fracNumber < 0) {
            this.fracNumber = 0;
        }
        this.expNumber = n3;
        if (this.expNumber < 0) {
            this.expNumber = 0;
        }
        n5 = this.intNumber + this.fracNumber + this.expNumber;
        if (this.editable) {
            this.buttons_up = new JArrowButton[n5];
            this.buttons_down = new JArrowButton[n5];
        }
        if (this.expNumber == 0) {
            this.maxValue = Math.pow(10.0, this.intNumber);
            this.minValue = -Math.pow(10.0, this.intNumber);
        } else {
            this.maxValue = Double.MAX_VALUE;
            this.minValue = -1.7976931348623157E308;
        }
        for (n4 = 0; n4 < n5 && this.editable; ++n4) {
            this.buttons_up[n4] = new JArrowButton();
            this.add(this.buttons_up[n4]);
            this.buttons_up[n4].addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent mouseEvent) {
                    WheelSwitch.this.clickUp(mouseEvent);
                }
            });
            this.buttons_down[n4] = new JArrowButton();
            this.add(this.buttons_down[n4]);
            this.buttons_down[n4].setOrientation(JArrowButton.DOWN);
            this.buttons_down[n4].addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent mouseEvent) {
                    WheelSwitch.this.clickDown(mouseEvent);
                }
            });
        }
        double d = 0.0;
        double d2 = 0.0;
        if (this.format.indexOf(101) > 0) {
            d = this.getFloatPart();
            d2 = this.getExpPart();
        } else {
            d = this.value;
        }
        this.setValue(this.near(d) * Math.pow(10.0, d2));
        this.nbButton = n5;
        this.selButton = n5 - 1;
        this.placeComponents();
        this.updateButtonFocus();
        this.repaint();
    }

    private boolean hasBorder() {
        return this.getBorder() != null;
    }

    private void clickUp(MouseEvent mouseEvent) {
        if (!this.isEnabled()) {
            return;
        }
        int n = 0;
        boolean bl = false;
        this.grabFocus();
        if (Double.isNaN(this.value)) {
            return;
        }
        while (n < this.nbButton && !bl) {
            bl = mouseEvent.getSource() == this.buttons_up[n];
            if (bl) continue;
            ++n;
        }
        if (!this.editMode && bl) {
            this.increaseValue(n);
            this.selButton = n;
            this.updateButtonFocus();
            this.repaint();
        }
    }

    private void clickDown(MouseEvent mouseEvent) {
        if (!this.isEnabled()) {
            return;
        }
        int n = 0;
        boolean bl = false;
        this.grabFocus();
        if (Double.isNaN(this.value)) {
            return;
        }
        while (n < this.nbButton && !bl) {
            bl = mouseEvent.getSource() == this.buttons_down[n];
            if (bl) continue;
            ++n;
        }
        if (!this.editMode && bl) {
            this.decreaseValue(n);
            this.selButton = n;
            this.updateButtonFocus();
            this.repaint();
        }
    }

    private void computeDigitSize() {
        int n = 0;
        int n2 = 0;
        if (this.dz == null) {
            String[] stringArray = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "E", "+", "-", " "};
            for (int i = 0; i < stringArray.length; ++i) {
                Dimension dimension = ATKGraphicsUtils.measureString(stringArray[i], this.getFont());
                int n3 = dimension.width + 1;
                if (n3 <= n) continue;
                n = n3;
            }
            n2 = (int)ATKGraphicsUtils.getLineMetrics("0123456789E+- ", this.getFont()).getAscent() + 1;
            this.dz = new Dimension(n, n2);
        }
    }

    private double near(double d) {
        double d2 = Math.pow(10.0, this.fracNumber);
        return Math.rint(d * d2) / d2;
    }

    private String getDigit(int n) {
        if (Double.isNaN(this.value)) {
            return "X";
        }
        String string = this.isGoodFormat() ? Format.sprintf(this.format, new Object[]{new Double(this.value)}) : Double.toString(this.value);
        if (string == null) {
            return "X";
        }
        string = string.toLowerCase();
        string = string.replaceAll("\\-", "");
        string = string.replaceAll("\\+", "");
        string = string.replaceAll(" ", "");
        String string2 = "";
        string2 = this.format.indexOf(100) != -1 ? string : string.substring(0, string.indexOf(46));
        if (n < this.intNumber) {
            if (string2.length() < this.intNumber) {
                if (n < this.intNumber - string2.length()) {
                    return "0";
                }
                return string2.substring(n + string2.length() - this.intNumber, n + 1 + string2.length() - this.intNumber);
            }
            if (string2.length() == this.intNumber) {
                return string2.substring(n, n + 1);
            }
            int n2 = string2.length() - this.intNumber;
            return string2.substring(n + n2, n + n2 + 1);
        }
        if (n < this.intNumber + this.fracNumber) {
            return string.substring(n + 1 + string2.length() - this.intNumber, n + 2 + string2.length() - this.intNumber);
        }
        int n3 = string.indexOf(101);
        return string.substring(n + n3 + 1 - this.intNumber - this.fracNumber, n + n3 + 2 - this.intNumber - this.fracNumber);
    }

    protected void paintComponent(Graphics graphics) {
        Serializable serializable;
        int n = this.getWidth();
        int n2 = this.getHeight();
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        graphics.setPaintMode();
        this.computeDigitSize();
        if (this.isOpaque()) {
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, n, n2);
        }
        graphics.setColor(this.getForeground());
        graphics.setFont(this.getFont());
        if (this.editMode) {
            serializable = this.getFontMetrics(this.getFont());
            Rectangle2D rectangle2D = serializable.getStringBounds(this.editValue, graphics);
            int n3 = (n - (int)rectangle2D.getWidth()) / 2;
            graphics.drawString(this.editValue, n3, this.off_y + this.dz.width + this.dz.height - 2);
        } else {
            int n4 = this.editable ? this.off_y + this.dz.width + this.dz.height - 2 : this.off_y + this.dz.height - 2;
            if (this.value < 0.0) {
                graphics.drawString("-", this.off_x, n4);
            }
            if (this.fracNumber > 0) {
                graphics.drawString(".", this.off_x + (this.intNumber + 1) * this.dz.width + 2, n4);
            }
            if (this.expNumber > 0) {
                graphics.drawString("E", this.off_x + (this.intNumber + this.fracNumber + 2) * this.dz.width + 2, n4);
                String string = "" + this.getExpPart();
                if (string != null) {
                    String string2 = string.substring(0, 1);
                    if (!"-".equals(string2)) {
                        string2 = "+";
                    }
                    graphics.drawString(string2, this.off_x + (this.intNumber + this.fracNumber + 3) * this.dz.width + 2, n4);
                }
            }
            for (int i = 0; i < this.nbButton; ++i) {
                int n5 = i < this.intNumber ? this.off_x + (i + 1) * this.dz.width : (i < this.intNumber + this.fracNumber ? this.off_x + (i + 2) * this.dz.width : this.off_x + (i + 4) * this.dz.width);
                graphics.drawString(this.getDigit(i), n5, n4);
            }
        }
        if (this.hasFocus() && this.editable) {
            serializable = this.hasBorder() ? this.getInsets() : new Insets(1, 1, 1, 1);
            graphics.setColor(defaultSelectionColor);
            graphics.drawLine(((Insets)serializable).left + 1, ((Insets)serializable).top + 1, n - ((Insets)serializable).right - 1, ((Insets)serializable).top + 1);
            graphics.drawLine(n - ((Insets)serializable).right - 1, ((Insets)serializable).top + 1, n - ((Insets)serializable).right - 1, n2 - ((Insets)serializable).bottom - 1);
            graphics.drawLine(n - ((Insets)serializable).right - 1, n2 - ((Insets)serializable).bottom - 1, ((Insets)serializable).left + 1, n2 - ((Insets)serializable).bottom - 1);
            graphics.drawLine(((Insets)serializable).left + 1, n2 - ((Insets)serializable).bottom - 1, ((Insets)serializable).left + 1, ((Insets)serializable).top + 1);
        }
    }

    public void addWheelSwitchListener(IWheelSwitchListener iWheelSwitchListener) {
        this.listenerList.add(IWheelSwitchListener.class, iWheelSwitchListener);
    }

    public void removeWheelSwitchListener(IWheelSwitchListener iWheelSwitchListener) {
        this.listenerList.remove(IWheelSwitchListener.class, iWheelSwitchListener);
    }

    private Double getExpPart() {
        int n = this.format.indexOf(101);
        if (n == -1) {
            return null;
        }
        String string = Format.sprintf(this.format, new Object[]{new Double(this.value)});
        if (string != null) {
            string = string.toLowerCase();
            return Double.valueOf(string.substring(string.indexOf(101) + 1));
        }
        return null;
    }

    private Double getFloatPart() {
        int n = this.format.indexOf(101);
        if (n == -1) {
            return new Double(this.value);
        }
        String string = Format.sprintf(this.format, new Object[]{new Double(this.value)});
        if (string != null) {
            string = string.toLowerCase();
            return Double.valueOf(string.substring(0, string.indexOf(101)));
        }
        return null;
    }

    private void fireValueChange() {
        IWheelSwitchListener[] iWheelSwitchListenerArray = (IWheelSwitchListener[])this.listenerList.getListeners(IWheelSwitchListener.class);
        WheelSwitchEvent wheelSwitchEvent = new WheelSwitchEvent(this, this.value);
        for (int i = 0; i < iWheelSwitchListenerArray.length; ++i) {
            iWheelSwitchListenerArray[i].valueChange(wheelSwitchEvent);
        }
    }

    private void updateButtonFocus() {
        if (!this.isEnabled()) {
            return;
        }
        if (!this.editable) {
            return;
        }
        for (int i = 0; i < this.nbButton; ++i) {
            if (i == this.selButton && this.hasFocus()) {
                this.buttons_up[i].setBackground(this.selectionColor);
                this.buttons_down[i].setBackground(this.selectionColor);
                continue;
            }
            this.buttons_up[i].setBackground(this.buttonBackground);
            this.buttons_down[i].setBackground(this.buttonBackground);
        }
    }

    private void increaseValue(int n) {
        double d = 0.0;
        double d2 = 0.0;
        if (this.format.indexOf(101) > 0) {
            d = this.getFloatPart();
            d2 = this.getExpPart();
        } else {
            d = this.value;
        }
        if (n < this.intNumber + this.fracNumber) {
            d = this.incrementeValue(d, n, this.intNumber);
        } else {
            int n2 = n - this.intNumber - this.fracNumber;
            d2 = this.incrementeValue(d2, n2, this.expNumber);
        }
        double d3 = this.near(d) * Math.pow(10.0, d2);
        if (!Double.isNaN(d3)) {
            if (d3 <= this.maxValue && d3 >= this.minValue) {
                this.setValue(d3);
                if (this.format.indexOf(101) > 0) {
                    this.reformat(Format.sprintf(this.format, new Object[]{new Double(this.value)}), this.intNumber, this.fracNumber);
                }
            }
            this.fireValueChange();
        }
        this.updateButtonVisibility();
    }

    private double incrementeValue(double d, int n, int n2) {
        double d2 = d + Math.pow(10.0, n2 - n - 1);
        return d2;
    }

    private double decrementeValue(double d, int n, int n2) {
        double d2 = d - Math.pow(10.0, n2 - n - 1);
        return d2;
    }

    private void decreaseValue(int n) {
        double d = 0.0;
        double d2 = 0.0;
        if (this.format.indexOf(101) > 0) {
            d = this.getFloatPart();
            d2 = this.getExpPart();
        } else {
            d = this.value;
        }
        if (n < this.intNumber + this.fracNumber) {
            d = this.decrementeValue(d, n, this.intNumber);
        } else {
            int n2 = n - (this.intNumber + this.fracNumber);
            d2 = this.decrementeValue(d2, n2, this.expNumber);
        }
        double d3 = this.near(d) * Math.pow(10.0, d2);
        if (!Double.isNaN(d3)) {
            if (d3 <= this.maxValue && d3 >= this.minValue) {
                this.setValue(d3);
                if (this.format.indexOf(101) > 0) {
                    this.reformat(Format.sprintf(this.format, new Object[]{new Double(this.value)}), this.intNumber, this.fracNumber);
                }
            }
            this.fireValueChange();
        }
        this.updateButtonVisibility();
    }

    private void processKey(KeyEvent keyEvent) {
        char c2 = keyEvent.getKeyChar();
        int n = keyEvent.getKeyCode();
        if (!this.editMode && this.nbButton > 0) {
            switch (n) {
                case 39: {
                    ++this.selButton;
                    if (this.selButton >= this.nbButton) {
                        this.selButton = this.nbButton - 1;
                    }
                    this.updateButtonFocus();
                    this.repaint();
                    break;
                }
                case 37: {
                    --this.selButton;
                    if (this.selButton < 0) {
                        this.selButton = 0;
                    }
                    this.updateButtonFocus();
                    this.repaint();
                    break;
                }
                case 38: {
                    this.increaseValue(this.selButton);
                    this.repaint();
                    break;
                }
                case 40: {
                    this.decreaseValue(this.selButton);
                    this.repaint();
                }
            }
        }
        if (c2 >= '0' && c2 <= '9' || c2 == '.' || c2 == '-') {
            this.editValue = this.editValue + c2;
            this.editMode = true;
            this.repaint();
        }
        if (!(c2 != 'e' && c2 != 'E' || this.editValue.toLowerCase().indexOf(101) != -1 || "".equals(this.editValue))) {
            this.editValue = this.editValue + c2;
            this.editMode = true;
            this.repaint();
        }
        if (n == 12 || n == 3 || n == 27) {
            this.editValue = "";
            this.editMode = false;
            this.repaint();
        }
        if (this.editMode && this.editValue.length() > 0 && (n == 8 || n == 127)) {
            this.editValue = this.editValue.substring(0, this.editValue.length() - 1);
            this.repaint();
        }
        if (n == 10) {
            if (this.editMode) {
                try {
                    double d = Double.parseDouble(this.editValue);
                    if (d <= this.maxValue && d >= this.minValue) {
                        this.value = d;
                        this.updateButtonVisibility();
                        this.fireValueChange();
                        this.editValue = "";
                        this.editMode = false;
                        this.repaint();
                    } else {
                        String string = "Warning, value is out of the range [" + this.minValue + "," + this.maxValue + "]\nCancel editing ?";
                        int n2 = JOptionPane.showConfirmDialog(this, string, "[WheelSwitch error]", 0);
                        if (n2 == 0) {
                            this.editValue = "";
                            this.editMode = false;
                            this.repaint();
                        }
                    }
                }
                catch (NumberFormatException numberFormatException) {}
            } else {
                this.fireValueChange();
                this.repaint();
            }
        }
    }

    private void updateButtonVisibility() {
        if (this.editable && this.format.indexOf(101) == -1) {
            for (int i = 0; i < this.nbButton; ++i) {
                double d = this.incrementeValue(this.value, i, this.intNumber);
                this.buttons_up[i].setVisible(d <= this.maxValue);
                d = this.decrementeValue(this.value, i, this.intNumber);
                this.buttons_down[i].setVisible(d >= this.minValue);
            }
        }
    }

    private synchronized void placeComponents() {
        this.computeDigitSize();
        Dimension dimension = this.getSize();
        int n = this.expNumber > 0 ? this.dz.width * (this.nbButton + 4) : (this.fracNumber > 0 ? this.dz.width * (this.nbButton + 2) : this.dz.width * (this.nbButton + 1));
        int n2 = this.editable ? this.dz.height + 2 * this.dz.width : this.dz.height;
        this.off_x = (dimension.width - n) / 2;
        this.off_y = (dimension.height - n2) / 2;
        for (int i = 0; i < this.nbButton && this.editable; ++i) {
            int n3 = i < this.intNumber ? this.off_x + (i + 1) * this.dz.width + 1 : (i < this.intNumber + this.fracNumber ? this.off_x + (i + 2) * this.dz.width + 1 : this.off_x + (i + 4) * this.dz.width + 1);
            this.buttons_up[i].setBounds(n3, this.off_y + 2, this.dz.width - 2, this.dz.width - 2);
            int n4 = this.dz.width + this.dz.height + this.off_y;
            this.buttons_down[i].setBounds(n3, n4, this.dz.width - 2, this.dz.width - 2);
        }
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        WheelSwitch wheelSwitch = new WheelSwitch();
        WheelSwitch wheelSwitch2 = new WheelSwitch();
        WheelSwitch wheelSwitch3 = new WheelSwitch();
        WheelSwitch wheelSwitch4 = new WheelSwitch();
        WheelSwitch wheelSwitch5 = new WheelSwitch();
        WheelSwitch wheelSwitch6 = new WheelSwitch();
        WheelSwitch wheelSwitch7 = new WheelSwitch();
        wheelSwitch.setFormat("%4.3e");
        wheelSwitch.setButtonColor(Color.RED);
        wheelSwitch.setValue(-42.9995);
        wheelSwitch.addWheelSwitchListener(new IWheelSwitchListener(){

            public void valueChange(WheelSwitchEvent wheelSwitchEvent) {
                System.out.println("Value changed ws1:" + wheelSwitchEvent.getValue());
            }
        });
        wheelSwitch2.setFormat("%6.0f");
        wheelSwitch2.setButtonColor(Color.GREEN);
        wheelSwitch2.setValue(-12.5);
        wheelSwitch2.setMaxValue(75.0);
        wheelSwitch2.setMinValue(-25.0);
        wheelSwitch2.setFont(new Font("Dialog", 1, 50));
        wheelSwitch2.addWheelSwitchListener(new IWheelSwitchListener(){

            public void valueChange(WheelSwitchEvent wheelSwitchEvent) {
                System.out.println("Value changed ws2:" + wheelSwitchEvent.getValue());
            }
        });
        wheelSwitch3.setFormat("%6d");
        wheelSwitch3.setButtonColor(Color.BLUE);
        wheelSwitch3.setValue(48.0);
        wheelSwitch3.setFont(new Font("Lucida Bright", 1, 30));
        wheelSwitch3.setBorder(BorderFactory.createEtchedBorder());
        wheelSwitch3.addWheelSwitchListener(new IWheelSwitchListener(){

            public void valueChange(WheelSwitchEvent wheelSwitchEvent) {
                System.out.println("Value changed ws3:" + wheelSwitchEvent.getValue());
            }
        });
        wheelSwitch4.setFormat("%6.3s");
        wheelSwitch4.setButtonColor(new Color(100, 200, 160));
        wheelSwitch4.setValue(28.1);
        wheelSwitch4.setFont(new Font("Lucida Bright", 1, 12));
        wheelSwitch4.setBorder(BorderFactory.createEtchedBorder());
        wheelSwitch4.addWheelSwitchListener(new IWheelSwitchListener(){

            public void valueChange(WheelSwitchEvent wheelSwitchEvent) {
                System.out.println("Value changed ws4:" + wheelSwitchEvent.getValue());
            }
        });
        wheelSwitch5.setFormat("%5.2e");
        wheelSwitch5.setButtonColor(new Color(100, 0, 0));
        wheelSwitch5.setValue(Double.NaN);
        wheelSwitch5.setFont(new Font("Dialog", 0, 16));
        wheelSwitch5.addWheelSwitchListener(new IWheelSwitchListener(){

            public void valueChange(WheelSwitchEvent wheelSwitchEvent) {
                System.out.println("Value changed ws5:" + wheelSwitchEvent.getValue());
            }
        });
        wheelSwitch6.setFormat("%5.2f");
        wheelSwitch6.setButtonColor(new Color(0, 100, 0));
        wheelSwitch6.setValue(Double.NaN);
        wheelSwitch6.setFont(new Font("Dialog", 0, 16));
        wheelSwitch6.addWheelSwitchListener(new IWheelSwitchListener(){

            public void valueChange(WheelSwitchEvent wheelSwitchEvent) {
                System.out.println("Value changed ws6:" + wheelSwitchEvent.getValue());
            }
        });
        wheelSwitch7.setFormat("%5d");
        wheelSwitch7.setButtonColor(new Color(0, 0, 100));
        wheelSwitch7.setValue(Double.NaN);
        wheelSwitch7.setFont(new Font("Dialog", 0, 16));
        wheelSwitch7.addWheelSwitchListener(new IWheelSwitchListener(){

            public void valueChange(WheelSwitchEvent wheelSwitchEvent) {
                System.out.println("Value changed ws7:" + wheelSwitchEvent.getValue());
            }
        });
        JButton jButton = new JButton("OK");
        jButton.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                System.exit(0);
            }
        });
        jFrame.getContentPane().setBackground(Color.white);
        jFrame.getContentPane().setLayout(new FlowLayout());
        jFrame.getContentPane().add(wheelSwitch);
        jFrame.getContentPane().add(wheelSwitch2);
        jFrame.getContentPane().add(wheelSwitch3);
        jFrame.getContentPane().add(wheelSwitch4);
        jFrame.getContentPane().add(wheelSwitch5);
        jFrame.getContentPane().add(wheelSwitch6);
        jFrame.getContentPane().add(wheelSwitch7);
        jFrame.getContentPane().add(jButton);
        jFrame.pack();
        jFrame.setVisible(true);
        jFrame.setDefaultCloseOperation(3);
    }
}

