/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.AttributeInfo;
import fr.esrf.TangoApi.CommandInfo;
import fr.esrf.tangoatk.core.ConnectionException;
import fr.esrf.tangoatk.core.Device;
import fr.esrf.tangoatk.core.DeviceFactory;
import fr.esrf.tangoatk.widget.util.EntityNode;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import fr.esrf.tangoatk.widget.util.Node;

class MemberNode
extends Node {
    private String domain;
    private String family;
    private String member;

    MemberNode(int n, String string, String string2, String string3) {
        this.mode = n;
        this.domain = string;
        this.family = string2;
        this.member = string3;
    }

    void populateNode() throws DevFailed {
        if (!this.isLeaf()) {
            String string = this.domain + "/" + this.family + "/" + this.member;
            try {
                Device device = DeviceFactory.getInstance().getDevice(string);
                switch (this.mode) {
                    case 1: {
                        String[] stringArray = device.get_attribute_list();
                        for (int i = 0; i < stringArray.length; ++i) {
                            this.add(new EntityNode(this.mode, stringArray[i]));
                        }
                        break;
                    }
                    case 3: {
                        AttributeInfo[] attributeInfoArray = device.get_attribute_info();
                        for (int i = 0; i < attributeInfoArray.length; ++i) {
                            if (attributeInfoArray[i].data_format.value() != 0) continue;
                            this.add(new EntityNode(this.mode, attributeInfoArray[i].name));
                        }
                        attributeInfoArray = null;
                        break;
                    }
                    case 5: {
                        AttributeInfo[] attributeInfoArray = device.get_attribute_info();
                        for (int i = 0; i < attributeInfoArray.length; ++i) {
                            if (attributeInfoArray[i].data_format.value() != 0 || attributeInfoArray[i].data_type != 1) continue;
                            this.add(new EntityNode(this.mode, attributeInfoArray[i].name));
                        }
                        attributeInfoArray = null;
                        break;
                    }
                    case 4: {
                        AttributeInfo[] attributeInfoArray = device.get_attribute_info();
                        for (int i = 0; i < attributeInfoArray.length; ++i) {
                            if (attributeInfoArray[i].data_format.value() != 0) continue;
                            switch (attributeInfoArray[i].data_type) {
                                case 2: 
                                case 3: 
                                case 4: 
                                case 5: 
                                case 6: 
                                case 7: 
                                case 21: 
                                case 22: {
                                    this.add(new EntityNode(this.mode, attributeInfoArray[i].name));
                                }
                            }
                        }
                        attributeInfoArray = null;
                        break;
                    }
                    case 7: {
                        AttributeInfo[] attributeInfoArray = device.get_attribute_info();
                        for (int i = 0; i < attributeInfoArray.length; ++i) {
                            if (attributeInfoArray[i].data_format.value() != 1) continue;
                            switch (attributeInfoArray[i].data_type) {
                                case 2: 
                                case 3: 
                                case 4: 
                                case 5: 
                                case 6: 
                                case 7: 
                                case 21: 
                                case 22: {
                                    this.add(new EntityNode(this.mode, attributeInfoArray[i].name));
                                }
                            }
                        }
                        Object var6_11 = null;
                        break;
                    }
                    case 6: {
                        AttributeInfo[] attributeInfoArray = device.get_attribute_info();
                        for (int i = 0; i < attributeInfoArray.length; ++i) {
                            if (attributeInfoArray[i].data_format.value() != 0 || attributeInfoArray[i].data_type != 8) continue;
                            this.add(new EntityNode(this.mode, attributeInfoArray[i].name));
                        }
                        attributeInfoArray = null;
                        break;
                    }
                    case 2: {
                        CommandInfo[] commandInfoArray = device.command_list_query();
                        for (int i = 0; i < commandInfoArray.length; ++i) {
                            this.add(new EntityNode(this.mode, commandInfoArray[i].cmd_name));
                        }
                        break;
                    }
                    case 8: {
                        AttributeInfo[] attributeInfoArray = device.get_attribute_info();
                        for (int i = 0; i < attributeInfoArray.length; ++i) {
                            if (attributeInfoArray[i].data_format.value() == 0 && attributeInfoArray[i].data_type == 1) {
                                this.add(new EntityNode(this.mode, attributeInfoArray[i].name));
                            }
                            if (attributeInfoArray[i].data_format.value() != 0) continue;
                            switch (attributeInfoArray[i].data_type) {
                                case 2: 
                                case 3: 
                                case 4: 
                                case 5: 
                                case 6: 
                                case 7: 
                                case 21: 
                                case 22: {
                                    this.add(new EntityNode(this.mode, attributeInfoArray[i].name));
                                }
                            }
                        }
                        attributeInfoArray = null;
                    }
                }
            }
            catch (ConnectionException connectionException) {
                ErrorPane.showErrorMessage(null, string, connectionException);
            }
        }
    }

    public boolean isLeaf() {
        return this.mode == 0;
    }

    public String toString() {
        return this.member;
    }
}

