/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util;

import fr.esrf.tangoatk.widget.util.ATKConstant;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.J3DTrendListener;
import fr.esrf.tangoatk.widget.util.chart.JLAxis;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;

public class J3DTrend
extends JComponent
implements MouseListener,
MouseMotionListener,
KeyListener {
    protected BufferedImage theImage = null;
    protected Insets margin;
    protected int xOrg;
    protected int yOrg;
    protected JLAxis xAxis;
    protected int xAxisHeight;
    protected int xAxisUpMargin;
    protected JLAxis yAxis;
    protected int yAxisWidth;
    protected int yAxisRightMargin;
    private boolean cursorEnabled;
    private int xCursor;
    private int yCursor;
    private int xCursorInc;
    private int yCursorInc;
    J3DTrendListener parent;

    public J3DTrend() {
        this.setLayout(null);
        this.setBorder(null);
        this.setBackground(new Color(180, 180, 200));
        this.setOpaque(true);
        this.setMargin(new Insets(5, 5, 5, 5));
        this.yAxis = new JLAxis(this, 6);
        this.yAxis.setAxisColor(Color.BLACK);
        this.yAxis.setFont(ATKConstant.labelFont);
        this.yAxis.setAutoScale(false);
        this.yAxis.setVisible(true);
        this.yAxis.setInverted(false);
        this.xAxis = new JLAxis(this, 1);
        this.xAxis.setAxisColor(Color.BLACK);
        this.xAxis.setFont(ATKConstant.labelFont);
        this.xAxis.setAutoScale(false);
        this.xAxis.setVisible(true);
        this.xAxis.setAnnotation(2);
        this.cursorEnabled = true;
        this.xCursorInc = 1;
        this.yCursorInc = 1;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addKeyListener(this);
        this.parent = null;
    }

    public JLAxis getYAxis() {
        return this.yAxis;
    }

    public JLAxis getXAxis() {
        return this.xAxis;
    }

    public void setMargin(Insets insets) {
        this.margin = insets;
    }

    public void setCursorEnabled(boolean bl) {
        this.cursorEnabled = bl;
        this.repaint();
    }

    public void setParent(J3DTrendListener j3DTrendListener) {
        this.parent = j3DTrendListener;
    }

    protected void measureAxis() {
        this.xAxisHeight = 0;
        this.yAxisWidth = 0;
        this.xAxisUpMargin = 0;
        this.yAxisRightMargin = 0;
        if (this.xAxis.isVisible()) {
            this.xAxis.measureAxis(ATKGraphicsUtils.getDefaultRenderContext(), this.theImage.getWidth(), 0);
            if (this.xAxis.getOrientation() == 2) {
                this.xAxisHeight = 7;
                this.xAxisUpMargin = this.xAxis.getThickness();
            } else {
                this.xAxisHeight = this.xAxis.getThickness();
                this.xAxisUpMargin = 7;
            }
        }
        if (this.yAxis.isVisible()) {
            this.yAxis.measureAxis(ATKGraphicsUtils.getDefaultRenderContext(), 0, this.theImage.getHeight());
            this.yAxisWidth = this.yAxis.getThickness();
            this.yAxisRightMargin = 15;
        }
    }

    public Dimension getMinimumSize() {
        if (this.theImage == null) {
            return new Dimension(320, 200);
        }
        this.measureAxis();
        int n = this.theImage.getWidth() + this.margin.right + this.margin.left + this.yAxisWidth + this.yAxisRightMargin;
        int n2 = this.theImage.getHeight() + this.margin.top + this.margin.bottom + this.xAxisHeight + this.xAxisUpMargin;
        return new Dimension(n, n2);
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public void setImage(BufferedImage bufferedImage, int n, int n2) {
        BufferedImage bufferedImage2 = this.theImage;
        this.theImage = bufferedImage;
        this.repaint();
        if (bufferedImage2 != null) {
            bufferedImage2.flush();
        }
        bufferedImage2 = null;
        this.yAxis.setMinimum(0.0);
        this.yAxis.setMaximum(n2);
        this.xAxis.setMinimum(-n);
        this.xAxis.setMaximum(0.0);
    }

    public BufferedImage getImage() {
        return this.theImage;
    }

    public void shiftCursorX(int n) {
        this.xCursor += n;
    }

    public int getXCursor() {
        return this.xCursor;
    }

    public int getYCursor() {
        return this.yCursor;
    }

    public boolean isCursorInside() {
        if (this.theImage == null) {
            return false;
        }
        return this.yCursor >= 0 && this.yCursor < this.theImage.getHeight() && this.xCursor >= 0 && this.xCursor < this.theImage.getWidth();
    }

    public void clearCursor() {
        this.xCursor = -1;
        this.yCursor = -1;
        this.cursorMove();
    }

    protected void paintAxis(Graphics graphics) {
        if (this.yAxis.isVisible()) {
            this.yAxis.paintAxisDirect(graphics, ATKGraphicsUtils.getDefaultRenderContext(), -this.yAxis.getThickness(), 0, Color.BLACK, 0, 0);
            if (this.yAxis.isDrawOpposite()) {
                this.yAxis.paintAxisOpposite(graphics, ATKGraphicsUtils.getDefaultRenderContext(), this.theImage.getWidth() - this.yAxis.getThickness(), 0, Color.BLACK, 0, 0);
            }
        }
        if (this.xAxis.isVisible()) {
            this.xAxis.paintAxisDirect(graphics, ATKGraphicsUtils.getDefaultRenderContext(), 0, this.theImage.getHeight(), Color.BLACK, 0, 0);
            if (this.xAxis.isDrawOpposite()) {
                this.xAxis.paintAxisOpposite(graphics, ATKGraphicsUtils.getDefaultRenderContext(), 0, 0, Color.BLACK, 0, 0);
            }
        }
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        if (this.isOpaque()) {
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, dimension.width, dimension.height);
        }
        if (this.theImage == null) {
            return;
        }
        this.measureAxis();
        this.xOrg = (dimension.width - (this.theImage.getWidth() + this.yAxisWidth + this.yAxisRightMargin)) / 2;
        this.yOrg = (dimension.height - (this.theImage.getHeight() + this.xAxisHeight + this.xAxisUpMargin)) / 2;
        graphics.translate(this.xOrg + this.yAxisWidth, this.yOrg + this.xAxisUpMargin);
        graphics.drawImage(this.theImage, 0, 0, null);
        this.paintAxis(graphics);
        if (this.cursorEnabled && this.isCursorInside()) {
            graphics.setColor(Color.WHITE);
            graphics.drawLine(0, this.yCursor, this.theImage.getWidth(), this.yCursor);
            graphics.drawLine(this.xCursor, 0, this.xCursor, this.theImage.getHeight());
        }
    }

    public void cursorMove() {
        if (this.parent != null) {
            if (this.isCursorInside()) {
                this.parent.updateCursor(this.xCursor, this.yCursor);
            } else {
                this.parent.updateCursor(-1, -1);
            }
        }
        this.repaint();
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.cursorEnabled) {
            this.xCursor = mouseEvent.getX() - this.xOrg - this.yAxisWidth;
            this.yCursor = mouseEvent.getY() - this.yOrg - this.xAxisUpMargin;
            this.cursorMove();
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.grabFocus();
        if (this.cursorEnabled) {
            this.xCursor = mouseEvent.getX() - this.xOrg - this.yAxisWidth;
            this.yCursor = mouseEvent.getY() - this.yOrg - this.xAxisUpMargin;
            this.cursorMove();
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 38: {
                if (!this.cursorEnabled) break;
                this.yCursor -= this.yCursorInc;
                this.cursorMove();
                break;
            }
            case 40: {
                if (!this.cursorEnabled) break;
                this.yCursor += this.yCursorInc;
                this.cursorMove();
                break;
            }
            case 37: {
                if (!this.cursorEnabled) break;
                this.xCursor -= this.xCursorInc;
                this.cursorMove();
                break;
            }
            case 39: {
                if (!this.cursorEnabled) break;
                this.xCursor += this.xCursorInc;
                this.cursorMove();
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }
}

