/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.properties;

import fr.esrf.tangoatk.core.Property;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTextArea;

public class PropertyAreaEditor
extends JTextArea
implements MouseListener,
ActionListener,
PropertyChangeListener,
KeyListener {
    private boolean askConfirmation = false;
    private String titleAskConfirmation = "Confirmation";
    private String textAskConfirmation = "Do you want to modify the property ?";
    private String sendValueText = "Apply modification";
    private JPopupMenu sendPopupMenu = null;
    private JMenuItem sendMenu = null;
    private Property model = null;

    public PropertyAreaEditor() {
        this.addMouseListener(this);
        this.addKeyListener(this);
        try {
            this.sendPopupMenu = new JPopupMenu();
            this.sendMenu = new JMenuItem();
            this.sendPopupMenu.setDoubleBuffered(true);
            this.sendMenu.setText(this.sendValueText);
            this.sendPopupMenu.add(this.sendMenu);
            this.sendMenu.addActionListener(this);
            this.setEditable(false);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setBackground(Color color) {
        if (color == null) {
            color = Color.LIGHT_GRAY;
        }
        super.setBackground(color);
    }

    public boolean isAskConfirmation() {
        return this.askConfirmation;
    }

    public void setAskConfirmation(boolean bl) {
        this.askConfirmation = bl;
    }

    public String getTextAskConfirmation() {
        return this.textAskConfirmation;
    }

    public void setTextAskConfirmation(String string) {
        if (string.equals("")) {
            return;
        }
        this.textAskConfirmation = string;
    }

    public String getTitleAskConfirmation() {
        return this.titleAskConfirmation;
    }

    public void setTitleAskConfirmation(String string) {
        if (string.equals("")) {
            return;
        }
        this.titleAskConfirmation = string;
    }

    protected void setProperty() {
        int n;
        if (this.askConfirmation && (n = JOptionPane.showConfirmDialog(this, this.textAskConfirmation, this.titleAskConfirmation, 0)) != 0) {
            if (this.model != null) {
                this.setText(this.model.getPresentation());
            } else {
                this.setText("");
            }
            return;
        }
        if (this.model != null) {
            if (this.model.isEditable()) {
                this.model.setValueFromString(this.getText());
                this.setText(this.model.getPresentation());
                this.model.store();
            } else {
                this.setText(this.model.getPresentation());
            }
        } else {
            this.setText("");
        }
    }

    public Property getModel() {
        return this.model;
    }

    public void setModel(Property property) {
        if (this.model != null) {
            this.model.removePresentationListener(this);
        }
        this.model = property;
        if (property != null) {
            property.addPresentationListener(this);
            this.setText(property.getPresentation());
            this.setEditable(property.isEditable());
        } else {
            this.setText("");
            this.setEditable(false);
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("presentation".equals(propertyChangeEvent.getPropertyName()) && propertyChangeEvent.getSource() instanceof Property) {
            this.setText(((Property)propertyChangeEvent.getSource()).getPresentation());
            this.setEditable(((Property)propertyChangeEvent.getSource()).isEditable());
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 1 && mouseEvent.getButton() == 3) {
            this.sendPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.setProperty();
    }

    public String getSendValueText() {
        return this.sendValueText;
    }

    public void setSendValueText(String string) {
        this.sendValueText = string;
        this.sendMenu.setText(string);
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getModifiersEx() == 128 && keyEvent.getKeyCode() == 10) {
            keyEvent.consume();
            this.setProperty();
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }
}

