/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.device;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.Database;
import fr.esrf.tangoatk.core.ATKException;
import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.CommandList;
import fr.esrf.tangoatk.core.ConnectionException;
import fr.esrf.tangoatk.core.Device;
import fr.esrf.tangoatk.core.DeviceFactory;
import fr.esrf.tangoatk.core.EventSupport;
import fr.esrf.tangoatk.core.IAttribute;
import fr.esrf.tangoatk.core.ICommand;
import fr.esrf.tangoatk.core.IDevice;
import fr.esrf.tangoatk.core.IErrorListener;
import fr.esrf.tangoatk.core.IStatusListener;
import fr.esrf.tangoatk.widget.device.tree.DeviceTreeCellRenderer;
import fr.esrf.tangoatk.widget.device.tree.DomainNode;
import fr.esrf.tangoatk.widget.device.tree.FamilyNode;
import fr.esrf.tangoatk.widget.device.tree.MemberNode;
import fr.esrf.tangoatk.widget.dnd.NodeFactory;
import fr.esrf.tangoatk.widget.dnd.TransferHandler;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import java.awt.Frame;
import java.awt.event.ComponentListener;
import java.awt.event.FocusListener;
import java.awt.event.HierarchyBoundsListener;
import java.awt.event.HierarchyListener;
import java.awt.event.InputMethodListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelListener;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreePath;

public class Tree
extends JTree {
    DomainNode[] domains;
    EventSupport propChanges;
    DefaultMutableTreeNode top;

    public Tree() {
        this.initComponents();
    }

    public void refresh() {
        this.top.removeAllChildren();
        this.importFromDb();
    }

    public synchronized void removeListeners() {
        this.propChanges.removeAtkEventListeners();
        ComponentListener[] componentListenerArray = this.getComponentListeners();
        for (int i = 0; i < componentListenerArray.length; ++i) {
            this.removeComponentListener(componentListenerArray[i]);
        }
        FocusListener[] focusListenerArray = this.getFocusListeners();
        for (int i = 0; i < focusListenerArray.length; ++i) {
            this.removeFocusListener(focusListenerArray[i]);
        }
        HierarchyBoundsListener[] hierarchyBoundsListenerArray = this.getHierarchyBoundsListeners();
        for (int i = 0; i < hierarchyBoundsListenerArray.length; ++i) {
            this.removeHierarchyBoundsListener(hierarchyBoundsListenerArray[i]);
        }
        HierarchyListener[] hierarchyListenerArray = this.getHierarchyListeners();
        for (int i = 0; i < hierarchyListenerArray.length; ++i) {
            this.removeHierarchyListener(hierarchyListenerArray[i]);
        }
        InputMethodListener[] inputMethodListenerArray = this.getInputMethodListeners();
        for (int i = 0; i < inputMethodListenerArray.length; ++i) {
            this.removeInputMethodListener(inputMethodListenerArray[i]);
        }
        KeyListener[] keyListenerArray = this.getKeyListeners();
        for (int i = 0; i < keyListenerArray.length; ++i) {
            this.removeKeyListener(keyListenerArray[i]);
        }
        MouseListener[] mouseListenerArray = this.getMouseListeners();
        for (int i = 0; i < mouseListenerArray.length; ++i) {
            this.removeMouseListener(mouseListenerArray[i]);
        }
        MouseMotionListener[] mouseMotionListenerArray = this.getMouseMotionListeners();
        for (int i = 0; i < mouseMotionListenerArray.length; ++i) {
            this.removeMouseMotionListener(mouseMotionListenerArray[i]);
        }
        MouseWheelListener[] mouseWheelListenerArray = this.getMouseWheelListeners();
        for (int i = 0; i < mouseWheelListenerArray.length; ++i) {
            this.removeMouseWheelListener(mouseWheelListenerArray[i]);
        }
        PropertyChangeListener[] propertyChangeListenerArray = this.getPropertyChangeListeners();
        for (int i = 0; i < propertyChangeListenerArray.length; ++i) {
            this.removePropertyChangeListener(propertyChangeListenerArray[i]);
        }
    }

    protected void error(Exception exception) {
        this.propChanges.fireReadErrorEvent(this, exception);
    }

    public void importFromDb() {
        try {
            this.propChanges.fireStatusEvent(this, "Importing from database...");
            Database database = new Database();
            String[] stringArray = database.get_device_domain("*");
            this.addDomains(this.top, database, stringArray);
        }
        catch (DevFailed devFailed) {
            this.error(new ATKException(devFailed));
        }
        this.propChanges.fireStatusEvent(this, "Importing from database...Done");
        this.expandRow(0);
    }

    public void addErrorListener(IErrorListener iErrorListener) {
        this.propChanges.addErrorListener(iErrorListener);
    }

    public void removeErrorListener(IErrorListener iErrorListener) {
        this.propChanges.removeErrorListener(iErrorListener);
    }

    public void addStatusListener(IStatusListener iStatusListener) {
        this.propChanges.addStatusListener(iStatusListener);
    }

    public void removeStatusListener(IStatusListener iStatusListener) {
        this.propChanges.removeStatusListener(iStatusListener);
    }

    protected void initComponents() {
        this.propChanges = new EventSupport();
        this.top = new DefaultMutableTreeNode("Devices");
        this.setTransferHandler(new TransferHandler());
        this.setCellRenderer(new DeviceTreeCellRenderer(this.getCellRenderer()));
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                if (Tree.this.getPathForLocation(mouseEvent.getX(), mouseEvent.getY()) != null) {
                    Tree.this.clearSelection();
                    Tree.this.setSelectionPath(Tree.this.getPathForLocation(mouseEvent.getX(), mouseEvent.getY()));
                }
            }
        });
        ((DefaultTreeModel)this.getModel()).setRoot(this.top);
    }

    protected void addDomains(DefaultMutableTreeNode defaultMutableTreeNode, Database database, String[] stringArray) throws DevFailed {
        this.domains = new DomainNode[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            this.domains[i] = new DomainNode(string, database);
            this.addFamilies(this.domains[i], database, database.get_device_family(string + "/*"));
            defaultMutableTreeNode.add(this.domains[i]);
        }
    }

    protected void addFamilies(DomainNode domainNode, Database database, String[] stringArray) throws DevFailed {
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            String[] stringArray2 = database.get_device_member(domainNode.getName() + "/" + string + "/*");
            FamilyNode familyNode = new FamilyNode(domainNode, string, database);
            this.initialAddMembers(familyNode, database, stringArray2);
            domainNode.add(familyNode);
        }
    }

    protected void initialAddMembers(FamilyNode familyNode, Database database, String[] stringArray) throws DevFailed {
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            MemberNode memberNode = new MemberNode(familyNode, string, database);
            familyNode.add(memberNode);
        }
    }

    protected void addAttributes(DefaultMutableTreeNode defaultMutableTreeNode, AttributeList attributeList) {
        NodeFactory nodeFactory = NodeFactory.getInstance();
        for (int i = 0; i < attributeList.size(); ++i) {
            IAttribute iAttribute = (IAttribute)attributeList.get(i);
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(nodeFactory.getNode4Entity(iAttribute));
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
        }
    }

    protected void addCommands(DefaultMutableTreeNode defaultMutableTreeNode, CommandList commandList) {
        NodeFactory nodeFactory = NodeFactory.getInstance();
        for (int i = 0; i < commandList.size(); ++i) {
            ICommand iCommand = (ICommand)commandList.get(i);
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(nodeFactory.getNode4Entity(iCommand));
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
        }
    }

    protected void addMembers(FamilyNode familyNode) {
        if (familyNode.isFilled()) {
            return;
        }
        JDialog jDialog = new JDialog((Frame)null, "Importing devices on " + familyNode + "...");
        jDialog.setVisible(true);
        ATKGraphicsUtils.centerDialog(jDialog, 400, 0);
        this.propChanges.fireStatusEvent(this, "Importing devices on " + familyNode + "...");
        familyNode.setFilled(true);
        List list = familyNode.getChildren();
        Vector<Device> vector = new Vector<Device>();
        DeviceFactory deviceFactory = DeviceFactory.getInstance();
        for (int i = 0; i < list.size(); ++i) {
            String string = ((MemberNode)list.get(i)).getName();
            try {
                vector.add(deviceFactory.getDevice(string));
                continue;
            }
            catch (Exception exception) {
                familyNode.setFilled(false);
                this.error(new ConnectionException(exception));
            }
        }
        this.addDevices(familyNode, vector);
        jDialog.setVisible(false);
        jDialog = null;
        this.propChanges.fireStatusEvent(this, "Importing devices on " + familyNode + "..." + "done");
    }

    protected void addDevices(FamilyNode familyNode, List list) {
        MemberNode memberNode = null;
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        for (int i = 0; i < list.size(); ++i) {
            AttributeList attributeList = new AttributeList();
            CommandList commandList = new CommandList();
            IDevice iDevice = (IDevice)list.get(i);
            memberNode = familyNode.getChild(iDevice.getName());
            memberNode.setAttributeList(attributeList);
            memberNode.setCommandList(commandList);
            memberNode.setDevice(iDevice);
            try {
                attributeList.add(iDevice.getName() + "/*");
            }
            catch (ATKException aTKException) {
                this.error(aTKException);
            }
            if (attributeList.size() > 0) {
                defaultMutableTreeNode = new DefaultMutableTreeNode("Attributes");
                memberNode.add(defaultMutableTreeNode);
                this.addAttributes(defaultMutableTreeNode, attributeList);
            }
            try {
                commandList.add(iDevice.getName() + "/*");
            }
            catch (ConnectionException connectionException) {
                this.error(connectionException);
            }
            if (commandList.size() <= 0) continue;
            defaultMutableTreeNode2 = new DefaultMutableTreeNode("commands");
            memberNode.add(defaultMutableTreeNode2);
            this.addCommands(defaultMutableTreeNode2, commandList);
        }
    }

    public void setShowEntities(boolean bl) {
        if (!bl) {
            return;
        }
        this.addTreeWillExpandListener(new TreeWillExpandListener(){

            public void treeWillCollapse(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
            }

            public void treeWillExpand(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
                TreePath treePath = treeExpansionEvent.getPath();
                Object[] objectArray = treePath.getPath();
                if (objectArray.length == 3) {
                    DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)objectArray[2];
                    if (!(defaultMutableTreeNode instanceof FamilyNode)) {
                        return;
                    }
                    Tree.this.addMembers((FamilyNode)defaultMutableTreeNode);
                }
            }
        });
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        Tree tree = new Tree();
        tree.setShowEntities(true);
        jFrame.setContentPane(tree);
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

