/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.device;

import fr.esrf.tangoatk.core.Device;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.IDevice;
import fr.esrf.tangoatk.core.IDeviceApplication;
import fr.esrf.tangoatk.core.IStateListener;
import fr.esrf.tangoatk.core.StateEvent;
import fr.esrf.tangoatk.widget.device.IDevicePopUp;
import fr.esrf.tangoatk.widget.device.SingletonStatusViewer;
import fr.esrf.tangoatk.widget.util.ATKConstant;
import fr.esrf.tangoatk.widget.util.UIManagerHelper;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class StateViewer
extends JPanel
implements IStateListener {
    IDevice device;
    String state = "UNKNOWN";
    boolean externalSetText = false;
    boolean stateClickable = true;
    IDeviceApplication application;
    private boolean stateInTooltip = false;
    IDevicePopUp popUp = SingletonStatusViewer.getInstance();
    private JLabel textLabel;
    private JLabel valueLabel;

    public StateViewer() {
        this.initComponents();
        UIManagerHelper.setAll("StateViewer.Label", this.textLabel);
    }

    private void initComponents() {
        this.textLabel = new JLabel();
        this.valueLabel = new JLabel();
        this.setLayout(new GridBagLayout());
        this.textLabel.setText("Not Connected");
        this.textLabel.setFont(new Font("Dialog", 0, 12));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 4, 0, 3);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.1;
        this.add((Component)this.textLabel, gridBagConstraints);
        this.valueLabel.setBackground(Color.red);
        this.valueLabel.setFont(new Font("Dialog", 0, 12));
        this.valueLabel.setPreferredSize(new Dimension(40, 14));
        this.valueLabel.setOpaque(true);
        this.valueLabel.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                StateViewer.this.valueLabelMouseClicked(mouseEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 3, 0, 4);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.2;
        gridBagConstraints.weighty = 0.2;
        this.add((Component)this.valueLabel, gridBagConstraints);
    }

    protected void valueLabelMouseClicked(MouseEvent mouseEvent) {
        if ((mouseEvent.getModifiers() & 4) != 0) {
            if (this.application == null) {
                return;
            }
            this.application.setModel(this.device);
            this.application.run();
            return;
        }
        if (this.stateClickable && this.device != null) {
            this.popUp.setModel(this.device);
            this.popUp.setVisible(true);
        }
    }

    public IDevicePopUp getPopUp() {
        return this.popUp;
    }

    public void setPopUp(IDevicePopUp iDevicePopUp) {
        this.popUp = iDevicePopUp;
    }

    public void setModel(IDevice iDevice) {
        Device device;
        this.clearModel();
        if (iDevice == null) {
            return;
        }
        this.device = iDevice;
        if (this.device instanceof Device && !(device = (Device)this.device).areDevPropertiesLoaded()) {
            device.loadDevProperties();
        }
        this.setState(this.device.getState());
        if (!this.externalSetText) {
            this.textLabel.setText(this.device.getName());
        }
        this.valueLabel.setToolTipText(this.device.getName());
    }

    public void clearModel() {
        if (this.device != null) {
            this.device.removeStateListener(this);
            this.textLabel.setText("Not Connected");
            this.state = "UNKNOWN";
            this.device = null;
        }
    }

    public JLabel getTextLabel() {
        return this.textLabel;
    }

    public JLabel getValueLabel() {
        return this.valueLabel;
    }

    public IDevice getModel() {
        return this.device;
    }

    private void setState(String string) {
        this.state = string;
        this.valueLabel.setBackground(ATKConstant.getColor4State(string, this.device.getInvertedOpenClose(), this.device.getInvertedInsertExtract()));
        if (this.stateInTooltip && this.device != null) {
            this.valueLabel.setToolTipText(this.device.getName() + " : " + string);
        }
    }

    public String getState() {
        return this.state;
    }

    public void setLabel(String string) {
        this.externalSetText = true;
        this.textLabel.setText(string);
    }

    public String getLabel() {
        return this.textLabel.getText();
    }

    public void setLabelVisible(boolean bl) {
        this.textLabel.setVisible(bl);
    }

    public boolean isLabelVisible() {
        return this.textLabel.isVisible();
    }

    public void setStateVisible(boolean bl) {
        this.valueLabel.setVisible(bl);
    }

    public boolean isStateVisible() {
        return this.valueLabel.isVisible();
    }

    public void stateChange(StateEvent stateEvent) {
        this.setState(stateEvent.getState());
    }

    public void errorChange(ErrorEvent errorEvent) {
        this.setState("UNKNOWN");
    }

    public void setStateText(String string) {
        this.valueLabel.setText(string);
    }

    public String getStateText() {
        return this.valueLabel.getText();
    }

    public void setStateFont(Font font) {
        this.valueLabel.setFont(font);
    }

    public void setFont(Font font) {
        if (this.valueLabel != null) {
            this.valueLabel.setFont(font);
        }
        if (this.textLabel != null) {
            this.textLabel.setFont(font);
        }
        super.setFont(font);
    }

    public Font getStateFont() {
        return this.valueLabel.getFont();
    }

    public void setStateForeground(Color color) {
        this.valueLabel.setForeground(color);
    }

    public Color getStateForeground() {
        return this.valueLabel.getForeground();
    }

    public void setForeground(Color color) {
        if (this.valueLabel != null) {
            this.valueLabel.setForeground(color);
        }
        if (this.textLabel != null) {
            this.textLabel.setForeground(color);
        }
        super.setForeground(color);
    }

    public void setStateHorizontalAlignment(int n) {
        this.valueLabel.setHorizontalAlignment(n);
    }

    public int getStateHorizontalAlignment() {
        return this.valueLabel.getHorizontalAlignment();
    }

    public void setStatePreferredSize(Dimension dimension) {
        this.valueLabel.setPreferredSize(dimension);
    }

    public Dimension getStatePreferredSize() {
        return this.valueLabel.getPreferredSize();
    }

    public void setStateBorder(Border border) {
        if (this.valueLabel == null) {
            return;
        }
        this.valueLabel.setBorder(border);
    }

    public Border getStateBorder() {
        if (this.valueLabel == null) {
            return null;
        }
        return this.valueLabel.getBorder();
    }

    public boolean getStateInTooltip() {
        return this.stateInTooltip;
    }

    public void setStateInTooltip(boolean bl) {
        if (this.stateInTooltip != bl) {
            if (!bl && this.device != null) {
                this.valueLabel.setToolTipText(this.device.getName());
            }
            this.stateInTooltip = bl;
        }
    }

    public void setStateClickable(boolean bl) {
        this.stateClickable = bl;
    }

    public boolean isStateClickable() {
        return this.stateClickable;
    }

    public void setApplication(IDeviceApplication iDeviceApplication) {
        this.application = iDeviceApplication;
    }

    public IDeviceApplication getApplication() {
        return this.application;
    }
}

