/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.device;

import fr.esrf.tangoatk.core.Device;
import fr.esrf.tangoatk.core.DeviceFactory;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.IErrorListener;
import fr.esrf.tangoatk.core.IStateListener;
import fr.esrf.tangoatk.core.StateEvent;
import fr.esrf.tangoatk.widget.util.ATKConstant;
import javax.swing.JButton;
import javax.swing.JFrame;

public class DeviceStateLightViewer
extends JButton
implements IStateListener,
IErrorListener {
    private Device deviceModel;
    private boolean viewLabel;
    private int chosenLabel;
    private static final String defaultName = "No device defined";
    public static final int name = 0;
    public static final int state = 1;
    public static final int nameAndState = 2;
    public static final int customLabel = 3;

    public DeviceStateLightViewer() {
        this.chosenLabel = 0;
        this.viewLabel = false;
        this.setDeviceModel(null);
    }

    public DeviceStateLightViewer(Device device, int n, boolean bl) {
        this.chosenLabel = n;
        this.viewLabel = bl;
        this.setDeviceModel(device);
    }

    public void setDeviceModel(Device device) {
        if (this.deviceModel != null) {
            this.deviceModel.removeStateListener(this);
            this.deviceModel.removeErrorListener(this);
        }
        this.deviceModel = null;
        this.deviceModel = device;
        if (this.deviceModel != null) {
            this.deviceModel.addStateListener(this);
            this.deviceModel.addErrorListener(this);
            this.manageLabel(this.deviceModel.getState());
            this.setIcon(ATKConstant.getIcon4State(this.deviceModel.getState()));
        } else {
            this.manageLabel("Unknown state");
            this.setIcon(ATKConstant.getIcon4State("UNKNOWN"));
        }
    }

    public void clearDeviceModel() {
        this.setDeviceModel(null);
    }

    public Device getDeviceModel() {
        return this.deviceModel;
    }

    public void setViewLabel(boolean bl) {
        this.viewLabel = bl;
        if (this.deviceModel != null) {
            this.manageLabel(this.deviceModel.getState());
        } else {
            this.manageLabel("unknown state");
        }
    }

    public boolean isViewLabel() {
        return this.viewLabel;
    }

    public void setChosenLabel(int n) {
        this.chosenLabel = n;
    }

    private void manageLabel(String string) {
        if (this.viewLabel) {
            switch (this.chosenLabel) {
                case 0: {
                    if (this.deviceModel == null) {
                        this.setText(defaultName);
                        break;
                    }
                    this.setText(this.deviceModel.getName());
                    break;
                }
                case 1: {
                    this.setText(string);
                    break;
                }
                case 2: {
                    if (this.deviceModel == null) {
                        this.setText("No device defined : " + string);
                        break;
                    }
                    this.setText(this.deviceModel.getName() + " : " + string);
                    break;
                }
            }
        }
    }

    public void stateChange(StateEvent stateEvent) {
        this.manageLabel(stateEvent.getState());
        this.setIcon(ATKConstant.getIcon4State(stateEvent.getState()));
        this.repaint();
    }

    public void errorChange(ErrorEvent errorEvent) {
        this.manageLabel("Error occured");
        this.setIcon(ATKConstant.getIcon4State("UNKNOWN"));
        this.repaint();
    }

    public static void main(String[] stringArray) {
        try {
            Device device = stringArray.length != 0 ? DeviceFactory.getInstance().getDevice(stringArray[0]) : DeviceFactory.getInstance().getDevice("tango/tangotest/1");
            DeviceStateLightViewer deviceStateLightViewer = new DeviceStateLightViewer(device, 2, true);
            JFrame jFrame = new JFrame(deviceStateLightViewer.getDeviceModel().getName());
            jFrame.getContentPane().add(deviceStateLightViewer);
            jFrame.setSize(300, 50);
            jFrame.setVisible(true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
    }
}

