/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.command;

import fr.esrf.tangoatk.core.CommandList;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.ICommand;
import fr.esrf.tangoatk.core.IEntity;
import fr.esrf.tangoatk.core.IErrorListener;
import fr.esrf.tangoatk.core.command.BooleanVoidCommand;
import fr.esrf.tangoatk.widget.util.ThreeStateSwitch;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class OnOffSwitchCommandViewer
extends ThreeStateSwitch
implements ActionListener,
IErrorListener {
    ICommand model = null;

    public OnOffSwitchCommandViewer() {
        this.addActionListener(this);
    }

    public OnOffSwitchCommandViewer(String string, Font font) {
        super(string, font);
        this.addActionListener(this);
    }

    public ICommand getModel() {
        return this.model;
    }

    public void setModel(ICommand iCommand) {
        if (this.model != null) {
            this.model.removeErrorListener(this);
            this.model = null;
        }
        if (iCommand != null && iCommand instanceof BooleanVoidCommand) {
            this.model = iCommand;
            this.model.addErrorListener(this);
        }
    }

    public void clearModel() {
        this.setModel(null);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string;
        Vector<String> vector = new Vector<String>();
        switch (this.getState()) {
            case 1: {
                string = new String("true");
                break;
            }
            case 2: {
                string = new String("false");
                break;
            }
            case 0: {
                string = new String("false");
                break;
            }
            default: {
                string = new String("false");
            }
        }
        if (this.model != null) {
            vector.add(0, string);
            this.model.execute(vector);
        }
    }

    public void errorChange(ErrorEvent errorEvent) {
        if (errorEvent.getSource() == this.model) {
            JOptionPane.showMessageDialog(this, "Failed to execute command:\n" + errorEvent.getError().getMessage());
        }
    }

    public static void main(String[] stringArray) {
        CommandList commandList = new CommandList();
        JFrame jFrame = new JFrame();
        JPanel jPanel = new JPanel();
        OnOffSwitchCommandViewer onOffSwitchCommandViewer = new OnOffSwitchCommandViewer();
        onOffSwitchCommandViewer.setBorder(BorderFactory.createEtchedBorder());
        jPanel.add(onOffSwitchCommandViewer);
        try {
            IEntity iEntity = commandList.add("sr/Agilent_4395a/1/AveragingOnOff");
            if (iEntity instanceof BooleanVoidCommand) {
                System.out.println("Oui c'est un booleanVoid command");
            } else {
                System.out.println("Desolee ce n'est pas un booleanVoid command");
            }
            if (iEntity instanceof ICommand) {
                ICommand iCommand = (ICommand)iEntity;
                onOffSwitchCommandViewer.setModel(iCommand);
                onOffSwitchCommandViewer.setTitle("Averaging");
            }
        }
        catch (Exception exception) {
            System.out.println("Cannot connect to sr/agilent/1/AveragingOnOff");
        }
        jFrame.setContentPane(jPanel);
        jFrame.setDefaultCloseOperation(3);
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

