/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.command;

import fr.esrf.tangoatk.core.CommandList;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.ICommand;
import fr.esrf.tangoatk.core.IEntity;
import fr.esrf.tangoatk.core.IErrorListener;
import fr.esrf.tangoatk.core.command.BooleanVoidCommand;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class OnOffCheckBoxCommandViewer
extends JCheckBox
implements ActionListener,
IErrorListener {
    ICommand cmdModel = null;

    public OnOffCheckBoxCommandViewer() {
        this.addActionListener(this);
    }

    public OnOffCheckBoxCommandViewer(String string) {
        super(string);
        this.addActionListener(this);
    }

    public ICommand getCmdModel() {
        return this.cmdModel;
    }

    public void setCmdModel(ICommand iCommand) {
        if (this.cmdModel != null) {
            this.cmdModel.removeErrorListener(this);
            this.cmdModel = null;
            this.setText("");
        }
        if (iCommand != null && iCommand instanceof BooleanVoidCommand) {
            this.cmdModel = iCommand;
            this.setText(iCommand.getNameSansDevice() + " Off");
            this.cmdModel.addErrorListener(this);
        }
    }

    public void clearModel() {
        this.setCmdModel(null);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string;
        JCheckBox jCheckBox = null;
        Vector<String> vector = new Vector<String>();
        jCheckBox = (JCheckBox)actionEvent.getSource();
        if (jCheckBox.isSelected()) {
            string = new String("true");
            String string2 = this.getText();
            string2 = string2.replaceFirst(" Off", " On");
            this.setText(string2);
        } else {
            string = new String("false");
            String string3 = this.getText();
            string3 = string3.replaceFirst(" On", " Off");
            this.setText(string3);
        }
        if (this.cmdModel != null) {
            vector.add(0, string);
            this.cmdModel.execute(vector);
        }
    }

    public void errorChange(ErrorEvent errorEvent) {
        if (errorEvent.getSource() == this.cmdModel) {
            JOptionPane.showMessageDialog(this, "Failed to execute command:\n" + errorEvent.getError().getMessage());
        }
    }

    public static void main(String[] stringArray) {
        CommandList commandList = new CommandList();
        JFrame jFrame = new JFrame();
        JPanel jPanel = new JPanel();
        OnOffCheckBoxCommandViewer onOffCheckBoxCommandViewer = new OnOffCheckBoxCommandViewer();
        onOffCheckBoxCommandViewer.setBorder(BorderFactory.createEtchedBorder());
        jPanel.add(onOffCheckBoxCommandViewer);
        try {
            IEntity iEntity = commandList.add("sr/Agilent_4395a/1/AveragingOnOff");
            if (iEntity instanceof BooleanVoidCommand) {
                System.out.println("Oui c'est un booleanVoid command");
            } else {
                System.out.println("Desolee ce n'est pas un booleanVoid command");
            }
            if (iEntity instanceof ICommand) {
                ICommand iCommand = (ICommand)iEntity;
                onOffCheckBoxCommandViewer.setCmdModel(iCommand);
                onOffCheckBoxCommandViewer.setText("Averaging");
            }
        }
        catch (Exception exception) {
            System.out.println("Cannot connect to sr/agilent/1/AveragingOnOff");
        }
        jFrame.setContentPane(jPanel);
        jFrame.setDefaultCloseOperation(3);
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

