/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.attribute;

import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.AttributeStateEvent;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.IStringScalar;
import fr.esrf.tangoatk.core.IStringScalarListener;
import fr.esrf.tangoatk.core.StringScalarEvent;
import fr.esrf.tangoatk.widget.util.ATKConstant;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;

public class StatusViewer
extends JPanel
implements IStringScalarListener {
    private JScrollPane jScrollPane1;
    private JTextArea status;
    private IStringScalar model = null;
    private boolean useDeviceAlias = true;

    public StatusViewer() {
        this.initComponents();
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.status = new JTextArea();
        this.setLayout(new BorderLayout());
        this.setBorder(new TitledBorder("Status"));
        this.jScrollPane1.setVerticalScrollBarPolicy(22);
        this.status.setLineWrap(true);
        this.status.setEditable(false);
        this.status.setColumns(50);
        this.status.setRows(4);
        this.status.setText("Unknown");
        this.status.setBackground(new Color(204, 204, 204));
        this.jScrollPane1.setViewportView(this.status);
        this.add((Component)this.jScrollPane1, "Center");
    }

    public void setModel(IStringScalar iStringScalar) {
        if (this.model != null) {
            this.model.removeStringScalarListener(this);
            this.setBorder(new TitledBorder("Status"));
        }
        this.status.setText("Unknown");
        this.model = iStringScalar;
        if (this.model != null) {
            this.model.addStringScalarListener(this);
            this.setStatus(this.model.getStringDeviceValue());
            if (this.useDeviceAlias) {
                if (this.model.getDevice().getAlias() != null) {
                    this.setBorder(new TitledBorder(this.model.getDevice().getAlias()));
                } else {
                    this.setBorder(new TitledBorder(this.model.getDevice().getName()));
                }
            } else {
                this.setBorder(new TitledBorder(this.model.getDevice().getName()));
            }
        }
    }

    public IStringScalar getModel() {
        return this.model;
    }

    public int getRows() {
        return this.status.getRows();
    }

    public void setRows(int n) {
        this.status.setRows(n);
    }

    public int getColumns() {
        return this.status.getColumns();
    }

    public void setColumns(int n) {
        this.status.setColumns(n);
    }

    public boolean getUseDeviceAlias() {
        return this.useDeviceAlias;
    }

    public void setUseDeviceAlias(boolean bl) {
        this.useDeviceAlias = bl;
    }

    public JTextArea getText() {
        return this.status;
    }

    public void stringScalarChange(StringScalarEvent stringScalarEvent) {
        if (!this.status.isEnabled()) {
            this.status.setEnabled(true);
        }
        this.setStatus(stringScalarEvent.getValue());
    }

    public void errorChange(ErrorEvent errorEvent) {
        this.setStatus("UNKNOWN");
        this.status.setEnabled(false);
    }

    public void stateChange(AttributeStateEvent attributeStateEvent) {
        this.attStateChange(attributeStateEvent.getState());
    }

    private void setStatus(String string) {
        if (string == null) {
            if ("".equals(this.status.getText()) || this.status.getText() == null) {
                return;
            }
            this.status.setText("");
        } else {
            if (string.equals(this.status.getText())) {
                return;
            }
            this.status.setText(string);
            this.status.setCaretPosition(0);
        }
    }

    private void attStateChange(String string) {
        if ("VALID".equals(string)) {
            this.status.setBackground(this.getBackground());
            return;
        }
        this.status.setBackground(ATKConstant.getColor4Quality(string));
    }

    public static void main(String[] stringArray) {
        final AttributeList attributeList = new AttributeList();
        StatusViewer statusViewer = new StatusViewer();
        try {
            IStringScalar iStringScalar = (IStringScalar)attributeList.add("dev/test/10/Status");
            statusViewer.setModel(iStringScalar);
        }
        catch (Exception exception) {
            System.out.println("caught exception : " + exception.getMessage());
            System.exit(-1);
        }
        JFrame jFrame = new JFrame();
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowActivated(WindowEvent windowEvent) {
                attributeList.startRefresher();
            }
        });
        jFrame.setContentPane(statusViewer);
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

