/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.attribute;

import com.braju.format.Format;
import fr.esrf.TangoDs.AttrManip;
import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.AttributeStateEvent;
import fr.esrf.tangoatk.core.BooleanScalarEvent;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.IAttribute;
import fr.esrf.tangoatk.core.IBooleanScalar;
import fr.esrf.tangoatk.core.IBooleanScalarListener;
import fr.esrf.tangoatk.core.IErrorListener;
import fr.esrf.tangoatk.core.INumberScalar;
import fr.esrf.tangoatk.core.INumberScalarListener;
import fr.esrf.tangoatk.core.IStringScalar;
import fr.esrf.tangoatk.core.IStringScalarListener;
import fr.esrf.tangoatk.core.NumberScalarEvent;
import fr.esrf.tangoatk.core.Property;
import fr.esrf.tangoatk.core.StringScalarEvent;
import fr.esrf.tangoatk.widget.util.ATKConstant;
import fr.esrf.tangoatk.widget.util.ATKFormat;
import fr.esrf.tangoatk.widget.util.JAutoScrolledText;
import fr.esrf.tangoatk.widget.util.jdraw.JDrawable;
import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class SimpleScalarViewer
extends JAutoScrolledText
implements INumberScalarListener,
IStringScalarListener,
IBooleanScalarListener,
PropertyChangeListener,
IErrorListener,
JDrawable {
    INumberScalar numberModel = null;
    IStringScalar stringModel = null;
    IBooleanScalar booleanModel = null;
    boolean alarmEnabled = true;
    String userFormat = "";
    ATKFormat atkUserFormat = null;
    String format = "";
    String error = "-----";
    boolean unitVisible = true;
    Color backgroundColor = ATKConstant.getColor4Quality("VALID");
    private boolean hasToolTip = false;
    private boolean qualityInTooltip = false;
    static String[] exts = new String[]{"unitVisible", "userFormat", "alarmEnabled", "validBackground", "invalidText"};

    public SimpleScalarViewer() {
        this.setOpaque(true);
        this.setMargin(new Insets(0, 0, 0, 0));
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color color) {
        this.backgroundColor = color;
    }

    public void initForEditing() {
        this.setText("000.00 unit");
    }

    public JComponent getComponent() {
        return this;
    }

    public String getDescription(String string) {
        if (string.equals("unitVisible")) {
            return "Display the unit of the tango attribute when enabled.\nPossible values are: true, false.";
        }
        if (string.equalsIgnoreCase("userFormat")) {
            return "Overrides the tango attribute format property when specified.\nSupports C format, ex:%5.2f .";
        }
        if (string.equalsIgnoreCase("alarmEnabled")) {
            return "When enabled, the background color change with the\nTango attribute quality factor.\nDefault colors are: ( unless they have been changed with\nATKConstant.setColor4Quality() )\n VALID   => Green\n INVALID => Grey\n ALARM   => Orange\n WARNING => Orange\n CHANGING => Blue\n UNKNOWN => Grey\nPossible values are: true, false.";
        }
        if (string.equalsIgnoreCase("invalidText")) {
            return "Text displayed when the qulaity factor is INVALID\nor when the connection is lost.";
        }
        if (string.equalsIgnoreCase("validBackground")) {
            return "Sets the background color (r,g,b) for the VALID quality factor for this viewer.\nHas effect only if alarmEnabled is true.";
        }
        return "";
    }

    public String[] getExtensionList() {
        return exts;
    }

    public boolean setExtendedParam(String string, String string2, boolean bl) {
        if (string.equalsIgnoreCase("unitVisible")) {
            if (string2.equalsIgnoreCase("true")) {
                this.setUnitVisible(true);
                this.setText("000.00 unit");
                return true;
            }
            if (string2.equalsIgnoreCase("false")) {
                this.setUnitVisible(false);
                this.setText("000.00");
                return true;
            }
            this.showJdrawError(bl, "unitVisible", "Wrong syntax: 'true' or 'false' expected.");
            return false;
        }
        if (string.equalsIgnoreCase("userFormat")) {
            this.setUserFormat(string2);
            return true;
        }
        if (string.equalsIgnoreCase("alarmEnabled")) {
            if (string2.equalsIgnoreCase("true")) {
                this.setAlarmEnabled(true);
                return true;
            }
            if (string2.equalsIgnoreCase("false")) {
                this.setAlarmEnabled(false);
                return true;
            }
            this.showJdrawError(bl, "alarmEnabled", "Wrong syntax: 'true' or 'false' expected.");
            return false;
        }
        if (string.equalsIgnoreCase("invalidText")) {
            this.setInvalidText(string2);
            return true;
        }
        if (string.equalsIgnoreCase("validBackground")) {
            String[] stringArray = string2.split(",");
            if (stringArray.length != 3) {
                this.showJdrawError(bl, "validBackground", "Integer list expected: r,g,b");
                return false;
            }
            try {
                int n = Integer.parseInt(stringArray[0]);
                int n2 = Integer.parseInt(stringArray[1]);
                int n3 = Integer.parseInt(stringArray[2]);
                if (n < 0 || n > 255 || n2 < 0 || n2 > 255 || n3 < 0 || n3 > 255) {
                    this.showJdrawError(bl, "validBackground", "Parameter out of bounds. [0..255]");
                    return false;
                }
                this.setBackgroundColor(new Color(n, n2, n3));
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                this.showJdrawError(bl, "validBackground", "Wrong integer syntax.");
                return false;
            }
        }
        return false;
    }

    public String getExtendedParam(String string) {
        if (string.equals("unitVisible")) {
            return this.getUnitVisible() ? "true" : "false";
        }
        if (string.equalsIgnoreCase("userFormat")) {
            return this.getUserFormat();
        }
        if (string.equals("alarmEnabled")) {
            return this.isAlarmEnabled() ? "true" : "false";
        }
        if (string.equals("invalidText")) {
            return this.getInvalidText();
        }
        if (string.equalsIgnoreCase("validBackground")) {
            Color color = this.backgroundColor;
            return color.getRed() + "," + color.getGreen() + "," + color.getBlue();
        }
        return "";
    }

    private void showJdrawError(boolean bl, String string, String string2) {
        if (bl) {
            JOptionPane.showMessageDialog(null, "SimpleScalarViewer: " + string + " incorrect.\n" + string2, "Error", 0);
        }
    }

    public void stringScalarChange(StringScalarEvent stringScalarEvent) {
        String string;
        String string2 = this.getDisplayString(stringScalarEvent);
        if (!string2.equals(string = this.getText())) {
            this.setText(string2);
        }
    }

    public void numberScalarChange(NumberScalarEvent numberScalarEvent) {
        String string = this.getDisplayString(numberScalarEvent);
        if (this.unitVisible) {
            this.setText(string + " " + this.numberModel.getUnit());
        } else {
            this.setText(string);
        }
    }

    public void booleanScalarChange(BooleanScalarEvent booleanScalarEvent) {
        String string;
        String string2 = this.getDisplayString(booleanScalarEvent);
        if (!string2.equals(string = this.getText())) {
            this.setText(string2);
        }
    }

    private String getDisplayString(StringScalarEvent stringScalarEvent) {
        if (this.atkUserFormat != null) {
            return this.atkUserFormat.format(stringScalarEvent.getValue());
        }
        return stringScalarEvent.getValue();
    }

    private String getDisplayString(NumberScalarEvent numberScalarEvent) {
        String string;
        Double d = new Double(numberScalarEvent.getValue());
        if (Double.isNaN(numberScalarEvent.getValue()) || Double.isInfinite(numberScalarEvent.getValue())) {
            string = Double.toString(numberScalarEvent.getValue());
        } else if (this.atkUserFormat != null) {
            string = this.atkUserFormat.format(new Double(numberScalarEvent.getValue()));
        } else {
            try {
                if (this.userFormat.length() > 0) {
                    Object[] objectArray = new Object[]{d};
                    string = Format.sprintf(this.userFormat, objectArray);
                } else if (this.format.indexOf(37) == -1) {
                    string = AttrManip.format(this.format, numberScalarEvent.getValue());
                } else {
                    Object[] objectArray = new Object[]{d};
                    string = Format.sprintf(this.format, objectArray);
                }
            }
            catch (Exception exception) {
                return "Exception while formating";
            }
        }
        return string;
    }

    private String getDisplayString(BooleanScalarEvent booleanScalarEvent) {
        if (this.atkUserFormat != null) {
            return this.atkUserFormat.format(new Boolean(booleanScalarEvent.getValue()));
        }
        return Boolean.toString(booleanScalarEvent.getValue());
    }

    public void setUserFormat(String string) {
        this.userFormat = string == null ? "" : string;
    }

    public void setUserFormat(ATKFormat aTKFormat) {
        this.atkUserFormat = aTKFormat;
    }

    public String getUserFormat() {
        return this.userFormat;
    }

    public void setUnitVisible(boolean bl) {
        this.unitVisible = bl;
    }

    public boolean getUnitVisible() {
        return this.unitVisible;
    }

    public void setAlarmEnabled(boolean bl) {
        this.alarmEnabled = bl;
    }

    public boolean isAlarmEnabled() {
        return this.alarmEnabled;
    }

    public void stateChange(AttributeStateEvent attributeStateEvent) {
        String string = attributeStateEvent.getState();
        if (this.hasToolTip && this.qualityInTooltip) {
            IAttribute iAttribute = (IAttribute)attributeStateEvent.getSource();
            this.setToolTipText(iAttribute.getName() + " : " + string);
        }
        if (string.equals("INVALID")) {
            this.setText(this.error);
        }
        if (!this.alarmEnabled) {
            return;
        }
        if (string.equals("VALID")) {
            this.setBackground(this.backgroundColor);
            return;
        }
        this.setBackground(ATKConstant.getColor4Quality(string));
    }

    public void errorChange(ErrorEvent errorEvent) {
        this.setText(this.error);
        if (!this.alarmEnabled) {
            return;
        }
        this.setBackground(ATKConstant.getColor4Quality("UNKNOWN"));
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Property property = (Property)propertyChangeEvent.getSource();
        if (this.numberModel != null) {
            if (property.getName().equalsIgnoreCase("format")) {
                this.format = property.getValue().toString();
            }
            this.numberModel.refresh();
        }
        if (this.stringModel != null) {
            if (property.getName().equalsIgnoreCase("format")) {
                this.format = property.getValue().toString();
            }
            this.stringModel.refresh();
        }
        if (this.booleanModel != null) {
            if (property.getName().equalsIgnoreCase("format")) {
                this.format = property.getValue().toString();
            }
            this.booleanModel.refresh();
        }
    }

    public void setModel(INumberScalar iNumberScalar) {
        this.clearModel();
        if (iNumberScalar != null) {
            this.format = iNumberScalar.getProperty("format").getPresentation();
            this.numberModel = iNumberScalar;
            this.numberModel.addNumberScalarListener(this);
            this.numberModel.getProperty("format").addPresentationListener(this);
            this.numberModel.getProperty("unit").addPresentationListener(this);
            if (this.hasToolTip) {
                this.setToolTipText(iNumberScalar.getName());
            }
            this.numberModel.refresh();
        }
    }

    public void setModel(IStringScalar iStringScalar) {
        this.clearModel();
        if (iStringScalar != null) {
            this.format = iStringScalar.getProperty("format").getPresentation();
            this.stringModel = iStringScalar;
            this.stringModel.addStringScalarListener(this);
            this.stringModel.getProperty("format").addPresentationListener(this);
            this.stringModel.refresh();
            if (this.hasToolTip) {
                this.setToolTipText(iStringScalar.getName());
            }
        }
    }

    public void setModel(IBooleanScalar iBooleanScalar) {
        this.clearModel();
        if (iBooleanScalar != null) {
            this.format = iBooleanScalar.getProperty("format").getPresentation();
            this.booleanModel = iBooleanScalar;
            this.booleanModel.addBooleanScalarListener(this);
            this.booleanModel.getProperty("format").addPresentationListener(this);
            this.booleanModel.refresh();
            if (this.hasToolTip) {
                this.setToolTipText(iBooleanScalar.getName());
            }
        }
    }

    public void clearModel() {
        if (this.hasToolTip) {
            this.setToolTipText(null);
        }
        if (this.stringModel != null) {
            this.stringModel.removeStringScalarListener(this);
            this.stringModel.getProperty("format").removePresentationListener(this);
            this.stringModel = null;
        }
        if (this.numberModel != null) {
            this.numberModel.removeNumberScalarListener(this);
            this.numberModel.getProperty("format").removePresentationListener(this);
            this.numberModel.getProperty("unit").removePresentationListener(this);
            this.numberModel = null;
        }
        if (this.booleanModel != null) {
            this.booleanModel.removeBooleanScalarListener(this);
            this.booleanModel.getProperty("format").removePresentationListener(this);
            this.booleanModel = null;
        }
    }

    public void setInvalidText(String string) {
        this.error = string;
    }

    public String getInvalidText() {
        return this.error;
    }

    public INumberScalar getNumberModel() {
        return this.numberModel;
    }

    public IStringScalar getStringModel() {
        return this.stringModel;
    }

    public IBooleanScalar getBooleanModel() {
        return this.booleanModel;
    }

    public boolean getHasToolTip() {
        return this.hasToolTip;
    }

    public void setHasToolTip(boolean bl) {
        if (this.hasToolTip == bl) {
            return;
        }
        this.hasToolTip = bl;
        if (!this.hasToolTip) {
            this.setToolTipText(null);
            return;
        }
        if (this.stringModel != null) {
            this.setToolTipText(this.stringModel.getName());
            return;
        }
        if (this.numberModel != null) {
            this.setToolTipText(this.numberModel.getName());
            return;
        }
        if (this.booleanModel != null) {
            this.setToolTipText(this.booleanModel.getName());
            return;
        }
    }

    public boolean getQualityInTooltip() {
        return this.qualityInTooltip;
    }

    public void setQualityInTooltip(boolean bl) {
        IAttribute iAttribute = null;
        if (!this.hasToolTip) {
            this.qualityInTooltip = bl;
            return;
        }
        if (this.qualityInTooltip != bl) {
            if (this.stringModel != null) {
                iAttribute = this.stringModel;
            } else if (this.numberModel != null) {
                iAttribute = this.numberModel;
            } else if (this.booleanModel != null) {
                iAttribute = this.booleanModel;
            }
            if (!bl && iAttribute != null) {
                this.setToolTipText(iAttribute.getName());
            }
            this.qualityInTooltip = bl;
        }
    }

    public static void main(String[] stringArray) throws Exception {
        AttributeList attributeList = new AttributeList();
        SimpleScalarViewer simpleScalarViewer = new SimpleScalarViewer();
        String string = "jlp/test/1/att_quatre";
        if (stringArray != null && stringArray.length > 0) {
            string = stringArray[0];
        }
        IAttribute iAttribute = null;
        try {
            iAttribute = (IAttribute)attributeList.add(string);
        }
        catch (Exception exception) {
            iAttribute = null;
        }
        if (iAttribute instanceof INumberScalar) {
            simpleScalarViewer.setModel((INumberScalar)iAttribute);
        } else if (iAttribute instanceof IStringScalar) {
            simpleScalarViewer.setModel((IStringScalar)iAttribute);
        } else if (iAttribute instanceof IBooleanScalar) {
            simpleScalarViewer.setModel((IBooleanScalar)iAttribute);
        } else {
            System.err.println(string + " is not a valid attribute or is not available");
            System.exit(1);
        }
        simpleScalarViewer.setBorder(BorderFactory.createLoweredBevelBorder());
        simpleScalarViewer.setBackgroundColor(Color.WHITE);
        simpleScalarViewer.setForeground(Color.BLACK);
        simpleScalarViewer.setFont(new Font("Dialog", 1, 30));
        iAttribute.refresh();
        JFrame jFrame = new JFrame();
        jFrame.setContentPane(simpleScalarViewer);
        jFrame.pack();
        jFrame.setVisible(true);
        attributeList.startRefresher();
    }
}

