/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.attribute;

import fr.esrf.Tango.AttrWriteType;
import fr.esrf.Tango.DispLevel;
import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.IAttribute;
import fr.esrf.tangoatk.core.IBooleanScalar;
import fr.esrf.tangoatk.core.INumberScalar;
import fr.esrf.tangoatk.core.IStringScalar;
import fr.esrf.tangoatk.core.Property;
import fr.esrf.tangoatk.core.attribute.ANumber;
import fr.esrf.tangoatk.widget.attribute.BooleanScalarCheckBoxViewer;
import fr.esrf.tangoatk.widget.attribute.BooleanScalarComboEditor;
import fr.esrf.tangoatk.widget.attribute.NumberScalarWheelEditor;
import fr.esrf.tangoatk.widget.attribute.SimpleScalarViewer;
import fr.esrf.tangoatk.widget.attribute.StringScalarEditor;
import fr.esrf.tangoatk.widget.util.JAutoScrolledText;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class SimplePropertyFrame
extends JDialog {
    private JPanel identPanel;
    private JLabel deviceLabel;
    private JTextField deviceText;
    private JLabel attLabel;
    private JTextField attText;
    private SimpleScalarViewer numberAndStringValue = null;
    private BooleanScalarCheckBoxViewer booleanValue = null;
    private NumberScalarWheelEditor numberSetter = null;
    private StringScalarEditor stringSetter = null;
    private BooleanScalarComboEditor booleanSetter = null;
    private JPanel propPanel;
    private JLabel nameLabel;
    private JTextField nameText;
    private JLabel minLabel;
    private JTextField minText;
    private JLabel maxLabel;
    private JTextField maxText;
    private JLabel alminLabel;
    private JTextField alminText;
    private JLabel almaxLabel;
    private JTextField almaxText;
    private JLabel minWarningLabel;
    private JTextField minWarningText;
    private JLabel maxWarningLabel;
    private JTextField maxWarningText;
    private JLabel deltaTLabel;
    private JTextField deltaTText;
    private JLabel deltaValLabel;
    private JTextField deltaValText;
    private JLabel formatLabel;
    private JTextField formatText;
    private JLabel unitLabel;
    private JTextField unitText;
    private JScrollPane textView;
    private JTextArea descText;
    private JButton okButton;
    private JButton applyButton;
    private JButton infoButton;
    private boolean editable = true;
    private IAttribute model;
    Dimension appsize = new Dimension(460, 490);

    public SimplePropertyFrame() {
        super((Frame)null, false);
        this.initComponents();
    }

    public SimplePropertyFrame(JDialog jDialog, boolean bl) {
        super((Dialog)jDialog, bl);
        this.initComponents();
    }

    public SimplePropertyFrame(JFrame jFrame, boolean bl) {
        super((Frame)jFrame, bl);
        this.initComponents();
    }

    public void pack() {
    }

    private void initComponents() {
        Container container = this.getContentPane();
        container.setLayout(null);
        this.addComponentListener(new ComponentAdapter(){

            public void componentHidden(ComponentEvent componentEvent) {
                System.out.println("Free ref");
                SimplePropertyFrame.this.setModel(null);
                SimplePropertyFrame.this.dispose();
            }
        });
        Font font = new Font("Dialog", 0, 11);
        Insets insets = new Insets(0, 0, 0, 0);
        this.identPanel = new JPanel();
        this.identPanel.setLayout(null);
        this.identPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Identification", 1, 2, font));
        this.deviceLabel = new JLabel("Device");
        this.identPanel.add(this.deviceLabel);
        this.deviceText = new JTextField();
        this.deviceText.setMargin(insets);
        this.deviceText.setEditable(false);
        this.identPanel.add(this.deviceText);
        this.attLabel = new JLabel("Attribute");
        this.identPanel.add(this.attLabel);
        this.attText = new JTextField();
        this.attText.setMargin(insets);
        this.attText.setEditable(false);
        this.identPanel.add(this.attText);
        container.add(this.identPanel);
        this.numberAndStringValue = new SimpleScalarViewer();
        this.numberAndStringValue.setFont(new Font("Dialog", 1, 30));
        this.numberAndStringValue.setBorder(BorderFactory.createLoweredBevelBorder());
        this.numberAndStringValue.setSizingBehavior(JAutoScrolledText.MATRIX_BEHAVIOR);
        this.booleanValue = new BooleanScalarCheckBoxViewer();
        this.booleanValue.setQualityEnabled(true);
        this.booleanValue.setTrueLabel("True");
        this.booleanValue.setFalseLabel("False");
        this.booleanValue.setOpaque(true);
        this.booleanValue.setFont(new Font("Dialog", 1, 30));
        this.booleanValue.setBorder(BorderFactory.createLoweredBevelBorder());
        container.add(this.numberAndStringValue);
        this.numberSetter = new NumberScalarWheelEditor();
        this.numberSetter.setFont(new Font("Dialog", 1, 20));
        this.numberSetter.setVisible(false);
        this.stringSetter = new StringScalarEditor();
        this.stringSetter.setFont(new Font("Dialog", 0, 14));
        this.stringSetter.setVisible(false);
        this.booleanSetter = new BooleanScalarComboEditor();
        this.booleanSetter.setFont(new Font("Dialog", 0, 14));
        this.booleanSetter.setVisible(false);
        container.add(this.numberSetter);
        this.propPanel = new JPanel();
        this.propPanel.setLayout(null);
        this.propPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Properties", 1, 2, font));
        this.nameLabel = new JLabel("Label");
        this.propPanel.add(this.nameLabel);
        this.nameText = new JTextField();
        this.nameText.setMargin(insets);
        this.nameText.setEditable(true);
        this.propPanel.add(this.nameText);
        this.minLabel = new JLabel("Minimum value");
        this.propPanel.add(this.minLabel);
        this.minText = new JTextField();
        this.minText.setMargin(insets);
        this.minText.setEditable(true);
        this.propPanel.add(this.minText);
        this.maxLabel = new JLabel("Maximum value");
        this.propPanel.add(this.maxLabel);
        this.maxText = new JTextField();
        this.maxText.setMargin(insets);
        this.maxText.setEditable(true);
        this.propPanel.add(this.maxText);
        this.alminLabel = new JLabel("Minimum alarm");
        this.propPanel.add(this.alminLabel);
        this.alminText = new JTextField();
        this.alminText.setMargin(insets);
        this.alminText.setEditable(true);
        this.propPanel.add(this.alminText);
        this.almaxLabel = new JLabel("Maximum alarm");
        this.propPanel.add(this.almaxLabel);
        this.almaxText = new JTextField();
        this.almaxText.setMargin(insets);
        this.almaxText.setEditable(true);
        this.propPanel.add(this.almaxText);
        this.minWarningLabel = new JLabel("Min. warning");
        this.propPanel.add(this.minWarningLabel);
        this.minWarningText = new JTextField();
        this.minWarningText.setMargin(insets);
        this.minWarningText.setEditable(true);
        this.propPanel.add(this.minWarningText);
        this.maxWarningLabel = new JLabel("Max. warning");
        this.propPanel.add(this.maxWarningLabel);
        this.maxWarningText = new JTextField();
        this.maxWarningText.setMargin(insets);
        this.maxWarningText.setEditable(true);
        this.propPanel.add(this.maxWarningText);
        this.deltaTLabel = new JLabel("Delta t(ms)");
        this.propPanel.add(this.deltaTLabel);
        this.deltaTText = new JTextField();
        this.deltaTText.setMargin(insets);
        this.deltaTText.setEditable(true);
        this.propPanel.add(this.deltaTText);
        this.deltaValLabel = new JLabel("Delta Val");
        this.propPanel.add(this.deltaValLabel);
        this.deltaValText = new JTextField();
        this.deltaValText.setMargin(insets);
        this.deltaValText.setEditable(true);
        this.propPanel.add(this.deltaValText);
        this.formatLabel = new JLabel("Format");
        this.propPanel.add(this.formatLabel);
        this.formatText = new JTextField();
        this.formatText.setMargin(insets);
        this.formatText.setEditable(true);
        this.propPanel.add(this.formatText);
        this.unitLabel = new JLabel("Unit");
        this.propPanel.add(this.unitLabel);
        this.unitText = new JTextField();
        this.unitText.setMargin(insets);
        this.unitText.setEditable(true);
        this.propPanel.add(this.unitText);
        this.descText = new JTextArea();
        this.descText.setEditable(true);
        this.textView = new JScrollPane(this.descText);
        this.propPanel.add(this.textView);
        container.add(this.propPanel);
        this.okButton = new JButton("Dismiss");
        this.okButton.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                SimplePropertyFrame.this.setVisible(false);
                SimplePropertyFrame.this.dispose();
            }
        });
        this.infoButton = new JButton("Information");
        this.infoButton.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                SimplePropertyFrame.this.showInformation();
            }
        });
        this.applyButton = new JButton("Apply change");
        this.applyButton.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                SimplePropertyFrame.this.applyChange();
            }
        });
        container.add(this.applyButton);
        container.add(this.infoButton);
        container.add(this.okButton);
        this.setTitle("Attribute property editor");
        this.placeComponents();
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension dimension = toolkit.getScreenSize();
        int n = (dimension.width - this.appsize.width) / 2;
        int n2 = (dimension.height - this.appsize.height) / 2;
        this.setBounds(n, n2, this.appsize.width, this.appsize.height);
    }

    public boolean propertyReset(String string) {
        return string.equalsIgnoreCase("Not specified") || string.equals("") || string.equalsIgnoreCase("NaN");
    }

    public void applyChange() {
        Map map = this.model.getPropertyMap();
        Property property = (Property)map.get("label");
        property.setValue(this.nameText.getText());
        property.refresh();
        if (this.model instanceof ANumber) {
            Double d;
            ANumber aNumber = (ANumber)this.model;
            property = (Property)map.get("min_value");
            String string = this.minText.getText();
            if (this.propertyReset(string)) {
                property.setValue("NaN");
            } else {
                try {
                    d = new Double(aNumber.getValueInDeviceUnit(Double.parseDouble(string)));
                    property.setValue(d);
                    property.refresh();
                }
                catch (NumberFormatException numberFormatException) {
                    JOptionPane.showMessageDialog(this, "Invalid minimum value\n" + numberFormatException.getMessage(), "Error", 0);
                }
            }
            property = (Property)map.get("max_value");
            string = this.maxText.getText();
            if (this.propertyReset(string)) {
                property.setValue("NaN");
            } else {
                try {
                    d = new Double(aNumber.getValueInDeviceUnit(Double.parseDouble(string)));
                    property.setValue(d);
                    property.refresh();
                }
                catch (NumberFormatException numberFormatException) {
                    JOptionPane.showMessageDialog(this, "Invalid maximum value\n" + numberFormatException.getMessage(), "Error", 0);
                }
            }
            property = (Property)map.get("min_alarm");
            string = this.alminText.getText();
            if (this.propertyReset(string)) {
                property.setValue("NaN");
            } else {
                try {
                    d = new Double(aNumber.getValueInDeviceUnit(Double.parseDouble(string)));
                    property.setValue(d);
                    property.refresh();
                }
                catch (NumberFormatException numberFormatException) {
                    JOptionPane.showMessageDialog(this, "Invalid minimum alarm\n" + numberFormatException.getMessage(), "Error", 0);
                }
            }
            property = (Property)map.get("max_alarm");
            string = this.almaxText.getText();
            if (this.propertyReset(string)) {
                property.setValue("NaN");
            } else {
                try {
                    d = new Double(aNumber.getValueInDeviceUnit(Double.parseDouble(string)));
                    property.setValue(d);
                    property.refresh();
                }
                catch (NumberFormatException numberFormatException) {
                    JOptionPane.showMessageDialog(this, "Invalid maximum alarm\n" + numberFormatException.getMessage(), "Error", 0);
                }
            }
            property = (Property)map.get("min_warning");
            string = this.minWarningText.getText();
            if (this.propertyReset(string)) {
                property.setValue("NaN");
            } else {
                try {
                    d = new Double(aNumber.getValueInDeviceUnit(Double.parseDouble(string)));
                    property.setValue(d);
                    property.refresh();
                }
                catch (NumberFormatException numberFormatException) {
                    JOptionPane.showMessageDialog(this, "Invalid minimum warning\n" + numberFormatException.getMessage(), "Error", 0);
                }
            }
            property = (Property)map.get("max_warning");
            string = this.maxWarningText.getText();
            if (this.propertyReset(string)) {
                property.setValue("NaN");
            } else {
                try {
                    d = new Double(aNumber.getValueInDeviceUnit(Double.parseDouble(string)));
                    property.setValue(d);
                    property.refresh();
                }
                catch (NumberFormatException numberFormatException) {
                    JOptionPane.showMessageDialog(this, "Invalid maximum warning\n" + numberFormatException.getMessage(), "Error", 0);
                }
            }
            property = (Property)map.get("delta_t");
            string = this.deltaTText.getText();
            if (this.propertyReset(string)) {
                property.setValue("NaN");
            } else {
                try {
                    d = new Double(string);
                    property.setValue(d);
                    property.refresh();
                }
                catch (NumberFormatException numberFormatException) {
                    JOptionPane.showMessageDialog(this, "Invalid delta t\n" + numberFormatException.getMessage(), "Error", 0);
                }
            }
            property = (Property)map.get("delta_val");
            string = this.deltaValText.getText();
            if (this.propertyReset(string)) {
                property.setValue("NaN");
            } else {
                try {
                    d = new Double(aNumber.getValueInDeviceUnit(Double.parseDouble(string)));
                    property.setValue(d);
                    property.refresh();
                }
                catch (NumberFormatException numberFormatException) {
                    JOptionPane.showMessageDialog(this, "Invalid delta val\n" + numberFormatException.getMessage(), "Error", 0);
                }
            }
        }
        property = (Property)map.get("format");
        property.setValue(this.formatText.getText());
        property.refresh();
        property = (Property)map.get("unit");
        property.setValue(this.unitText.getText());
        property.refresh();
        property = (Property)map.get("description");
        property.setValue(this.descText.getText());
        property.refresh();
        this.model.storeConfig();
        this.updateComponents();
    }

    public void updateComponents() {
        if (this.model == null) {
            return;
        }
        Container container = this.getContentPane();
        container.remove(1);
        this.deviceText.setText(this.model.getDevice().getName());
        this.attText.setText(this.model.getNameSansDevice());
        if (this.model instanceof INumberScalar) {
            this.numberAndStringValue.setModel((INumberScalar)this.model);
            this.numberAndStringValue.setVisible(true);
            this.booleanValue.clearModel();
            this.booleanValue.setVisible(false);
            container.add((Component)this.numberAndStringValue, 1);
        } else if (this.model instanceof IStringScalar) {
            this.numberAndStringValue.setModel((IStringScalar)this.model);
            this.numberAndStringValue.setVisible(true);
            this.booleanValue.clearModel();
            this.booleanValue.setVisible(false);
            container.add((Component)this.numberAndStringValue, 1);
        } else {
            this.numberAndStringValue.clearModel();
            this.numberAndStringValue.setText("");
            this.numberAndStringValue.setVisible(false);
            if (this.model instanceof IBooleanScalar) {
                this.booleanValue.setAttModel((IBooleanScalar)this.model);
                this.booleanValue.setVisible(true);
                container.add((Component)this.booleanValue, 1);
            } else {
                this.booleanValue.clearModel();
                this.booleanValue.setVisible(false);
                container.add((Component)this.numberAndStringValue, 1);
            }
        }
        if (container.getComponent(2) == this.numberSetter || container.getComponent(2) == this.stringSetter || container.getComponent(2) == this.booleanSetter) {
            container.remove(2);
        }
        if (this.model.isWritable()) {
            if (this.model instanceof INumberScalar) {
                this.numberSetter.setModel((INumberScalar)this.model);
                this.numberSetter.setVisible(true);
                this.stringSetter.setModel(null);
                this.stringSetter.setVisible(false);
                this.booleanSetter.setAttModel(null);
                this.booleanSetter.setVisible(false);
                container.add((Component)this.numberSetter, 2);
            } else if (this.model instanceof IStringScalar) {
                this.numberSetter.setModel(null);
                this.numberSetter.setVisible(false);
                this.stringSetter.setModel((IStringScalar)this.model);
                this.stringSetter.setVisible(true);
                this.booleanSetter.setAttModel(null);
                this.booleanSetter.setVisible(false);
                container.add((Component)this.stringSetter, 2);
            } else if (this.model instanceof IBooleanScalar) {
                this.numberSetter.setModel(null);
                this.numberSetter.setVisible(false);
                this.stringSetter.setModel(null);
                this.stringSetter.setVisible(false);
                this.booleanSetter.setAttModel((IBooleanScalar)this.model);
                this.booleanSetter.setVisible(true);
                container.add((Component)this.booleanSetter, 2);
            } else {
                this.numberSetter.setModel(null);
                this.numberSetter.setVisible(false);
                this.stringSetter.setModel(null);
                this.stringSetter.setVisible(false);
                this.booleanSetter.setAttModel(null);
                this.booleanSetter.setVisible(false);
            }
        } else {
            this.numberSetter.setModel(null);
            this.numberSetter.setVisible(false);
            this.stringSetter.setModel(null);
            this.stringSetter.setVisible(false);
            this.booleanSetter.setAttModel(null);
            this.booleanSetter.setVisible(false);
        }
        container.repaint();
        this.nameText.setText(this.model.getLabel());
        if (this.model instanceof ANumber) {
            ANumber aNumber = (ANumber)this.model;
            double d = aNumber.getMinValue();
            if (Double.isNaN(d)) {
                this.minText.setText("Not specified");
            } else {
                this.minText.setText(Double.toString(aNumber.getValueInDisplayUnit(d)));
            }
            d = aNumber.getMaxValue();
            if (Double.isNaN(d)) {
                this.maxText.setText("Not specified");
            } else {
                this.maxText.setText(Double.toString(aNumber.getValueInDisplayUnit(d)));
            }
            d = aNumber.getMinAlarm();
            if (Double.isNaN(d)) {
                this.alminText.setText("Not specified");
            } else {
                this.alminText.setText(Double.toString(aNumber.getValueInDisplayUnit(d)));
            }
            d = aNumber.getMaxAlarm();
            if (Double.isNaN(d)) {
                this.almaxText.setText("Not specified");
            } else {
                this.almaxText.setText(Double.toString(aNumber.getValueInDisplayUnit(d)));
            }
            d = aNumber.getMinWarning();
            if (Double.isNaN(d)) {
                this.minWarningText.setText("Not specified");
            } else {
                this.minWarningText.setText(Double.toString(aNumber.getValueInDisplayUnit(d)));
            }
            d = aNumber.getMaxWarning();
            if (Double.isNaN(d)) {
                this.maxWarningText.setText("Not specified");
            } else {
                this.maxWarningText.setText(Double.toString(aNumber.getValueInDisplayUnit(d)));
            }
            d = aNumber.getDeltaT();
            if (Double.isNaN(d)) {
                this.deltaTText.setText("Not specified");
            } else {
                this.deltaTText.setText(Double.toString(d));
            }
            d = aNumber.getDeltaVal();
            if (Double.isNaN(d)) {
                this.deltaValText.setText("Not specified");
            } else {
                this.deltaValText.setText(Double.toString(aNumber.getValueInDisplayUnit(d)));
            }
        } else {
            this.minText.setText("None");
            this.maxText.setText("None");
            this.alminText.setText("None");
            this.almaxText.setText("None");
            this.minWarningText.setText("None");
            this.maxWarningText.setText("None");
            this.deltaTText.setText("None");
            this.deltaValText.setText("None");
        }
        this.formatText.setText(this.model.getFormat());
        this.unitText.setText(this.model.getUnit());
        this.descText.setText(this.model.getDescription());
    }

    public void placeComponents() {
        int n;
        this.identPanel.setBounds(5, 5, 440, 80);
        this.deviceLabel.setBounds(10, 15, 65, 25);
        this.deviceText.setBounds(80, 15, 345, 25);
        this.attLabel.setBounds(10, 45, 65, 25);
        this.attText.setBounds(80, 45, 345, 25);
        if (this.numberAndStringValue.isVisible()) {
            if (!this.numberSetter.isVisible() && !this.stringSetter.isVisible()) {
                this.numberAndStringValue.setBounds(5, 87, 440, 45);
            } else {
                n = (int)this.numberSetter.getPreferredSize().getWidth();
                this.numberAndStringValue.setBounds(5, 87, 435 - n, 45);
                this.numberSetter.setBounds(440 - n, 87, n, 45);
                this.stringSetter.setBounds(440 - n, 87, n, 45);
            }
            this.propPanel.setBounds(5, 135, 440, 280);
        } else if (this.booleanValue.isVisible()) {
            if (!this.booleanSetter.isVisible()) {
                this.booleanValue.setBounds(5, 87, 440, 45);
            } else {
                n = (int)this.booleanSetter.getPreferredSize().getWidth();
                this.booleanValue.setBounds(5, 87, 435 - n, 45);
                this.booleanSetter.setBounds(440 - n, 87, n, 45);
            }
            this.propPanel.setBounds(5, 135, 440, 280);
        } else {
            this.propPanel.setBounds(5, 85, 440, 280);
        }
        this.nameLabel.setBounds(10, 15, 110, 25);
        this.nameText.setBounds(120, 15, 310, 25);
        this.minLabel.setBounds(10, 45, 110, 25);
        this.minText.setBounds(120, 45, 100, 25);
        this.maxLabel.setBounds(225, 45, 110, 25);
        this.maxText.setBounds(330, 45, 100, 25);
        this.alminLabel.setBounds(10, 75, 110, 25);
        this.alminText.setBounds(120, 75, 100, 25);
        this.almaxLabel.setBounds(225, 75, 110, 25);
        this.almaxText.setBounds(330, 75, 100, 25);
        this.formatLabel.setBounds(10, 105, 110, 25);
        this.formatText.setBounds(120, 105, 100, 25);
        this.unitLabel.setBounds(225, 105, 110, 25);
        this.unitText.setBounds(330, 105, 100, 25);
        this.minWarningLabel.setBounds(10, 135, 110, 25);
        this.minWarningText.setBounds(120, 135, 100, 25);
        this.maxWarningLabel.setBounds(225, 135, 110, 25);
        this.maxWarningText.setBounds(330, 135, 100, 25);
        this.deltaTLabel.setBounds(10, 165, 110, 25);
        this.deltaTText.setBounds(120, 165, 100, 25);
        this.deltaValLabel.setBounds(225, 165, 110, 25);
        this.deltaValText.setBounds(330, 165, 100, 25);
        this.textView.setBounds(10, 195, 425, 80);
        if (this.numberAndStringValue.isVisible() || this.booleanValue.isVisible()) {
            this.applyButton.setBounds(5, 420, 120, 30);
            this.infoButton.setBounds(160, 420, 120, 30);
            this.okButton.setBounds(325, 420, 120, 30);
            this.setSize(this.appsize);
        } else {
            this.applyButton.setBounds(5, 370, 120, 30);
            this.infoButton.setBounds(160, 370, 120, 30);
            this.okButton.setBounds(325, 370, 120, 30);
            Dimension dimension = new Dimension(this.appsize);
            dimension.height -= 50;
            this.setSize(dimension);
        }
        this.textView.revalidate();
    }

    public void setModel(IAttribute iAttribute) {
        this.model = iAttribute;
        if (this.model != null) {
            this.updateComponents();
            this.placeComponents();
            this.model.refresh();
        }
    }

    public void setEditable(boolean bl) {
        this.editable = bl;
        this.nameText.setEditable(bl);
        this.minText.setEditable(bl);
        this.maxText.setEditable(bl);
        this.alminText.setEditable(bl);
        this.almaxText.setEditable(bl);
        this.formatText.setEditable(bl);
        this.unitText.setEditable(bl);
        this.descText.setEditable(bl);
        this.applyButton.setEnabled(bl);
    }

    public boolean isEditable() {
        return this.editable;
    }

    private void showInformation() {
        String string = "Attribute: " + this.model.getName() + "\n\n";
        string = string + "Type: " + this.model.getType() + "\n";
        AttrWriteType attrWriteType = (AttrWriteType)this.model.getProperty("writable").getValue();
        switch (attrWriteType.value()) {
            case 0: {
                string = string + "Writable: READ\n";
                break;
            }
            case 1: {
                string = string + "Writable: READ_WITH_WRITE\n";
                break;
            }
            case 3: {
                string = string + "Writable: READ_WRITE\n";
                break;
            }
            case 2: {
                string = string + "Writable: WRITE\n";
            }
        }
        DispLevel dispLevel = (DispLevel)this.model.getProperty("level").getValue();
        switch (dispLevel.value()) {
            case 1: {
                string = string + "Display level: EXPERT\n";
                break;
            }
            case 0: {
                string = string + "Display level: OPERATOR\n";
            }
        }
        string = string + "Display unit factor: " + this.model.getDisplayUnitFactor() + "\n";
        string = string + "Standart unit factor: " + this.model.getStandardUnitFactor() + "\n";
        string = string + "Writable attribute: " + this.model.getProperty("writable_attr_name").getValue().toString() + "\n";
        string = string + "Max X dimension: " + this.model.getMaxXDimension() + "\n";
        string = string + "Max Y dimension: " + this.model.getMaxYDimension() + "\n";
        JOptionPane.showMessageDialog(this, string, "Information", 1);
    }

    public static void main(String[] stringArray) {
        SimplePropertyFrame simplePropertyFrame = new SimplePropertyFrame();
        AttributeList attributeList = new AttributeList();
        try {
            simplePropertyFrame.setModel((IAttribute)attributeList.add("jlp/test/1/att_un"));
        }
        catch (Exception exception) {
            System.out.println("attributeList.add() failed with " + exception.getMessage());
            exception.printStackTrace();
        }
        simplePropertyFrame.setDefaultCloseOperation(3);
        simplePropertyFrame.setVisible(true);
    }
}

