/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.attribute;

import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.AttributeStateEvent;
import fr.esrf.tangoatk.core.BooleanScalarEvent;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.IAttribute;
import fr.esrf.tangoatk.core.IBooleanScalar;
import fr.esrf.tangoatk.core.IBooleanScalarListener;
import fr.esrf.tangoatk.core.INumberScalar;
import fr.esrf.tangoatk.core.INumberScalarListener;
import fr.esrf.tangoatk.core.NumberScalarEvent;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;

public class SignalScalarLightViewer
extends JButton
implements INumberScalarListener,
IBooleanScalarListener {
    public static final ImageIcon bulbOff = new ImageIcon(SignalScalarLightViewer.class.getResource("/fr/esrf/tangoatk/widget/icons/bulbDisabled.gif"));
    public static final ImageIcon bulbOn = new ImageIcon(SignalScalarLightViewer.class.getResource("/fr/esrf/tangoatk/widget/icons/bulbEnabled.gif"));
    public static final ImageIcon bulbKO = new ImageIcon(SignalScalarLightViewer.class.getResource("/fr/esrf/tangoatk/widget/icons/bulbKO.gif"));
    public static final ImageIcon blueLED = new ImageIcon(SignalScalarLightViewer.class.getResource("/fr/esrf/tangoatk/widget/icons/ledBlue.gif"));
    public static final ImageIcon brownGrayLED = new ImageIcon(SignalScalarLightViewer.class.getResource("/fr/esrf/tangoatk/widget/icons/ledBrownGray.gif"));
    public static final ImageIcon darkGrayLED = new ImageIcon(SignalScalarLightViewer.class.getResource("/fr/esrf/tangoatk/widget/icons/ledDarkGray.gif"));
    public static final ImageIcon darkOrangeLED = new ImageIcon(SignalScalarLightViewer.class.getResource("/fr/esrf/tangoatk/widget/icons/ledDarkOrange.gif"));
    public static final ImageIcon grayLED = new ImageIcon(SignalScalarLightViewer.class.getResource("/fr/esrf/tangoatk/widget/icons/ledGray.gif"));
    public static final ImageIcon greenLED = new ImageIcon(SignalScalarLightViewer.class.getResource("/fr/esrf/tangoatk/widget/icons/ledGreen.gif"));
    public static final ImageIcon darkGreenLED = new ImageIcon(SignalScalarLightViewer.class.getResource("/fr/esrf/tangoatk/widget/icons/ledDarkGreen.gif"));
    public static final ImageIcon lightOrangeLED = new ImageIcon(SignalScalarLightViewer.class.getResource("/fr/esrf/tangoatk/widget/icons/ledLightOrange.gif"));
    public static final ImageIcon pinkLED = new ImageIcon(SignalScalarLightViewer.class.getResource("/fr/esrf/tangoatk/widget/icons/ledPink.gif"));
    public static final ImageIcon redLED = new ImageIcon(SignalScalarLightViewer.class.getResource("/fr/esrf/tangoatk/widget/icons/ledRed.gif"));
    public static final ImageIcon whiteLED = new ImageIcon(SignalScalarLightViewer.class.getResource("/fr/esrf/tangoatk/widget/icons/ledWhite.gif"));
    public static final ImageIcon yellowLED = new ImageIcon(SignalScalarLightViewer.class.getResource("/fr/esrf/tangoatk/widget/icons/ledYellow.gif"));
    public static final ImageIcon KOLED = new ImageIcon(SignalScalarLightViewer.class.getResource("/fr/esrf/tangoatk/widget/icons/ledKO.gif"));
    private ImageIcon m_iconLightOn;
    private ImageIcon m_iconLightOff;
    private ImageIcon m_iconLightKO;
    private IAttribute attributeModel = null;
    private String falseLabel = "FALSE";
    private String trueLabel = "TRUE";
    private String errorLabel = "ERROR";
    private Boolean formerValue = null;
    public static final int booleanLabel = 0;
    public static final int label = 1;
    public static final int name = 2;
    public static final int completeName = 3;
    public static final int customLabel = 4;
    public static final int labelAndBoolean = 5;
    public static final int nameAndBoolean = 6;
    private int chosenLabel = 0;
    private boolean viewLabel;

    public SignalScalarLightViewer() {
        this(false);
    }

    public SignalScalarLightViewer(boolean bl) {
        this.viewLabel = bl;
        this.setIconLightOn(redLED);
        this.setIconLightOff(grayLED);
        this.setIconLightKO(KOLED);
        this.setIcon(this.m_iconLightKO);
        this.repaint();
    }

    public void numberScalarChange(NumberScalarEvent numberScalarEvent) {
        Boolean bl = null;
        try {
            if (numberScalarEvent.getValue() == 1.0) {
                this.setIcon(this.m_iconLightOn);
                bl = new Boolean(true);
            } else {
                this.setIcon(this.m_iconLightOff);
                bl = new Boolean(false);
            }
        }
        catch (Exception exception) {
            this.setIcon(this.m_iconLightKO);
        }
        this.manageLabel(bl);
        this.repaint();
    }

    public void setViewLabel(boolean bl) {
        this.viewLabel = bl;
        this.manageLabel(this.formerValue);
    }

    public boolean isViewLabel() {
        return this.viewLabel;
    }

    public void stateChange(AttributeStateEvent attributeStateEvent) {
    }

    public void errorChange(ErrorEvent errorEvent) {
        this.setIcon(this.m_iconLightKO);
        this.manageLabel(null);
        this.repaint();
    }

    public IAttribute getAttributeModel() {
        return this.attributeModel;
    }

    public void setAttributeModel(IAttribute iAttribute) {
        if (!(iAttribute instanceof INumberScalar) && !(iAttribute instanceof IBooleanScalar)) {
            return;
        }
        this.clearAttributeModel();
        this.attributeModel = iAttribute;
        if (this.attributeModel instanceof INumberScalar) {
            ((INumberScalar)iAttribute).addNumberScalarListener(this);
            if (this.viewLabel) {
                this.setText(this.attributeModel.getLabel());
            }
        }
        if (this.attributeModel instanceof IBooleanScalar) {
            ((IBooleanScalar)iAttribute).addBooleanScalarListener(this);
            if (this.viewLabel) {
                this.setText(this.attributeModel.getLabel());
            }
        }
    }

    public void clearAttributeModel() {
        if (this.attributeModel != null) {
            if (this.attributeModel instanceof INumberScalar) {
                ((INumberScalar)this.attributeModel).removeNumberScalarListener(this);
            }
            if (this.attributeModel instanceof IBooleanScalar) {
                ((IBooleanScalar)this.attributeModel).removeBooleanScalarListener(this);
            }
            this.attributeModel = null;
        }
    }

    public int getChosenLabel() {
        return this.chosenLabel;
    }

    public void setChosenLabel(int n) {
        this.chosenLabel = n;
    }

    public String getFalseLabel() {
        return this.falseLabel;
    }

    public void setFalseLabel(String string) {
        this.falseLabel = string;
    }

    public String getTrueLabel() {
        return this.trueLabel;
    }

    public void setTrueLabel(String string) {
        this.trueLabel = string;
    }

    private void manageLabel(Boolean bl) {
        this.formerValue = bl;
        if (this.viewLabel) {
            if (this.attributeModel == null) {
                this.setText("Unknown Attribute");
                return;
            }
            switch (this.chosenLabel) {
                case 1: {
                    this.setText(this.attributeModel.getLabel());
                    break;
                }
                case 2: {
                    this.setText(this.attributeModel.getNameSansDevice());
                    break;
                }
                case 0: {
                    if (bl == null) {
                        this.setText(this.errorLabel);
                        break;
                    }
                    if (bl.booleanValue()) {
                        this.setText(this.trueLabel);
                        break;
                    }
                    this.setText(this.falseLabel);
                    break;
                }
                case 5: {
                    if (bl == null) {
                        this.setText(this.attributeModel.getLabel() + ":" + this.errorLabel);
                        break;
                    }
                    if (bl.booleanValue()) {
                        this.setText(this.attributeModel.getLabel() + ":" + this.trueLabel);
                        break;
                    }
                    this.setText(this.attributeModel.getLabel() + ":" + this.falseLabel);
                    break;
                }
                case 6: {
                    if (bl == null) {
                        this.setText(this.attributeModel.getNameSansDevice() + ":" + this.errorLabel);
                        break;
                    }
                    if (bl.booleanValue()) {
                        this.setText(this.attributeModel.getNameSansDevice() + ":" + this.trueLabel);
                        break;
                    }
                    this.setText(this.attributeModel.getNameSansDevice() + ":" + this.falseLabel);
                    break;
                }
                case 3: {
                    this.setText(this.attributeModel.getName());
                    break;
                }
            }
        }
    }

    public void setIconLightOn(ImageIcon imageIcon) {
        this.m_iconLightOn = imageIcon;
    }

    public void setIconLightOff(ImageIcon imageIcon) {
        this.m_iconLightOff = imageIcon;
    }

    public void setIconLightKO(ImageIcon imageIcon) {
        this.m_iconLightKO = imageIcon;
    }

    public void booleanScalarChange(BooleanScalarEvent booleanScalarEvent) {
        try {
            if (booleanScalarEvent.getValue()) {
                this.setIcon(this.m_iconLightOn);
            } else {
                this.setIcon(this.m_iconLightOff);
            }
        }
        catch (Exception exception) {
            this.setIcon(this.m_iconLightKO);
        }
        this.manageLabel(new Boolean(booleanScalarEvent.getValue()));
        this.repaint();
    }

    public static void main(String[] stringArray) {
        AttributeList attributeList = new AttributeList();
        SignalScalarLightViewer signalScalarLightViewer = new SignalScalarLightViewer(true);
        try {
            if (stringArray.length != 0) {
                signalScalarLightViewer.setAttributeModel((IAttribute)attributeList.add(stringArray[0]));
            } else {
                signalScalarLightViewer.setAttributeModel((IAttribute)attributeList.add("test/testSignal2/1/signal"));
            }
            attributeList.setRefreshInterval(1000);
            attributeList.startRefresher();
            JFrame jFrame = new JFrame(signalScalarLightViewer.getAttributeModel().getName().substring(0, signalScalarLightViewer.getAttributeModel().getName().lastIndexOf("/")));
            jFrame.setDefaultCloseOperation(3);
            jFrame.getContentPane().add(signalScalarLightViewer);
            jFrame.setSize(300, 50);
            jFrame.setVisible(true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
    }
}

