/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.attribute;

import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.IAttribute;
import fr.esrf.tangoatk.core.IBooleanScalar;
import fr.esrf.tangoatk.core.IEnumScalar;
import fr.esrf.tangoatk.core.INumberScalar;
import fr.esrf.tangoatk.core.IStringScalar;
import fr.esrf.tangoatk.core.attribute.AAttribute;
import fr.esrf.tangoatk.widget.attribute.BooleanScalarCheckBoxViewer;
import fr.esrf.tangoatk.widget.attribute.BooleanScalarComboEditor;
import fr.esrf.tangoatk.widget.attribute.EnumScalarComboEditor;
import fr.esrf.tangoatk.widget.attribute.NumberScalarComboEditor;
import fr.esrf.tangoatk.widget.attribute.NumberScalarWheelEditor;
import fr.esrf.tangoatk.widget.attribute.SimpleEnumScalarViewer;
import fr.esrf.tangoatk.widget.attribute.SimplePropertyFrame;
import fr.esrf.tangoatk.widget.attribute.SimpleScalarViewer;
import fr.esrf.tangoatk.widget.attribute.StringScalarComboEditor;
import fr.esrf.tangoatk.widget.attribute.StringScalarEditor;
import fr.esrf.tangoatk.widget.properties.LabelViewer;
import fr.esrf.tangoatk.widget.util.JAutoScrolledText;
import fr.esrf.tangoatk.widget.util.JAutoScrolledTextListener;
import fr.esrf.tangoatk.widget.util.JSmoothLabel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.text.JTextComponent;

public class ScalarListSetter
extends JPanel
implements JAutoScrolledTextListener {
    public static final String BOOLEAN_DEFAULT_SETTER = "None";
    public static final String BOOLEAN_COMBO_SETTER = "BooleanComboEditor";
    protected Vector<IAttribute> listModel = null;
    protected Vector<LabelViewer> scalarLabels = null;
    protected Vector<JComponent> scalarViewers = null;
    protected Vector<JComponent> scalarSetters = null;
    protected Vector<JButton> scalarPropButtons = null;
    protected SimplePropertyFrame propFrame = new SimplePropertyFrame();
    protected Font theFont = new Font("Dialog", 0, 14);
    private boolean labelVisible = true;
    private boolean viewerVisible = true;
    private boolean propertyButtonVisible = true;
    private boolean propertyListEditable = true;
    private boolean unitVisible = true;
    private String booleanSetterType = "None";
    private Color arrowColor = null;
    private String numberSetterType = "deprecated";
    private String stringSetterType = "deprecated";
    public static final String NUMBER_DEFAULT_SETTER = "WheelEditor";
    public static final String NUMBER_COMBO_SETTER = "ComboEditor";
    public static final String STRING_DEFAULT_SETTER = "StringScalarEditor";
    public static final String STRING_COMBO_SETTER = "StringComboEditor";

    public ScalarListSetter() {
        this.setLayout(new GridBagLayout());
        this.setVisible(false);
    }

    public void setModel(AttributeList attributeList) {
        if (attributeList == null) {
            if (this.listModel != null) {
                this.removeComponents();
            }
            return;
        }
        if (this.listModel != null) {
            return;
        }
        int n = attributeList.getSize();
        if (n <= 0) {
            return;
        }
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            IAttribute iAttribute;
            Object e = attributeList.getElementAt(i);
            if (!(e instanceof INumberScalar) && !(e instanceof IStringScalar) && !(e instanceof IBooleanScalar) && !(e instanceof IEnumScalar) || !(iAttribute = (IAttribute)e).isWritable()) continue;
            bl = true;
            break;
        }
        if (!bl) {
            return;
        }
        this.initComponents(attributeList);
        this.setVisible(true);
    }

    protected void removeComponents() {
        IAttribute iAttribute = null;
        JComponent jComponent = null;
        LabelViewer labelViewer = null;
        SimpleScalarViewer simpleScalarViewer = null;
        BooleanScalarCheckBoxViewer booleanScalarCheckBoxViewer = null;
        SimpleEnumScalarViewer simpleEnumScalarViewer = null;
        NumberScalarWheelEditor numberScalarWheelEditor = null;
        NumberScalarComboEditor numberScalarComboEditor = null;
        StringScalarEditor stringScalarEditor = null;
        StringScalarComboEditor stringScalarComboEditor = null;
        BooleanScalarComboEditor booleanScalarComboEditor = null;
        EnumScalarComboEditor enumScalarComboEditor = null;
        Object var19_13 = null;
        this.propFrame = null;
        this.propFrame = new SimplePropertyFrame();
        int n = this.listModel.size();
        for (int i = 0; i < n; ++i) {
            try {
                INumberScalar iNumberScalar = null;
                IStringScalar iStringScalar = null;
                IBooleanScalar iBooleanScalar = null;
                IEnumScalar iEnumScalar = null;
                iAttribute = this.listModel.get(i);
                if (iAttribute instanceof INumberScalar) {
                    iNumberScalar = (INumberScalar)iAttribute;
                } else if (iAttribute instanceof IStringScalar) {
                    iStringScalar = (IStringScalar)iAttribute;
                } else if (iAttribute instanceof IBooleanScalar) {
                    iBooleanScalar = (IBooleanScalar)iAttribute;
                } else if (iAttribute instanceof IEnumScalar) {
                    iEnumScalar = (IEnumScalar)iAttribute;
                }
                if (iNumberScalar == null && iStringScalar == null && iBooleanScalar == null && iEnumScalar == null) continue;
                labelViewer = this.scalarLabels.get(i);
                labelViewer.setModel(null);
                jComponent = this.scalarViewers.get(i);
                if (jComponent instanceof SimpleScalarViewer) {
                    simpleScalarViewer = (SimpleScalarViewer)jComponent;
                    simpleScalarViewer.clearModel();
                } else if (jComponent instanceof BooleanScalarCheckBoxViewer) {
                    booleanScalarCheckBoxViewer = (BooleanScalarCheckBoxViewer)jComponent;
                    booleanScalarCheckBoxViewer.clearModel();
                } else if (jComponent instanceof SimpleEnumScalarViewer) {
                    simpleEnumScalarViewer = (SimpleEnumScalarViewer)jComponent;
                    simpleEnumScalarViewer.clearModel();
                }
                jComponent = this.scalarSetters.get(i);
                if (jComponent == null) continue;
                if (jComponent instanceof NumberScalarWheelEditor) {
                    numberScalarWheelEditor = (NumberScalarWheelEditor)jComponent;
                    numberScalarWheelEditor.setModel(null);
                    continue;
                }
                if (jComponent instanceof NumberScalarComboEditor) {
                    numberScalarComboEditor = (NumberScalarComboEditor)jComponent;
                    numberScalarComboEditor.setNumberModel(null);
                    continue;
                }
                if (jComponent instanceof StringScalarEditor) {
                    stringScalarEditor = (StringScalarEditor)jComponent;
                    stringScalarEditor.setModel(null);
                    continue;
                }
                if (jComponent instanceof StringScalarComboEditor) {
                    stringScalarComboEditor = (StringScalarComboEditor)jComponent;
                    stringScalarComboEditor.setStringModel(null);
                    continue;
                }
                if (jComponent instanceof BooleanScalarComboEditor) {
                    booleanScalarComboEditor = (BooleanScalarComboEditor)jComponent;
                    if (iBooleanScalar == null || !iBooleanScalar.isWritable()) continue;
                    booleanScalarComboEditor.setAttModel(null);
                    continue;
                }
                if (!(jComponent instanceof EnumScalarComboEditor)) continue;
                enumScalarComboEditor = (EnumScalarComboEditor)jComponent;
                if (iEnumScalar == null || !iEnumScalar.isWritable()) continue;
                enumScalarComboEditor.setEnumModel(null);
                continue;
            }
            catch (Exception exception) {
                System.out.println("ScalarListSetter : setTheFont : Caught exception  " + exception.getMessage());
            }
        }
        this.scalarLabels.removeAllElements();
        this.scalarViewers.removeAllElements();
        this.scalarSetters.removeAllElements();
        this.scalarPropButtons.removeAllElements();
        this.listModel.removeAllElements();
        this.removeAll();
        this.listModel = null;
        this.scalarLabels = null;
        this.scalarViewers = null;
        this.scalarSetters = null;
        this.scalarPropButtons = null;
    }

    public Font getTheFont() {
        return this.theFont;
    }

    public void setTheFont(Font font) {
        LabelViewer labelViewer = null;
        JComponent jComponent = null;
        JComponent jComponent2 = null;
        JButton jButton = null;
        if (font != null) {
            this.theFont = font;
            if (this.listModel != null) {
                int n = this.listModel.size();
                for (int i = 0; i < n; ++i) {
                    try {
                        labelViewer = this.scalarLabels.get(i);
                        labelViewer.setFont(this.theFont);
                        jComponent = this.scalarViewers.get(i);
                        if (jComponent != null && (jComponent instanceof SimpleScalarViewer || jComponent instanceof BooleanScalarCheckBoxViewer || jComponent instanceof SimpleEnumScalarViewer)) {
                            jComponent.setFont(this.theFont);
                        }
                        if ((jComponent2 = this.scalarSetters.get(i)) != null && (jComponent2 instanceof NumberScalarWheelEditor || jComponent2 instanceof NumberScalarComboEditor || jComponent2 instanceof StringScalarEditor || jComponent2 instanceof StringScalarComboEditor || jComponent2 instanceof BooleanScalarComboEditor || jComponent2 instanceof EnumScalarComboEditor)) {
                            jComponent2.setFont(this.theFont);
                        }
                        jButton = this.scalarPropButtons.get(i);
                        jButton.setFont(this.theFont);
                        continue;
                    }
                    catch (Exception exception) {
                        System.out.println("ScalarListSetter : setTheFont : Caught exception  " + exception.getMessage());
                    }
                }
            }
        }
    }

    public boolean getLabelVisible() {
        return this.labelVisible;
    }

    public void setLabelVisible(boolean bl) {
        if (this.labelVisible != bl) {
            this.labelVisible = bl;
            this.changeLabelVisibility();
        }
    }

    private void changeLabelVisibility() {
        LabelViewer labelViewer = null;
        if (this.scalarLabels != null) {
            int n = this.scalarLabels.size();
            for (int i = 0; i < n; ++i) {
                try {
                    labelViewer = this.scalarLabels.get(i);
                    labelViewer.setVisible(this.labelVisible);
                    continue;
                }
                catch (Exception exception) {
                    System.out.println("ScalarListSetter : changeLabelVisibility : Caught exception  " + exception.getMessage());
                }
            }
        }
    }

    public boolean getViewerVisible() {
        return this.viewerVisible;
    }

    public void setViewerVisible(boolean bl) {
        if (this.viewerVisible != bl) {
            this.viewerVisible = bl;
            this.changeViewerVisibility();
        }
    }

    private void changeViewerVisibility() {
        JComponent jComponent = null;
        if (this.scalarViewers != null) {
            int n = this.scalarViewers.size();
            for (int i = 0; i < n; ++i) {
                try {
                    jComponent = this.scalarViewers.get(i);
                    if (jComponent == null || !(jComponent instanceof SimpleScalarViewer) && !(jComponent instanceof BooleanScalarCheckBoxViewer) && !(jComponent instanceof SimpleEnumScalarViewer)) continue;
                    jComponent.setVisible(this.viewerVisible);
                    if (!(jComponent instanceof BooleanScalarCheckBoxViewer) || this.viewerVisible || this.booleanSetterType.equalsIgnoreCase(BOOLEAN_COMBO_SETTER)) continue;
                    jComponent.setVisible(true);
                    continue;
                }
                catch (Exception exception) {
                    System.out.println("ScalarListSetter : changeViewerVisibility : Caught exception  " + exception.getMessage());
                }
            }
        }
    }

    public boolean getPropertyButtonVisible() {
        return this.propertyButtonVisible;
    }

    public void setPropertyButtonVisible(boolean bl) {
        if (this.propertyButtonVisible != bl) {
            this.propertyButtonVisible = bl;
            this.changePropButtonVisibility();
        }
    }

    private void changePropButtonVisibility() {
        JButton jButton = null;
        if (this.scalarPropButtons != null) {
            int n = this.scalarPropButtons.size();
            for (int i = 0; i < n; ++i) {
                try {
                    jButton = this.scalarPropButtons.get(i);
                    jButton.setVisible(this.propertyButtonVisible);
                    continue;
                }
                catch (Exception exception) {
                    System.out.println("ScalarListSetter : changePropButtonVisibility : Caught exception  " + exception.getMessage());
                }
            }
        }
    }

    public boolean getPropertyListEditable() {
        return this.propertyListEditable;
    }

    public void setPropertyListEditable(boolean bl) {
    }

    public boolean getUnitVisible() {
        return this.unitVisible;
    }

    public void setUnitVisible(boolean bl) {
        if (this.unitVisible != bl) {
            this.unitVisible = bl;
            this.changeUnitVisibility();
        }
    }

    private void changeUnitVisibility() {
        JComponent jComponent = null;
        SimpleScalarViewer simpleScalarViewer = null;
        NumberScalarComboEditor numberScalarComboEditor = null;
        if (this.scalarViewers != null) {
            int n = this.scalarViewers.size();
            for (int i = 0; i < n; ++i) {
                try {
                    jComponent = this.scalarViewers.get(i);
                    if (jComponent != null && jComponent instanceof SimpleScalarViewer) {
                        simpleScalarViewer = (SimpleScalarViewer)jComponent;
                        simpleScalarViewer.setUnitVisible(this.unitVisible);
                    }
                    if ((jComponent = this.scalarSetters.get(i)) == null || !(jComponent instanceof NumberScalarComboEditor)) continue;
                    numberScalarComboEditor = (NumberScalarComboEditor)jComponent;
                    numberScalarComboEditor.setUnitVisible(this.unitVisible);
                    continue;
                }
                catch (Exception exception) {
                    System.out.println("ScalarListViewer : changeUnitVisibility : Caught exception  " + exception.getMessage());
                }
            }
        }
    }

    public String getBooleanSetterType() {
        return this.booleanSetterType;
    }

    public void setBooleanSetterType(String string) {
        if (this.listModel != null) {
            return;
        }
        this.booleanSetterType = string.equalsIgnoreCase(BOOLEAN_DEFAULT_SETTER) ? BOOLEAN_DEFAULT_SETTER : (string.equalsIgnoreCase(BOOLEAN_COMBO_SETTER) ? BOOLEAN_COMBO_SETTER : BOOLEAN_DEFAULT_SETTER);
    }

    public String getNumberSetterType() {
        return this.numberSetterType;
    }

    public void setNumberSetterType(String string) {
    }

    public String getStringSetterType() {
        return this.stringSetterType;
    }

    public void setStringSetterType(String string) {
    }

    public Color getArrowColor() {
        if (this.arrowColor == null) {
            return this.getBackground();
        }
        return this.arrowColor;
    }

    public void setArrowColor(Color color) {
        if (color == this.arrowColor) {
            return;
        }
        this.changeArrowColors(color);
        this.arrowColor = color;
    }

    private void changeArrowColors(Color color) {
        JComponent jComponent = null;
        NumberScalarWheelEditor numberScalarWheelEditor = null;
        if (this.scalarSetters != null) {
            int n = this.scalarSetters.size();
            for (int i = 0; i < n; ++i) {
                try {
                    jComponent = this.scalarSetters.get(i);
                    if (!(jComponent instanceof NumberScalarWheelEditor)) continue;
                    numberScalarWheelEditor = (NumberScalarWheelEditor)jComponent;
                    if (color == null) {
                        numberScalarWheelEditor.setButtonColor(numberScalarWheelEditor.getBackground());
                        continue;
                    }
                    numberScalarWheelEditor.setButtonColor(color);
                    continue;
                }
                catch (Exception exception) {
                    System.out.println("ScalarListSetter : changeArrowColors : Caught exception  " + exception.getMessage());
                }
            }
        }
    }

    public void textExceedBounds(JAutoScrolledText jAutoScrolledText) {
        this.revalidate();
    }

    protected void initComponents(AttributeList attributeList) {
        LabelViewer labelViewer = null;
        SimpleScalarViewer simpleScalarViewer = null;
        BooleanScalarCheckBoxViewer booleanScalarCheckBoxViewer = null;
        BooleanScalarComboEditor booleanScalarComboEditor = null;
        SimpleEnumScalarViewer simpleEnumScalarViewer = null;
        EnumScalarComboEditor enumScalarComboEditor = null;
        NumberScalarWheelEditor numberScalarWheelEditor = null;
        NumberScalarComboEditor numberScalarComboEditor = null;
        StringScalarEditor stringScalarEditor = null;
        StringScalarComboEditor stringScalarComboEditor = null;
        Object var23_12 = null;
        JComponent jComponent = null;
        JComponent jComponent2 = null;
        JButton jButton = null;
        this.listModel = new Vector();
        this.scalarLabels = new Vector();
        this.scalarViewers = new Vector();
        this.scalarSetters = new Vector();
        this.scalarPropButtons = new Vector();
        int n = 0;
        int n2 = attributeList.size();
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            Insets insets;
            int n4;
            Serializable serializable;
            AAttribute aAttribute;
            labelViewer = null;
            simpleScalarViewer = null;
            jComponent = null;
            booleanScalarCheckBoxViewer = null;
            booleanScalarComboEditor = null;
            simpleEnumScalarViewer = null;
            enumScalarComboEditor = null;
            numberScalarWheelEditor = null;
            numberScalarComboEditor = null;
            jComponent2 = null;
            stringScalarEditor = null;
            stringScalarComboEditor = null;
            jButton = null;
            Object e = attributeList.getElementAt(i);
            if (!(e instanceof AAttribute) || !(aAttribute = (AAttribute)e).isWritable() || !(e instanceof INumberScalar) && !(e instanceof IStringScalar) && !(e instanceof IBooleanScalar) && !(e instanceof IEnumScalar)) continue;
            INumberScalar iNumberScalar = null;
            IStringScalar iStringScalar = null;
            IBooleanScalar iBooleanScalar = null;
            IEnumScalar iEnumScalar = null;
            if (e instanceof INumberScalar) {
                simpleScalarViewer = new SimpleScalarViewer();
                serializable = simpleScalarViewer.getMargin();
                ((Insets)serializable).left += 2;
                ((Insets)serializable).right += 2;
                simpleScalarViewer.setMargin((Insets)serializable);
                jComponent = simpleScalarViewer;
                iNumberScalar = (INumberScalar)e;
                boolean bl = false;
                if (iNumberScalar.getPossibleValues() != null && iNumberScalar.getPossibleValues().length > 0) {
                    bl = true;
                }
                if (bl) {
                    numberScalarComboEditor = new NumberScalarComboEditor();
                    numberScalarComboEditor.setFont(this.theFont);
                    numberScalarComboEditor.setBackground(this.getBackground());
                    numberScalarComboEditor.setUnitVisible(this.unitVisible);
                    numberScalarComboEditor.setNumberModel(iNumberScalar);
                    this.scalarSetters.add(numberScalarComboEditor);
                    jComponent2 = numberScalarComboEditor;
                } else {
                    numberScalarWheelEditor = new NumberScalarWheelEditor();
                    numberScalarWheelEditor.setFont(this.theFont);
                    numberScalarWheelEditor.setBackground(this.getBackground());
                    numberScalarWheelEditor.setModel(iNumberScalar);
                    this.scalarSetters.add(numberScalarWheelEditor);
                    jComponent2 = numberScalarWheelEditor;
                }
            } else if (e instanceof IBooleanScalar) {
                iBooleanScalar = (IBooleanScalar)e;
                booleanScalarCheckBoxViewer = new BooleanScalarCheckBoxViewer();
                booleanScalarCheckBoxViewer.setTrueLabel(new String());
                booleanScalarCheckBoxViewer.setFalseLabel(new String());
                jComponent = booleanScalarCheckBoxViewer;
                if (this.booleanSetterType.equalsIgnoreCase(BOOLEAN_COMBO_SETTER)) {
                    booleanScalarComboEditor = new BooleanScalarComboEditor();
                    booleanScalarComboEditor.setFont(this.theFont);
                    booleanScalarComboEditor.setBackground(this.getBackground());
                    booleanScalarComboEditor.setAttModel(iBooleanScalar);
                    jComponent2 = booleanScalarComboEditor;
                } else {
                    jComponent2 = null;
                }
                this.scalarSetters.add(jComponent2);
            } else if (e instanceof IEnumScalar) {
                iEnumScalar = (IEnumScalar)e;
                simpleEnumScalarViewer = new SimpleEnumScalarViewer();
                jComponent = simpleEnumScalarViewer;
                enumScalarComboEditor = new EnumScalarComboEditor();
                enumScalarComboEditor.setFont(this.theFont);
                enumScalarComboEditor.setBackground(this.getBackground());
                enumScalarComboEditor.setEnumModel(iEnumScalar);
                jComponent2 = enumScalarComboEditor;
                this.scalarSetters.add(jComponent2);
            } else {
                simpleScalarViewer = new SimpleScalarViewer();
                jComponent = simpleScalarViewer;
                iStringScalar = (IStringScalar)e;
                boolean bl = false;
                if (iStringScalar.getPossibleValues() != null && iStringScalar.getPossibleValues().length > 0) {
                    bl = true;
                }
                if (bl) {
                    stringScalarComboEditor = new StringScalarComboEditor();
                    stringScalarComboEditor.setFont(this.theFont);
                    stringScalarComboEditor.setStringModel(iStringScalar);
                    this.scalarSetters.add(stringScalarComboEditor);
                    jComponent2 = stringScalarComboEditor;
                } else {
                    stringScalarEditor = new StringScalarEditor();
                    stringScalarEditor.setFont(this.theFont);
                    stringScalarEditor.setModel(iStringScalar);
                    this.scalarSetters.add(stringScalarEditor);
                    jComponent2 = stringScalarEditor;
                }
            }
            labelViewer = new LabelViewer();
            jButton = new JButton();
            labelViewer.setFont(this.theFont);
            labelViewer.setHorizontalAlignment(JSmoothLabel.RIGHT_ALIGNMENT);
            labelViewer.setBackground(this.getBackground());
            if (iNumberScalar != null) {
                labelViewer.setModel(iNumberScalar);
            } else if (iStringScalar != null) {
                labelViewer.setModel(iStringScalar);
            } else if (iBooleanScalar != null) {
                labelViewer.setModel(iBooleanScalar);
            } else if (iEnumScalar != null) {
                labelViewer.setModel(iEnumScalar);
            }
            if (simpleScalarViewer != null) {
                simpleScalarViewer.setFont(this.theFont);
                simpleScalarViewer.setUnitVisible(this.unitVisible);
                simpleScalarViewer.setBackgroundColor(this.getBackground());
                simpleScalarViewer.setBorder(BorderFactory.createLoweredBevelBorder());
                simpleScalarViewer.setAlarmEnabled(true);
                simpleScalarViewer.addTextListener(this);
                if (iNumberScalar != null) {
                    simpleScalarViewer.setModel(iNumberScalar);
                } else {
                    simpleScalarViewer.setModel(iStringScalar);
                }
            } else if (booleanScalarCheckBoxViewer != null) {
                booleanScalarCheckBoxViewer.setAttModel(iBooleanScalar);
                booleanScalarCheckBoxViewer.setBackground(this.getBackground());
            } else if (simpleEnumScalarViewer != null) {
                simpleEnumScalarViewer.setFont(this.theFont);
                simpleEnumScalarViewer.setBackgroundColor(this.getBackground());
                simpleEnumScalarViewer.setBorder(BorderFactory.createLoweredBevelBorder());
                simpleEnumScalarViewer.setAlarmEnabled(true);
                simpleEnumScalarViewer.addTextListener(this);
                simpleEnumScalarViewer.setModel(iEnumScalar);
            }
            jButton.setFont(this.theFont);
            jButton.setBackground(this.getBackground());
            jButton.setText(" ... ");
            jButton.setMargin(new Insets(-3, 0, 3, 0));
            jButton.setToolTipText("Attribute Properties");
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ScalarListSetter.this.propertyButtonActionPerformed(actionEvent);
                }
            });
            labelViewer.setVisible(this.labelVisible);
            jComponent.setVisible(this.viewerVisible);
            jButton.setVisible(this.propertyButtonVisible);
            if (iBooleanScalar != null && !this.viewerVisible && !this.booleanSetterType.equalsIgnoreCase(BOOLEAN_COMBO_SETTER)) {
                jComponent.setVisible(true);
            }
            if (iNumberScalar != null) {
                iNumberScalar.refresh();
            } else if (iStringScalar != null) {
                iStringScalar.refresh();
            } else if (iBooleanScalar != null) {
                iBooleanScalar.refresh();
            } else if (iEnumScalar != null) {
                iEnumScalar.refresh();
            }
            n3 = 0;
            int n5 = labelViewer.getPreferredSize().height + 4;
            if (n5 > n3) {
                n3 = n5;
            }
            if ((n5 = jComponent2.getPreferredSize().height + 4) > n3) {
                n3 = n5;
            }
            if (jComponent != null && jComponent.isVisible() && (n5 = jComponent.getPreferredSize().height + 4) > n3) {
                n3 = n5;
            }
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = n;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(2, 6, 2, 1);
            this.add((Component)labelViewer, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = n;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(2, 3, 2, 1);
            this.add((Component)jComponent, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = n;
            gridBagConstraints.fill = 1;
            if (jComponent2 != null) {
                if (iNumberScalar != null) {
                    gridBagConstraints.insets = new Insets(1, 3, 1, 1);
                    this.add((Component)jComponent2, gridBagConstraints);
                } else if (iStringScalar != null) {
                    gridBagConstraints.insets = new Insets(2, 3, 2, 1);
                    this.add((Component)jComponent2, gridBagConstraints);
                } else if (iBooleanScalar != null) {
                    gridBagConstraints.insets = new Insets(2, 3, 2, 1);
                    this.add((Component)jComponent2, gridBagConstraints);
                } else if (iEnumScalar != null) {
                    gridBagConstraints.insets = new Insets(2, 3, 2, 1);
                    this.add((Component)jComponent2, gridBagConstraints);
                }
            }
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 3;
            gridBagConstraints.gridy = n;
            gridBagConstraints.insets = new Insets(2, 3, 2, 6);
            this.add((Component)jButton, gridBagConstraints);
            if (iNumberScalar != null) {
                this.listModel.add(iNumberScalar);
            } else if (iStringScalar != null) {
                this.listModel.add(iStringScalar);
            } else if (iBooleanScalar != null) {
                this.listModel.add(iBooleanScalar);
            } else if (iEnumScalar != null) {
                this.listModel.add(iEnumScalar);
            }
            this.scalarLabels.add(labelViewer);
            this.scalarViewers.add(jComponent);
            this.scalarPropButtons.add(jButton);
            if (jComponent2 instanceof StringScalarEditor) {
                serializable = (StringScalarEditor)jComponent2;
                n5 = jComponent2.getPreferredSize().height;
                n4 = n5 < n3 ? (n3 - n5) / 2 : 0;
                insets = ((JTextComponent)serializable).getMargin();
                insets.top += n4;
                insets.bottom += n4;
                insets.left += 2;
                insets.right += 2;
                ((JTextComponent)serializable).setMargin(insets);
            }
            if (jComponent.isVisible()) {
                if (jComponent instanceof SimpleScalarViewer) {
                    serializable = (SimpleScalarViewer)jComponent;
                    n5 = jComponent.getPreferredSize().height;
                    n4 = n5 < n3 ? (n3 - n5) / 2 : 0;
                    insets = ((JAutoScrolledText)serializable).getMargin();
                    insets.top += n4;
                    insets.bottom += n4;
                    insets.left += 2;
                    insets.right += 2;
                    ((JAutoScrolledText)serializable).setMargin(insets);
                } else if (jComponent instanceof SimpleEnumScalarViewer) {
                    serializable = (SimpleEnumScalarViewer)jComponent;
                    n5 = jComponent.getPreferredSize().height;
                    n4 = n5 < n3 ? (n3 - n5) / 2 : 0;
                    insets = ((JAutoScrolledText)serializable).getMargin();
                    insets.top += n4;
                    insets.bottom += n4;
                    insets.left += 2;
                    insets.right += 2;
                    ((JAutoScrolledText)serializable).setMargin(insets);
                }
            }
            ++n;
        }
    }

    private void propertyButtonActionPerformed(ActionEvent actionEvent) {
        int n = -1;
        if (this.scalarPropButtons == null) {
            return;
        }
        if (this.listModel == null) {
            return;
        }
        int n2 = this.scalarPropButtons.size();
        for (int i = 0; i < n2; ++i) {
            try {
                JButton jButton = this.scalarPropButtons.get(i);
                if (!jButton.equals(actionEvent.getSource())) continue;
                n = i;
                break;
            }
            catch (Exception exception) {
                System.out.println("ScalarListSetter : propertyButtonActionPerformed : Caught exception  " + exception.getMessage());
                return;
            }
        }
        if (n < 0) {
            return;
        }
        INumberScalar iNumberScalar = null;
        IStringScalar iStringScalar = null;
        IBooleanScalar iBooleanScalar = null;
        IEnumScalar iEnumScalar = null;
        try {
            IAttribute iAttribute = this.listModel.get(n);
            if (iAttribute instanceof INumberScalar) {
                iNumberScalar = (INumberScalar)iAttribute;
            } else if (iAttribute instanceof IStringScalar) {
                iStringScalar = (IStringScalar)iAttribute;
            } else if (iAttribute instanceof IBooleanScalar) {
                iBooleanScalar = (IBooleanScalar)iAttribute;
            } else if (iAttribute instanceof IEnumScalar) {
                iEnumScalar = (IEnumScalar)iAttribute;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (iNumberScalar == null && iStringScalar == null && iBooleanScalar == null && iEnumScalar == null) {
            return;
        }
        if (this.propFrame != null) {
            if (iNumberScalar != null) {
                this.propFrame.setModel(iNumberScalar);
            } else if (iStringScalar != null) {
                this.propFrame.setModel(iStringScalar);
            } else if (iBooleanScalar != null) {
                this.propFrame.setModel(iBooleanScalar);
            } else if (iEnumScalar != null) {
                this.propFrame.setModel(iEnumScalar);
            }
            this.propFrame.setVisible(true);
        }
    }

    public static void main(String[] stringArray) {
        final AttributeList attributeList = new AttributeList();
        ScalarListSetter scalarListSetter = new ScalarListSetter();
        scalarListSetter.setTheFont(new Font("Lucida Bright", 0, 18));
        scalarListSetter.setViewerVisible(false);
        scalarListSetter.setBooleanSetterType(BOOLEAN_COMBO_SETTER);
        try {
            INumberScalar iNumberScalar = (INumberScalar)attributeList.add("jlp/test/1/att_un");
            iNumberScalar = (INumberScalar)attributeList.add("jlp/test/1/att_deux");
            iNumberScalar = (INumberScalar)attributeList.add("jlp/test/1/att_trois");
            iNumberScalar = (INumberScalar)attributeList.add("jlp/test/1/att_quatre");
            IStringScalar iStringScalar = (IStringScalar)attributeList.add("jlp/test/1/att_cinq");
            IBooleanScalar iBooleanScalar = (IBooleanScalar)attributeList.add("jlp/test/1/Att_boolean");
            IAttribute iAttribute = (IAttribute)attributeList.add("jlp/test/1/att_six");
            scalarListSetter.setModel(attributeList);
        }
        catch (Exception exception) {
            System.out.println("caught exception : " + exception.getMessage());
            exception.printStackTrace();
            System.exit(-1);
        }
        JFrame jFrame = new JFrame();
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowActivated(WindowEvent windowEvent) {
                attributeList.startRefresher();
            }
        });
        jFrame.setContentPane(scalarListSetter);
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

