/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.attribute;

import fr.esrf.tangoatk.core.AttributePolledList;
import fr.esrf.tangoatk.core.AttributeStateEvent;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.IAttributeStateListener;
import fr.esrf.tangoatk.core.IErrorListener;
import fr.esrf.tangoatk.core.INumberSpectrum;
import fr.esrf.tangoatk.core.ISpectrumListener;
import fr.esrf.tangoatk.core.NumberSpectrumEvent;
import fr.esrf.tangoatk.widget.util.ATKConstant;
import fr.esrf.tangoatk.widget.util.MultiExtFileFilter;
import fr.esrf.tangoatk.widget.util.chart.CfFileReader;
import fr.esrf.tangoatk.widget.util.chart.JLChart;
import fr.esrf.tangoatk.widget.util.chart.JLDataView;
import fr.esrf.tangoatk.widget.util.chart.OFormat;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileWriter;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JToolBar;

public class NumberSpectrumTrendViewer
extends JPanel
implements ISpectrumListener,
IAttributeStateListener,
IErrorListener,
ActionListener {
    protected INumberSpectrum model;
    protected JLabel nameLabel;
    protected static final String DEFAULT_NAME = "No Attribute";
    protected AttributePolledList attList;
    protected Vector<JLDataView> views;
    protected JLChart chart;
    protected JToolBar theToolBar;
    protected JButton optionButton;
    protected JButton stopButton;
    protected JButton startButton;
    protected JButton loadButton;
    protected JButton saveButton;
    protected JButton zoomButton;
    protected JButton timeButton;
    protected JButton resetButton;
    protected JPanel innerPanel;
    protected String lastConfig = "";
    protected static final Color[] defaultColor = new Color[]{Color.red, Color.blue, Color.cyan, Color.green, Color.magenta, Color.orange, Color.pink, Color.yellow, Color.black, Color.white};
    protected static final int[] defaultMarkerStyle = new int[]{2, 9, 8, 4, 1, 7, 10, 5, 3, 6};

    public NumberSpectrumTrendViewer() {
        this.initComponents();
        this.addComponents();
    }

    public void setModel(String string) {
        if (string == null || "".equals(string.trim())) {
            this.setModel((INumberSpectrum)null);
            return;
        }
        this.attList.stopRefresher();
        this.attList.clear();
        this.chart.getY1Axis().clearDataView();
        this.views.clear();
        if (this.model != null) {
            this.model.removeSpectrumListener(this);
        }
        try {
            this.model = (INumberSpectrum)this.attList.add(string);
            this.model.addSpectrumListener(this);
            this.attList.add(this.model);
            this.attList.startRefresher();
            String string2 = this.model.getState();
            this.nameLabel.setText(this.model.getName());
            this.nameLabel.setBackground(ATKConstant.getColor4Quality(string2));
            this.nameLabel.setToolTipText(string2);
            this.nameLabel.repaint();
            string2 = null;
        }
        catch (Exception exception) {
            this.model = null;
            this.nameLabel.setText(DEFAULT_NAME);
            this.nameLabel.setToolTipText(DEFAULT_NAME);
            this.nameLabel.setBackground(ATKConstant.getColor4Quality("UNKNOWN"));
            JOptionPane.showMessageDialog(this, "Failed to set " + string + " as model", "Error", 0);
        }
    }

    public void setModel(INumberSpectrum iNumberSpectrum) {
        if (this.model != null) {
            this.model.removeSpectrumListener(this);
        }
        if (iNumberSpectrum == null || !(iNumberSpectrum instanceof INumberSpectrum)) {
            return;
        }
        this.attList.stopRefresher();
        this.attList.clear();
        this.chart.getY1Axis().clearDataView();
        this.views.clear();
        if (this.model != null) {
            this.model.removeSpectrumListener(this);
        }
        try {
            this.model = iNumberSpectrum;
            this.model.addSpectrumListener(this);
            this.attList.add(this.model);
            this.attList.startRefresher();
            String string = this.model.getState();
            this.nameLabel.setText(this.model.getName());
            this.nameLabel.setBackground(ATKConstant.getColor4Quality(string));
            this.nameLabel.setToolTipText(string);
            this.nameLabel.repaint();
            string = null;
        }
        catch (Exception exception) {
            this.model = null;
            this.nameLabel.setText(DEFAULT_NAME);
            this.nameLabel.setToolTipText(DEFAULT_NAME);
            this.nameLabel.setBackground(ATKConstant.getColor4Quality("UNKNOWN"));
            JOptionPane.showMessageDialog(this, "Failed to set " + iNumberSpectrum.getName() + " as model", "Error", 0);
        }
    }

    public void clearModel() {
        this.setModel((INumberSpectrum)null);
    }

    public void spectrumChange(NumberSpectrumEvent numberSpectrumEvent) {
        for (int i = 0; i < numberSpectrumEvent.getValue().length; ++i) {
            JLDataView jLDataView;
            if (i < this.views.size()) {
                jLDataView = this.views.get(i);
                jLDataView.add(numberSpectrumEvent.getTimeStamp(), numberSpectrumEvent.getValue()[i]);
                this.chart.garbageData(jLDataView);
            } else {
                jLDataView = new JLDataView();
                jLDataView.add(numberSpectrumEvent.getTimeStamp(), numberSpectrumEvent.getValue()[i]);
                Color color = defaultColor[i % defaultColor.length];
                int n = defaultMarkerStyle[i / defaultColor.length % defaultMarkerStyle.length];
                jLDataView.setMarkerSize(3);
                jLDataView.setViewType(0);
                jLDataView.setColor(color);
                jLDataView.setMarker(n);
                jLDataView.setMarkerColor(color);
                jLDataView.setStyle(0);
                this.chart.getY1Axis().addDataView(jLDataView);
                this.views.add(jLDataView);
            }
            if (i < ((INumberSpectrum)numberSpectrumEvent.getSource()).getXDimension()) {
                jLDataView.setLineWidth(1);
                jLDataView.setName(Integer.toString(i));
            } else {
                jLDataView.setLineWidth(2);
                jLDataView.setName(i - ((INumberSpectrum)numberSpectrumEvent.getSource()).getXDimension() + "(write)");
            }
            jLDataView.setUnit(((INumberSpectrum)numberSpectrumEvent.getSource()).getUnit());
            jLDataView = null;
        }
        this.chart.repaint();
        String string = ((INumberSpectrum)numberSpectrumEvent.getSource()).getState();
        this.nameLabel.setBackground(ATKConstant.getColor4Quality(string));
        this.nameLabel.setToolTipText(string);
        this.nameLabel.repaint();
        string = null;
    }

    public void stateChange(AttributeStateEvent attributeStateEvent) {
        String string = ((INumberSpectrum)attributeStateEvent.getSource()).getState();
        this.nameLabel.setBackground(ATKConstant.getColor4Quality(string));
        this.nameLabel.setToolTipText(string);
        this.nameLabel.repaint();
        string = null;
    }

    public void errorChange(ErrorEvent errorEvent) {
        for (int i = 0; i < this.views.size(); ++i) {
            JLDataView jLDataView = this.views.get(i);
            jLDataView.add(errorEvent.getTimeStamp(), Double.NaN);
            this.chart.garbageData(jLDataView);
        }
        this.chart.repaint();
        String string = ((INumberSpectrum)errorEvent.getSource()).getState();
        this.nameLabel.setBackground(ATKConstant.getColor4Quality(string));
        this.nameLabel.setToolTipText(string);
        this.nameLabel.repaint();
        string = null;
    }

    public void setRefreshInterval(int n) {
        this.attList.setRefreshInterval(n);
    }

    public int getRefreshInterval() {
        return this.attList.getRefreshInterval();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.optionButton) {
            this.chart.showOptionDialog();
        } else if (object == this.stopButton) {
            this.attList.stopRefresher();
        } else if (object == this.startButton) {
            this.attList.startRefresher();
        } else if (object == this.loadButton) {
            this.loadButtonActionPerformed();
        } else if (object == this.saveButton) {
            this.saveButtonActionPerformed();
        } else if (object == this.zoomButton) {
            if (!this.chart.isZoomed()) {
                this.chart.enterZoom();
            } else {
                this.chart.exitZoom();
            }
        } else if (object == this.timeButton) {
            this.setRefreshInterval();
        } else if (object == this.resetButton) {
            this.resetTrend();
        }
    }

    protected void initComponents() {
        this.nameLabel = new JLabel(DEFAULT_NAME, 0);
        this.nameLabel.setBackground(ATKConstant.getColor4Quality("UNKNOWN"));
        this.nameLabel.setToolTipText(DEFAULT_NAME);
        this.nameLabel.setOpaque(true);
        this.nameLabel.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.nameLabel.getPreferredSize().height));
        this.attList = new AttributePolledList();
        this.chart = new JLChart();
        this.chart.getY1Axis().setAutoScale(true);
        this.chart.setDisplayDuration(300000.0);
        this.chart.setLabelVisible(false);
        this.views = new Vector();
        this.theToolBar = new JToolBar();
        this.theToolBar.setFloatable(true);
        this.loadButton = new JButton(new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/attribute/trend_load.gif")));
        this.loadButton.setToolTipText("Load configuration");
        this.saveButton = new JButton(new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/attribute/trend_save.gif")));
        this.saveButton.setToolTipText("Save configuration");
        this.optionButton = new JButton(new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/attribute/trend_settings.gif")));
        this.optionButton.setToolTipText("Global settings");
        this.zoomButton = new JButton(new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/attribute/trend_zoom.gif")));
        this.zoomButton.setToolTipText("Zoom");
        this.startButton = new JButton(new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/attribute/trend_start.gif")));
        this.startButton.setToolTipText("Start monitoring");
        this.stopButton = new JButton(new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/attribute/trend_stop.gif")));
        this.stopButton.setToolTipText("Stop monitoring");
        this.timeButton = new JButton(new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/attribute/trend_time.gif")));
        this.timeButton.setToolTipText("Set refresh interval");
        this.resetButton = new JButton(new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/attribute/trend_reset.gif")));
        this.resetButton.setToolTipText("Reset viewer");
        this.loadButton.addActionListener(this);
        this.saveButton.addActionListener(this);
        this.optionButton.addActionListener(this);
        this.zoomButton.addActionListener(this);
        this.stopButton.addActionListener(this);
        this.startButton.addActionListener(this);
        this.timeButton.addActionListener(this);
        this.resetButton.addActionListener(this);
        this.theToolBar.add(this.loadButton);
        this.theToolBar.add(this.saveButton);
        this.theToolBar.add(this.optionButton);
        this.theToolBar.add(this.zoomButton);
        this.theToolBar.add(this.startButton);
        this.theToolBar.add(this.stopButton);
        this.theToolBar.add(this.timeButton);
        this.theToolBar.add(this.resetButton);
    }

    protected void addComponents() {
        this.innerPanel = new JPanel();
        this.innerPanel.setLayout(new BorderLayout());
        this.setLayout(new BorderLayout());
        this.add((Component)this.theToolBar, "North");
        this.innerPanel.add((Component)this.nameLabel, "North");
        this.innerPanel.add((Component)this.chart, "Center");
        this.add((Component)this.innerPanel, "Center");
    }

    protected void loadButtonActionPerformed() {
        String string;
        File file;
        int n;
        boolean bl = false;
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.addChoosableFileFilter(new MultiExtFileFilter("Text files", "txt", new String[0]));
        if (this.lastConfig.length() > 0) {
            jFileChooser.setSelectedFile(new File(this.lastConfig));
        }
        if ((n = jFileChooser.showOpenDialog(this)) == 0 && (file = jFileChooser.getSelectedFile()) != null && !bl && (string = this.loadSetting(file.getAbsolutePath())).length() > 0) {
            JOptionPane.showMessageDialog(this, string, "Errors reading " + file.getName(), 0);
        }
    }

    public String loadSetting(String string) {
        CfFileReader cfFileReader = new CfFileReader();
        if (!cfFileReader.readFile(string)) {
            return "Failed to read " + string;
        }
        this.lastConfig = string;
        return this.applySettings(cfFileReader);
    }

    protected String applySettings(CfFileReader cfFileReader) {
        String string = "";
        Vector<String> vector = cfFileReader.getParam("model");
        if (vector == null) {
            this.clearModel();
        } else {
            this.setModel(vector.get(0).toString());
        }
        vector = cfFileReader.getParam("refresh_time");
        this.attList.stopRefresher();
        if (vector != null) {
            this.attList.setRefreshInterval(OFormat.getInt(vector.get(0).toString()));
        } else {
            this.attList.setRefreshInterval(1000);
        }
        this.attList.startRefresher();
        this.chart.setMaxDisplayDuration(Double.POSITIVE_INFINITY);
        this.chart.setDisplayDuration(Double.POSITIVE_INFINITY);
        this.chart.applyConfiguration(cfFileReader);
        this.chart.getXAxis().applyConfiguration("x", cfFileReader);
        this.chart.getY1Axis().applyConfiguration("y1", cfFileReader);
        this.chart.getY2Axis().applyConfiguration("y2", cfFileReader);
        return string;
    }

    public String getSettings() {
        String string = "";
        string = string + this.chart.getConfiguration();
        if (this.attList != null) {
            string = string + "refresh_time:" + this.attList.getRefreshInterval() + "\n";
        }
        if (this.model != null) {
            string = string + "model:'" + this.model.getName() + "'\n";
        }
        string = string + this.chart.getXAxis().getConfiguration("x");
        string = string + this.chart.getY1Axis().getConfiguration("y1");
        string = string + this.chart.getY2Axis().getConfiguration("y2");
        return string;
    }

    private void saveButtonActionPerformed() {
        File file;
        int n;
        int n2 = 0;
        JFileChooser jFileChooser = new JFileChooser(".");
        jFileChooser.addChoosableFileFilter(new MultiExtFileFilter("Text files", "txt", new String[0]));
        if (this.lastConfig.length() > 0) {
            jFileChooser.setSelectedFile(new File(this.lastConfig));
        }
        if ((n = jFileChooser.showSaveDialog(this)) == 0 && (file = jFileChooser.getSelectedFile()) != null) {
            if (MultiExtFileFilter.getExtension(file) == null) {
                file = new File(file.getAbsolutePath() + ".txt");
            }
            if (file.exists()) {
                n2 = JOptionPane.showConfirmDialog(this, "Do you want to overwrite " + file.getName() + " ?", "Confirm overwrite", 0);
            }
            if (n2 == 0) {
                this.saveSetting(file.getAbsolutePath());
            }
        }
    }

    public void saveSetting(String string) {
        try {
            FileWriter fileWriter = new FileWriter(string);
            String string2 = this.getSettings();
            fileWriter.write(string2, 0, string2.length());
            fileWriter.close();
            this.lastConfig = string;
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, "Failed to write " + string, "Error", 0);
        }
    }

    protected void setRefreshInterval() {
        int n = this.attList.getRefreshInterval();
        String string = JOptionPane.showInputDialog(this, "Enter refresh interval (ms)", new Integer(n));
        if (string != null) {
            try {
                int n2 = Integer.parseInt(string);
                this.attList.setRefreshInterval(n2);
            }
            catch (NumberFormatException numberFormatException) {
                JOptionPane.showMessageDialog(this, "Invalid number !", "Error", 0);
            }
        }
    }

    public void resetTrend() {
        if (this.views != null) {
            for (int i = 0; i < this.views.size(); ++i) {
                JLDataView jLDataView = this.views.get(i);
                if (jLDataView == null) continue;
                jLDataView.reset();
            }
            this.chart.repaint();
        }
    }

    public static void main(String[] stringArray) {
        String string = stringArray.length > 0 ? stringArray[0] : "tango/tangotest/1/float_spectrum_ro";
        final NumberSpectrumTrendViewer numberSpectrumTrendViewer = new NumberSpectrumTrendViewer();
        numberSpectrumTrendViewer.setRefreshInterval(1000);
        JFrame jFrame = new JFrame("NumberSpectrumTrendViewer - close once to clear model, twice to exit");
        jFrame.setDefaultCloseOperation(0);
        jFrame.addWindowListener(new WindowAdapter(){
            int closecount = 0;

            public void windowClosing(WindowEvent windowEvent) {
                if (this.closecount++ == 1) {
                    System.exit(0);
                } else {
                    numberSpectrumTrendViewer.clearModel();
                }
            }
        });
        jFrame.getContentPane().add(numberSpectrumTrendViewer);
        numberSpectrumTrendViewer.setModel(string);
        jFrame.setSize(800, 600);
        jFrame.setVisible(true);
    }
}

