/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.attribute;

import fr.esrf.tangoatk.core.AttributeStateEvent;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.INumberSpectrum;
import fr.esrf.tangoatk.core.ISpectrumListener;
import fr.esrf.tangoatk.core.NumberSpectrumEvent;
import fr.esrf.tangoatk.widget.util.EditableJTableRow;
import fr.esrf.tangoatk.widget.util.EditableTableRowModel;
import fr.esrf.tangoatk.widget.util.MultiExtFileFilter;
import fr.esrf.tangoatk.widget.util.chart.JLDataView;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class NumberSpectrumTableEditor
extends JFrame
implements ISpectrumListener,
TableModelListener {
    private JButton closeFileJButton;
    private JPanel dummyJPanel1;
    private JButton resetJButton;
    private JPanel dummyJPanel2;
    private JButton writeAttJButton;
    private EditableJTableRow theTable = new EditableJTableRow();
    private EditableTableRowModel etrm = this.theTable.getEditorTableRowModel();
    private JLDataView setDvy;
    private boolean updatedOnce = false;
    private double A0 = 0.0;
    private double A1 = 1.0;
    protected INumberSpectrum model = null;
    private JFileChooser jfc = null;

    public NumberSpectrumTableEditor() {
        this.etrm.addTableModelListener(this);
        this.theTable.setTableRowModel(this.etrm);
        this.theTable.setEditable(true);
        this.setDvy = new JLDataView();
        this.initComponents();
        this.jfc = new JFileChooser();
        this.jfc.addChoosableFileFilter(new MultiExtFileFilter("Text files", "txt", new String[0]));
        this.jfc.setDialogTitle("Load Graph Data (Text file with TAB separated fields)");
    }

    public void setData(Object[][] objectArray, String[] stringArray) {
        this.theTable.setData(objectArray, stringArray);
    }

    public void clearData() {
        this.theTable.clearData();
    }

    public void centerWindow() {
        this.theTable.adjustColumnSize();
        this.theTable.adjustSize();
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension dimension = toolkit.getScreenSize();
        this.pack();
        Dimension dimension2 = this.getPreferredSize();
        if (dimension2.height > 600) {
            dimension2.height = 600;
            if (dimension2.width < 800) {
                dimension2.width += 16;
            }
        }
        if (dimension2.width > 800) {
            dimension2.width = 800;
        }
        int n = (dimension.width - dimension2.width) / 2;
        int n2 = (dimension.height - dimension2.height) / 2;
        this.setBounds(n, n2, dimension2.width, dimension2.height);
    }

    public void setXAxisAffineTransform(double d, double d2) {
        this.A0 = d;
        this.A1 = d2;
    }

    private void initComponents() {
        this.closeFileJButton = new JButton();
        this.dummyJPanel1 = new JPanel();
        this.writeAttJButton = new JButton();
        this.setDefaultCloseOperation(1);
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.theTable, gridBagConstraints);
        this.closeFileJButton.setText("Close");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.closeFileJButton, gridBagConstraints);
        this.closeFileJButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NumberSpectrumTableEditor.this.closeJButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.dummyJPanel1, gridBagConstraints);
        this.writeAttJButton.setText("Write Attribute");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.writeAttJButton, gridBagConstraints);
        this.writeAttJButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NumberSpectrumTableEditor.this.writeAttJButtonActionPerformed(actionEvent);
            }
        });
        this.pack();
    }

    private void closeJButtonActionPerformed(ActionEvent actionEvent) {
        this.setVisible(false);
    }

    private void resetJButtonActionPerformed(ActionEvent actionEvent) {
        this.updateTable();
    }

    private void writeAttJButtonActionPerformed(ActionEvent actionEvent) {
        double[] dArray = null;
        if (this.theTable == null) {
            return;
        }
        if (this.theTable.getEditorTableRowModel() == null) {
            return;
        }
        this.etrm = this.theTable.getEditorTableRowModel();
        dArray = this.etrm.parseNumberSpectrumData();
        if (dArray == null) {
            return;
        }
        this.model.setValue(dArray);
    }

    public void setModel(INumberSpectrum iNumberSpectrum) {
        if (this.model != null) {
            this.clearModel();
        }
        if (iNumberSpectrum != null && iNumberSpectrum.isWritable()) {
            this.model = iNumberSpectrum;
            this.etrm = this.theTable.getEditorTableRowModel();
            this.etrm.setAttributeColumnName(this.model.getName());
            this.model.addSpectrumListener(this);
            this.model.refresh();
        }
        this.repaint();
    }

    public void clearModel() {
        if (this.model != null) {
            this.model.removeSpectrumListener(this);
            this.model = null;
            this.updatedOnce = false;
        }
        this.clearData();
        this.theTable = new EditableJTableRow();
        this.etrm.removeTableModelListener(this);
        this.etrm = this.theTable.getEditorTableRowModel();
        this.etrm.addTableModelListener(this);
        this.theTable.setTableRowModel(this.etrm);
        this.theTable.setEditable(true);
        this.setDvy = new JLDataView();
    }

    public void spectrumChange(NumberSpectrumEvent numberSpectrumEvent) {
        if (this.isVisible() && this.updatedOnce) {
            return;
        }
        this.updateTable();
        this.updatedOnce = true;
    }

    public void stateChange(AttributeStateEvent attributeStateEvent) {
    }

    public void errorChange(ErrorEvent errorEvent) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTable() {
        this.clearData();
        double[] dArray = this.model.getSpectrumSetPoint();
        String[] stringArray = new String[]{"Index", this.model.getName()};
        JLDataView jLDataView = this.setDvy;
        synchronized (jLDataView) {
            this.setDvy.reset();
            for (int i = 0; i < dArray.length; ++i) {
                this.setDvy.add(this.A0 + this.A1 * (double)i, dArray[i], false);
            }
            this.setDvy.updateFilters();
            Object[][] objectArray = new Object[dArray.length][2];
            for (int i = 0; i < dArray.length; ++i) {
                String[] stringArray2 = new String[]{Double.toString(i), this.setDvy.formatValue(this.setDvy.getYValueByIndex(i))};
                objectArray[i][0] = stringArray2[0];
                objectArray[i][1] = stringArray2[1];
            }
            this.setData(objectArray, stringArray);
        }
    }

    public static void main(String[] stringArray) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new NumberSpectrumTableEditor().setVisible(true);
            }
        });
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        if (tableModelEvent.getType() == 1 || tableModelEvent.getType() == 0) {
            this.theTable.adjustColumnSize();
            this.theTable.adjustSize();
            this.pack();
            Dimension dimension = this.getPreferredSize();
            if (dimension.height > 600) {
                dimension.height = 600;
                if (dimension.width < 800) {
                    dimension.width += 16;
                }
            }
            if (dimension.width > 800) {
                dimension.width = 800;
            }
            this.setBounds(this.getBounds().x, this.getBounds().y, dimension.width, dimension.height);
            if (tableModelEvent.getType() == 1 && this.theTable.getJTable() != null) {
                this.theTable.getJTable().changeSelection(tableModelEvent.getLastRow(), 1, false, false);
                this.theTable.getJTable().editCellAt(tableModelEvent.getLastRow(), 1);
            }
        }
    }
}

