/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.attribute;

import fr.esrf.tangoatk.core.AttributePolledList;
import fr.esrf.tangoatk.core.AttributeStateEvent;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.INumberSpectrum;
import fr.esrf.tangoatk.core.ISpectrumListener;
import fr.esrf.tangoatk.core.NumberSpectrumEvent;
import fr.esrf.tangoatk.widget.attribute.NumberSpectrumViewer;
import fr.esrf.tangoatk.widget.util.chart.DataList;
import fr.esrf.tangoatk.widget.util.chart.JLDataView;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class NumberSpectrumRecorder
extends JPanel
implements ISpectrumListener,
ActionListener {
    protected static final Color[] defaultColor = new Color[]{Color.red, Color.blue, Color.magenta, Color.orange, Color.cyan, Color.green, Color.pink, Color.yellow, Color.black};
    protected int index = 0;
    protected NumberSpectrumViewer viewer = null;
    protected JLDataView dvy = null;
    protected INumberSpectrum model = null;
    protected Vector snapshots = null;
    protected JButton snapshotButton = null;
    protected JButton clearButton = null;
    protected JPanel buttonPanel = null;

    public NumberSpectrumRecorder() {
        this.initComponents();
        this.dvy = this.viewer.getY1Axis().getDataView(0);
        this.dvy.setMarkerColor(defaultColor[this.index]);
        this.dvy.setColor(defaultColor[this.index]);
        this.snapshots = new Vector();
        this.initLayout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void spectrumChange(NumberSpectrumEvent numberSpectrumEvent) {
        JLDataView jLDataView = this.dvy;
        synchronized (jLDataView) {
            this.viewer.spectrumChange(numberSpectrumEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void makeSnaphot() {
        JLDataView jLDataView = this.dvy;
        synchronized (jLDataView) {
            ++this.index;
            JLDataView jLDataView2 = new JLDataView();
            jLDataView2.setMarkerColor(defaultColor[this.index % defaultColor.length]);
            jLDataView2.setColor(defaultColor[this.index % defaultColor.length]);
            jLDataView2.setMarkerSize(this.dvy.getMarkerSize());
            jLDataView2.setMarker(this.dvy.getMarker());
            jLDataView2.setLineWidth(this.dvy.getLineWidth());
            jLDataView2.setStyle(this.dvy.getStyle());
            jLDataView2.setViewType(this.dvy.getViewType());
            jLDataView2.setUnit(this.dvy.getUnit());
            jLDataView2.setUserFormat(this.dvy.getUserFormat());
            jLDataView2.setBarWidth(this.dvy.getBarWidth());
            jLDataView2.setA0(this.dvy.getA0());
            jLDataView2.setA1(this.dvy.getA1());
            jLDataView2.setA2(this.dvy.getA2());
            DataList dataList = this.dvy.getData();
            while (dataList != null) {
                jLDataView2.add(dataList.x, dataList.y);
                dataList = dataList.next;
            }
            this.snapshots.add(jLDataView2);
            jLDataView2.setName(this.dvy.getName() + " - Record " + this.snapshots.size());
            this.viewer.getY1Axis().addDataView(jLDataView2);
        }
        this.viewer.repaint();
    }

    public synchronized void clearSnapshots() {
        for (int i = 0; i < this.snapshots.size(); ++i) {
            this.viewer.getY1Axis().removeDataView((JLDataView)this.snapshots.get(i));
        }
        this.snapshots.clear();
        this.index = 0;
        this.viewer.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stateChange(AttributeStateEvent attributeStateEvent) {
        JLDataView jLDataView = this.dvy;
        synchronized (jLDataView) {
            this.viewer.stateChange(attributeStateEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void errorChange(ErrorEvent errorEvent) {
        JLDataView jLDataView = this.dvy;
        synchronized (jLDataView) {
            this.viewer.errorChange(errorEvent);
        }
    }

    public INumberSpectrum getModel() {
        return this.model;
    }

    public void setModel(INumberSpectrum iNumberSpectrum) {
        if (this.model != null) {
            this.model.removeSpectrumListener(this);
        }
        this.viewer.setModel(iNumberSpectrum);
        if (iNumberSpectrum != null) {
            iNumberSpectrum.removeSpectrumListener(this.viewer);
            iNumberSpectrum.addSpectrumListener(this);
        }
    }

    public void clearModel() {
        this.setModel(null);
    }

    public NumberSpectrumViewer getViewer() {
        return this.viewer;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.snapshotButton) {
            this.makeSnaphot();
        } else if (actionEvent.getSource() == this.clearButton) {
            this.clearSnapshots();
        }
    }

    protected void initComponents() {
        this.viewer = new NumberSpectrumViewer();
        this.snapshotButton = new JButton("Record Values");
        this.snapshotButton.setMargin(new Insets(0, 0, 0, 0));
        this.snapshotButton.addActionListener(this);
        this.clearButton = new JButton("Clear Records");
        this.clearButton.setMargin(new Insets(0, 0, 0, 0));
        this.clearButton.addActionListener(this);
        this.viewer.setOpaque(false);
        this.buttonPanel = new JPanel();
        this.buttonPanel.setOpaque(false);
        this.setBackground(this.viewer.getChartBackground());
    }

    protected void initLayout() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weighty = 0.0;
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.fill = 0;
        gridBagConstraints3.gridx = 2;
        gridBagConstraints3.gridy = 0;
        gridBagConstraints3.weightx = 0.0;
        gridBagConstraints3.weighty = 0.0;
        this.buttonPanel.setLayout(new GridBagLayout());
        this.buttonPanel.add((Component)this.snapshotButton, gridBagConstraints);
        this.buttonPanel.add(Box.createGlue(), gridBagConstraints2);
        this.buttonPanel.add((Component)this.clearButton, gridBagConstraints3);
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.fill = 1;
        gridBagConstraints4.gridx = 0;
        gridBagConstraints4.gridy = 0;
        gridBagConstraints4.weightx = 1.0;
        gridBagConstraints4.weighty = 1.0;
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.fill = 2;
        gridBagConstraints5.gridx = 0;
        gridBagConstraints5.gridy = 1;
        gridBagConstraints5.weightx = 1.0;
        gridBagConstraints5.weighty = 0.0;
        this.setLayout(new GridBagLayout());
        this.add((Component)this.viewer, gridBagConstraints4);
        this.add((Component)this.buttonPanel, gridBagConstraints5);
        this.repaint();
    }

    public static void main(String[] stringArray) {
        try {
            AttributePolledList attributePolledList = new AttributePolledList();
            NumberSpectrumRecorder numberSpectrumRecorder = new NumberSpectrumRecorder();
            String string = "tango/tangotest/1/short_spectrum_ro";
            if (stringArray.length > 0) {
                string = stringArray[0];
            }
            INumberSpectrum iNumberSpectrum = (INumberSpectrum)attributePolledList.add(string);
            numberSpectrumRecorder.setModel(iNumberSpectrum);
            JFrame jFrame = new JFrame("NumberSpectrumRecorder");
            jFrame.setDefaultCloseOperation(3);
            attributePolledList.startRefresher();
            jFrame.setContentPane(numberSpectrumRecorder);
            jFrame.setSize(640, 480);
            jFrame.setVisible(true);
            jFrame.repaint();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
    }
}

