/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.attribute;

import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.AttributeStateEvent;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.IAttributeStateListener;
import fr.esrf.tangoatk.core.INumberSpectrum;
import fr.esrf.tangoatk.core.ISpectrumListener;
import fr.esrf.tangoatk.core.NumberSpectrumEvent;
import fr.esrf.tangoatk.widget.util.chart.JLAxis;
import fr.esrf.tangoatk.widget.util.chart.JLChart;
import fr.esrf.tangoatk.widget.util.chart.JLDataView;
import java.awt.Color;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.JFrame;

public class NumberSpectrumItemTrend
extends JLChart
implements ISpectrumListener,
IAttributeStateListener,
ActionListener {
    public static final int AXIS_NONE = 0;
    public static final int AXIS_Y1 = 1;
    public static final int AXIS_Y2 = 2;
    private boolean plotAll = true;
    private boolean plotting = true;
    protected INumberSpectrum model = null;
    protected Map<Integer, JLDataView> itemMap = new HashMap<Integer, JLDataView>();
    protected Map<JLDataView, Integer> dvAxisMap = new HashMap<JLDataView, Integer>();
    protected List<JLDataView> allItems = new Vector<JLDataView>();
    private String qualityFactor = null;
    protected static final Color[] defaultColor = new Color[]{Color.red, Color.blue, new Color(0, 120, 0), new Color(250, 70, 0), Color.magenta, new Color(120, 0, 120), Color.black, Color.pink, Color.green, Color.orange};
    protected static final int[] defaultMarkerStyle = new int[]{2, 9, 8, 4, 1, 7, 10, 5, 3, 6};

    public void setModel(INumberSpectrum iNumberSpectrum) {
        if (this.model != null) {
            this.clearModel();
        }
        if (iNumberSpectrum == null) {
            return;
        }
        this.model = iNumberSpectrum;
        this.model.addSpectrumListener(this);
        this.model.addStateListener(this);
        this.model.addErrorListener(this);
    }

    public void clearModel() {
        this.getY1Axis().clearDataView();
        this.getY2Axis().clearDataView();
        this.itemMap.clear();
        this.dvAxisMap.clear();
        this.allItems.clear();
        if (this.model != null) {
            this.model.removeSpectrumListener(this);
            this.model.removeStateListener(this);
            this.model.removeErrorListener(this);
        }
        this.repaint();
    }

    public boolean getPlotAll() {
        return this.plotAll;
    }

    public void setPlotAll(boolean bl) {
        if (bl == this.plotAll) {
            return;
        }
        this.getY1Axis().clearDataView();
        this.getY2Axis().clearDataView();
        this.itemMap.clear();
        this.dvAxisMap.clear();
        this.allItems.clear();
        this.plotAll = bl;
        this.repaint();
    }

    public boolean isPlotting() {
        return this.plotting;
    }

    public void setPlotting(boolean bl) {
        this.plotting = bl;
    }

    public void removeAllPlots() {
        boolean bl = this.plotting;
        this.plotting = false;
        this.getY1Axis().clearDataView();
        this.getY2Axis().clearDataView();
        this.itemMap.clear();
        this.dvAxisMap.clear();
        this.allItems.clear();
        this.repaint();
        this.plotting = bl;
    }

    public JLDataView getDataViewForItem(int n) {
        if (n < 0) {
            return null;
        }
        if (this.plotAll && n >= this.allItems.size()) {
            return null;
        }
        if (this.plotAll) {
            return this.allItems.get(n);
        }
        Set<Integer> set = this.itemMap.keySet();
        if (set != null) {
            for (Integer n2 : set) {
                if (n2 != n) continue;
                return this.itemMap.get(n2);
            }
        }
        return null;
    }

    public void plotItem(int n, int n2, String string) {
        if (this.model == null) {
            return;
        }
        if (this.plotAll) {
            return;
        }
        if (n2 != 1 && n2 != 2) {
            return;
        }
        JLDataView jLDataView = this.getDataViewForItem(n);
        if (jLDataView != null) {
            this.removePlotItem(n);
        }
        Integer n3 = new Integer(n);
        Integer n4 = new Integer(n2);
        Color color = defaultColor[this.itemMap.size() % defaultColor.length];
        jLDataView = new JLDataView();
        jLDataView.setViewType(0);
        jLDataView.setStyle(0);
        jLDataView.setColor(color);
        jLDataView.setMarkerColor(color);
        jLDataView.setName(string);
        jLDataView.setUnit(this.model.getUnit());
        if (n2 == 2) {
            this.getY2Axis().addDataView(jLDataView);
        } else {
            this.getY1Axis().addDataView(jLDataView);
        }
        this.itemMap.put(n3, jLDataView);
        this.dvAxisMap.put(jLDataView, n4);
    }

    public void removePlotItem(int n) {
        if (this.model == null) {
            return;
        }
        if (this.plotAll) {
            return;
        }
        if (n < 0 || n >= this.model.getXDimension()) {
            return;
        }
        Set<Integer> set = this.itemMap.keySet();
        if (set != null) {
            for (Integer n2 : set) {
                if (n2 != n) continue;
                JLDataView jLDataView = this.itemMap.get(n2);
                JLAxis jLAxis = jLDataView.getAxis();
                if (jLAxis != null) {
                    this.dvAxisMap.remove(jLDataView);
                    jLAxis.removeDataView(jLDataView);
                }
                this.itemMap.remove(n2);
                this.repaint();
            }
        }
    }

    public void hideItem(int n) {
        if (this.model == null) {
            return;
        }
        if (this.plotAll) {
            return;
        }
        JLDataView jLDataView = this.getDataViewForItem(n);
        if (jLDataView == null) {
            return;
        }
        JLAxis jLAxis = jLDataView.getAxis();
        if (jLAxis != this.getY1Axis() && jLAxis != this.getY2Axis()) {
            return;
        }
        jLAxis.removeDataView(jLDataView);
    }

    public void showItem(int n) {
        if (this.model == null) {
            return;
        }
        if (this.plotAll) {
            return;
        }
        JLDataView jLDataView = this.getDataViewForItem(n);
        if (jLDataView == null) {
            return;
        }
        JLAxis jLAxis = jLDataView.getAxis();
        if (jLAxis == this.getY1Axis() || jLAxis == this.getY2Axis()) {
            return;
        }
        if (!this.dvAxisMap.containsKey(jLDataView)) {
            return;
        }
        Integer n2 = this.dvAxisMap.get(jLDataView);
        if (n2 == null) {
            return;
        }
        if (n2 == 1) {
            this.getY1Axis().addDataView(jLDataView);
        } else if (n2 == 2) {
            this.getY2Axis().addDataView(jLDataView);
        }
    }

    public void changeItemAxis(int n, int n2) {
        if (this.model == null) {
            return;
        }
        if (this.plotAll) {
            return;
        }
        if (n2 != 1 && n2 != 2 && n2 != 0) {
            return;
        }
        if (n2 == 0) {
            this.hideItem(n);
            return;
        }
        JLDataView jLDataView = this.getDataViewForItem(n);
        if (jLDataView == null) {
            return;
        }
        int n3 = jLDataView.getAxis() == this.getY1Axis() ? 1 : (jLDataView.getAxis() == this.getY2Axis() ? 2 : 0);
        if (n3 == 0) {
            this.showItem(n);
            return;
        }
        if (n3 == n2) {
            return;
        }
        if (n3 == 1) {
            this.getY1Axis().removeDataView(jLDataView);
        } else {
            this.getY2Axis().removeDataView(jLDataView);
        }
        if (n2 == 1) {
            this.getY1Axis().addDataView(jLDataView);
        } else {
            this.getY2Axis().addDataView(jLDataView);
        }
        if (this.dvAxisMap.containsKey(jLDataView)) {
            this.dvAxisMap.remove(jLDataView);
        }
        this.dvAxisMap.put(jLDataView, new Integer(n2));
    }

    private void plotAllItems(NumberSpectrumEvent numberSpectrumEvent) {
        int n = ((INumberSpectrum)numberSpectrumEvent.getSource()).getXDimension();
        for (int i = 0; i < numberSpectrumEvent.getValue().length && i < n; ++i) {
            JLDataView jLDataView;
            if (i < this.allItems.size()) {
                jLDataView = this.allItems.get(i);
                if (this.qualityFactor == null) {
                    jLDataView.add(numberSpectrumEvent.getTimeStamp(), Double.NaN);
                } else if (this.qualityFactor.equals("INVALID")) {
                    jLDataView.add(numberSpectrumEvent.getTimeStamp(), Double.NaN);
                } else {
                    jLDataView.add(numberSpectrumEvent.getTimeStamp(), numberSpectrumEvent.getValue()[i]);
                }
                this.garbageData(jLDataView);
            } else {
                jLDataView = new JLDataView();
                if (this.qualityFactor == null) {
                    jLDataView.add(numberSpectrumEvent.getTimeStamp(), Double.NaN);
                } else if (this.qualityFactor.equals("INVALID")) {
                    jLDataView.add(numberSpectrumEvent.getTimeStamp(), Double.NaN);
                } else {
                    jLDataView.add(numberSpectrumEvent.getTimeStamp(), numberSpectrumEvent.getValue()[i]);
                }
                Color color = defaultColor[i % defaultColor.length];
                jLDataView.setViewType(0);
                jLDataView.setStyle(0);
                jLDataView.setColor(color);
                jLDataView.setMarkerColor(color);
                jLDataView.setName(Integer.toString(i));
                jLDataView.setUnit(((INumberSpectrum)numberSpectrumEvent.getSource()).getUnit());
                this.getY1Axis().addDataView(jLDataView);
                this.allItems.add(jLDataView);
            }
            jLDataView = null;
        }
    }

    public void spectrumChange(NumberSpectrumEvent numberSpectrumEvent) {
        JLDataView jLDataView = null;
        double[] dArray = numberSpectrumEvent.getValue();
        if (!this.plotting) {
            return;
        }
        if (this.plotAll) {
            this.plotAllItems(numberSpectrumEvent);
        } else {
            Set<Integer> set = this.itemMap.keySet();
            if (set == null) {
                return;
            }
            for (Integer n : set) {
                jLDataView = this.itemMap.get(n);
                int n2 = n;
                try {
                    double d = dArray[n2];
                    jLDataView.add(numberSpectrumEvent.getTimeStamp(), d);
                }
                catch (Exception exception) {
                    jLDataView.add(numberSpectrumEvent.getTimeStamp(), Double.NaN);
                }
                this.garbageData(jLDataView);
            }
        }
        this.repaint();
    }

    public void stateChange(AttributeStateEvent attributeStateEvent) {
        Set<Integer> set;
        this.qualityFactor = attributeStateEvent.getState();
        if (this.qualityFactor.equals("INVALID") && (set = this.itemMap.keySet()) != null) {
            for (Integer n : set) {
                JLDataView jLDataView = this.itemMap.get(n);
                jLDataView.add(attributeStateEvent.getTimeStamp(), Double.NaN);
                this.garbageData(jLDataView);
            }
        }
    }

    public void errorChange(ErrorEvent errorEvent) {
        if (!this.plotting) {
            return;
        }
        if (this.plotAll) {
            this.plotAllError(errorEvent);
        } else {
            Set<Integer> set = this.itemMap.keySet();
            if (set != null) {
                for (Integer n : set) {
                    JLDataView jLDataView = this.itemMap.get(n);
                    jLDataView.add(errorEvent.getTimeStamp(), Double.NaN);
                    this.garbageData(jLDataView);
                }
            }
        }
        this.repaint();
    }

    private void plotAllError(ErrorEvent errorEvent) {
        for (int i = 0; i < this.allItems.size(); ++i) {
            JLDataView jLDataView = this.allItems.get(i);
            jLDataView.add(errorEvent.getTimeStamp(), Double.NaN);
            this.garbageData(jLDataView);
        }
    }

    public static void main(String[] stringArray) {
        AttributeList attributeList = new AttributeList();
        NumberSpectrumItemTrend numberSpectrumItemTrend = new NumberSpectrumItemTrend();
        String string = stringArray.length > 0 ? stringArray[0] : "fp/test/1/wave";
        try {
            INumberSpectrum iNumberSpectrum = (INumberSpectrum)attributeList.add(string);
            numberSpectrumItemTrend.getXAxis().setGridVisible(true);
            numberSpectrumItemTrend.getY1Axis().setGridVisible(true);
            numberSpectrumItemTrend.getY1Axis().setAutoScale(false);
            numberSpectrumItemTrend.getY2Axis().setAutoScale(false);
            numberSpectrumItemTrend.getY1Axis().setMinimum(0.0);
            numberSpectrumItemTrend.getY1Axis().setMaximum(10.0);
            numberSpectrumItemTrend.getY2Axis().setMinimum(0.0);
            numberSpectrumItemTrend.getY2Axis().setMaximum(100.0);
            numberSpectrumItemTrend.setPlotAll(false);
            numberSpectrumItemTrend.setModel(iNumberSpectrum);
            numberSpectrumItemTrend.plotItem(30, 1, "wave[30]");
            numberSpectrumItemTrend.plotItem(1, 1, "wave[1]");
        }
        catch (Exception exception) {
            System.out.println("caught exception : " + exception.getMessage());
            System.exit(-1);
        }
        JFrame jFrame = new JFrame();
        jFrame.setDefaultCloseOperation(3);
        jFrame.getContentPane().add(numberSpectrumItemTrend);
        attributeList.startRefresher();
        jFrame.setSize(800, 600);
        jFrame.pack();
        jFrame.setVisible(true);
        for (int i = 0; i < 10; ++i) {
            try {
                Thread.sleep(5000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            numberSpectrumItemTrend.hideItem(7);
            try {
                Thread.sleep(5000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            numberSpectrumItemTrend.showItem(7);
        }
    }
}

