/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.attribute;

import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.AttributeStateEvent;
import fr.esrf.tangoatk.core.BooleanScalarEvent;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.IBooleanScalar;
import fr.esrf.tangoatk.core.IBooleanScalarListener;
import fr.esrf.tangoatk.core.IEntity;
import fr.esrf.tangoatk.core.ISetErrorListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JFrame;

public class BooleanScalarComboEditor
extends JComboBox
implements ActionListener,
IBooleanScalarListener,
ISetErrorListener {
    private IBooleanScalar attModel = null;
    private String trueLabel = "True";
    private String falseLabel = "False";
    private DefaultComboBoxModel comboModel = null;
    protected String defActionCmd = "setAttActionCmd";
    private String[] optionList = new String[]{this.trueLabel, this.falseLabel};
    static final int trueIndex = 0;
    static final int falseIndex = 1;

    public BooleanScalarComboEditor() {
        this.comboModel = new DefaultComboBoxModel<String>(this.optionList);
        this.setModel(this.comboModel);
        this.setActionCommand(this.defActionCmd);
        this.addActionListener(this);
    }

    public IBooleanScalar getAttModel() {
        return this.attModel;
    }

    public void setAttModel(IBooleanScalar iBooleanScalar) {
        if (this.attModel != null) {
            this.attModel.removeBooleanScalarListener(this);
            this.attModel.removeSetErrorListener(this);
            this.attModel = null;
        }
        if (iBooleanScalar == null) {
            return;
        }
        if (!iBooleanScalar.isWritable()) {
            throw new IllegalArgumentException("BooleanScalarComboEditor: Only accept writeable attribute.");
        }
        this.optionList = new String[]{this.trueLabel, this.falseLabel};
        this.comboModel = new DefaultComboBoxModel<String>(this.optionList);
        this.setModel(this.comboModel);
        this.attModel = iBooleanScalar;
        this.attModel.addBooleanScalarListener(this);
        this.attModel.addSetErrorListener(this);
        this.attModel.refresh();
        this.repaint();
    }

    public void clearModel() {
        this.setAttModel(null);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        boolean bl;
        JComboBox jComboBox = null;
        boolean bl2 = false;
        Object var5_4 = null;
        if (!actionEvent.getActionCommand().equals(this.defActionCmd)) {
            return;
        }
        if (this.attModel == null) {
            return;
        }
        jComboBox = (JComboBox)actionEvent.getSource();
        if (jComboBox.getSelectedIndex() < 0) {
            return;
        }
        boolean bl3 = bl = jComboBox.getSelectedIndex() == 0;
        if (bl) {
            this.attModel.setValue(true);
        } else {
            this.attModel.setValue(false);
        }
    }

    public void booleanScalarChange(BooleanScalarEvent booleanScalarEvent) {
        boolean bl = this.hasFocus() ? this.attModel.getDeviceSetPoint() : this.attModel.getSetPoint();
        this.changeCurrentSelection(bl);
    }

    public void stateChange(AttributeStateEvent attributeStateEvent) {
    }

    public void errorChange(ErrorEvent errorEvent) {
        this.disableExecution();
        this.setSelectedIndex(-1);
        this.repaint();
        this.enableExecution();
    }

    public void setErrorOccured(ErrorEvent errorEvent) {
        if (this.attModel == null) {
            return;
        }
        if (errorEvent.getSource() != this.attModel) {
            return;
        }
        this.changeCurrentSelection(this.attModel.getDeviceSetPoint());
    }

    private void changeCurrentSelection(boolean bl) {
        this.disableExecution();
        if (bl) {
            this.setSelectedIndex(0);
        } else {
            this.setSelectedIndex(1);
        }
        this.repaint();
        this.enableExecution();
    }

    public void enableExecution() {
        this.setActionCommand(this.defActionCmd);
    }

    public void disableExecution() {
        this.setActionCommand("dummy");
    }

    public static void main(String[] stringArray) {
        AttributeList attributeList = new AttributeList();
        JFrame jFrame = new JFrame();
        BooleanScalarComboEditor booleanScalarComboEditor = new BooleanScalarComboEditor();
        try {
            IEntity iEntity = attributeList.add("jlp/test/1/att_boolean");
            if (!(iEntity instanceof IBooleanScalar)) {
                System.out.println("jlp/test/1/att_boolean is not a booleanScalar");
                System.exit(0);
            }
            IBooleanScalar iBooleanScalar = (IBooleanScalar)iEntity;
            booleanScalarComboEditor.setAttModel(iBooleanScalar);
        }
        catch (Exception exception) {
            System.out.println("Cannot connect to jlp/test/1/att_boolean");
            System.exit(-1);
        }
        attributeList.startRefresher();
        jFrame.setContentPane(booleanScalarComboEditor);
        jFrame.setDefaultCloseOperation(3);
        jFrame.pack();
        jFrame.setVisible(true);
    }

    public String getFalseLabel() {
        return this.falseLabel;
    }

    public void setFalseLabel(String string) {
        this.falseLabel = string;
    }

    public String getTrueLabel() {
        return this.trueLabel;
    }

    public void setTrueLabel(String string) {
        this.trueLabel = string;
    }
}

