/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.attribute;

import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.AttributeStateEvent;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.IAttribute;
import fr.esrf.tangoatk.core.IAttributeStateListener;
import fr.esrf.tangoatk.core.IErrorListener;
import fr.esrf.tangoatk.widget.util.ATKConstant;
import javax.swing.JButton;
import javax.swing.JFrame;

public class AttributeQualityLightViewer
extends JButton
implements IAttributeStateListener,
IErrorListener {
    private boolean viewLabel;
    private IAttribute attributeModel;
    private int chosenLabel;
    private static final String defaultName = "No attribute defined";
    public static final int label = 0;
    public static final int name = 1;
    public static final int quality = 2;
    public static final int labelAndQuality = 3;
    public static final int nameAndQuality = 4;
    public static final int customLabel = 5;
    public static final int completeName = 6;

    public AttributeQualityLightViewer() {
        this.chosenLabel = 0;
        this.viewLabel = false;
        this.setAttributeModel(null);
    }

    public AttributeQualityLightViewer(IAttribute iAttribute, int n, boolean bl) {
        this.chosenLabel = n;
        this.viewLabel = bl;
        this.setAttributeModel(iAttribute);
    }

    public IAttribute getAttributeModel() {
        return this.attributeModel;
    }

    public void setAttributeModel(IAttribute iAttribute) {
        if (this.attributeModel != null) {
            this.attributeModel.removeStateListener(this);
            this.attributeModel.removeErrorListener(this);
        }
        this.attributeModel = null;
        this.attributeModel = iAttribute;
        if (this.attributeModel != null) {
            this.attributeModel.addStateListener(this);
            this.attributeModel.addErrorListener(this);
            this.manageLabel(this.attributeModel.getState());
            this.setIcon(ATKConstant.getIcon4Quality(this.attributeModel.getState()));
        } else {
            this.manageLabel("Unknown quality");
            this.setIcon(ATKConstant.getIcon4Quality("UNKNOWN"));
        }
    }

    public void clearAttributeModel() {
        this.setAttributeModel(null);
    }

    public void stateChange(AttributeStateEvent attributeStateEvent) {
        this.manageLabel(attributeStateEvent.getState());
        this.setIcon(ATKConstant.getIcon4Quality(attributeStateEvent.getState()));
        this.repaint();
    }

    public void errorChange(ErrorEvent errorEvent) {
        this.manageLabel("Error occured");
        this.setIcon(ATKConstant.getIcon4Quality("UNKNOWN"));
        this.repaint();
    }

    public void setViewLabel(boolean bl) {
        this.viewLabel = bl;
        if (this.attributeModel != null) {
            this.manageLabel(this.attributeModel.getState());
        } else {
            this.manageLabel("unknown state");
        }
    }

    public boolean isViewLabel() {
        return this.viewLabel;
    }

    public void setChosenLabel(int n) {
        this.chosenLabel = n;
    }

    public int getChosenLabel() {
        return this.chosenLabel;
    }

    private void manageLabel(String string) {
        if (this.viewLabel) {
            switch (this.chosenLabel) {
                case 0: {
                    if (this.attributeModel == null) {
                        this.setText(defaultName);
                        break;
                    }
                    this.setText(this.attributeModel.getLabel());
                    break;
                }
                case 1: {
                    if (this.attributeModel == null) {
                        this.setText(defaultName);
                        break;
                    }
                    this.setText(this.attributeModel.getNameSansDevice());
                    break;
                }
                case 2: {
                    this.setText(string);
                }
                case 4: {
                    if (this.attributeModel == null) {
                        this.setText("No attribute defined : " + string);
                        break;
                    }
                    this.setText(this.attributeModel.getName() + " : " + string);
                    break;
                }
                case 3: {
                    if (this.attributeModel == null) {
                        this.setText("No attribute defined : " + string);
                        break;
                    }
                    this.setText(this.attributeModel.getLabel() + " : " + string);
                    break;
                }
                case 6: {
                    if (this.attributeModel == null) {
                        this.setText(defaultName);
                        break;
                    }
                    this.setText(this.attributeModel.getName());
                    break;
                }
            }
        }
    }

    public static void main(String[] stringArray) {
        AttributeList attributeList = new AttributeList();
        AttributeQualityLightViewer attributeQualityLightViewer = new AttributeQualityLightViewer();
        attributeQualityLightViewer.setViewLabel(true);
        attributeQualityLightViewer.setChosenLabel(3);
        try {
            if (stringArray.length != 0) {
                attributeQualityLightViewer.setAttributeModel((IAttribute)attributeList.add(stringArray[0]));
            } else {
                attributeQualityLightViewer.setAttributeModel((IAttribute)attributeList.add("test/testSignal2/1/signal"));
            }
            attributeQualityLightViewer.setViewLabel(true);
            attributeList.setRefreshInterval(1000);
            attributeList.startRefresher();
            JFrame jFrame = new JFrame(attributeQualityLightViewer.getAttributeModel().getName().substring(0, attributeQualityLightViewer.getAttributeModel().getName().lastIndexOf("/")));
            jFrame.getContentPane().add(attributeQualityLightViewer);
            jFrame.setSize(300, 50);
            jFrame.setVisible(true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
    }
}

