/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.attribute;

import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.AttributeStateEvent;
import fr.esrf.tangoatk.core.ConnectionException;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.IAttribute;
import fr.esrf.tangoatk.core.INumberScalar;
import fr.esrf.tangoatk.core.INumberScalarListener;
import fr.esrf.tangoatk.core.NumberScalarEvent;
import fr.esrf.tangoatk.widget.util.ATKConstant;
import fr.esrf.tangoatk.widget.util.MultiExtFileFilter;
import fr.esrf.tangoatk.widget.util.chart.CfFileReader;
import fr.esrf.tangoatk.widget.util.chart.DataList;
import fr.esrf.tangoatk.widget.util.chart.JLChart;
import fr.esrf.tangoatk.widget.util.chart.JLDataView;
import fr.esrf.tangoatk.widget.util.chart.JLTable;
import fr.esrf.tangoatk.widget.util.chart.OFormat;
import fr.esrf.tangoatk.widget.util.chart.SearchInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;

public class AttributeMultiChart
extends JLChart
implements INumberScalarListener {
    protected String header = "Barchart";
    protected String xaxisName = "X";
    protected String unit = "unknown";
    protected double alarmLevel = 0.0;
    protected double faultLevel = 0.0;
    protected JLDataView alarm;
    protected JLDataView fault;
    protected JLDataView lineView;
    protected String lastConfig = "";
    protected int refreshingPeriod = 1000;
    protected Map<INumberScalar, List<Object>> dataViewHash = null;
    protected AttributeList model = null;
    protected int chartStyle;
    protected int markerStyle;
    protected Color chartColor = ATKConstant.getColor4Quality("VALID");
    protected boolean alarmEnable = true;
    protected boolean chartOnXAxis = true;
    protected boolean highAlarm = true;
    protected boolean highFault = true;
    protected JMenu multiChartMenu;
    protected JMenuItem barChartItem;
    protected JMenu dotChartMenu;
    protected JMenuItem dotItem;
    protected JMenuItem boxItem;
    protected JMenuItem triangleItem;
    protected JMenuItem diamondItem;
    protected JMenuItem starItem;
    protected JMenuItem vertLineItem;
    protected JMenuItem horizLineItem;
    protected JMenuItem crossItem;
    protected JMenuItem circleItem;
    protected JMenuItem squareItem;
    protected JMenu lineChartMenu;
    protected JMenuItem dotItem2;
    protected JMenuItem boxItem2;
    protected JMenuItem triangleItem2;
    protected JMenuItem diamondItem2;
    protected JMenuItem starItem2;
    protected JMenuItem vertLineItem2;
    protected JMenuItem horizLineItem2;
    protected JMenuItem crossItem2;
    protected JMenuItem circleItem2;
    protected JMenuItem squareItem2;
    protected JMenu tooltipMenu;
    protected JMenuItem fullNameItem;
    protected JMenuItem noDeviceNameItem;
    protected JMenuItem labelItem;
    protected JMenuItem aliasItem;
    protected JMenuItem deviceNameItem;
    protected JMenu axisInfoMenu;
    protected JMenuItem axisInfoFullNameItem;
    protected JMenuItem axisInfoNoDeviceNameItem;
    protected JMenuItem axisInfoLabelItem;
    protected JMenuItem axisInfoAliasItem;
    protected JMenuItem axisInfoDeviceNameItem;
    protected JMenuItem axisInfoIndexItem;
    protected JMenu YScale;
    protected JMenuItem logarithmic;
    protected JMenuItem linear;
    protected int displayMode = -1;
    protected int axisDisplayMode = -1;
    public static final int barChart = 0;
    public static final int dotChart = 1;
    public static final int lineChart = 2;
    public static final int DISPLAY_FULL_NAME = 0;
    public static final int DISPLAY_NAME_NO_DEVICE = 1;
    public static final int DISPLAY_LABEL = 2;
    public static final int DISPLAY_ALIAS = 3;
    public static final int DISPLAY_DEVICE_NAME = 4;
    public static final int DISPLAY_INDEX = 5;

    public AttributeMultiChart() {
        this.getXAxis().setDrawOpposite(false);
        this.getXAxis().setLabelFormat(0);
        this.getXAxis().setGridVisible(true);
        this.getXAxis().setAutoScale(true);
        this.getY1Axis().setZeroAlwaysVisible(true);
        this.dataViewHash = new HashMap<INumberScalar, List<Object>>();
        this.setMarkerStyle(5);
        this.initComponents();
        this.addUserAction("Load configuration");
        this.addUserAction("Save configuration");
        this.addUserAction("Set Refresh Interval...");
        this.multiChartMenu = new JMenu("Chart Style");
        this.barChartItem = new JMenuItem("Bar Chart");
        this.dotChartMenu = new JMenu("Dot Chart (choose marker)");
        this.lineChartMenu = new JMenu("Line Chart (choose marker)");
        this.tooltipMenu = new JMenu("Tooltip Information:");
        this.fullNameItem = new JMenuItem("Attribute's full name");
        this.noDeviceNameItem = new JMenuItem("Attribute's name wihout device");
        this.labelItem = new JMenuItem("Attribute's label");
        this.aliasItem = new JMenuItem("Attribute's alias");
        this.deviceNameItem = new JMenuItem("Attribute's parent device name");
        this.axisInfoMenu = new JMenu("X Axis Information:");
        this.axisInfoFullNameItem = new JMenuItem("Attribute's full name");
        this.axisInfoNoDeviceNameItem = new JMenuItem("Attribute's name wihout device");
        this.axisInfoLabelItem = new JMenuItem("Attribute's label");
        this.axisInfoAliasItem = new JMenuItem("Attribute's alias");
        this.axisInfoDeviceNameItem = new JMenuItem("Attribute's parent device name");
        this.axisInfoIndexItem = new JMenuItem("Attribute's index");
        this.dotItem = new JMenuItem("dot");
        this.boxItem = new JMenuItem("box");
        this.triangleItem = new JMenuItem("triangle");
        this.diamondItem = new JMenuItem("diamond");
        this.starItem = new JMenuItem("star");
        this.vertLineItem = new JMenuItem("vertical line");
        this.horizLineItem = new JMenuItem("horizontal line");
        this.crossItem = new JMenuItem("cross");
        this.circleItem = new JMenuItem("circle");
        this.squareItem = new JMenuItem("square");
        this.dotItem2 = new JMenuItem("dot");
        this.boxItem2 = new JMenuItem("box");
        this.triangleItem2 = new JMenuItem("triangle");
        this.diamondItem2 = new JMenuItem("diamond");
        this.starItem2 = new JMenuItem("star");
        this.vertLineItem2 = new JMenuItem("vertical line");
        this.horizLineItem2 = new JMenuItem("horizontal line");
        this.crossItem2 = new JMenuItem("cross");
        this.circleItem2 = new JMenuItem("circle");
        this.squareItem2 = new JMenuItem("square");
        this.barChartItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AttributeMultiChart.this.setChartStyle(0);
            }
        });
        this.dotItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AttributeMultiChart.this.setChartStyle(1);
                AttributeMultiChart.this.setMarkerStyle(1);
            }
        });
        this.boxItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AttributeMultiChart.this.setChartStyle(1);
                AttributeMultiChart.this.setMarkerStyle(2);
            }
        });
        this.triangleItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AttributeMultiChart.this.setChartStyle(1);
                AttributeMultiChart.this.setMarkerStyle(3);
            }
        });
        this.diamondItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AttributeMultiChart.this.setChartStyle(1);
                AttributeMultiChart.this.setMarkerStyle(4);
            }
        });
        this.starItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AttributeMultiChart.this.setChartStyle(1);
                AttributeMultiChart.this.setMarkerStyle(5);
            }
        });
        this.vertLineItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AttributeMultiChart.this.setChartStyle(1);
                AttributeMultiChart.this.setMarkerStyle(6);
            }
        });
        this.horizLineItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AttributeMultiChart.this.setChartStyle(1);
                AttributeMultiChart.this.setMarkerStyle(7);
            }
        });
        this.crossItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AttributeMultiChart.this.setChartStyle(1);
                AttributeMultiChart.this.setMarkerStyle(8);
            }
        });
        this.circleItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AttributeMultiChart.this.setChartStyle(1);
                AttributeMultiChart.this.setMarkerStyle(9);
            }
        });
        this.squareItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AttributeMultiChart.this.setChartStyle(1);
                AttributeMultiChart.this.setMarkerStyle(10);
            }
        });
        this.dotItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AttributeMultiChart.this.setChartStyle(2);
                AttributeMultiChart.this.setMarkerStyle(1);
            }
        });
        this.boxItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AttributeMultiChart.this.setChartStyle(2);
                AttributeMultiChart.this.setMarkerStyle(2);
            }
        });
        this.triangleItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AttributeMultiChart.this.setChartStyle(2);
                AttributeMultiChart.this.setMarkerStyle(3);
            }
        });
        this.diamondItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AttributeMultiChart.this.setChartStyle(2);
                AttributeMultiChart.this.setMarkerStyle(4);
            }
        });
        this.starItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AttributeMultiChart.this.setChartStyle(2);
                AttributeMultiChart.this.setMarkerStyle(5);
            }
        });
        this.vertLineItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AttributeMultiChart.this.setChartStyle(2);
                AttributeMultiChart.this.setMarkerStyle(6);
            }
        });
        this.horizLineItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AttributeMultiChart.this.setChartStyle(2);
                AttributeMultiChart.this.setMarkerStyle(7);
            }
        });
        this.crossItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AttributeMultiChart.this.setChartStyle(2);
                AttributeMultiChart.this.setMarkerStyle(8);
            }
        });
        this.circleItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AttributeMultiChart.this.setChartStyle(2);
                AttributeMultiChart.this.setMarkerStyle(9);
            }
        });
        this.squareItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AttributeMultiChart.this.setChartStyle(2);
                AttributeMultiChart.this.setMarkerStyle(10);
            }
        });
        this.YScale = new JMenu("Y Axis Scale");
        this.logarithmic = new JMenuItem("logarithmic");
        this.linear = new JMenuItem("linear");
        this.logarithmic.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AttributeMultiChart.this.getY1Axis().setScale(1);
                AttributeMultiChart.this.repaint();
            }
        });
        this.linear.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AttributeMultiChart.this.getY1Axis().setScale(0);
                AttributeMultiChart.this.repaint();
            }
        });
        this.fullNameItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AttributeMultiChart.this.setDisplayMode(0);
                AttributeMultiChart.this.repaint();
            }
        });
        this.noDeviceNameItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AttributeMultiChart.this.setDisplayMode(1);
                AttributeMultiChart.this.repaint();
            }
        });
        this.labelItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AttributeMultiChart.this.setDisplayMode(2);
                AttributeMultiChart.this.repaint();
            }
        });
        this.aliasItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AttributeMultiChart.this.setDisplayMode(3);
                AttributeMultiChart.this.repaint();
            }
        });
        this.deviceNameItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AttributeMultiChart.this.setDisplayMode(4);
                AttributeMultiChart.this.repaint();
            }
        });
        this.axisInfoFullNameItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AttributeMultiChart.this.setAxisDisplayMode(0);
                AttributeMultiChart.this.repaint();
            }
        });
        this.axisInfoNoDeviceNameItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AttributeMultiChart.this.setAxisDisplayMode(1);
                AttributeMultiChart.this.repaint();
            }
        });
        this.axisInfoLabelItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AttributeMultiChart.this.setAxisDisplayMode(2);
                AttributeMultiChart.this.repaint();
            }
        });
        this.axisInfoAliasItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AttributeMultiChart.this.setAxisDisplayMode(3);
                AttributeMultiChart.this.repaint();
            }
        });
        this.axisInfoDeviceNameItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AttributeMultiChart.this.setAxisDisplayMode(4);
                AttributeMultiChart.this.repaint();
            }
        });
        this.axisInfoIndexItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AttributeMultiChart.this.setAxisDisplayMode(5);
                AttributeMultiChart.this.repaint();
            }
        });
        this.dotChartMenu.add(this.dotItem);
        this.dotChartMenu.add(this.boxItem);
        this.dotChartMenu.add(this.triangleItem);
        this.dotChartMenu.add(this.diamondItem);
        this.dotChartMenu.add(this.starItem);
        this.dotChartMenu.add(this.vertLineItem);
        this.dotChartMenu.add(this.horizLineItem);
        this.dotChartMenu.add(this.crossItem);
        this.dotChartMenu.add(this.circleItem);
        this.dotChartMenu.add(this.squareItem);
        this.lineChartMenu.add(this.dotItem2);
        this.lineChartMenu.add(this.boxItem2);
        this.lineChartMenu.add(this.triangleItem2);
        this.lineChartMenu.add(this.diamondItem2);
        this.lineChartMenu.add(this.starItem2);
        this.lineChartMenu.add(this.vertLineItem2);
        this.lineChartMenu.add(this.horizLineItem2);
        this.lineChartMenu.add(this.crossItem2);
        this.lineChartMenu.add(this.circleItem2);
        this.lineChartMenu.add(this.squareItem2);
        this.multiChartMenu.add(this.barChartItem);
        this.multiChartMenu.add(this.dotChartMenu);
        this.multiChartMenu.add(this.lineChartMenu);
        this.tooltipMenu.add(this.fullNameItem);
        this.tooltipMenu.add(this.noDeviceNameItem);
        this.tooltipMenu.add(this.labelItem);
        this.tooltipMenu.add(this.aliasItem);
        this.tooltipMenu.add(this.deviceNameItem);
        this.axisInfoMenu.add(this.axisInfoFullNameItem);
        this.axisInfoMenu.add(this.axisInfoNoDeviceNameItem);
        this.axisInfoMenu.add(this.axisInfoLabelItem);
        this.axisInfoMenu.add(this.axisInfoAliasItem);
        this.axisInfoMenu.add(this.axisInfoDeviceNameItem);
        this.axisInfoMenu.add(this.axisInfoIndexItem);
        this.YScale.add(this.linear);
        this.YScale.add(this.logarithmic);
        this.addSeparator();
        this.addMenuItem(this.multiChartMenu);
        this.addMenuItem(this.tooltipMenu);
        this.addMenuItem(this.axisInfoMenu);
        this.addMenuItem(this.YScale);
        this.removeMenuItem(1);
        this.setDisplayMode(0);
        this.setAxisDisplayMode(5);
    }

    public AttributeMultiChart(int n) {
        this();
        this.setChartStyle(n);
    }

    public AttributeMultiChart(int n, int n2) {
        this();
        this.setChartStyle(n);
        this.setDisplayMode(n2);
    }

    public int getMarkerStyle() {
        return this.markerStyle;
    }

    public void setMarkerStyle(int n) {
        this.markerStyle = n;
        Set<INumberScalar> set = this.dataViewHash.keySet();
        block4: for (INumberScalar iNumberScalar : set) {
            List<Object> list = this.dataViewHash.get(iNumberScalar);
            JLDataView jLDataView = (JLDataView)list.get(0);
            switch (this.chartStyle) {
                case 0: {
                    continue block4;
                }
                case 1: 
                case 2: {
                    jLDataView.setMarker(this.markerStyle);
                    continue block4;
                }
            }
            jLDataView.setMarker(0);
            jLDataView.setViewType(0);
        }
        this.repaint();
    }

    protected void initComponents() {
        this.setHeaderFont(new Font("Times", 1, 18));
        switch (this.chartStyle) {
            case 0: {
                this.setHeader("BarChart");
                break;
            }
            case 1: {
                this.setHeader("DotChart");
                break;
            }
            case 2: {
                this.setHeader("LineChart");
                break;
            }
            default: {
                this.setHeader("");
            }
        }
        this.setLabelVisible(false);
        this.setSize(640, 480);
        this.getY1Axis().setAutoScale(true);
        this.getY1Axis().setGridVisible(true);
        this.getY1Axis().setSubGridVisible(true);
        this.getXAxis().setAutoScale(false);
        this.getXAxis().setMinimum(0.0);
        this.getXAxis().setMaximum(0.0);
        this.getXAxis().setGridVisible(false);
        this.getXAxis().setSubGridVisible(false);
        this.getXAxis().setPosition(3);
        this.initLevels();
        this.setPaintAxisFirst(false);
    }

    protected String[] buildPanelString(SearchInfo searchInfo) {
        if (!this.isChartOnXAxis()) {
            String[] stringArray = new String[]{searchInfo.dataView.getExtendedName() + " " + searchInfo.axis.getAxeName(), "Index = " + new Double(searchInfo.value.y).intValue(), "X = " + searchInfo.dataView.formatValue(searchInfo.dataView.getTransformedValue(searchInfo.value.x)) + " " + searchInfo.dataView.getUnit()};
            return stringArray;
        }
        String[] stringArray = new String[]{searchInfo.dataView.getExtendedName() + " " + searchInfo.axis.getAxeName(), "Index = " + new Double(searchInfo.value.x).intValue(), "Y = " + searchInfo.dataView.formatValue(searchInfo.dataView.getTransformedValue(searchInfo.value.y)) + " " + searchInfo.dataView.getUnit()};
        return stringArray;
    }

    protected void initLevels() {
        this.alarm = new JLDataView();
        this.alarm.setName("Alarm level");
        this.alarm.setColor(ATKConstant.getColor4State("ALARM"));
        this.alarm.setLineWidth(2);
        this.getY1Axis().addDataView(this.alarm);
        this.fault = new JLDataView();
        this.fault.setName("Fault level");
        this.fault.setColor(ATKConstant.getColor4State("FAULT"));
        this.fault.setLineWidth(2);
        this.getY1Axis().addDataView(this.fault);
        this.lineView = new JLDataView();
        this.lineView.setColor(Color.black);
        this.lineView.setLineWidth(1);
        if (this.chartStyle == 2) {
            this.getY1Axis().addDataView(this.lineView);
        } else {
            this.getY1Axis().removeDataView(this.lineView);
        }
    }

    public boolean isChartOnXAxis() {
        return this.chartOnXAxis;
    }

    public void setChartOnXAxis(boolean bl) {
        this.chartOnXAxis = bl;
    }

    public void setModel(AttributeList attributeList) {
        Object e;
        int n;
        this.setChartOnXAxis(this.chartOnXAxis);
        int n2 = 10;
        if (this.model != null) {
            this.clearModel();
            this.model = null;
        }
        if (attributeList == null) {
            return;
        }
        int n3 = attributeList.getSize();
        if (n3 <= 0) {
            return;
        }
        boolean bl = false;
        for (n = 0; n < n3; ++n) {
            e = attributeList.getElementAt(n);
            if (!(e instanceof INumberScalar)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            return;
        }
        this.model = attributeList;
        this.refreshingPeriod = this.model.getRefreshInterval();
        int n4 = 0;
        this.getXAxis().setLabels(null, null);
        for (n = 0; n < n3; ++n) {
            INumberScalar iNumberScalar;
            e = attributeList.getElementAt(n);
            if (!(e instanceof INumberScalar) || this.dataViewHash.containsKey(iNumberScalar = (INumberScalar)e)) continue;
            JLDataView jLDataView = new JLDataView();
            jLDataView.setUnit(iNumberScalar.getUnit());
            this.prepareName(jLDataView, iNumberScalar);
            jLDataView.setColor(Color.black);
            jLDataView.setLineWidth(1);
            jLDataView.setBarWidth(n2);
            jLDataView.setFillStyle(1);
            jLDataView.setFillMethod(1);
            if (this.chartStyle == 0) {
                if (this.chartOnXAxis) {
                    jLDataView.setMarker(0);
                    jLDataView.setViewType(1);
                } else {
                    jLDataView.setLineWidth(n2);
                    jLDataView.setMarker(0);
                    jLDataView.setViewType(0);
                    jLDataView.setColor(this.chartColor);
                }
            } else {
                jLDataView.setMarker(5);
                jLDataView.setViewType(0);
            }
            this.getY1Axis().addDataView(jLDataView);
            iNumberScalar.addNumberScalarListener(this);
            Vector<Serializable> vector = new Vector<Serializable>();
            Integer n5 = new Integer(n4);
            vector.add(0, jLDataView);
            vector.add(1, n5);
            this.dataViewHash.put(iNumberScalar, vector);
            ++n4;
        }
        if (this.isChartOnXAxis()) {
            this.getXAxis().setMaximum(n4 + 1);
            this.getXAxis().setMinimum(0.0);
        } else {
            this.getY1Axis().setMaximum(n4 + 1);
            this.getY1Axis().setMinimum(0.0);
        }
        if (this.chartOnXAxis) {
            this.getXAxis().setLabelFormat(3);
        } else {
            this.getY1Axis().setLabelFormat(3);
        }
        this.setFaultLevel(this.getFaultLevel());
        this.setAlarmLevel(this.getAlarmLevel());
        this.getXAxis().setAnnotation(2);
        this.manageLabels();
    }

    public void clearModel() {
        if (this.model == null) {
            return;
        }
        int n = this.model.getSize();
        if (n <= 0) {
            return;
        }
        for (int i = 0; i < n; ++i) {
            INumberScalar iNumberScalar;
            Object e = this.model.getElementAt(i);
            if (!(e instanceof INumberScalar) || !this.dataViewHash.containsKey(iNumberScalar = (INumberScalar)e)) continue;
            iNumberScalar.removeNumberScalarListener(this);
        }
        this.getY1Axis().clearDataView();
        this.dataViewHash.clear();
        this.initLevels();
    }

    public void setWidth(int n) {
        if (this.model == null) {
            return;
        }
        int n2 = this.model.getSize();
        if (n2 <= 0) {
            return;
        }
        for (int i = 0; i < n2; ++i) {
            Object object;
            int n3;
            List<Object> list;
            INumberScalar iNumberScalar;
            Object e = this.model.getElementAt(i);
            if (!(e instanceof INumberScalar) || !this.dataViewHash.containsKey(iNumberScalar = (INumberScalar)e) || (list = this.dataViewHash.get(iNumberScalar)) == null || (n3 = list.size()) < 2 || (object = list.get(0)) == null || !(object instanceof JLDataView)) continue;
            JLDataView jLDataView = (JLDataView)object;
            if (this.chartOnXAxis) {
                jLDataView.setBarWidth(n);
                continue;
            }
            jLDataView.setLineWidth(n);
        }
    }

    public boolean isHighAlarm() {
        return this.highAlarm;
    }

    public void setHighAlarm(boolean bl) {
        this.highAlarm = bl;
    }

    public boolean isHighFault() {
        return this.highFault;
    }

    public void setHighFault(boolean bl) {
        this.highFault = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void numberScalarChange(NumberScalarEvent numberScalarEvent) {
        INumberScalar iNumberScalar = (INumberScalar)numberScalarEvent.getSource();
        if (this.dataViewHash.containsKey(iNumberScalar)) {
            List<Object> list = this.dataViewHash.get(iNumberScalar);
            if (list == null) {
                return;
            }
            int n = list.size();
            if (n < 2) {
                return;
            }
            Object object = list.get(0);
            if (object == null) {
                return;
            }
            if (!(object instanceof JLDataView)) {
                return;
            }
            JLDataView jLDataView = (JLDataView)object;
            object = list.get(1);
            if (object == null) {
                return;
            }
            if (!(object instanceof Integer)) {
                return;
            }
            int n2 = (Integer)object;
            double d = numberScalarEvent.getValue();
            jLDataView.reset();
            jLDataView.setUnit(iNumberScalar.getUnit());
            if (this.chartOnXAxis) {
                jLDataView.add(n2 + 1, d);
            } else if (this.chartStyle == 0) {
                jLDataView.add(0.0, n2 + 1);
                jLDataView.add(d, n2 + 1);
            } else {
                jLDataView.add(d, n2 + 1);
            }
            if (!this.chartOnXAxis) {
                jLDataView.setFillStyle(0);
            }
            if (this.alarmEnable) {
                if (this.isHighFault() && d > this.faultLevel || !this.isHighFault() && d <= this.faultLevel) {
                    jLDataView.setFillColor(ATKConstant.getColor4State("FAULT"));
                    jLDataView.setMarkerColor(ATKConstant.getColor4State("FAULT"));
                    jLDataView.setColor(ATKConstant.getColor4Quality("FAULT"));
                } else if (this.isHighAlarm() && d > this.alarmLevel || !this.isHighAlarm() && d <= this.alarmLevel) {
                    jLDataView.setFillColor(ATKConstant.getColor4Quality("ALARM"));
                    jLDataView.setMarkerColor(ATKConstant.getColor4Quality("ALARM"));
                    jLDataView.setColor(ATKConstant.getColor4Quality("ALARM"));
                } else {
                    jLDataView.setFillColor(this.chartColor);
                    jLDataView.setMarkerColor(this.chartColor);
                    jLDataView.setColor(this.chartColor);
                }
            } else {
                jLDataView.setFillColor(this.chartColor);
                jLDataView.setMarkerColor(this.chartColor);
                jLDataView.setColor(this.chartColor);
            }
            JLDataView jLDataView2 = this.lineView;
            synchronized (jLDataView2) {
                int n3;
                this.lineView.reset();
                Set<INumberScalar> set = this.dataViewHash.keySet();
                Iterator<INumberScalar> iterator = set.iterator();
                DataList[] dataListArray = new DataList[set.size()];
                for (n3 = 0; n3 < dataListArray.length; ++n3) {
                    dataListArray[n3] = null;
                }
                while (iterator.hasNext()) {
                    DataList dataList;
                    INumberScalar iNumberScalar2 = iterator.next();
                    List<Object> list2 = this.dataViewHash.get(iNumberScalar2);
                    JLDataView jLDataView3 = (JLDataView)list2.get(0);
                    Integer n4 = (Integer)list2.get(1);
                    dataListArray[n4.intValue()] = dataList = jLDataView3.getData();
                }
                for (n3 = 0; n3 < dataListArray.length; ++n3) {
                    if (dataListArray[n3] == null) continue;
                    if (this.chartOnXAxis) {
                        this.lineView.add(n3 + 1, dataListArray[n3].y);
                        continue;
                    }
                    this.lineView.add(dataListArray[n3].x, n3 + 1);
                }
            }
            this.repaint();
        }
    }

    public int getChartStyle() {
        return this.chartStyle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setChartStyle(int n) {
        this.chartStyle = n;
        Set<INumberScalar> set = this.dataViewHash.keySet();
        for (INumberScalar iNumberScalar : set) {
            List<Object> list = this.dataViewHash.get(iNumberScalar);
            JLDataView jLDataView = (JLDataView)list.get(0);
            switch (this.chartStyle) {
                case 0: {
                    jLDataView.setMarker(0);
                    if (this.chartOnXAxis) {
                        jLDataView.setViewType(1);
                    } else {
                        jLDataView.setViewType(0);
                    }
                    JLDataView jLDataView2 = this.lineView;
                    synchronized (jLDataView2) {
                        this.getY1Axis().removeDataView(this.lineView);
                        break;
                    }
                }
                case 1: {
                    jLDataView.setMarker(this.markerStyle);
                    jLDataView.setViewType(0);
                    JLDataView jLDataView2 = this.lineView;
                    synchronized (jLDataView2) {
                        this.getY1Axis().removeDataView(this.lineView);
                        break;
                    }
                }
                case 2: {
                    jLDataView.setMarker(this.markerStyle);
                    jLDataView.setViewType(0);
                    JLDataView jLDataView2 = this.lineView;
                    synchronized (jLDataView2) {
                        this.getY1Axis().addDataView(this.lineView);
                        break;
                    }
                }
                default: {
                    jLDataView.setMarker(0);
                    jLDataView.setViewType(0);
                }
            }
        }
        this.repaint();
    }

    public void stateChange(AttributeStateEvent attributeStateEvent) {
    }

    public void errorChange(ErrorEvent errorEvent) {
    }

    public double getAlarmLevel() {
        return this.alarmLevel;
    }

    public void setAlarmLevel(double d) {
        this.alarmLevel = d;
        this.getY1Axis().removeDataView(this.alarm);
        this.alarm.reset();
        if (this.chartOnXAxis) {
            this.alarm.add(0.0, d);
            int n = 1;
            if (this.model != null) {
                n = this.model.size() + 1;
            }
            this.alarm.add(n, d);
        } else {
            this.alarm.add(d, 0.0);
            int n = 1;
            if (this.model != null) {
                n = this.model.size() + 1;
            }
            this.alarm.add(d, n);
        }
        if (d != Double.MAX_VALUE) {
            this.getY1Axis().addDataView(this.alarm);
        }
    }

    public double getFaultLevel() {
        return this.faultLevel;
    }

    public void setFaultLevel(double d) {
        this.faultLevel = d;
        this.getY1Axis().removeDataView(this.fault);
        this.fault.reset();
        if (this.chartOnXAxis) {
            this.fault.add(0.0, d);
            int n = 1;
            if (this.model != null) {
                n = this.model.size() + 1;
            }
            this.fault.add(n, d);
        } else {
            this.fault.add(d, 0.0);
            int n = 1;
            if (this.model != null) {
                n = this.model.size() + 1;
            }
            this.fault.add(d, n);
        }
        if (d != Double.MAX_VALUE) {
            this.getY1Axis().addDataView(this.fault);
        }
    }

    public String getChartHeader() {
        return this.header;
    }

    public void setChartHeader(String string) {
        this.header = string;
        this.setHeader(string);
    }

    public String getUnit() {
        return this.unit;
    }

    public void setUnit(String string) {
        this.unit = string;
        if (!this.chartOnXAxis) {
            this.getY1Axis().setName(string);
            this.alarm.setUnit(string);
            this.fault.setUnit(string);
            return;
        }
        this.getXAxis().setName(string);
        this.alarm.setUnit(string);
        this.fault.setUnit(string);
    }

    public String getXaxisName() {
        return this.xaxisName;
    }

    public void setXaxisName(String string) {
        this.xaxisName = string;
        if (this.chartOnXAxis) {
            this.getXAxis().setName(string);
        } else {
            this.getY1Axis().setName(string);
        }
    }

    public String getSettings() {
        INumberScalar iNumberScalar;
        Object e;
        int n;
        String string = "";
        string = string + this.getConfiguration();
        string = string + "chartStyle:" + this.chartStyle + "\n";
        string = string + "markerStyle:" + this.markerStyle + "\n";
        string = string + "alarm:" + this.getAlarmLevel() + "\n";
        string = string + "fault:" + this.getFaultLevel() + "\n";
        if (this.model != null) {
            string = string + "refresh_time:" + this.refreshingPeriod + "\n";
        }
        string = string + this.getXAxis().getConfiguration("x");
        string = string + this.getY1Axis().getConfiguration("y1");
        string = string + this.getY2Axis().getConfiguration("y2");
        int n2 = this.model.getSize();
        int n3 = 0;
        for (n = 0; n < n2; ++n) {
            e = this.model.getElementAt(n);
            if (!(e instanceof INumberScalar) || !this.dataViewHash.containsKey(iNumberScalar = (INumberScalar)e)) continue;
            ++n3;
        }
        string = string + "dv_number:" + n3 + "\n";
        n3 = 0;
        for (n = 0; n < n2; ++n) {
            Object object;
            Object object2;
            int n4;
            List<Object> list;
            e = this.model.getElementAt(n);
            if (!(e instanceof INumberScalar) || !this.dataViewHash.containsKey(iNumberScalar = (INumberScalar)e) || (list = this.dataViewHash.get(iNumberScalar)) == null || (n4 = list.size()) < 2 || (object2 = list.get(0)) == null || !(object2 instanceof JLDataView) || (object = list.get(1)) == null || !(object instanceof Integer)) continue;
            int n5 = (Integer)object;
            JLDataView jLDataView = (JLDataView)object2;
            string = string + "dv" + n5 + "_name:'" + iNumberScalar + "'\n";
            string = string + jLDataView.getConfiguration("dv" + n5);
        }
        return string;
    }

    public void saveSetting(String string) {
        try {
            FileWriter fileWriter = new FileWriter(string);
            String string2 = this.getSettings();
            fileWriter.write(string2, 0, string2.length());
            fileWriter.close();
            this.lastConfig = string;
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this.getParent(), "Failed to write " + string, "Error", 0);
            exception.printStackTrace();
        }
    }

    public String loadSetting(String string) {
        CfFileReader cfFileReader = new CfFileReader();
        if (!cfFileReader.readFile(string)) {
            return "Failed to read " + string;
        }
        this.lastConfig = string;
        return this.applySettings(cfFileReader);
    }

    public int getRefreshingPeriod() {
        if (this.model == null) {
            return 0;
        }
        this.refreshingPeriod = this.model.getRefreshInterval();
        return this.refreshingPeriod;
    }

    public void setRefreshingPeriod(int n) {
        this.refreshingPeriod = n;
        if (this.model == null) {
            return;
        }
        this.model.stopRefresher();
        this.model.setRefreshInterval(n);
        this.model.startRefresher();
    }

    protected String applySettings(CfFileReader cfFileReader) {
        String string = "";
        String string2 = "";
        Vector<String> vector = cfFileReader.getParam("dv_number");
        if (vector != null) {
            int n;
            try {
                n = Integer.parseInt(vector.get(0).toString());
            }
            catch (NumberFormatException numberFormatException) {
                string = string + "dv_number: invalid number\n";
                return string;
            }
            for (int i = 0; i < n; ++i) {
                vector = cfFileReader.getParam("dv" + i + "_name");
                if (vector == null) {
                    string = string + "Unable to find dv" + i + "_name param\n";
                    return string;
                }
                try {
                    string2 = string2 + vector.get(0).toString() + ",";
                    continue;
                }
                catch (Exception exception) {
                    string = string + exception.getMessage() + "\n";
                    return string;
                }
            }
            if (n > 0) {
                vector = cfFileReader.getParam("refresh_time");
                if (vector != null) {
                    this.setRefreshingPeriod(OFormat.getInt(vector.get(0).toString()));
                }
                string2 = string2.substring(0, string2.lastIndexOf(","));
                this.setAttributeListAsString(string2);
            }
        } else {
            boolean bl = false;
        }
        this.applyConfiguration(cfFileReader);
        this.getXAxis().applyConfiguration("x", cfFileReader);
        this.getY1Axis().applyConfiguration("y1", cfFileReader);
        this.getY2Axis().applyConfiguration("y2", cfFileReader);
        vector = cfFileReader.getParam("dv0_barwidth");
        if (vector == null) {
            string = string + "Unable to find dv" + 0 + "_barwidth param";
            return string;
        }
        this.setWidth(Integer.parseInt(vector.get(0).toString().trim()));
        vector = cfFileReader.getParam("xtitle");
        if (vector == null) {
            string = string + "Unable to find xtitle param";
            return string;
        }
        this.setXaxisName(vector.get(0).toString().replaceAll("'", "").trim());
        vector = cfFileReader.getParam("graph_title");
        if (vector == null) {
            string = string + "Unable to find graph_title param";
            return string;
        }
        this.setChartHeader(vector.get(0).toString().replaceAll("'", "").trim());
        vector = cfFileReader.getParam("y1title");
        if (vector == null) {
            string = string + "Unable to find y1title param";
            return string;
        }
        this.setUnit(vector.get(0).toString().replaceAll("'", "").trim());
        vector = cfFileReader.getParam("chartStyle");
        if (vector == null) {
            string = string + "Unable to find chartStyle param";
            return string;
        }
        this.setChartStyle(Integer.valueOf(vector.get(0).toString().replaceAll("'", "").trim()));
        vector = cfFileReader.getParam("markerStyle");
        if (vector == null) {
            string = string + "Unable to find markerStyle param";
            return string;
        }
        this.setMarkerStyle(Integer.valueOf(vector.get(0).toString().replaceAll("'", "").trim()));
        vector = cfFileReader.getParam("alarm");
        if (vector == null) {
            string = string + "Unable to find alarm param";
            return string;
        }
        this.setAlarmLevel(Double.valueOf(vector.get(0).toString().replaceAll("'", "").trim()).intValue());
        vector = cfFileReader.getParam("fault");
        if (vector == null) {
            string = string + "Unable to find fault param";
            return string;
        }
        this.setFaultLevel(Double.valueOf(vector.get(0).toString().replaceAll("'", "").trim()).intValue());
        return string;
    }

    protected void setAttributeListAsString(String string) {
        String[] stringArray = string.split(",");
        AttributeList attributeList = new AttributeList();
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                attributeList.add(stringArray[i]);
                continue;
            }
            catch (ConnectionException connectionException) {
                JOptionPane.showMessageDialog(this, "Failed to connect to " + stringArray[i], "Error", 0);
            }
        }
        this.setModel(attributeList);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().trim().equalsIgnoreCase("Load configuration")) {
            this.loadPerformed();
        } else if (actionEvent.getActionCommand().trim().equalsIgnoreCase("Save configuration")) {
            this.savePerformed();
        } else if (actionEvent.getActionCommand().trim().equalsIgnoreCase("Set Refresh Interval...")) {
            int n = -1;
            n = this.getRefreshingPeriod();
            String string = JOptionPane.showInputDialog(this, "Enter refresh interval (ms)", new Integer(n));
            if (string != null && string.length() > 0) {
                try {
                    int n2 = Integer.parseInt(string);
                    this.setRefreshingPeriod(n2);
                }
                catch (NumberFormatException numberFormatException) {
                    JOptionPane.showMessageDialog(this, "Invalid number !", "Error", 0);
                    return;
                }
            }
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    protected void showTableAll() {
        int n;
        if (this.model == null) {
            return;
        }
        JLTable jLTable = new JLTable();
        String[] stringArray = new String[]{"Attribute", "Value (" + new SimpleDateFormat("yyyy.MM.dd 'at' HH:mm:ss ").format(new Date()) + ")"};
        Vector<Object> vector = new Vector<Object>();
        int n2 = this.model.size();
        for (n = 0; n < n2; ++n) {
            IAttribute iAttribute = (IAttribute)this.model.getElementAt(n);
            vector.add(iAttribute.getName());
            if (iAttribute instanceof INumberScalar) {
                vector.add(new Double(((INumberScalar)iAttribute).getNumberScalarValue()));
                continue;
            }
            vector.add("NaN");
        }
        n = n2;
        int n3 = stringArray.length;
        Object[][] objectArray = new Object[n][n3];
        int n4 = 0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n3; ++j) {
                Object e = vector.get(n4);
                objectArray[i][j] = e;
                ++n4;
            }
        }
        jLTable.setData(objectArray, stringArray);
        if (!jLTable.isVisible()) {
            jLTable.centerWindow();
        }
        jLTable.setVisible(true);
    }

    protected void loadPerformed() {
        String string;
        File file;
        if (this.model != null) {
            this.model.stopRefresher();
        }
        this.clearModel();
        boolean bl = false;
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setSelectedFile(new File(this.lastConfig));
        jFileChooser.addChoosableFileFilter(new MultiExtFileFilter("Text files", "txt", new String[0]));
        int n = jFileChooser.showOpenDialog(this.getParent());
        if (n == 0 && (file = jFileChooser.getSelectedFile()) != null && !bl && (string = this.loadSetting(file.getAbsolutePath())).length() > 0) {
            JOptionPane.showMessageDialog(this.getParent(), string, "Errors reading " + file.getName(), 0);
        }
        this.repaint();
    }

    protected void savePerformed() {
        int n = 0;
        JFileChooser jFileChooser = new JFileChooser(".");
        jFileChooser.addChoosableFileFilter(new MultiExtFileFilter("Text files", "txt", new String[0]));
        jFileChooser.setSelectedFile(new File(this.lastConfig));
        int n2 = jFileChooser.showSaveDialog(this.getParent());
        if (n2 == 0) {
            File file = jFileChooser.getSelectedFile();
            if (MultiExtFileFilter.getExtension(file) == null) {
                file = new File(file.getAbsolutePath() + ".txt");
            }
            if (file != null) {
                if (file.exists()) {
                    n = JOptionPane.showConfirmDialog(this.getParent(), "Do you want to overwrite " + file.getName() + " ?", "Confirm overwrite", 0);
                }
                if (n == 0) {
                    this.saveSetting(file.getAbsolutePath());
                }
            }
        }
    }

    public int getDisplayMode() {
        return this.displayMode;
    }

    public void setDisplayMode(int n) {
        if (this.displayMode != n) {
            this.displayMode = n;
            this.updateToolTips();
        }
    }

    public int getAxisDisplayMode() {
        return this.axisDisplayMode;
    }

    public void setAxisDisplayMode(int n) {
        if (this.axisDisplayMode != n) {
            this.axisDisplayMode = n;
            this.manageLabels();
        }
    }

    protected void updateToolTips() {
        if (this.model != null) {
            Object e;
            int n;
            int n2 = this.model.getSize();
            boolean bl = false;
            for (n = 0; n < n2; ++n) {
                e = this.model.getElementAt(n);
                if (!(e instanceof INumberScalar)) continue;
                bl = true;
                break;
            }
            if (!bl) {
                return;
            }
            this.refreshingPeriod = this.model.getRefreshInterval();
            for (n = 0; n < n2; ++n) {
                e = this.model.getElementAt(n);
                if (!(e instanceof INumberScalar)) continue;
                INumberScalar iNumberScalar = (INumberScalar)e;
                List<Object> list = this.dataViewHash.get(iNumberScalar);
                if (list == null) {
                    return;
                }
                int n3 = list.size();
                if (n3 < 2) {
                    return;
                }
                Object object = list.get(0);
                if (object == null) {
                    return;
                }
                if (!(object instanceof JLDataView)) {
                    return;
                }
                JLDataView jLDataView = (JLDataView)object;
                this.prepareName(jLDataView, iNumberScalar);
            }
        }
    }

    protected void prepareName(JLDataView jLDataView, INumberScalar iNumberScalar) {
        switch (this.getDisplayMode()) {
            case 1: {
                jLDataView.setName(iNumberScalar.getNameSansDevice());
                return;
            }
            case 2: {
                jLDataView.setName(iNumberScalar.getLabel());
                return;
            }
            case 3: {
                jLDataView.setName(iNumberScalar.getAlias());
                return;
            }
            case 4: {
                jLDataView.setName(iNumberScalar.getDevice().getName());
                return;
            }
        }
        jLDataView.setName(iNumberScalar.getName());
    }

    protected void manageLabels() {
        if (this.dataViewHash.size() > 0) {
            String[] stringArray = new String[this.dataViewHash.size()];
            double[] dArray = new double[this.dataViewHash.size()];
            Set<INumberScalar> set = this.dataViewHash.keySet();
            Iterator<INumberScalar> iterator = set.iterator();
            int n = 0;
            switch (this.getAxisDisplayMode()) {
                case 1: {
                    while (iterator.hasNext()) {
                        INumberScalar iNumberScalar = iterator.next();
                        List<Object> list = this.dataViewHash.get(iNumberScalar);
                        Integer n2 = (Integer)list.get(1);
                        stringArray[n] = iNumberScalar.getNameSansDevice();
                        dArray[n++] = n2.doubleValue() + 1.0;
                    }
                    break;
                }
                case 2: {
                    while (iterator.hasNext()) {
                        INumberScalar iNumberScalar = iterator.next();
                        List<Object> list = this.dataViewHash.get(iNumberScalar);
                        Integer n3 = (Integer)list.get(1);
                        stringArray[n] = iNumberScalar.getLabel();
                        dArray[n++] = n3.doubleValue() + 1.0;
                    }
                    break;
                }
                case 3: {
                    while (iterator.hasNext()) {
                        INumberScalar iNumberScalar = iterator.next();
                        List<Object> list = this.dataViewHash.get(iNumberScalar);
                        Integer n4 = (Integer)list.get(1);
                        stringArray[n] = iNumberScalar.getAlias();
                        dArray[n++] = n4.doubleValue() + 1.0;
                    }
                    break;
                }
                case 4: {
                    while (iterator.hasNext()) {
                        INumberScalar iNumberScalar = iterator.next();
                        List<Object> list = this.dataViewHash.get(iNumberScalar);
                        Integer n5 = (Integer)list.get(1);
                        stringArray[n] = iNumberScalar.getDevice().getName();
                        dArray[n++] = n5.doubleValue() + 1.0;
                    }
                    break;
                }
                case 0: {
                    while (iterator.hasNext()) {
                        INumberScalar iNumberScalar = iterator.next();
                        List<Object> list = this.dataViewHash.get(iNumberScalar);
                        Integer n6 = (Integer)list.get(1);
                        stringArray[n] = iNumberScalar.getName();
                        dArray[n++] = n6.doubleValue() + 1.0;
                    }
                    break;
                }
                default: {
                    stringArray = null;
                    dArray = null;
                }
            }
            this.getXAxis().setLabels(stringArray, dArray);
        }
    }

    public Color getChartColor() {
        return this.chartColor;
    }

    public void setChartColor(Color color) {
        this.chartColor = color;
    }

    public boolean isAlarmEnable() {
        return this.alarmEnable;
    }

    public void setAlarmEnable(boolean bl) {
        this.alarmEnable = bl;
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        final AttributeMultiChart attributeMultiChart = new AttributeMultiChart(0);
        attributeMultiChart.getXAxis().setTickSpacing(0.0);
        final AttributeList attributeList = new AttributeList();
        try {
            if (stringArray.length > 0) {
                for (int i = 0; i < stringArray.length; ++i) {
                    attributeList.add(stringArray[i]);
                }
            } else {
                attributeList.add("LT1/AE/CH.1/voltage");
                attributeList.add("LT1/AE/CH.2/voltage");
                attributeList.add("LT1/AE/CH.3/voltage");
            }
        }
        catch (ConnectionException connectionException) {
            connectionException.printStackTrace();
            System.exit(1);
        }
        attributeMultiChart.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 32) {
                    if (attributeList.isRefresherStarted()) {
                        attributeList.stopRefresher();
                    } else {
                        attributeList.startRefresher();
                    }
                }
            }

            public void keyReleased(KeyEvent keyEvent) {
            }

            public void keyTyped(KeyEvent keyEvent) {
            }
        });
        attributeMultiChart.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                attributeMultiChart.grabFocus();
            }
        });
        attributeMultiChart.setModel(attributeList);
        attributeList.startRefresher();
        attributeMultiChart.setWidth(10);
        attributeMultiChart.setHeader("AttributeMultiChart");
        attributeMultiChart.setFaultLevel(200.0);
        attributeMultiChart.setAlarmLevel(100.0);
        jFrame.getContentPane().add((Component)attributeMultiChart, "Center");
        jFrame.setSize(640, 480);
        jFrame.setTitle(attributeMultiChart.getHeader() + " Example 1");
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        jFrame.setVisible(true);
    }
}

