/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core.command;

import fr.esrf.Tango.DevError;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.Group.Group;
import fr.esrf.TangoApi.Group.GroupCmdReply;
import fr.esrf.TangoApi.Group.GroupCmdReplyList;
import fr.esrf.tangoatk.core.CommandExecuteException;
import fr.esrf.tangoatk.core.CommandList;
import fr.esrf.tangoatk.core.ConnectionException;
import fr.esrf.tangoatk.core.DeviceFactory;
import fr.esrf.tangoatk.core.EventSupport;
import fr.esrf.tangoatk.core.ICommand;
import fr.esrf.tangoatk.core.ICommandGroup;
import fr.esrf.tangoatk.core.IEndGroupExecutionListener;
import fr.esrf.tangoatk.core.IEntity;
import fr.esrf.tangoatk.core.IEntityFilter;
import fr.esrf.tangoatk.core.command.ACommand;
import fr.esrf.tangoatk.core.command.CommandFactory;
import fr.esrf.tangoatk.core.command.VoidVoidCommand;
import java.util.List;

public class VoidVoidCommandGroup
extends CommandList
implements ICommandGroup {
    protected EventSupport propChanges;
    protected Group devGroup;
    protected String uniqueCmdName = null;

    public VoidVoidCommandGroup() {
        this.factory = CommandFactory.getInstance();
        this.devGroup = new Group("VoidVoidCmd Group");
        this.filter = new IEntityFilter(){

            public boolean keep(IEntity iEntity) {
                if (iEntity instanceof VoidVoidCommand) {
                    if (VoidVoidCommandGroup.this.uniqueCmdName != null && !VoidVoidCommandGroup.this.uniqueCmdName.equalsIgnoreCase(iEntity.getNameSansDevice())) {
                        return false;
                    }
                    if (VoidVoidCommandGroup.this.uniqueCmdName == null) {
                        VoidVoidCommandGroup.this.uniqueCmdName = new String(iEntity.getNameSansDevice());
                    }
                    try {
                        VoidVoidCommandGroup.this.devGroup.add(iEntity.getDevice().getName());
                    }
                    catch (DevFailed devFailed) {
                        return false;
                    }
                    return true;
                }
                return false;
            }
        };
        this.propChanges = new EventSupport();
    }

    public void setFilter(IEntityFilter iEntityFilter) {
    }

    public void addEndGroupExecutionListener(IEndGroupExecutionListener iEndGroupExecutionListener) {
        this.propChanges.addEndGroupExecutionListener(iEndGroupExecutionListener);
    }

    public void removeEndGroupExecutionListener(IEndGroupExecutionListener iEndGroupExecutionListener) {
        this.propChanges.removeEndGroupExecutionListener(iEndGroupExecutionListener);
    }

    protected void publishEndExecution(List list) {
        this.propChanges.fireEndGroupExecutionEvent(this, list);
    }

    public void loopExecute() {
        long l = System.currentTimeMillis();
        IEntity iEntity = null;
        ICommand iCommand = null;
        DeviceFactory.getInstance().trace(16, "VoidVoidCommandGroup.loopExecute()  ", l);
        for (int i = 0; i < this.size(); ++i) {
            iEntity = (IEntity)this.get(i);
            if (!(iEntity instanceof VoidVoidCommand)) continue;
            iCommand = (ICommand)iEntity;
            iCommand.execute();
        }
        long l2 = System.currentTimeMillis();
        DeviceFactory.getInstance().trace(16, "VoidVoidCommandGroup.loopExecute()  end of loop", l2);
        this.publishEndExecution(null);
    }

    public void execute() {
        long l = System.currentTimeMillis();
        GroupCmdReplyList groupCmdReplyList = null;
        DeviceFactory.getInstance().trace(16, "VoidVoidCommandGroup.execute()  ", l);
        if (this.uniqueCmdName == null) {
            return;
        }
        if (this.devGroup == null) {
            return;
        }
        if (this.devGroup.get_size(false) <= 0) {
            return;
        }
        try {
            groupCmdReplyList = this.devGroup.command_inout(this.uniqueCmdName, false);
            if (groupCmdReplyList.has_failed()) {
                for (int i = 0; i < groupCmdReplyList.size(); ++i) {
                    IEntity iEntity;
                    GroupCmdReply groupCmdReply = (GroupCmdReply)groupCmdReplyList.get(i);
                    if (!groupCmdReply.has_failed() || (iEntity = this.get(groupCmdReply.dev_name() + this.uniqueCmdName)) == null) continue;
                    ACommand aCommand = (ACommand)iEntity;
                    String string = "execute(" + aCommand.getName() + ") failed: ";
                    CommandExecuteException commandExecuteException = this.buildCmdException(string, groupCmdReply);
                    aCommand.cmdError(string, commandExecuteException);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        long l2 = System.currentTimeMillis();
        DeviceFactory.getInstance().trace(16, "VoidVoidCommandGroup.execute()  end of loop", l2);
        this.publishEndExecution(null);
    }

    private CommandExecuteException buildCmdException(String string, GroupCmdReply groupCmdReply) {
        CommandExecuteException commandExecuteException = null;
        DevError[] devErrorArray = groupCmdReply.get_err_stack();
        if (devErrorArray == null) {
            commandExecuteException = new CommandExecuteException(string);
            return commandExecuteException;
        }
        if (devErrorArray.length <= 0) {
            commandExecuteException = new CommandExecuteException(string);
            return commandExecuteException;
        }
        commandExecuteException = devErrorArray[0].reason != null ? new CommandExecuteException(devErrorArray[0].reason, devErrorArray) : new CommandExecuteException(string, devErrorArray);
        return commandExecuteException;
    }

    public String getCmdName() {
        return this.uniqueCmdName;
    }

    public String getVersion() {
        return "$Id $";
    }

    public static void main(String[] stringArray) {
        VoidVoidCommandGroup voidVoidCommandGroup = new VoidVoidCommandGroup();
        try {
            voidVoidCommandGroup.add("id/id/00/open");
            voidVoidCommandGroup.add("fe/id/0/open");
            voidVoidCommandGroup.add("fe/id/0/delivery");
        }
        catch (ConnectionException connectionException) {
            // empty catch block
        }
        voidVoidCommandGroup.execute();
    }
}

