/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core.attribute;

import fr.esrf.Tango.AttrQuality;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.TangoApi.DeviceDataHistory;
import fr.esrf.tangoatk.core.IAttributeSpectrumHistory;
import fr.esrf.tangoatk.core.INumberSpectrumHistory;
import fr.esrf.tangoatk.core.attribute.AAttribute;
import fr.esrf.tangoatk.core.attribute.ANumberSpectrumHelper;
import fr.esrf.tangoatk.core.attribute.NumberSpectrumHistory;

public class FloatSpectrumHelper
extends ANumberSpectrumHelper {
    public FloatSpectrumHelper(AAttribute aAttribute) {
        this.init(aAttribute);
    }

    void init(AAttribute aAttribute) {
        super.init(aAttribute);
    }

    void insert(double[] dArray) {
        double d = 1.0;
        float[] fArray = new float[dArray.length];
        d = this.attribute.getDisplayUnitFactor();
        DeviceAttribute deviceAttribute = this.attribute.getAttribute();
        for (int i = 0; i < fArray.length; ++i) {
            fArray[i] = (float)(dArray[i] / d);
        }
        deviceAttribute.insert(fArray);
    }

    protected INumberSpectrumHistory[] getNumberSpectrumAttHistory(DeviceDataHistory[] deviceDataHistoryArray) {
        INumberSpectrumHistory[] iNumberSpectrumHistoryArray = new NumberSpectrumHistory[deviceDataHistoryArray.length];
        double d = 1.0;
        if (deviceDataHistoryArray.length <= 0) {
            return null;
        }
        d = this.attribute.getDisplayUnitFactor();
        if (d <= 0.0) {
            d = 1.0;
        }
        for (int i = 0; i < deviceDataHistoryArray.length; ++i) {
            NumberSpectrumHistory numberSpectrumHistory = new NumberSpectrumHistory();
            try {
                numberSpectrumHistory.setTimestamp(deviceDataHistoryArray[i].getTime());
            }
            catch (Exception exception) {
                numberSpectrumHistory.setTimestamp(0L);
            }
            try {
                AttrQuality attrQuality = deviceDataHistoryArray[i].getAttrQuality();
                if (0 == attrQuality.value()) {
                    numberSpectrumHistory.setState("VALID");
                } else if (1 == attrQuality.value()) {
                    numberSpectrumHistory.setState("INVALID");
                } else if (2 == attrQuality.value()) {
                    numberSpectrumHistory.setState("ALARM");
                } else if (4 == attrQuality.value()) {
                    numberSpectrumHistory.setState("WARNING");
                } else if (3 == attrQuality.value()) {
                    numberSpectrumHistory.setState("CHANGING");
                } else {
                    numberSpectrumHistory.setState("UNKNOWN");
                }
            }
            catch (Exception exception) {
                numberSpectrumHistory.setState("UNKNOWN");
            }
            try {
                float[] fArray = deviceDataHistoryArray[i].extractFloatArray();
                double[] dArray = new double[fArray.length];
                for (int j = 0; j < fArray.length; ++j) {
                    dArray[j] = (double)fArray[j] * d;
                }
                numberSpectrumHistory.setValue(dArray);
            }
            catch (Exception exception) {
                numberSpectrumHistory.setValue(new double[0]);
            }
            iNumberSpectrumHistoryArray[i] = numberSpectrumHistory;
        }
        return iNumberSpectrumHistoryArray;
    }

    protected INumberSpectrumHistory[] getNumberSpectrumDeviceAttHistory(DeviceDataHistory[] deviceDataHistoryArray) {
        INumberSpectrumHistory[] iNumberSpectrumHistoryArray = new NumberSpectrumHistory[deviceDataHistoryArray.length];
        if (deviceDataHistoryArray.length <= 0) {
            return null;
        }
        for (int i = 0; i < deviceDataHistoryArray.length; ++i) {
            NumberSpectrumHistory numberSpectrumHistory = new NumberSpectrumHistory();
            try {
                numberSpectrumHistory.setTimestamp(deviceDataHistoryArray[i].getTime());
            }
            catch (Exception exception) {
                numberSpectrumHistory.setTimestamp(0L);
            }
            try {
                AttrQuality attrQuality = deviceDataHistoryArray[i].getAttrQuality();
                if (0 == attrQuality.value()) {
                    numberSpectrumHistory.setState("VALID");
                } else if (1 == attrQuality.value()) {
                    numberSpectrumHistory.setState("INVALID");
                } else if (2 == attrQuality.value()) {
                    numberSpectrumHistory.setState("ALARM");
                } else if (4 == attrQuality.value()) {
                    numberSpectrumHistory.setState("WARNING");
                } else if (3 == attrQuality.value()) {
                    numberSpectrumHistory.setState("CHANGING");
                } else {
                    numberSpectrumHistory.setState("UNKNOWN");
                }
            }
            catch (Exception exception) {
                numberSpectrumHistory.setState("UNKNOWN");
            }
            try {
                float[] fArray = deviceDataHistoryArray[i].extractFloatArray();
                double[] dArray = new double[fArray.length];
                for (int j = 0; j < fArray.length; ++j) {
                    dArray[j] = fArray[j];
                }
                numberSpectrumHistory.setValue(dArray);
            }
            catch (Exception exception) {
                numberSpectrumHistory.setValue(new double[0]);
            }
            iNumberSpectrumHistoryArray[i] = numberSpectrumHistory;
        }
        return iNumberSpectrumHistoryArray;
    }

    protected IAttributeSpectrumHistory[] getSpectrumDeviceAttHistory(DeviceDataHistory[] deviceDataHistoryArray) {
        return this.getNumberSpectrumDeviceAttHistory(deviceDataHistoryArray);
    }

    protected IAttributeSpectrumHistory[] getSpectrumAttHistory(DeviceDataHistory[] deviceDataHistoryArray) {
        return this.getNumberSpectrumAttHistory(deviceDataHistoryArray);
    }

    void setMinAlarm(double d, boolean bl) {
        this.setProperty("min_alarm", new Float(d), bl);
    }

    void setMaxAlarm(double d, boolean bl) {
        this.setProperty("max_alarm", new Float(d), bl);
    }

    void setMinValue(double d, boolean bl) {
        this.setProperty("min_value", new Float(d), bl);
    }

    void setMaxValue(double d, boolean bl) {
        this.setProperty("max_value", new Float(d), bl);
    }

    void setMinWarning(double d, boolean bl) {
        this.setProperty("min_warning", new Float(d), bl);
    }

    void setMaxWarning(double d, boolean bl) {
        this.setProperty("max_warning", new Float(d), bl);
    }

    void setDeltaT(double d, boolean bl) {
        this.setProperty("delta_t", new Float(d), bl);
    }

    void setDeltaVal(double d, boolean bl) {
        this.setProperty("delta_val", new Float(d), bl);
    }

    void setMinAlarm(double d) {
        this.setProperty("min_alarm", new Float(d));
    }

    void setMaxAlarm(double d) {
        this.setProperty("max_alarm", new Float(d));
    }

    void setMinValue(double d) {
        this.setProperty("min_value", new Float(d));
    }

    void setMaxValue(double d) {
        this.setProperty("max_value", new Float(d));
    }

    void setMinWarning(double d) {
        this.setProperty("min_warning", new Float(d));
    }

    void setMaxWarning(double d) {
        this.setProperty("max_warning", new Float(d));
    }

    void setDeltaT(double d) {
        this.setProperty("delta_t", new Float(d));
    }

    void setDeltaVal(double d) {
        this.setProperty("delta_val", new Float(d));
    }

    double[] getNumberSpectrumValue(DeviceAttribute deviceAttribute) throws DevFailed {
        float[] fArray = deviceAttribute.extractFloatArray();
        int n = deviceAttribute.getNbRead();
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = fArray[i];
        }
        return dArray;
    }

    double[] getNumberSpectrumSetPoint(DeviceAttribute deviceAttribute) throws DevFailed {
        int n;
        float[] fArray = deviceAttribute.extractFloatArray();
        int n2 = fArray.length - (n = deviceAttribute.getNbRead());
        if (n2 <= 0) {
            return this.getNumberSpectrumValue(deviceAttribute);
        }
        double[] dArray = new double[n2];
        int n3 = 0;
        for (int i = n; i < fArray.length; ++i) {
            dArray[n3] = fArray[i];
            ++n3;
        }
        return dArray;
    }

    double[] getNumberSpectrumDisplayValue(DeviceAttribute deviceAttribute) throws DevFailed {
        double d = this.attribute.getDisplayUnitFactor();
        float[] fArray = deviceAttribute.extractFloatArray();
        int n = deviceAttribute.getNbRead();
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = (double)fArray[i] * d;
        }
        return dArray;
    }

    double[] getNumberSpectrumDisplaySetPoint(DeviceAttribute deviceAttribute) throws DevFailed {
        float[] fArray = deviceAttribute.extractFloatArray();
        int n = deviceAttribute.getNbRead();
        int n2 = fArray.length - n;
        double d = this.attribute.getDisplayUnitFactor();
        if (n2 <= 0) {
            return this.getNumberSpectrumDisplayValue(deviceAttribute);
        }
        double[] dArray = new double[n2];
        int n3 = 0;
        for (int i = n; i < fArray.length; ++i) {
            dArray[n3] = (double)fArray[i] * d;
            ++n3;
        }
        return dArray;
    }

    public String getVersion() {
        return "$Id: FloatSpectrumHelper.java 15105 2010-09-24 13:11:54Z poncet $";
    }
}

