/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoDs;

import fr.esrf.Tango.AttrWriteType;
import fr.esrf.Tango.AttributeConfig;
import fr.esrf.Tango.AttributeConfig_2;
import fr.esrf.Tango.AttributeValue;
import fr.esrf.Tango.DevAttrHistory;
import fr.esrf.Tango.DevCmdHistory;
import fr.esrf.Tango.DevCmdInfo;
import fr.esrf.Tango.DevCmdInfo_2;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevInfo;
import fr.esrf.Tango.DevSource;
import fr.esrf.Tango.DevState;
import fr.esrf.Tango.DevVarBooleanArrayHelper;
import fr.esrf.Tango.DevVarDoubleArrayHelper;
import fr.esrf.Tango.DevVarLong64ArrayHelper;
import fr.esrf.Tango.DevVarLongArrayHelper;
import fr.esrf.Tango.DevVarLongStringArray;
import fr.esrf.Tango.DevVarShortArrayHelper;
import fr.esrf.Tango.DevVarStateArrayHelper;
import fr.esrf.Tango.DevVarStringArrayHelper;
import fr.esrf.Tango.DevVarULong64ArrayHelper;
import fr.esrf.Tango.DevVarULongArrayHelper;
import fr.esrf.Tango.DevVarUShortArrayHelper;
import fr.esrf.Tango.Device_2POA;
import fr.esrf.TangoApi.DbAttribute;
import fr.esrf.TangoApi.DbDatum;
import fr.esrf.TangoApi.DbDevice;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoDs.Attr;
import fr.esrf.TangoDs.Attribute;
import fr.esrf.TangoDs.BlackBox;
import fr.esrf.TangoDs.Command;
import fr.esrf.TangoDs.DServer;
import fr.esrf.TangoDs.DeviceClass;
import fr.esrf.TangoDs.Except;
import fr.esrf.TangoDs.Logging;
import fr.esrf.TangoDs.MultiAttribute;
import fr.esrf.TangoDs.PollObj;
import fr.esrf.TangoDs.TangoConst;
import fr.esrf.TangoDs.TangoMonitor;
import fr.esrf.TangoDs.Util;
import java.util.Vector;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.SystemException;
import org.omg.PortableServer.POA;

public abstract class DeviceImpl
extends Device_2POA
implements TangoConst {
    protected BlackBox blackbox;
    protected int blackbox_depth;
    protected String device_name;
    protected String adm_device_name;
    protected String desc;
    protected String device_status;
    protected DevState device_state;
    protected byte[] access;
    protected int version;
    protected final DeviceClass device_class;
    protected MultiAttribute dev_attr;
    protected DbDevice db_dev;
    private byte[] obj_id;
    private boolean exported = false;
    private Logger logger = null;
    private Level last_level = Level.OFF;
    private long rft = 2048L;
    private final DeviceImplExt ext;

    public DeviceImpl(DeviceClass deviceClass, String string, String string2, DevState devState, String string3) throws DevFailed {
        this.device_class = deviceClass;
        this.device_name = string;
        this.desc = string2;
        this.device_state = devState;
        this.device_status = string3;
        this.version = 2;
        this.blackbox_depth = 0;
        this.ext = new DeviceImplExt();
        if (Util._UseDb) {
            this.db_dev = new DbDevice(this.device_name);
        }
        this.get_dev_system_resource();
        this.black_box_create();
        this.dev_attr = new MultiAttribute(this.device_name, this.device_class);
        StringBuffer stringBuffer = new StringBuffer("dserver/");
        stringBuffer.append(Util.instance().get_ds_name());
        this.adm_device_name = stringBuffer.toString();
        this.init_logger();
    }

    public DeviceImpl(DeviceClass deviceClass, String string) throws DevFailed {
        this.device_class = deviceClass;
        this.device_name = string;
        this.desc = "A Tango device";
        this.device_state = DevState.UNKNOWN;
        this.device_status = "Not Initialised";
        this.version = 2;
        this.blackbox_depth = 0;
        this.ext = new DeviceImplExt();
        if (Util._UseDb) {
            this.db_dev = new DbDevice(this.device_name);
        }
        this.get_dev_system_resource();
        this.black_box_create();
        this.dev_attr = new MultiAttribute(this.device_name, this.device_class);
        StringBuffer stringBuffer = new StringBuffer("dserver/");
        stringBuffer.append(Util.instance().get_ds_name());
        this.adm_device_name = stringBuffer.toString();
        this.init_logger();
    }

    public DeviceImpl(DeviceClass deviceClass, String string, String string2) throws DevFailed {
        this.device_class = deviceClass;
        this.device_name = string;
        this.desc = string2;
        this.device_state = DevState.UNKNOWN;
        this.device_status = "Not Initialised";
        this.version = 2;
        this.blackbox_depth = 0;
        this.ext = new DeviceImplExt();
        if (Util._UseDb) {
            this.db_dev = new DbDevice(this.device_name);
        }
        this.get_dev_system_resource();
        this.black_box_create();
        this.dev_attr = new MultiAttribute(this.device_name, this.device_class);
        StringBuffer stringBuffer = new StringBuffer("dserver/");
        stringBuffer.append(Util.instance().get_ds_name());
        this.adm_device_name = stringBuffer.toString();
        this.init_logger();
    }

    private void black_box_create() {
        this.blackbox = this.blackbox_depth == 0 ? new BlackBox() : new BlackBox(this.blackbox_depth);
    }

    private void get_dev_system_resource() throws DevFailed {
        if (Util._UseDb) {
            try {
                String[] stringArray = new String[]{"blackbox_depth", "description", "poll_ring_depth", "polled_cmd", "polled_attr", "non_auto_polled_cmd", "non_auto_polled_attr", "poll_old_factor"};
                DbDatum[] dbDatumArray = this.db_dev.get_property(stringArray);
                int n = 0;
                if (!dbDatumArray[n].is_empty()) {
                    this.blackbox_depth = dbDatumArray[n].extractLong();
                }
                if (!dbDatumArray[++n].is_empty()) {
                    this.desc = dbDatumArray[n].extractString();
                }
                if (!dbDatumArray[++n].is_empty()) {
                    this.set_poll_ring_depth(dbDatumArray[n].extractLong());
                }
                if (!dbDatumArray[++n].is_empty()) {
                    this.set_polled_cmd(dbDatumArray[n].extractStringArray());
                }
                if (!dbDatumArray[++n].is_empty()) {
                    this.set_polled_attr(dbDatumArray[n].extractStringArray());
                }
                if (!dbDatumArray[++n].is_empty()) {
                    this.set_non_auto_polled_cmd(dbDatumArray[n].extractStringArray());
                }
                if (!dbDatumArray[++n].is_empty()) {
                    this.set_non_auto_polled_attr(dbDatumArray[n].extractStringArray());
                }
                if (!dbDatumArray[++n].is_empty()) {
                    this.set_poll_old_factor(dbDatumArray[n].extractLong());
                } else {
                    this.set_poll_old_factor(4);
                }
            }
            catch (DevFailed devFailed) {
                StringBuffer stringBuffer = new StringBuffer("Database error while trying to retrieve device properties for device ");
                stringBuffer.append(this.device_name);
                Except.throw_exception("API_DatabaseAccess", stringBuffer.toString(), "DeviceImpl.get_dev_system_resource");
            }
            catch (BAD_OPERATION bAD_OPERATION) {
                StringBuffer stringBuffer = new StringBuffer("Database error while trying to retrieve device properties for device ");
                stringBuffer.append(this.device_name);
                Except.throw_exception("API_DatabaseAccess", stringBuffer.toString(), "DeviceImpl.get_dev_system_resource");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Any command_inout(String string, Any any) throws DevFailed {
        Util.out4.println("DeviceImpl.command_inout(): command received : " + string);
        this.blackbox.insert_cmd(string, 1);
        Any any2 = null;
        try {
            Util.increaseAccessConter();
            if (Util.getAccessConter() > Util.getPoaThreadPoolMax() - 2) {
                Util.decreaseAccessConter();
                Except.throw_exception("API_MemoryAllocation", Util.instance().get_ds_real_name() + ": No thread available to connect device", "DeviceImpl.write_attributes()");
            }
            switch (Util.get_serial_model()) {
                case 1: {
                    DeviceClass deviceClass = this.device_class;
                    synchronized (deviceClass) {
                        any2 = this.device_class.command_handler(this, string, any);
                        break;
                    }
                }
                case 0: {
                    DeviceImpl deviceImpl = this;
                    synchronized (deviceImpl) {
                        any2 = this.device_class.command_handler(this, string, any);
                        break;
                    }
                }
                default: {
                    any2 = this.device_class.command_handler(this, string, any);
                }
            }
        }
        catch (DevFailed devFailed) {
            Util.decreaseAccessConter();
            throw devFailed;
        }
        catch (Exception exception) {
            Util.decreaseAccessConter();
            Except.throw_exception("API_ExceptionCatched", exception.toString(), "DeviceImpl.command_inout");
        }
        Util.decreaseAccessConter();
        Util.out4.println("DeviceImpl.command_inout(): leaving method for command " + string);
        return any2;
    }

    public Any command_inout_2(String string, Any any, DevSource devSource) throws DevFailed, SystemException {
        Util.out4.println("Device_2Impl.command_inout_2 arrived, source = " + devSource + ", command = " + string);
        PollObj pollObj = null;
        boolean bl = false;
        if (devSource == DevSource.DEV) {
            return this.command_inout(string, any);
        }
        try {
            double d;
            double d2;
            int n;
            this.blackbox.insert_cmd(string, 2);
            String string2 = string.toLowerCase();
            this.check_command_exists(string2);
            boolean bl2 = false;
            Vector vector = this.get_poll_obj_list();
            for (int i = 0; i < vector.size(); ++i) {
                PollObj pollObj2 = (PollObj)vector.elementAt(i);
                if (pollObj2.get_type() != 0 || !pollObj2.get_name().equals(string.toLowerCase())) continue;
                pollObj = pollObj2;
                bl2 = true;
            }
            if (!bl2) {
                Object object;
                Command command = this.get_command(string2);
                int n2 = command.get_polling_period();
                if (n2 == 0) {
                    Except.throw_exception("API_CmdNotPolled", "Command " + string + " not polled", "Device_2Impl.command_inout");
                }
                bl2 = false;
                Vector vector2 = this.get_non_auto_polled_cmd();
                for (n = 0; n < vector2.size(); ++n) {
                    object = (String)vector2.elementAt(n);
                    if (!((String)object).equals(string2)) continue;
                    bl2 = true;
                }
                if (bl2) {
                    Except.throw_exception("API_CmdNotPolled", "Command " + string + " not polled", "Device_2Impl.command_inout");
                } else {
                    Util util = Util.instance();
                    object = util.get_dserver_device();
                    DevVarLongStringArray devVarLongStringArray = new DevVarLongStringArray();
                    devVarLongStringArray.lvalue = new int[1];
                    devVarLongStringArray.svalue = new String[3];
                    devVarLongStringArray.lvalue[0] = n2;
                    devVarLongStringArray.svalue[0] = this.device_name;
                    devVarLongStringArray.svalue[1] = "command";
                    devVarLongStringArray.svalue[2] = string;
                    ((DServer)object).add_obj_polling(devVarLongStringArray, false);
                    for (int i = 0; i < vector.size(); ++i) {
                        PollObj pollObj3 = (PollObj)vector.elementAt(i);
                        if (pollObj3.get_type() != 0 || !pollObj3.get_name().equals(string)) continue;
                        pollObj = pollObj3;
                        break;
                    }
                }
            }
            if (pollObj == null) {
                Except.throw_exception("API_CommandNotPolled", "Command not found.", "Device_2Impl.command_inout");
            }
            assert (pollObj != null);
            if (pollObj.is_ring_empty()) {
                Except.throw_exception("API_NoDataYet", "No data available in cache for command " + string, "Device_2Impl.command_inout");
            }
            long l = System.currentTimeMillis();
            int n3 = (int)(l / 1000L);
            double d3 = pollObj.get_last_insert_date();
            if ((d2 = (d = (double)(n3 -= 1002000000) + (double)(n = (int)(l - (long)(1000 * n3)) * 1000) / 1000000.0) - d3) > pollObj.get_authorized_delta()) {
                Except.throw_exception("API_NotUpdatedAnyMore", "Data in cache for command " + string + " not updated any more", "Device_2Impl.command_inout");
            }
        }
        catch (DevFailed devFailed) {
            if (devSource == DevSource.CACHE) {
                throw devFailed;
            }
            bl = true;
        }
        if (devSource == DevSource.CACHE) {
            Util.out4.println("Device_2Impl: Returning data from polling buffer");
            assert (pollObj != null);
            return pollObj.get_last_cmd_result();
        }
        if (!bl) {
            Util.out4.println("Device_2Impl: Returning data from polling buffer");
            return pollObj.get_last_cmd_result();
        }
        return this.command_inout(string, any);
    }

    public DevCmdHistory[] command_inout_history_2(String string, int n) throws DevFailed, SystemException {
        int n2;
        Util.out4.println("Device_2Impl.command_inout_history_2 arrived");
        String string2 = string.toLowerCase();
        this.blackbox.insert_op(16);
        this.check_command_exists(string2);
        PollObj pollObj = null;
        Vector vector = this.get_poll_obj_list();
        for (n2 = 0; n2 < vector.size(); ++n2) {
            PollObj pollObj2 = (PollObj)vector.elementAt(n2);
            if (pollObj2.get_type() != 0 || !pollObj2.get_name().equals(string2)) continue;
            pollObj = pollObj2;
        }
        if (pollObj == null) {
            Except.throw_exception("API_CmdNotPolled", "Command " + string2 + " not polled", "Device_2Impl.command_inout_history_2");
        }
        assert (pollObj != null);
        if (pollObj.is_ring_empty()) {
            Except.throw_exception("API_NoDataYet", "No data available in cache for command " + string2, "Device_2Impl.command_inout_history_2");
        }
        if (n > (n2 = pollObj.get_elt_nb_in_buffer())) {
            n = n2;
        }
        return pollObj.get_cmd_history(n);
    }

    public String name() {
        Util.out4.println("DeviceImpl.name() arrived");
        this.blackbox.insert_attr(1);
        Util.out4.println("Leaving DeviceImpl.name()");
        return this.device_name;
    }

    public String adm_name() {
        Util.out4.println("DeviceImpl.adm_name() arrived");
        this.blackbox.insert_attr(5);
        Util.out4.println("Leaving DeviceImpl.adm_name()");
        return this.adm_device_name;
    }

    public String description() {
        Util.out4.println("DeviceImpl.description() arrived");
        this.blackbox.insert_attr(2);
        Util.out4.println("Leaving DeviceImpl.description()");
        return this.desc;
    }

    public DevState state() {
        Util.out4.println("DeviceImpl.state() (attribute) arrived");
        this.blackbox.insert_attr(3);
        DevState devState = null;
        try {
            devState = this.dev_state();
        }
        catch (DevFailed devFailed) {
            // empty catch block
        }
        Util.out4.println("Leaving DeviceImpl.state() (attribute)");
        return devState;
    }

    public String status() {
        Util.out4.println("DeviceImpl.status() (attibute) arrived");
        this.blackbox.insert_attr(4);
        String string = null;
        try {
            string = this.dev_status();
        }
        catch (DevFailed devFailed) {
            // empty catch block
        }
        Util.out4.println("Leaving DeviceImpl.status() (attribute)");
        return string;
    }

    public String[] black_box(int n) throws DevFailed {
        Util.out4.println("DeviceImpl.black_box() arrived");
        String[] stringArray = this.blackbox.read(n);
        this.blackbox.insert_op(2);
        Util.out4.println("Leaving DeviceImpl.black_box()");
        return stringArray;
    }

    public DevCmdInfo[] command_list_query() {
        int n;
        Util.out4.println("DeviceImpl.command_list_query() arrived");
        int n2 = this.device_class.get_command_list().size();
        Util.out4.println(n2 + " command(s) for device");
        DevCmdInfo[] devCmdInfoArray = new DevCmdInfo[n2];
        for (n = 0; n < n2; ++n) {
            devCmdInfoArray[n] = new DevCmdInfo();
        }
        for (n = 0; n < n2; ++n) {
            devCmdInfoArray[n].cmd_name = ((Command)this.device_class.get_command_list().elementAt(n)).get_name();
            devCmdInfoArray[n].cmd_tag = ((Command)this.device_class.get_command_list().elementAt(n)).get_tag();
            devCmdInfoArray[n].in_type = ((Command)this.device_class.get_command_list().elementAt(n)).get_in_type();
            devCmdInfoArray[n].out_type = ((Command)this.device_class.get_command_list().elementAt(n)).get_out_type();
            String string = ((Command)this.device_class.get_command_list().elementAt(n)).get_in_type_desc();
            devCmdInfoArray[n].in_type_desc = string == null ? "Uninitialised" : string;
            string = ((Command)this.device_class.get_command_list().elementAt(n)).get_out_type_desc();
            devCmdInfoArray[n].out_type_desc = string == null ? "Uninitialised" : string;
        }
        this.blackbox.insert_op(5);
        Util.out4.println("Leaving DeviceImpl.command_list_query()");
        return devCmdInfoArray;
    }

    public DevCmdInfo_2[] command_list_query_2() {
        Util.out4.println("Device_2Impl.command_list_query_2 arrived");
        Vector vector = this.device_class.get_command_list();
        Util.out4.println(vector.size() + " command(s) for device");
        DevCmdInfo_2[] devCmdInfo_2Array = new DevCmdInfo_2[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            Command command = (Command)vector.elementAt(i);
            DevCmdInfo_2 devCmdInfo_2 = new DevCmdInfo_2();
            devCmdInfo_2.cmd_name = command.get_name();
            devCmdInfo_2.cmd_tag = command.get_tag();
            devCmdInfo_2.level = command.get_disp_level();
            devCmdInfo_2.in_type = command.get_in_type();
            devCmdInfo_2.out_type = command.get_out_type();
            String string = command.get_in_type_desc();
            devCmdInfo_2.in_type_desc = string != null ? string : "Uninitialised";
            String string2 = command.get_out_type_desc();
            devCmdInfo_2.out_type_desc = string2 != null ? string2 : "Uninitialised";
            devCmdInfo_2Array[i] = devCmdInfo_2;
        }
        this.blackbox.insert_op(12);
        Util.out4.println("Device_2Impl.command_list_query_2 exiting");
        return devCmdInfo_2Array;
    }

    public DevCmdInfo_2 command_query_2(String string) throws DevFailed, SystemException {
        Util.out4.println("Device_2Impl.command_query_2(" + string + ") arrived");
        int n = this.device_class.get_command_list().size();
        Util.out4.println(n + " command(s) for device");
        DevCmdInfo_2 devCmdInfo_2 = null;
        for (int i = 0; i < n; ++i) {
            Command command = (Command)this.device_class.get_command_list().elementAt(i);
            if (!command.get_name().toLowerCase().equals(string.toLowerCase())) continue;
            DevCmdInfo_2 devCmdInfo_22 = new DevCmdInfo_2();
            devCmdInfo_22.cmd_name = command.get_name();
            devCmdInfo_22.cmd_tag = command.get_tag();
            devCmdInfo_22.level = command.get_disp_level();
            devCmdInfo_22.in_type = command.get_in_type();
            devCmdInfo_22.out_type = command.get_out_type();
            String string2 = command.get_in_type_desc();
            devCmdInfo_22.in_type_desc = string2.length() != 0 ? string2 : "Uninitialised";
            String string3 = command.get_out_type_desc();
            devCmdInfo_22.out_type_desc = string3.length() != 0 ? string3 : "Uninitialised";
            devCmdInfo_2 = devCmdInfo_22;
        }
        if (devCmdInfo_2 == null) {
            Except.throw_exception("API_CommandNotFound", "Command " + string + " not found", "Device_2Impl.command_query_2");
        }
        this.blackbox.insert_op(12);
        Util.out4.println("Device_2Impl.command_list_query_2 exiting");
        return devCmdInfo_2;
    }

    public DevCmdInfo command_query(String string) throws DevFailed {
        int n;
        Util.out4.println("DeviceImpl.command_query() arrived");
        DevCmdInfo devCmdInfo = new DevCmdInfo();
        String string2 = string.toLowerCase();
        int n2 = this.device_class.get_command_list().size();
        for (n = 0; n < n2; ++n) {
            Command command = (Command)this.device_class.get_command_list().elementAt(n);
            if (!command.get_name().toLowerCase().equals(string2)) continue;
            devCmdInfo.cmd_name = string;
            devCmdInfo.cmd_tag = command.get_tag();
            devCmdInfo.in_type = command.get_in_type();
            devCmdInfo.out_type = command.get_out_type();
            String string3 = command.get_in_type_desc();
            devCmdInfo.in_type_desc = string3 == null ? "Uninitialised" : string3;
            string3 = command.get_out_type_desc();
            if (string3 == null) {
                devCmdInfo.out_type_desc = "Uninitialised";
                break;
            }
            devCmdInfo.out_type_desc = string3;
            break;
        }
        if (n == n2) {
            Util.out3.println("DeviceImpl.command_query(): operation " + string + " not found");
            Except.throw_exception("API_CommandNotFound", "Command " + string + " not found", "DeviceImpl.command_query()");
        }
        this.blackbox.insert_op(6);
        Util.out4.println("Leaving DeviceImpl.command_query()");
        return devCmdInfo;
    }

    public DevInfo info() {
        Util.out4.println("DeviceImpl.info() arrived");
        DevInfo devInfo = new DevInfo();
        Util util = Util.instance();
        devInfo.server_host = util.get_host_name();
        devInfo.dev_class = this.device_class.get_name();
        devInfo.server_id = util.get_ds_real_name();
        devInfo.server_version = 2;
        devInfo.doc_url = this.device_class.get_doc_url();
        this.blackbox.insert_op(4);
        Util.out4.println("Leaving DeviceImpl.info()");
        return devInfo;
    }

    public void ping() {
        Util.out4.println("DeviceImpl.ping() arrived");
        this.blackbox.insert_op(3);
        Util.out4.println("Leaving DeviceImpl.ping()");
    }

    public AttributeConfig[] get_attribute_config(String[] stringArray) throws DevFailed {
        int n;
        Util.out4.println("DeviceImpl.get_attribute_config arrived");
        int n2 = stringArray.length;
        boolean bl = false;
        this.blackbox.insert_op(7);
        int n3 = this.dev_attr.get_attr_nb();
        if (n3 == 0) {
            Except.throw_exception("API_AttrNotFound", "The device does not have any attribute", "DeviceImpl.get_attribute_config");
        }
        if (n2 == 1 && stringArray[0].equals("All attributes")) {
            n2 = n3;
            bl = true;
        }
        AttributeConfig[] attributeConfigArray = null;
        try {
            attributeConfigArray = new AttributeConfig[n2];
            for (n = 0; n < n2; ++n) {
                attributeConfigArray[n] = new AttributeConfig();
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            Util.out3.println("Bad allocation while in DeviceImpl.get_attribute_config");
            Except.throw_exception("API_MemoryAllocation", "Can't allocate memory in server", "DeviceImpl.get_attribute_config");
        }
        for (n = 0; n < n2; ++n) {
            Attribute attribute;
            if (bl) {
                attribute = this.dev_attr.get_attr_by_ind(n);
                attribute.get_properties(attributeConfigArray[n]);
                continue;
            }
            attribute = this.dev_attr.get_attr_by_name(stringArray[n]);
            attribute.get_properties(attributeConfigArray[n]);
        }
        Util.out4.println("Leaving DeviceImpl.get_attribute_config");
        return attributeConfigArray;
    }

    public AttributeConfig_2[] get_attribute_config_2(String[] stringArray) throws DevFailed, SystemException {
        Util.out4.println("Device_2Impl.get_attribute_config_2 arrived");
        int n = stringArray.length;
        boolean bl = false;
        this.blackbox.insert_op(14);
        int n2 = this.dev_attr.get_attr_nb();
        String string = stringArray[0];
        if (n == 1 && string.equals("All attributes")) {
            n = n2;
            bl = true;
        }
        AttributeConfig_2[] attributeConfig_2Array = new AttributeConfig_2[n];
        for (int i = 0; i < n; ++i) {
            Attribute attribute;
            if (bl) {
                attribute = this.dev_attr.get_attr_by_ind(i);
                attributeConfig_2Array[i] = attribute.get_properties_2();
                continue;
            }
            attribute = this.dev_attr.get_attr_by_name(stringArray[i]);
            attributeConfig_2Array[i] = attribute.get_properties_2();
        }
        Util.out4.println("Leaving Device_2Impl.get_attribute_config_2");
        return attributeConfig_2Array;
    }

    public void set_attribute_config(AttributeConfig[] attributeConfigArray) throws DevFailed {
        Util.out4.println("DeviceImpl.set_attribute_config arrived");
        this.blackbox.insert_op(8);
        int n = this.dev_attr.get_attr_nb();
        if (n == 0) {
            Except.throw_exception("API_AttrNotFound", "The device does not have any attribute", "DeviceImpl.set_attribute_config");
        }
        int n2 = attributeConfigArray.length;
        int n3 = 0;
        try {
            for (n3 = 0; n3 < n2; ++n3) {
                Attribute attribute = this.dev_attr.get_attr_by_name(attributeConfigArray[n3].name);
                if (Util._UseDb) {
                    attribute.upd_database(attributeConfigArray[n3], this.device_name);
                }
                attribute.set_properties(attributeConfigArray[n3], this.device_name);
            }
        }
        catch (DevFailed devFailed) {
            this.dev_attr.get_alarm_list().removeAllElements();
            for (int i = 0; i < n; ++i) {
                if (!this.dev_attr.get_attr_by_ind(i).is_alarmed()) continue;
                this.dev_attr.get_alarm_list().addElement(i);
            }
            StringBuffer stringBuffer = new StringBuffer(devFailed.errors[0].reason);
            if (n3 != 0) {
                stringBuffer.append("\nAll previous attribute(s) have been successfully updated");
            }
            if (n3 != n2 - 1) {
                stringBuffer.append("\nAll remaining attribute(s) have not been updated");
            }
            devFailed.errors[0].reason = stringBuffer.toString();
            throw devFailed;
        }
        this.dev_attr.get_alarm_list().removeAllElements();
        for (n3 = 0; n3 < n; ++n3) {
            if (!this.dev_attr.get_attr_by_ind(n3).is_alarmed()) continue;
            this.dev_attr.get_alarm_list().addElement(n3);
        }
        Util.out4.println("Leaving DeviceImpl.set_attribute_config");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AttributeValue[] read_attributes(String[] stringArray) throws DevFailed {
        Util.out4.println("DeviceImpl.read_attributes arrived" + stringArray[0]);
        this.blackbox.insert_op(9);
        if (this.dev_attr.get_attr_nb() == 0) {
            Except.throw_exception("API_AttrNotFound", "The device does not have any attribute", "DeviceImpl.read_attributes");
        }
        String[] stringArray2 = this.checkRealNames(stringArray);
        Util.increaseAccessConter();
        if (Util.getAccessConter() > Util.getPoaThreadPoolMax() - 2) {
            Util.decreaseAccessConter();
            Except.throw_exception("API_MemoryAllocation", Util.instance().get_ds_real_name() + ": No thread available to connect device", "DeviceImpl.read_attributes()");
        }
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        AttributeValue[] attributeValueArray = null;
        try {
            switch (Util.get_serial_model()) {
                case 1: {
                    DeviceClass deviceClass = this.device_class;
                    synchronized (deviceClass) {
                        this.sortAttributes(stringArray2, vector, vector2);
                        attributeValueArray = this.manageReadAttrinbute(stringArray2, vector, vector2);
                        break;
                    }
                }
                case 0: {
                    DeviceImpl deviceImpl = this;
                    synchronized (deviceImpl) {
                        this.sortAttributes(stringArray2, vector, vector2);
                        attributeValueArray = this.manageReadAttrinbute(stringArray2, vector, vector2);
                        break;
                    }
                }
                default: {
                    DeviceImpl deviceImpl = this;
                    synchronized (deviceImpl) {
                        this.sortAttributes(stringArray2, vector, vector2);
                    }
                    attributeValueArray = this.manageReadAttrinbute(stringArray2, vector, vector2);
                }
            }
        }
        catch (DevFailed devFailed) {
            Util.decreaseAccessConter();
            this.setNotActive(stringArray2);
            throw devFailed;
        }
        catch (Exception exception) {
            Util.decreaseAccessConter();
            this.setNotActive(stringArray2);
            exception.printStackTrace();
            Except.throw_exception("API_ExceptionCatched", exception.toString(), "DeviceImpl.read_attributes");
        }
        Util.decreaseAccessConter();
        this.setNotActive(stringArray2);
        Util.out4.println("Leaving DeviceImpl.read_attributes");
        return attributeValueArray;
    }

    private AttributeValue[] manageReadAttrinbute(String[] stringArray, Vector vector, Vector vector2) throws DevFailed {
        int n;
        int n2;
        this.always_executed_hook();
        if (vector.size() != 0) {
            this.read_attr_hardware(vector);
        }
        for (n2 = 0; n2 < vector.size(); ++n2) {
            n = (Integer)vector.elementAt(n2);
            this.read_attr(this.dev_attr.get_attr_by_ind(n));
        }
        for (n2 = 0; n2 < vector2.size(); ++n2) {
            n = (Integer)vector2.elementAt(n2);
            AttrWriteType attrWriteType = this.dev_attr.get_attr_by_ind(n).get_writable();
            if (attrWriteType != AttrWriteType.READ_WITH_WRITE && attrWriteType != AttrWriteType.WRITE) continue;
            this.dev_attr.get_attr_by_ind(n).set_value();
        }
        return this.buildAttributeValue(stringArray);
    }

    private AttributeValue[] buildAttributeValue(String[] stringArray) throws DevFailed {
        int n;
        AttributeValue[] attributeValueArray = new AttributeValue[]{};
        try {
            attributeValueArray = new AttributeValue[stringArray.length];
            for (n = 0; n < stringArray.length; ++n) {
                attributeValueArray[n] = new AttributeValue();
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            Except.throw_exception("API_MemoryAllocation", "Can't allocate memory in server", "DeviceImpl.read_attributes");
        }
        for (n = 0; n < stringArray.length; ++n) {
            Attribute attribute = this.dev_attr.get_attr_by_name(stringArray[n]);
            if (attribute.get_value_flag()) {
                AttrWriteType attrWriteType = attribute.get_writable();
                if (attrWriteType == AttrWriteType.READ || attrWriteType == AttrWriteType.READ_WRITE || attrWriteType == AttrWriteType.READ_WITH_WRITE) {
                    if (attrWriteType == AttrWriteType.READ_WRITE || attrWriteType == AttrWriteType.READ_WITH_WRITE) {
                        this.dev_attr.add_write_value(attribute);
                    }
                    if (attribute.is_alarmed() && attribute.get_quality().value() != 1) {
                        attribute.check_alarm();
                    }
                }
                attributeValueArray[n].time = attribute.get_when();
                attributeValueArray[n].quality = attribute.get_quality();
                attributeValueArray[n].name = attribute.get_name();
                attributeValueArray[n].dim_x = attribute.get_x();
                attributeValueArray[n].dim_y = attribute.get_y();
                Util util = Util.instance();
                attributeValueArray[n].value = util.get_orb().create_any();
                switch (attribute.get_data_type()) {
                    case 1: {
                        DevVarBooleanArrayHelper.insert(attributeValueArray[n].value, attribute.get_boolean_value());
                        break;
                    }
                    case 2: {
                        DevVarShortArrayHelper.insert(attributeValueArray[n].value, attribute.get_short_value());
                        break;
                    }
                    case 6: {
                        DevVarUShortArrayHelper.insert(attributeValueArray[n].value, attribute.get_short_value());
                        break;
                    }
                    case 3: {
                        DevVarLongArrayHelper.insert(attributeValueArray[n].value, attribute.get_long_value());
                        break;
                    }
                    case 7: {
                        DevVarULongArrayHelper.insert(attributeValueArray[n].value, attribute.get_long_value());
                        break;
                    }
                    case 23: {
                        DevVarLong64ArrayHelper.insert(attributeValueArray[n].value, attribute.get_long64_value());
                        break;
                    }
                    case 24: {
                        DevVarULong64ArrayHelper.insert(attributeValueArray[n].value, attribute.get_long64_value());
                        break;
                    }
                    case 5: {
                        DevVarDoubleArrayHelper.insert(attributeValueArray[n].value, attribute.get_double_value());
                        break;
                    }
                    case 8: {
                        DevVarStringArrayHelper.insert(attributeValueArray[n].value, attribute.get_string_value());
                        break;
                    }
                    case 19: {
                        DevVarStateArrayHelper.insert(attributeValueArray[n].value, attribute.get_state_value());
                        break;
                    }
                    default: {
                        Except.throw_exception("API_DatTypeNotSupported", "Attribute " + attribute.get_name() + " data type not supported !", "Device_2Impl.read_attributes()");
                        break;
                    }
                }
                continue;
            }
            Except.throw_exception("API_AttrValueNotSet", "Read value for attribute " + attribute.get_name() + " has not been updated", "DeviceImpl.read_attributes");
        }
        return attributeValueArray;
    }

    private void sortAttributes(String[] stringArray, Vector vector, Vector vector2) throws DevFailed {
        for (String string : stringArray) {
            Attribute attribute = this.dev_attr.get_attr_by_name(string);
            int n = this.dev_attr.get_attr_ind_by_name(string);
            if (attribute.get_writable() == AttrWriteType.READ_WRITE) {
                vector2.addElement(n);
                vector.addElement(n);
                attribute.waitEndOfRead();
                continue;
            }
            if (attribute.get_writable() == AttrWriteType.WRITE) {
                vector2.addElement(n);
                continue;
            }
            vector.addElement(n);
            attribute.waitEndOfRead();
        }
    }

    private String[] checkRealNames(String[] stringArray) {
        if (stringArray.length == 1) {
            if (stringArray[0].equals("All attributes")) {
                String[] stringArray2 = new String[this.dev_attr.get_attr_nb()];
                for (int i = 0; i < this.dev_attr.get_attr_nb(); ++i) {
                    stringArray2[i] = this.dev_attr.get_attr_by_ind(i).get_name();
                }
                return stringArray2;
            }
            return stringArray;
        }
        return stringArray;
    }

    private void setNotActive(String[] stringArray) throws DevFailed {
        for (String string : stringArray) {
            this.dev_attr.get_attr_by_name(string).setActive(false);
        }
    }

    public AttributeValue[] read_attributes_2(String[] stringArray, DevSource devSource) throws DevFailed {
        Util.out4.println("DeviceImpl.read_attributes_2 arrived src=" + devSource.value());
        if (devSource == DevSource.DEV) {
            return this.read_attributes(stringArray);
        }
        boolean bl = false;
        this.blackbox.insert_op(15);
        AttributeValue[] attributeValueArray = null;
        try {
            Object object;
            int n;
            Object object2;
            int n2;
            Object object3;
            boolean bl2 = false;
            Vector vector = this.get_poll_obj_list();
            int n3 = vector.size();
            int n4 = stringArray.length;
            String[] stringArray2 = stringArray;
            if (n4 == 1 && ((String)(object3 = stringArray[0])).equals("All attributes")) {
                bl2 = true;
                int n5 = 0;
                for (n2 = 0; n2 < n3; ++n2) {
                    object2 = (PollObj)vector.elementAt(n2);
                    if (((PollObj)object2).get_type() != 1) continue;
                    ++n5;
                }
                stringArray2 = new String[n5];
                n = 0;
                for (n2 = 0; n2 < n3 && n < n5; ++n2) {
                    object2 = (PollObj)vector.elementAt(n2);
                    if (((PollObj)object2).get_type() != 1) continue;
                    stringArray2[n++] = ((PollObj)object2).get_name();
                }
            }
            if (!bl2) {
                for (n2 = 0; n2 < stringArray2.length; ++n2) {
                    this.dev_attr.get_attr_ind_by_name(stringArray2[n2]);
                }
            }
            object3 = new Vector();
            if (!bl2) {
                for (n2 = 0; n2 < stringArray2.length; ++n2) {
                    PollObj pollObj;
                    for (n = 0; n < n3 && !(pollObj = (PollObj)vector.elementAt(n)).get_name().equals(stringArray2[n2].toLowerCase()); ++n) {
                    }
                    if (n != n3) continue;
                    ((Vector)object3).add(stringArray2[n2]);
                }
            }
            Vector<Integer> vector2 = new Vector<Integer>();
            if (((Vector)object3).size() != 0) {
                for (n2 = 0; n2 < ((Vector)object3).size(); ++n2) {
                    object2 = (String)((Vector)object3).elementAt(n2);
                    object = this.dev_attr.get_attr_by_name((String)object2);
                    vector2.add(((Attribute)object).get_polling_period());
                    if (((Attribute)object).get_polling_period() == 0) {
                        Except.throw_exception("API_AttrNotPolled", "Attribute " + (String)object2 + " not polled", "Device_2Impl.read_attributes");
                        continue;
                    }
                    boolean bl3 = false;
                    Vector vector3 = this.get_non_auto_polled_attr();
                    for (n = 0; n < vector3.size(); ++n) {
                        String string = ((String)vector3.elementAt(n)).toLowerCase();
                        if (!string.equals(((String)object2).toLowerCase())) continue;
                        bl3 = true;
                    }
                    if (!bl3) continue;
                    Except.throw_exception("API_AttrNotPolled", "Attribute " + (String)object2 + " not polled", "Device_2Impl.read_attributes");
                }
                object2 = Util.instance();
                object = ((Util)object2).get_dserver_device();
                DevVarLongStringArray devVarLongStringArray = new DevVarLongStringArray();
                devVarLongStringArray.lvalue = new int[1];
                devVarLongStringArray.svalue = new String[3];
                devVarLongStringArray.svalue[0] = this.device_name;
                devVarLongStringArray.svalue[1] = "attribute";
                for (n2 = 0; n2 < ((Vector)object3).size(); ++n2) {
                    devVarLongStringArray.lvalue[0] = (Integer)vector2.elementAt(n2);
                    devVarLongStringArray.svalue[2] = (String)((Vector)object3).elementAt(n2);
                    ((DServer)object).add_obj_polling(devVarLongStringArray, false);
                }
            }
            int n6 = stringArray2.length;
            attributeValueArray = new AttributeValue[n6];
            for (n2 = 0; n2 < n6; ++n2) {
                int n7;
                double d;
                double d2;
                object = null;
                for (n = 0; n < vector.size(); ++n) {
                    PollObj pollObj = (PollObj)vector.elementAt(n);
                    if (pollObj.get_type() != 1 || !pollObj.get_name().toLowerCase().equals(stringArray2[n2].toLowerCase())) continue;
                    object = pollObj;
                    break;
                }
                if (((PollObj)object).is_ring_empty()) {
                    Except.throw_exception("API_NoDataYet", "No data available in cache for attribute " + stringArray2[n2], "Device_2Impl.read_attributes");
                }
                long l = System.currentTimeMillis();
                int n8 = (int)(l / 1000L);
                double d3 = ((PollObj)object).get_last_insert_date();
                if ((d2 = (d = (double)(n8 -= 1002000000) + (double)(n7 = (int)(l - (long)(1000 * n8)) * 1000) / 1000000.0) - d3) > ((PollObj)object).get_authorized_delta()) {
                    Except.throw_exception("API_NotUpdatedAnyMore", "Data in cache for attribute " + stringArray2[n2] + " not updated any more", "Device_2Impl.read_attributes");
                }
                attributeValueArray[n2] = ((PollObj)object).get_last_attr_value();
            }
        }
        catch (DevFailed devFailed) {
            if (devSource == DevSource.CACHE) {
                throw devFailed;
            }
            bl = true;
        }
        if (devSource == DevSource.CACHE_DEV && bl) {
            attributeValueArray = this.read_attributes(stringArray);
        }
        return attributeValueArray;
    }

    public DevAttrHistory[] read_attribute_history_2(String string, int n) throws DevFailed, SystemException {
        int n2;
        Util.out4.println("Device_2Impl.read_attribute_history_2 arrived");
        this.blackbox.insert_op(17);
        Vector vector = this.get_poll_obj_list();
        int n3 = vector.size();
        Attribute attribute = this.dev_attr.get_attr_by_name(string);
        String string2 = string.toLowerCase();
        PollObj pollObj = null;
        for (n2 = 0; n2 < n3; ++n2) {
            PollObj pollObj2 = (PollObj)vector.elementAt(n2);
            if (pollObj2.get_type() != 1 || !pollObj2.get_name().equals(string2)) continue;
            pollObj = pollObj2;
            break;
        }
        if (pollObj == null) {
            Except.throw_exception("API_AttrNotPolled", "No data available in cache for attribute " + string2, "Device_2Impl.read_attribute_history_2");
        }
        assert (pollObj != null);
        if (pollObj.is_ring_empty()) {
            Except.throw_exception("API_NoDataYet", "No data available in cache for attribute " + string2, "Device_2Impl.read_attribute_history_2");
        }
        if (n > (n2 = pollObj.get_elt_nb_in_buffer())) {
            n = n2;
        }
        return pollObj.get_attr_history(n, attribute.get_data_type());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write_attributes(AttributeValue[] attributeValueArray) throws DevFailed {
        Object object;
        Util.out4.println("DeviceImpl.write_attributes arrived");
        this.blackbox.insert_op(10);
        int n = this.dev_attr.get_attr_nb();
        if (n == 0) {
            Except.throw_exception("API_AttrNotFound", "The device does not have any attribute", "DeviceImpl.write_attributes");
        }
        long l = attributeValueArray.length;
        Vector<Integer> vector = new Vector<Integer>();
        int n2 = 0;
        while ((long)n2 < l) {
            vector.addElement(this.dev_attr.get_attr_ind_by_name(attributeValueArray[n2].name));
            ++n2;
        }
        n2 = 0;
        while ((long)n2 < l) {
            if (this.dev_attr.get_attr_by_ind((Integer)vector.elementAt(n2)).get_writable() == AttrWriteType.READ || this.dev_attr.get_attr_by_ind((Integer)vector.elementAt(n2)).get_writable() == AttrWriteType.READ_WITH_WRITE) {
                object = new StringBuffer("Attribute ");
                ((StringBuffer)object).append(this.dev_attr.get_attr_by_ind((Integer)vector.elementAt(n2)).get_name());
                ((StringBuffer)object).append(" is not writable");
                Except.throw_exception("API_AttrNotWritable", ((StringBuffer)object).toString(), "DeviceImpl.write_attributes");
            }
            ++n2;
        }
        n2 = 0;
        while ((long)n2 < l) {
            try {
                this.dev_attr.get_w_attr_by_ind((Integer)vector.elementAt(n2)).set_write_value(attributeValueArray[n2].value);
            }
            catch (DevFailed devFailed) {
                for (int i = 0; i < n2; ++i) {
                    this.dev_attr.get_w_attr_by_ind((Integer)vector.elementAt(i)).rollback();
                }
                throw devFailed;
            }
            ++n2;
        }
        try {
            Util.increaseAccessConter();
            if (Util.getAccessConter() > Util.getPoaThreadPoolMax() - 2) {
                Util.decreaseAccessConter();
                Except.throw_exception("API_MemoryAllocation", Util.instance().get_ds_real_name() + ": No thread available to connect device", "DeviceImpl.write_attributes()");
            }
            this.always_executed_hook();
            switch (Util.get_serial_model()) {
                case 1: {
                    object = this.device_class;
                    synchronized (object) {
                        this.write_attr_hardware(vector);
                        break;
                    }
                }
                case 0: {
                    object = this;
                    synchronized (object) {
                        this.write_attr_hardware(vector);
                        break;
                    }
                }
                default: {
                    this.write_attr_hardware(vector);
                }
            }
        }
        catch (DevFailed devFailed) {
            Util.decreaseAccessConter();
            throw devFailed;
        }
        catch (Exception exception) {
            Util.decreaseAccessConter();
            Except.throw_exception("API_ExceptionCatched", exception.toString(), "DeviceImpl.write_attributes");
        }
        Util.decreaseAccessConter();
        Util.out4.println("Leaving DeviceImpl.write_attributes");
    }

    public void remove_attribute(String string) throws DevFailed {
        if (Util._UseDb) {
            DeviceProxy deviceProxy = new DeviceProxy(this.device_name);
            DbAttribute dbAttribute = deviceProxy.get_attribute_property(string);
            deviceProxy.delete_attribute_property(dbAttribute);
        }
        this.dev_attr.remove_attribute(string);
    }

    public void add_attribute(Attr attr) throws DevFailed {
        int n;
        Vector vector = this.device_class.get_class_attr().get_attr_list();
        int n2 = vector.size();
        String string = attr.get_name();
        boolean bl = true;
        try {
            this.dev_attr.get_attr_by_name(string);
        }
        catch (DevFailed devFailed) {
            bl = false;
        }
        if (bl) {
            return;
        }
        for (n = 0; n < n2 && !((Attr)vector.elementAt(n)).get_name().equals(string); ++n) {
        }
        if (n == n2) {
            vector.addElement(attr);
            this.device_class.get_class_attr().init_class_attribute(this.device_class.get_name(), n2);
        }
        this.dev_attr.add_attribute(this.device_name, this.device_class, n);
    }

    public DevState dev_state() throws DevFailed {
        Vector vector;
        int n;
        if ((this.device_state.value() == 0 || this.device_state.value() == 11) && (n = (vector = this.dev_attr.get_alarm_list()).size()) != 0) {
            this.read_attr_hardware(vector);
            for (int i = 0; i < n; ++i) {
                Attribute attribute = this.dev_attr.get_attr_by_ind((Integer)vector.elementAt(i));
                attribute.wanted_date(false);
                try {
                    this.read_attr(attribute);
                }
                catch (DevFailed devFailed) {
                    attribute.wanted_date(true);
                    throw devFailed;
                }
                attribute.wanted_date(true);
            }
            if (this.dev_attr.check_alarm()) {
                this.device_state = DevState.ALARM;
            }
        }
        return this.device_state;
    }

    public String dev_status() throws DevFailed {
        if (this.device_state.value() == 11 || this.device_state.value() == 0) {
            StringBuffer stringBuffer = new StringBuffer(this.device_status);
            this.dev_attr.read_alarm(stringBuffer);
            return stringBuffer.toString();
        }
        return this.device_status;
    }

    public void read_attr_hardware(Vector vector) throws DevFailed {
    }

    public void read_attr(Attribute attribute) throws DevFailed {
    }

    public void write_attr_hardware(Vector vector) throws DevFailed {
    }

    public void always_executed_hook() throws DevFailed {
    }

    public abstract void init_device() throws DevFailed;

    public abstract void delete_device() throws DevFailed;

    public POA _default_POA() {
        return Util.instance().get_poa();
    }

    public String get_status() {
        return this.device_status;
    }

    public void set_status(String string) {
        this.device_status = string;
    }

    public DevState get_state() {
        return this.device_state;
    }

    public void set_state(DevState devState) {
        this.device_state = devState;
    }

    public String get_name() {
        return this.device_name;
    }

    public DeviceClass get_device_class() {
        return this.device_class;
    }

    public void set_device_attr(MultiAttribute multiAttribute) {
        this.dev_attr = multiAttribute;
    }

    public DbDevice get_db_device() {
        return this.db_dev;
    }

    public byte[] get_obj_id() {
        return this.obj_id;
    }

    public void set_obj_id(byte[] byArray) {
        this.obj_id = byArray;
    }

    void set_exported_flag(boolean bl) {
        this.exported = bl;
    }

    boolean get_exported_flag() {
        return this.exported;
    }

    public Logger get_logger() {
        if (this.logger == null) {
            this.logger = Logger.getLogger(this.get_name().toLowerCase());
            this.logger.setAdditivity(false);
            this.logger.setLevel(Level.WARN);
            this.last_level = Level.WARN;
        }
        return this.logger;
    }

    public void init_logger() {
        try {
            Level level;
            Util.out4.println("Initializing logging for " + this.get_name());
            Util util = Util.instance();
            int n = util.get_trace_level();
            boolean bl = true;
            if (n <= 0) {
                bl = false;
                level = Level.OFF;
            } else {
                level = n <= 2 ? Level.INFO : Level.DEBUG;
            }
            if (bl) {
                try {
                    Logging.instance().add_logging_target(this.get_logger(), "console");
                }
                catch (DevFailed devFailed) {
                    // empty catch block
                }
            }
            if (!Util._UseDb) {
                Util.out4.println("Not using the database. Logging Intialization complete");
                return;
            }
            Logging.LoggingProperties loggingProperties = Logging.instance().get_logging_properties(this.get_logger(), util.get_database());
            if (loggingProperties == null) {
                Util.out4.println("Failed to obtain logging properties from database");
                Util.out4.println("Aborting logging intialization");
                this.get_logger().setLevel(level);
                return;
            }
            if (!bl) {
                this.get_logger().setLevel(loggingProperties.logging_level);
                Util.out4.println("Logging level set to " + loggingProperties.logging_level.toString());
            } else {
                this.get_logger().setLevel(level);
            }
            this.last_level = this.get_logger().getLevel();
            if (this.rft != loggingProperties.logging_rft) {
                this.rft = loggingProperties.logging_rft;
                Util.out4.println("Rolling threshold changed to " + String.valueOf(this.rft));
            }
            if (loggingProperties.logging_targets != null) {
                Util.out4.println("Adding logging targets (" + loggingProperties.logging_targets.length + " entries in db)");
                for (String string : loggingProperties.logging_targets) {
                    try {
                        Logging.instance().add_logging_target(this.get_logger(), string);
                    }
                    catch (DevFailed devFailed) {
                        // empty catch block
                    }
                }
            }
            Logging.instance().set_rolling_file_threshold(this.get_logger(), this.rft);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void stop_logging() {
        this.last_level = this.get_logger().getLevel();
        this.get_logger().setLevel(Level.OFF);
    }

    public void start_logging() {
        this.get_logger().setLevel(this.last_level);
    }

    void check_command_exists(String string) throws DevFailed {
        Vector vector = this.device_class.get_command_list();
        for (int i = 0; i < vector.size(); ++i) {
            Command command = (Command)vector.elementAt(i);
            if (!command.get_name().toLowerCase().equals(string)) continue;
            if (command.get_in_type() != 0) {
                Except.throw_exception("API_IncompatibleCmdArgumentType", "Command " + string + " cannot be polled because it needs input value", "DeviceImpl.check_command_exists");
            }
            return;
        }
        Except.throw_exception("API_CommandNotFound", "Command " + string + " not found", "DeviceImpl.check_command_exists");
    }

    int get_poll_old_factor() {
        return this.ext.poll_old_factor;
    }

    void set_poll_old_factor(int n) {
        this.ext.poll_old_factor = n;
    }

    boolean is_polled() {
        return this.ext.polled;
    }

    void is_polled(boolean bl) {
        this.ext.polled = bl;
    }

    Vector get_poll_obj_list() {
        return this.ext.poll_obj_list;
    }

    int get_poll_ring_depth() {
        return this.ext.poll_ring_depth;
    }

    public void set_poll_ring_depth(int n) {
        this.ext.poll_ring_depth = n;
    }

    MultiAttribute get_device_attr() {
        return this.dev_attr;
    }

    void set_non_auto_polled_cmd(String[] stringArray) {
        for (String string : stringArray) {
            this.ext.non_auto_polled_cmd.add(string);
        }
    }

    Vector get_non_auto_polled_cmd() {
        return this.ext.non_auto_polled_cmd;
    }

    void set_non_auto_polled_attr(String[] stringArray) {
        for (String string : stringArray) {
            this.ext.non_auto_polled_attr.add(string);
        }
    }

    Vector get_non_auto_polled_attr() {
        return this.ext.non_auto_polled_attr;
    }

    public void set_polled_cmd(String[] stringArray) {
        for (String string : stringArray) {
            this.ext.polled_cmd.add(string);
        }
    }

    Vector get_polled_cmd() {
        return this.ext.polled_cmd;
    }

    public void set_polled_attr(String[] stringArray) {
        for (String string : stringArray) {
            this.ext.polled_attr.add(string);
        }
    }

    Vector get_polled_attr() {
        return this.ext.polled_attr;
    }

    TangoMonitor get_dev_monitor() {
        return this.ext.only_one;
    }

    synchronized PollObj get_polled_obj_by_type_name(int n, String string) throws DevFailed {
        Vector vector = this.get_poll_obj_list();
        for (int i = 0; i < vector.size(); ++i) {
            PollObj pollObj = (PollObj)vector.elementAt(i);
            if (pollObj.get_type_i() != n || !pollObj.get_name_i().equals(string)) continue;
            return pollObj;
        }
        Except.throw_exception("API_PollObjNotFound", string + " not found in list of polled object", "DeviceImpl.get_polled_obj_by_type_name");
        return null;
    }

    Command get_command(String string) throws DevFailed {
        Command command = null;
        Vector vector = this.device_class.get_command_list();
        for (int i = 0; i < vector.size(); ++i) {
            Command command2 = (Command)vector.elementAt(i);
            if (!command2.get_name().toLowerCase().equals(string.toLowerCase())) continue;
            command = command2;
        }
        if (command == null) {
            Except.throw_exception("API_CommandNotFound", "Command " + string + " not found", "DeviceImpl.get_command");
        }
        return command;
    }

    class DeviceImplExt {
        boolean exported = false;
        boolean polled = false;
        int poll_ring_depth = 0;
        int poll_old_factor;
        Vector polled_cmd = new Vector();
        Vector polled_attr = new Vector();
        Vector non_auto_polled_cmd = new Vector();
        Vector non_auto_polled_attr = new Vector();
        Vector poll_obj_list = new Vector();
        TangoMonitor only_one = new TangoMonitor();

        DeviceImplExt() {
        }
    }
}

