/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoApi.events;

import fr.esrf.Tango.AttDataReady;
import fr.esrf.Tango.DevError;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.AttributeInfoEx;
import fr.esrf.TangoApi.CallBack;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.TangoApi.events.EventCallBackStruct;
import fr.esrf.TangoApi.events.EventData;
import fr.esrf.TangoApi.events.EventQueue;
import fr.esrf.TangoApi.events.ZMQutils;
import fr.esrf.TangoApi.events.ZmqEventConsumer;
import fr.esrf.TangoDs.Except;
import java.util.ArrayList;
import java.util.Hashtable;
import org.zeromq.ZMQ;

public class ZmqMainThread
extends Thread {
    private static final int ControlSock = 0;
    private static final int HearBeatSock = 1;
    private static final int EventSock = 2;
    private ZMQ.Socket controlSocket;
    private ZMQ.Socket heartbeatSocket;
    private ZMQ.Socket eventSocket;
    private ZMQ.Poller items;
    private boolean stop = false;
    private ArrayList<String> connected = new ArrayList();

    ZmqMainThread(ZMQ.Context context) {
        this.controlSocket = context.socket(4);
        this.heartbeatSocket = context.socket(2);
        this.eventSocket = context.socket(2);
        this.controlSocket.setLinger(0L);
        this.controlSocket.bind("inproc://control");
        this.heartbeatSocket.setLinger(0L);
        this.eventSocket.setLinger(0L);
        this.items = context.poller(3);
        this.items.register(this.controlSocket, 1);
        this.items.register(this.heartbeatSocket, 1);
        this.items.register(this.eventSocket, 1);
    }

    @Override
    public void run() {
        while (!this.stop) {
            this.items.poll();
            for (int i = 0; i < this.items.getSize(); ++i) {
                if (!this.items.pollin(i)) continue;
                this.manageInputBuffer(i);
            }
        }
        ApiUtil.printTrace("------------ End of ZmqMainThread ---------------");
    }

    private byte[][] readSocket(ZMQ.Socket socket, int n) {
        byte[][] byArrayArray = new byte[n][];
        for (int i = 0; i < n; ++i) {
            byArrayArray[i] = socket.recv(0);
        }
        return byArrayArray;
    }

    private void manageInputBuffer(int n) {
        switch (n) {
            case 0: {
                try {
                    byte[] byArray = this.controlSocket.recv(0);
                    this.manageControl(byArray);
                    this.controlSocket.send("".getBytes(), 0);
                }
                catch (DevFailed devFailed) {
                    this.controlSocket.send(devFailed.errors[0].desc.getBytes(), 0);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    this.controlSocket.send(exception.toString().getBytes(), 0);
                }
                break;
            }
            case 1: {
                try {
                    byte[][] byArray = this.readSocket(this.heartbeatSocket, 3);
                    this.manageHeartbeat(byArray);
                }
                catch (DevFailed devFailed) {
                    Except.print_exception(devFailed);
                }
                break;
            }
            case 2: {
                try {
                    byte[][] byArray = this.readSocket(this.eventSocket, 4);
                    this.manageEvent(byArray);
                    break;
                }
                catch (DevFailed devFailed) {
                    Except.print_exception(devFailed);
                }
            }
        }
    }

    private String getDeviceName(String string) {
        int n = string.lastIndexOf(46);
        return string.substring(0, n);
    }

    private String getEventName(byte[] byArray) {
        String string = new String(byArray);
        int n = string.lastIndexOf(46);
        for (int i = 0; i < 4; ++i) {
            n = string.lastIndexOf(47, n - 1);
        }
        return string.substring(n + 1);
    }

    private void manageEvent(byte[][] byArray) throws DevFailed {
        boolean bl = byArray[1][0] != 0;
        String string = this.getEventName(byArray[0]);
        String string2 = this.getDeviceName(string);
        int n = ZMQutils.getEventType(string);
        Hashtable<String, EventCallBackStruct> hashtable = ZmqEventConsumer.getEventCallbackMap();
        if (hashtable.containsKey(string)) {
            EventCallBackStruct eventCallBackStruct = hashtable.get(string);
            CallBack callBack = eventCallBackStruct.callback;
            DeviceAttribute deviceAttribute = null;
            AttributeInfoEx attributeInfoEx = null;
            AttDataReady attDataReady = null;
            DevError[] devErrorArray = null;
            switch (n) {
                case 5: {
                    attributeInfoEx = ZMQutils.deMarshallAttributeConfig(byArray[3], bl);
                    break;
                }
                case 6: {
                    attDataReady = ZMQutils.deMarshallAttDataReady(byArray[3], bl);
                    break;
                }
                default: {
                    deviceAttribute = ZMQutils.deMarshallAttribute(byArray[3], bl);
                }
            }
            EventData eventData = new EventData(eventCallBackStruct.device, string2, string, eventCallBackStruct.event_type, 0, deviceAttribute, attributeInfoEx, attDataReady, devErrorArray);
            if (eventCallBackStruct.use_ev_queue) {
                EventQueue eventQueue = eventCallBackStruct.device.getEventQueue();
                eventQueue.insert_event(eventData);
            } else if (callBack != null) {
                callBack.push_event(eventData);
            }
        } else {
            System.err.println(string + " ?  NOT FOUND");
        }
    }

    private void manageHeartbeat(byte[][] byArray) throws DevFailed {
        String string = new String(byArray[0]);
        ApiUtil.printTrace("Receive Heartbeat");
        int n = string.indexOf("dserver/");
        int n2 = string.lastIndexOf(46);
        string = string.substring(n, n2);
        ZmqEventConsumer.getInstance().push_structured_event_heartbeat(string);
    }

    void removeConnection(String string) {
        System.out.println("---------------> Removing " + string);
        this.connected.remove(string);
    }

    private boolean alreadyConnected(String string) {
        for (String string2 : this.connected) {
            if (!string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    private void manageControl(byte[] byArray) throws DevFailed {
        ZMQutils.ControlStructure controlStructure = ZMQutils.getInstance().decodeControlBuffer(byArray);
        ApiUtil.printTrace("From Control:\n" + controlStructure);
        switch (controlStructure.commandCode) {
            case 0: {
                this.stop = true;
                break;
            }
            case 1: {
                if (this.alreadyConnected(controlStructure.endPoint)) {
                    ApiUtil.printTrace("heartbeatSocket already connected to " + controlStructure.endPoint);
                } else {
                    ApiUtil.printTrace("Connect heartbeatSocket to " + controlStructure.endPoint);
                    this.heartbeatSocket.connect(controlStructure.endPoint);
                    this.connected.add(controlStructure.endPoint);
                }
                this.heartbeatSocket.subscribe(controlStructure.eventName.getBytes());
                break;
            }
            case 2: {
                this.heartbeatSocket.unsubscribe(controlStructure.eventName.getBytes());
                break;
            }
            case 3: {
                if (this.alreadyConnected(controlStructure.endPoint)) {
                    ApiUtil.printTrace("Event already connected to " + controlStructure.endPoint);
                } else {
                    this.eventSocket.setHWM((long)controlStructure.hwm);
                    this.eventSocket.connect(controlStructure.endPoint);
                    this.connected.add(controlStructure.endPoint);
                    ApiUtil.printTrace("Connect   eventSocket to " + controlStructure.endPoint);
                }
                this.eventSocket.subscribe(controlStructure.eventName.getBytes());
                ApiUtil.printTrace("subscribe eventSocket to " + controlStructure.eventName);
                break;
            }
            case 4: {
                this.eventSocket.unsubscribe(controlStructure.eventName.getBytes());
            }
        }
    }
}

