/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoApi.events;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.events.EventData;
import fr.esrf.TangoDs.Except;
import fr.esrf.TangoDs.TangoConst;
import java.util.ArrayList;

public class EventQueue {
    private int max_size = 1000000;
    private ArrayList<EventData> events = new ArrayList();

    public EventQueue() {
    }

    public EventQueue(int n) {
        this.max_size = n;
    }

    public synchronized boolean is_empty() {
        return this.events.size() == 0;
    }

    public synchronized int size(int n) {
        int n2 = 0;
        for (EventData eventData : this.events) {
            if (eventData.event_type != n) continue;
            ++n2;
        }
        return n2;
    }

    public synchronized int size() {
        return this.events.size();
    }

    public synchronized void insert_event(EventData eventData) {
        this.events.add(eventData);
        while (this.events.size() > this.max_size) {
            this.events.remove(0);
        }
    }

    public synchronized EventData getNextEvent() throws DevFailed {
        if (this.events.size() == 0) {
            Except.throw_exception("BUFFER_EMPTY", "Event queue is empty.", "EventQueue.getNextEvent()");
        }
        EventData eventData = this.events.get(0);
        this.events.remove(0);
        return eventData;
    }

    public synchronized EventData getNextEvent(int n) throws DevFailed {
        EventData eventData = null;
        for (EventData eventData2 : this.events) {
            if (eventData2.event_type != n) continue;
            eventData = eventData2;
        }
        if (eventData == null) {
            Except.throw_exception("BUFFER_EMPTY", "No " + TangoConst.eventNames[n] + " in event queue.", "EventQueue.getNextEvent()");
        }
        this.events.remove(eventData);
        return eventData;
    }

    public synchronized EventData[] getEvents() {
        EventData[] eventDataArray = new EventData[this.events.size()];
        for (int i = 0; i < this.events.size(); ++i) {
            eventDataArray[i] = this.events.get(i);
        }
        this.events.clear();
        return eventDataArray;
    }

    public synchronized EventData[] getEvents(int n) {
        ArrayList<EventData> arrayList = new ArrayList<EventData>();
        for (EventData eventData : this.events) {
            if (eventData.event_type != n) continue;
            arrayList.add(eventData);
        }
        EventData[] eventDataArray = new EventData[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            eventDataArray[i] = (EventData)arrayList.get(i);
            this.events.remove(arrayList.get(i));
        }
        return eventDataArray;
    }

    public synchronized long getLastEventDate() throws DevFailed {
        if (this.events.size() == 0) {
            Except.throw_exception("BUFFER_EMPTY", "Event queue is empty.", "EventQueu.getNextEvent()");
        }
        EventData eventData = this.events.get(this.events.size() - 1);
        return eventData.date;
    }
}

