/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoApi.events;

import fr.esrf.Tango.DevError;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.AttributeInfoEx;
import fr.esrf.TangoApi.CallBack;
import fr.esrf.TangoApi.Database;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoApi.events.EventCallBackStruct;
import fr.esrf.TangoApi.events.EventChannelStruct;
import fr.esrf.TangoApi.events.EventData;
import fr.esrf.TangoApi.events.EventQueue;
import fr.esrf.TangoApi.events.IEventConsumer;
import fr.esrf.TangoApi.events.NotifdEventConsumer;
import fr.esrf.TangoDs.Except;
import fr.esrf.TangoDs.TangoConst;
import java.util.Enumeration;
import java.util.Hashtable;
import org.omg.CosNotification.EventType;
import org.omg.CosNotifyComm.InvalidEventType;
import org.omg.CosNotifyComm.StructuredPushConsumerPOA;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EventConsumer
extends StructuredPushConsumerPOA
implements TangoConst,
Runnable,
IEventConsumer {
    protected static int subscribe_event_id = 0;
    protected static Hashtable<String, EventChannelStruct> channel_map = new Hashtable();
    protected static Hashtable<String, String> device_channel_map = new Hashtable();
    protected static Hashtable<String, EventCallBackStruct> event_callback_map = new Hashtable();
    protected static Hashtable<String, EventCallBackStruct> failed_event_callback_map = new Hashtable();

    protected abstract void checkDeviceConnection(DeviceProxy var1, String var2, DeviceData var3, String var4) throws DevFailed;

    protected abstract void connect_event_channel(ConnectionStructure var1) throws DevFailed;

    protected abstract boolean reSubscribe(EventChannelStruct var1, EventCallBackStruct var2);

    protected abstract void removeFilters(EventCallBackStruct var1) throws DevFailed;

    protected abstract String getEventSubscriptionCommandName();

    protected abstract void checkIfAlreadyConnected(DeviceProxy var1, String var2, String var3, CallBack var4, int var5, boolean var6) throws DevFailed;

    protected abstract void setAdditionalInfoToEventCallBackStruct(EventCallBackStruct var1, String var2, String var3, String var4, String[] var5, EventChannelStruct var6) throws DevFailed;

    protected abstract void unsubscribeTheEvent(EventCallBackStruct var1) throws DevFailed;

    protected abstract void checkIfHeartbeatSkipped(String var1, EventChannelStruct var2);

    protected EventConsumer() throws DevFailed {
    }

    static Hashtable<String, EventChannelStruct> getChannelMap() {
        return channel_map;
    }

    static Hashtable<String, EventCallBackStruct> getEventCallbackMap() {
        return event_callback_map;
    }

    @Override
    public void disconnect_structured_push_consumer() {
        System.out.println("calling EventConsumer.disconnect_structured_push_consumer()");
    }

    @Override
    public void offer_change(EventType[] eventTypeArray, EventType[] eventTypeArray2) throws InvalidEventType {
        System.out.println("calling EventConsumer.offer_change()");
    }

    protected void push_structured_event_heartbeat(String string) {
        try {
            if (channel_map.containsKey(string)) {
                EventChannelStruct eventChannelStruct = channel_map.get(string);
                eventChannelStruct.last_heartbeat = System.currentTimeMillis();
            } else {
                Enumeration<String> enumeration = channel_map.keys();
                boolean bl = false;
                while (enumeration.hasMoreElements() && !bl) {
                    String string2 = enumeration.nextElement();
                    EventChannelStruct eventChannelStruct = channel_map.get(string2);
                    if (!eventChannelStruct.adm_device_proxy.name().equals(string)) continue;
                    eventChannelStruct.last_heartbeat = System.currentTimeMillis();
                    bl = true;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void callEventSubscriptionAndConnect(DeviceProxy deviceProxy, String string, String string2) throws DevFailed {
        String string3 = deviceProxy.name();
        String[] stringArray = new String[]{string3, string, "subscribe", string2};
        DeviceData deviceData = new DeviceData();
        deviceData.insert(stringArray);
        DeviceData deviceData2 = deviceProxy.get_adm_dev().command_inout(this.getEventSubscriptionCommandName(), deviceData);
        this.checkDeviceConnection(deviceProxy, string, deviceData2, string2);
    }

    @Override
    public int subscribe_event(DeviceProxy deviceProxy, String string, int n, CallBack callBack, String[] stringArray, boolean bl) throws DevFailed {
        return this.subscribe_event(deviceProxy, string, n, callBack, -1, stringArray, bl);
    }

    @Override
    public int subscribe_event(DeviceProxy deviceProxy, String string, int n, int n2, String[] stringArray, boolean bl) throws DevFailed {
        return this.subscribe_event(deviceProxy, string, n, null, n2, stringArray, bl);
    }

    @Override
    public int subscribe_event(DeviceProxy deviceProxy, String string, int n, CallBack callBack, int n2, String[] stringArray, boolean bl) throws DevFailed {
        String string2 = eventNames[n];
        this.checkIfAlreadyConnected(deviceProxy, string, string2, callBack, n2, bl);
        if (callBack == null && n2 >= 0 && deviceProxy.getEventQueue() == null) {
            if (n2 > 0) {
                deviceProxy.setEventQueue(new EventQueue(n2));
            } else {
                deviceProxy.setEventQueue(new EventQueue());
            }
        }
        String string3 = deviceProxy.name();
        String string4 = string3.toLowerCase() + "/" + string + "." + string2;
        try {
            this.callEventSubscriptionAndConnect(deviceProxy, string.toLowerCase(), string2);
        }
        catch (DevFailed devFailed) {
            if (!bl || devFailed.errors[0].desc.equals("Command ZmqEventSubscriptionChange not found")) {
                throw devFailed;
            }
            EventCallBackStruct eventCallBackStruct = new EventCallBackStruct(deviceProxy, string, string2, "", callBack, n2, ++subscribe_event_id, n, stringArray, false);
            failed_event_callback_map.put(string4, eventCallBackStruct);
            return subscribe_event_id;
        }
        String string5 = device_channel_map.get(string3);
        EventChannelStruct eventChannelStruct = channel_map.get(string5);
        eventChannelStruct.last_subscribed = System.currentTimeMillis();
        EventCallBackStruct eventCallBackStruct = failed_event_callback_map.get(string4);
        int n3 = eventCallBackStruct == null ? ++subscribe_event_id : eventCallBackStruct.id;
        EventCallBackStruct eventCallBackStruct2 = new EventCallBackStruct(deviceProxy, string, string2, string5, callBack, n2, n3, n, stringArray, true);
        this.setAdditionalInfoToEventCallBackStruct(eventCallBackStruct2, string3, string, string2, stringArray, eventChannelStruct);
        event_callback_map.put(string4, eventCallBackStruct2);
        if (n == 0 || n == 2 || n == 1 || n == 3 || n == 4 || n == 5) {
            new PushAttrValueLater(eventCallBackStruct2).start();
        }
        return n3;
    }

    static void subscribe_if_not_done() {
        Enumeration<EventCallBackStruct> enumeration = failed_event_callback_map.elements();
        while (enumeration.hasMoreElements()) {
            EventCallBackStruct eventCallBackStruct = enumeration.nextElement();
            String string = eventCallBackStruct.device.name().toLowerCase() + "/" + eventCallBackStruct.attr_name + "." + eventCallBackStruct.event_name;
            if (eventCallBackStruct.consumer != null) {
                try {
                    eventCallBackStruct.consumer.subscribe_event(eventCallBackStruct.device, eventCallBackStruct.attr_name, eventCallBackStruct.event_type, eventCallBackStruct.callback, eventCallBackStruct.max_size, eventCallBackStruct.filters, false);
                    failed_event_callback_map.remove(string);
                }
                catch (DevFailed devFailed) {
                    int n = eventCallBackStruct.consumer instanceof NotifdEventConsumer ? 1 : 0;
                    EventData eventData = new EventData(eventCallBackStruct.device, string, eventCallBackStruct.event_name, n, eventCallBackStruct.event_type, null, null, null, devFailed.errors);
                    if (eventCallBackStruct.use_ev_queue) {
                        EventQueue eventQueue = eventCallBackStruct.device.getEventQueue();
                        eventQueue.insert_event(eventData);
                        continue;
                    }
                    eventCallBackStruct.callback.push_event(eventData);
                }
                continue;
            }
            System.err.println("====================================================");
            System.err.println("callback_struct.consumer=null  for " + string);
        }
    }

    static EventCallBackStruct getCallBackStruct(Hashtable hashtable, int n) {
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            EventCallBackStruct eventCallBackStruct = (EventCallBackStruct)hashtable.get(string);
            if (eventCallBackStruct.id != n) continue;
            return eventCallBackStruct;
        }
        return null;
    }

    private void removeCallBackStruct(Hashtable hashtable, EventCallBackStruct eventCallBackStruct) throws DevFailed {
        this.removeFilters(eventCallBackStruct);
        String string = eventCallBackStruct.device.name().toLowerCase() + "/" + eventCallBackStruct.attr_name + "." + eventCallBackStruct.event_name;
        hashtable.remove(string);
    }

    @Override
    public void unsubscribe_event(int n) throws DevFailed {
        EventCallBackStruct eventCallBackStruct = EventConsumer.getCallBackStruct(event_callback_map, n);
        if (eventCallBackStruct != null) {
            this.removeCallBackStruct(event_callback_map, eventCallBackStruct);
            this.unsubscribeTheEvent(eventCallBackStruct);
        } else {
            eventCallBackStruct = EventConsumer.getCallBackStruct(failed_event_callback_map, n);
            if (eventCallBackStruct != null) {
                this.removeCallBackStruct(failed_event_callback_map, eventCallBackStruct);
            } else {
                Except.throw_event_system_failed("API_EventNotFound", "Failed to unsubscribe event, the event id (" + n + ") specified does not correspond with any known one", "EventConsumer.unsubscribe_event()");
            }
        }
    }

    void reSubscribeByName(EventChannelStruct eventChannelStruct, String string) {
        Enumeration<EventCallBackStruct> enumeration = event_callback_map.elements();
        while (enumeration.hasMoreElements()) {
            EventCallBackStruct eventCallBackStruct = enumeration.nextElement();
            if (!eventCallBackStruct.channel_name.equals(string)) continue;
            this.reSubscribe(eventChannelStruct, eventCallBackStruct);
        }
    }

    void pushReceivedException(EventChannelStruct eventChannelStruct, EventCallBackStruct eventCallBackStruct, DevError devError) {
        try {
            if (eventChannelStruct != null) {
                if (eventChannelStruct.consumer instanceof NotifdEventConsumer && !eventCallBackStruct.filter_ok) {
                    eventCallBackStruct.filter_id = NotifdEventConsumer.getInstance().add_filter_for_channel(eventChannelStruct, eventCallBackStruct.filter_constraint);
                    eventCallBackStruct.filter_ok = true;
                }
            } else {
                return;
            }
            int n = eventChannelStruct.consumer instanceof NotifdEventConsumer ? 1 : 0;
            DevError[] devErrorArray = new DevError[]{devError};
            String string = eventCallBackStruct.device.name() + "/" + eventCallBackStruct.attr_name.toLowerCase();
            EventData eventData = new EventData(eventChannelStruct.adm_device_proxy, string, eventCallBackStruct.event_name, eventCallBackStruct.event_type, n, null, null, null, devErrorArray);
            CallBack callBack = eventCallBackStruct.callback;
            eventData.device = eventCallBackStruct.device;
            eventData.name = eventCallBackStruct.device.name();
            eventData.event = eventCallBackStruct.event_name;
            if (eventCallBackStruct.use_ev_queue) {
                EventQueue eventQueue = eventCallBackStruct.device.getEventQueue();
                eventQueue.insert_event(eventData);
            } else {
                callBack.push_event(eventData);
            }
        }
        catch (DevFailed devFailed) {
            // empty catch block
        }
    }

    void readAttributeAndPush(EventChannelStruct eventChannelStruct, EventCallBackStruct eventCallBackStruct) {
        boolean bl = false;
        for (int i = 0; !bl && i < eventNames.length; ++i) {
            bl = eventCallBackStruct.event_name.equals(eventNames[i]);
        }
        if (!bl) {
            return;
        }
        DeviceAttribute deviceAttribute = null;
        AttributeInfoEx attributeInfoEx = null;
        DevError[] devErrorArray = null;
        String string = eventCallBackStruct.device.name() + "/" + eventCallBackStruct.attr_name;
        boolean bl2 = eventCallBackStruct.device.get_transparency_reconnection();
        eventCallBackStruct.device.set_transparency_reconnection(true);
        try {
            if (eventCallBackStruct.event_name.equals(eventNames[5])) {
                attributeInfoEx = eventCallBackStruct.device.get_attribute_info_ex(eventCallBackStruct.attr_name);
            } else {
                deviceAttribute = eventCallBackStruct.device.read_attribute(eventCallBackStruct.attr_name);
            }
            ++eventChannelStruct.has_notifd_closed_the_connection;
        }
        catch (DevFailed devFailed) {
            devErrorArray = devFailed.errors;
        }
        eventCallBackStruct.device.set_transparency_reconnection(bl2);
        int n = eventChannelStruct.consumer instanceof NotifdEventConsumer ? 1 : 0;
        EventData eventData = new EventData(eventCallBackStruct.device, string, eventCallBackStruct.event_name, n, eventCallBackStruct.event_type, deviceAttribute, attributeInfoEx, null, devErrorArray);
        if (eventCallBackStruct.use_ev_queue) {
            EventQueue eventQueue = eventCallBackStruct.device.getEventQueue();
            eventQueue.insert_event(eventData);
        } else {
            eventCallBackStruct.callback.push_event(eventData);
        }
    }

    protected class ConnectionStructure {
        String channelName;
        String attributeName;
        String deviceName;
        String eventName;
        Database dbase;
        DeviceData deviceData = null;
        boolean reconnect = false;

        ConnectionStructure(String string, String string2, String string3, String string4, Database database, DeviceData deviceData, boolean bl) {
            this.channelName = string;
            this.deviceName = string2;
            this.attributeName = string3;
            this.eventName = string4;
            this.dbase = database;
            this.deviceData = deviceData;
            this.reconnect = bl;
        }

        ConnectionStructure(String string, Database database, boolean bl) {
            this(string, null, null, null, database, null, bl);
        }

        public String toString() {
            return "channel name: " + this.channelName + "\ndbase:        " + this.dbase + "\nreconnect:    " + this.reconnect;
        }
    }

    class PushAttrValueLater
    extends Thread {
        private EventCallBackStruct cb_struct;

        PushAttrValueLater(EventCallBackStruct eventCallBackStruct) {
            this.cb_struct = eventCallBackStruct;
        }

        public void run() {
            try {
                PushAttrValueLater.sleep(10L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            DeviceAttribute deviceAttribute = null;
            AttributeInfoEx attributeInfoEx = null;
            DevError[] devErrorArray = null;
            String string = this.cb_struct.device.name() + "/" + this.cb_struct.attr_name.toLowerCase();
            try {
                if (this.cb_struct.event_type == 5) {
                    attributeInfoEx = this.cb_struct.device.get_attribute_info_ex(this.cb_struct.attr_name);
                } else {
                    deviceAttribute = this.cb_struct.device.read_attribute(this.cb_struct.attr_name);
                }
            }
            catch (DevFailed devFailed) {
                devErrorArray = devFailed.errors;
            }
            int n = this.cb_struct.consumer instanceof NotifdEventConsumer ? 1 : 0;
            EventData eventData = new EventData(this.cb_struct.device, string, this.cb_struct.event_name, this.cb_struct.event_type, n, deviceAttribute, attributeInfoEx, null, devErrorArray);
            if (this.cb_struct.use_ev_queue) {
                EventQueue eventQueue = this.cb_struct.device.getEventQueue();
                eventQueue.insert_event(eventData);
            } else {
                this.cb_struct.callback.push_event(eventData);
            }
        }
    }
}

