/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoApi;

import fr.esrf.Tango.AttrQuality;
import fr.esrf.Tango.AttributeDim;
import fr.esrf.Tango.AttributeValue_3;
import fr.esrf.Tango.DevAttrHistory;
import fr.esrf.Tango.DevAttrHistory_3;
import fr.esrf.Tango.DevBooleanHelper;
import fr.esrf.Tango.DevCmdHistory;
import fr.esrf.Tango.DevDoubleHelper;
import fr.esrf.Tango.DevEncoded;
import fr.esrf.Tango.DevEncodedHelper;
import fr.esrf.Tango.DevError;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevFloatHelper;
import fr.esrf.Tango.DevLongHelper;
import fr.esrf.Tango.DevShortHelper;
import fr.esrf.Tango.DevState;
import fr.esrf.Tango.DevStateHelper;
import fr.esrf.Tango.DevStringHelper;
import fr.esrf.Tango.DevULongHelper;
import fr.esrf.Tango.DevUShortHelper;
import fr.esrf.Tango.DevVarBooleanArrayHelper;
import fr.esrf.Tango.DevVarCharArrayHelper;
import fr.esrf.Tango.DevVarDoubleArrayHelper;
import fr.esrf.Tango.DevVarDoubleStringArray;
import fr.esrf.Tango.DevVarDoubleStringArrayHelper;
import fr.esrf.Tango.DevVarEncodedArrayHelper;
import fr.esrf.Tango.DevVarFloatArrayHelper;
import fr.esrf.Tango.DevVarLong64ArrayHelper;
import fr.esrf.Tango.DevVarLongArrayHelper;
import fr.esrf.Tango.DevVarLongStringArray;
import fr.esrf.Tango.DevVarLongStringArrayHelper;
import fr.esrf.Tango.DevVarShortArrayHelper;
import fr.esrf.Tango.DevVarStateArrayHelper;
import fr.esrf.Tango.DevVarStringArrayHelper;
import fr.esrf.Tango.DevVarULong64ArrayHelper;
import fr.esrf.Tango.DevVarULongArrayHelper;
import fr.esrf.Tango.DevVarUShortArrayHelper;
import fr.esrf.Tango.TimeVal;
import fr.esrf.TangoApi.DeviceDataHistory;
import fr.esrf.TangoApi.IDeviceDataHistoryDAO;
import fr.esrf.TangoApi.WrongData;
import fr.esrf.TangoDs.Except;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.TypeCodePackage.BadKind;

public class DeviceDataHistoryDAODefaultImpl
implements IDeviceDataHistoryDAO {
    private Any any;
    private AttributeValue_3 attrval;
    private TimeVal tval;
    private int setType = -1;
    private boolean[] bool_data = null;
    private short[] short_data = null;
    private int[] int_data = null;
    private long[] long_data = null;
    private float[] float_data = null;
    private double[] double_data = null;
    private String[] string_data = null;
    private DevState[] state_data = null;
    private DevEncoded[] enc_data = null;
    private DevVarLongStringArray long_string_data = null;
    private DevVarDoubleStringArray double_string_data = null;

    public void init(DeviceDataHistory deviceDataHistory, String string, DevCmdHistory devCmdHistory) throws DevFailed {
        this.any = devCmdHistory.value;
        deviceDataHistory.source = 0;
        deviceDataHistory.name = string;
        this.tval = devCmdHistory.time;
        deviceDataHistory.failed = devCmdHistory.cmd_failed;
        deviceDataHistory.errors = devCmdHistory.errors;
    }

    public void init(DeviceDataHistory deviceDataHistory, DevAttrHistory devAttrHistory) throws DevFailed {
        this.any = devAttrHistory.value.value;
        deviceDataHistory.source = 1;
        this.attrval = new AttributeValue_3(this.any, devAttrHistory.value.quality, devAttrHistory.value.time, devAttrHistory.value.name, new AttributeDim(devAttrHistory.value.dim_x, devAttrHistory.value.dim_y), new AttributeDim(0, 0), devAttrHistory.errors);
        deviceDataHistory.name = devAttrHistory.value.name;
        this.tval = devAttrHistory.value.time;
        deviceDataHistory.failed = devAttrHistory.attr_failed;
        deviceDataHistory.errors = devAttrHistory.errors;
    }

    public void init(DeviceDataHistory deviceDataHistory, DevAttrHistory_3 devAttrHistory_3) throws DevFailed {
        this.any = devAttrHistory_3.value.value;
        deviceDataHistory.source = 1;
        this.attrval = devAttrHistory_3.value;
        deviceDataHistory.name = devAttrHistory_3.value.name;
        this.tval = devAttrHistory_3.value.time;
        deviceDataHistory.failed = devAttrHistory_3.attr_failed;
        deviceDataHistory.errors = devAttrHistory_3.value.err_list;
    }

    public void init(DeviceDataHistory deviceDataHistory, String string, int n, TimeVal timeVal) throws DevFailed {
        this.any = null;
        deviceDataHistory.source = n;
        this.attrval = new AttributeValue_3(null, null, timeVal, string, null, null, null);
        deviceDataHistory.name = string;
        this.tval = timeVal;
        deviceDataHistory.failed = false;
        deviceDataHistory.errors = null;
    }

    public void init(DeviceDataHistory deviceDataHistory, String string, int n, long l) throws DevFailed {
        this.any = null;
        deviceDataHistory.source = n;
        int n2 = (int)(l / 1000L);
        int n3 = (int)((l - (long)(1000 * n2)) * 1000L);
        TimeVal timeVal = new TimeVal(n2, n3, 0);
        this.attrval = new AttributeValue_3(null, null, timeVal, string, null, null, null);
        deviceDataHistory.name = string;
        this.tval = timeVal;
        deviceDataHistory.failed = false;
        deviceDataHistory.errors = null;
    }

    public void setTimeVal(DeviceDataHistory deviceDataHistory, TimeVal timeVal) {
        this.tval = timeVal;
    }

    public TimeVal getTimeVal(DeviceDataHistory deviceDataHistory) {
        return this.tval;
    }

    public long getTimeValSec(DeviceDataHistory deviceDataHistory) {
        return this.tval.tv_sec;
    }

    public long getTime(DeviceDataHistory deviceDataHistory) {
        return (long)this.tval.tv_sec * 1000L + (long)(this.tval.tv_usec / 1000);
    }

    public void setAttrQuality(DeviceDataHistory deviceDataHistory, AttrQuality attrQuality) throws DevFailed {
        this.attrval.quality = attrQuality;
    }

    public AttrQuality getAttrQuality(DeviceDataHistory deviceDataHistory) throws DevFailed {
        if (deviceDataHistory.source == 0) {
            Except.throw_non_supported_exception("TangoApi_NOT_AVAILABLE", "Method not avalaible for command", "DeviceDataHistory.getAttrQuality()");
        }
        return this.attrval.quality;
    }

    public void setDimX(DeviceDataHistory deviceDataHistory, int n) throws DevFailed {
        if (this.attrval.r_dim == null) {
            this.attrval.r_dim = new AttributeDim();
        }
        this.attrval.r_dim.dim_x = n;
        this.attrval.r_dim.dim_y = 1;
    }

    public void setDimY(DeviceDataHistory deviceDataHistory, int n) throws DevFailed {
        if (this.attrval.r_dim == null) {
            this.attrval.r_dim = new AttributeDim();
        }
        this.attrval.r_dim.dim_y = n == 0 ? 1 : n;
    }

    public int getDimX(DeviceDataHistory deviceDataHistory) throws DevFailed {
        if (deviceDataHistory.source == 0 && this.attrval.r_dim == null) {
            Except.throw_non_supported_exception("TangoApi_NOT_AVAILABLE", "Method not avalaible for command", "DeviceDataHistory.getDimX()");
        }
        return this.attrval.r_dim.dim_x;
    }

    public int getDimY(DeviceDataHistory deviceDataHistory) throws DevFailed {
        if (deviceDataHistory.source == 0 && this.attrval.r_dim == null) {
            Except.throw_non_supported_exception("TangoApi_NOT_AVAILABLE", "Method not avalaible for command", "DeviceDataHistory.getDimY()");
        }
        return this.attrval.r_dim.dim_y;
    }

    public boolean hasFailed(DeviceDataHistory deviceDataHistory) {
        return deviceDataHistory.failed;
    }

    public void setErrStack(DeviceDataHistory deviceDataHistory, DevError[] devErrorArray) {
        deviceDataHistory.failed = true;
        this.attrval.err_list = devErrorArray;
    }

    public DevError[] getErrStack(DeviceDataHistory deviceDataHistory) {
        return this.attrval.err_list;
    }

    public String getName(DeviceDataHistory deviceDataHistory) {
        return this.attrval.name;
    }

    private int DIM_MINI(int n) {
        return n == 0 ? 1 : n;
    }

    public int getNbRead(DeviceDataHistory deviceDataHistory) {
        return this.attrval.r_dim.dim_x * this.DIM_MINI(this.attrval.r_dim.dim_y);
    }

    public int getNbWritten(DeviceDataHistory deviceDataHistory) {
        return this.attrval.w_dim.dim_x * this.DIM_MINI(this.attrval.w_dim.dim_y);
    }

    public void setWrittenDimX(DeviceDataHistory deviceDataHistory, int n) {
        if (this.attrval.w_dim == null) {
            this.attrval.w_dim = new AttributeDim();
        }
        this.attrval.w_dim.dim_x = n;
        this.attrval.w_dim.dim_y = 1;
    }

    public void setWrittenDimY(DeviceDataHistory deviceDataHistory, int n) {
        if (this.attrval.w_dim == null) {
            this.attrval.w_dim = new AttributeDim();
        }
        this.attrval.w_dim.dim_y = n == 0 ? 1 : n;
    }

    public int getWrittenDimX(DeviceDataHistory deviceDataHistory) {
        return this.attrval.w_dim.dim_x;
    }

    public int getWrittenDimY(DeviceDataHistory deviceDataHistory) {
        return this.attrval.w_dim.dim_y;
    }

    private void manageExceptions(String string) throws DevFailed {
        if (this.attrval.err_list != null && this.attrval.err_list.length > 0) {
            throw new WrongData(this.attrval.err_list);
        }
        if (this.attrval.quality == AttrQuality.ATTR_INVALID) {
            Except.throw_wrong_data_exception("AttrQuality_ATTR_INVALID", "Attribute quality factor is INVALID", "DeviceAttributeHistory." + string + "()");
        }
    }

    public Any extractAny(DeviceDataHistory deviceDataHistory) throws DevFailed {
        return this.any;
    }

    public boolean extractBoolean(DeviceDataHistory deviceDataHistory) throws DevFailed {
        this.manageExceptions("extractBoolean()");
        if (this.bool_data != null) {
            return this.bool_data[0];
        }
        return DevBooleanHelper.extract(this.any);
    }

    public short extractUChar(DeviceDataHistory deviceDataHistory) throws DevFailed {
        this.manageExceptions("extractUChar()");
        if (this.short_data != null) {
            return this.short_data[0];
        }
        if (deviceDataHistory.source == 1) {
            return this.extractUCharArray(deviceDataHistory)[0];
        }
        return this.extractUChar(deviceDataHistory);
    }

    public short extractShort(DeviceDataHistory deviceDataHistory) throws DevFailed {
        this.manageExceptions("extractShort()");
        if (this.short_data != null) {
            return this.short_data[0];
        }
        if (deviceDataHistory.source == 1) {
            return this.extractShortArray(deviceDataHistory)[0];
        }
        return DevShortHelper.extract(this.any);
    }

    public short extractUShort(DeviceDataHistory deviceDataHistory) throws DevFailed {
        return DevUShortHelper.extract(this.any);
    }

    public int extractLong(DeviceDataHistory deviceDataHistory) throws DevFailed {
        this.manageExceptions("extractLong()");
        if (this.int_data != null) {
            return this.int_data[0];
        }
        if (deviceDataHistory.source == 1) {
            return this.extractLongArray(deviceDataHistory)[0];
        }
        return DevLongHelper.extract(this.any);
    }

    public int extractULong(DeviceDataHistory deviceDataHistory) throws DevFailed {
        this.manageExceptions("extractULong()");
        if (this.int_data != null) {
            return this.int_data[0];
        }
        if (deviceDataHistory.source == 1) {
            return this.extractULongArray(deviceDataHistory)[0];
        }
        return DevULongHelper.extract(this.any);
    }

    public long extractLong64(DeviceDataHistory deviceDataHistory) throws DevFailed {
        this.manageExceptions("extractLong64");
        if (this.long_data != null) {
            return this.long_data[0];
        }
        return this.extractLong64Array(deviceDataHistory)[0];
    }

    public long extractULong64(DeviceDataHistory deviceDataHistory) throws DevFailed {
        this.manageExceptions("extractULong64");
        if (this.long_data != null) {
            return this.long_data[0];
        }
        return this.extractULong64Array(deviceDataHistory)[0];
    }

    public float extractFloat(DeviceDataHistory deviceDataHistory) throws DevFailed {
        this.manageExceptions("extractFloat()");
        if (this.float_data != null) {
            return this.float_data[0];
        }
        if (deviceDataHistory.source == 1) {
            return this.extractFloatArray(deviceDataHistory)[0];
        }
        return DevFloatHelper.extract(this.any);
    }

    public double extractDouble(DeviceDataHistory deviceDataHistory) throws DevFailed {
        this.manageExceptions("extractDouble()");
        if (this.double_data != null) {
            return this.double_data[0];
        }
        if (deviceDataHistory.source == 1) {
            return this.extractDoubleArray(deviceDataHistory)[0];
        }
        return DevDoubleHelper.extract(this.any);
    }

    public String extractString(DeviceDataHistory deviceDataHistory) throws DevFailed {
        this.manageExceptions("extractString()");
        if (this.string_data != null) {
            return this.string_data[0];
        }
        if (deviceDataHistory.source == 1) {
            return this.extractStringArray(deviceDataHistory)[0];
        }
        return DevStringHelper.extract(this.any);
    }

    public DevState extractDevState(DeviceDataHistory deviceDataHistory) throws DevFailed {
        this.manageExceptions("extractDevState");
        if (this.state_data != null) {
            return this.state_data[0];
        }
        if (this.isArray()) {
            return deviceDataHistory.extractDevStateArray()[0];
        }
        return DevStateHelper.extract(this.attrval.value);
    }

    public DevEncoded extractDevEncoded(DeviceDataHistory deviceDataHistory) throws DevFailed {
        this.manageExceptions("extractDevEncoded");
        if (this.enc_data != null) {
            return this.enc_data[0];
        }
        if (deviceDataHistory.source == 1) {
            return this.extractDevEncodedArray(deviceDataHistory)[0];
        }
        return DevEncodedHelper.extract(this.any);
    }

    public boolean[] extractBooleanArray(DeviceDataHistory deviceDataHistory) throws DevFailed {
        this.manageExceptions("extractBooleanArray()");
        if (this.bool_data != null) {
            return this.bool_data;
        }
        return DevVarBooleanArrayHelper.extract(this.any);
    }

    public byte[] extractByteArray(DeviceDataHistory deviceDataHistory) throws DevFailed {
        this.manageExceptions("extractByteArray()");
        return DevVarCharArrayHelper.extract(this.any);
    }

    public short[] extractUCharArray(DeviceDataHistory deviceDataHistory) throws DevFailed {
        this.manageExceptions("extractUCharArray()");
        if (this.short_data != null) {
            return this.short_data;
        }
        byte[] byArray = DevVarCharArrayHelper.extract(this.any);
        short[] sArray = new short[byArray.length];
        int n = 255;
        for (int i = 0; i < byArray.length; ++i) {
            sArray[i] = (short)(n & byArray[i]);
        }
        return sArray;
    }

    public short[] extractShortArray(DeviceDataHistory deviceDataHistory) throws DevFailed {
        this.manageExceptions("extractShortArray()");
        if (this.short_data != null) {
            return this.short_data;
        }
        return DevVarShortArrayHelper.extract(this.any);
    }

    public short[] extractUShortArray(DeviceDataHistory deviceDataHistory) throws DevFailed {
        this.manageExceptions("extractUShortArray()");
        return DevVarUShortArrayHelper.extract(this.any);
    }

    public int[] extractLongArray(DeviceDataHistory deviceDataHistory) throws DevFailed {
        this.manageExceptions("extractLongArray()");
        if (this.int_data != null) {
            return this.int_data;
        }
        return DevVarLongArrayHelper.extract(this.any);
    }

    public int[] extractULongArray(DeviceDataHistory deviceDataHistory) throws DevFailed {
        this.manageExceptions("extractULongArray()");
        if (this.int_data != null) {
            return this.int_data;
        }
        return DevVarULongArrayHelper.extract(this.any);
    }

    public long[] extractLong64Array(DeviceDataHistory deviceDataHistory) throws DevFailed {
        this.manageExceptions("extractLong64Array()");
        if (this.long_data != null) {
            return this.long_data;
        }
        return DevVarLong64ArrayHelper.extract(this.any);
    }

    public long[] extractULong64Array(DeviceDataHistory deviceDataHistory) throws DevFailed {
        this.manageExceptions("extractULong64Array()");
        if (this.long_data != null) {
            return this.long_data;
        }
        return DevVarULong64ArrayHelper.extract(this.any);
    }

    public float[] extractFloatArray(DeviceDataHistory deviceDataHistory) throws DevFailed {
        this.manageExceptions("extractFloatArray()");
        if (this.float_data != null) {
            return this.float_data;
        }
        return DevVarFloatArrayHelper.extract(this.any);
    }

    public double[] extractDoubleArray(DeviceDataHistory deviceDataHistory) throws DevFailed {
        this.manageExceptions("extractDoubleArray()");
        if (this.double_data != null) {
            return this.double_data;
        }
        return DevVarDoubleArrayHelper.extract(this.any);
    }

    public String[] extractStringArray(DeviceDataHistory deviceDataHistory) throws DevFailed {
        this.manageExceptions("extractStringArray()");
        if (this.string_data != null) {
            return this.string_data;
        }
        return DevVarStringArrayHelper.extract(this.any);
    }

    public DevState[] extractDevStateArray(DeviceDataHistory deviceDataHistory) throws DevFailed {
        this.manageExceptions("extractDevStateArray()");
        if (this.state_data != null) {
            return this.state_data;
        }
        try {
            if (this.isArray()) {
                return DevVarStateArrayHelper.extract(this.any);
            }
            return new DevState[]{DevStateHelper.extract(this.any)};
        }
        catch (BAD_PARAM bAD_PARAM) {
            Except.throw_wrong_data_exception(bAD_PARAM.toString(), "Exception catched : " + bAD_PARAM.toString() + "\n" + "Maybe the attribute value has not been initialized", "DeviceAttribute.extractDevStateArray()");
            return new DevState[0];
        }
    }

    public DevEncoded[] extractDevEncodedArray(DeviceDataHistory deviceDataHistory) throws DevFailed {
        this.manageExceptions("extractDevEncodedArray()");
        if (this.enc_data != null) {
            return this.enc_data;
        }
        return DevVarEncodedArrayHelper.extract(this.any);
    }

    public DevVarLongStringArray extractLongStringArray(DeviceDataHistory deviceDataHistory) throws DevFailed {
        if (this.long_string_data != null) {
            return this.long_string_data;
        }
        return DevVarLongStringArrayHelper.extract(this.any);
    }

    public DevVarDoubleStringArray extractDoubleStringArray(DeviceDataHistory deviceDataHistory) throws DevFailed {
        if (this.double_string_data != null) {
            return this.double_string_data;
        }
        return DevVarDoubleStringArrayHelper.extract(this.any);
    }

    public TypeCode type(DeviceDataHistory deviceDataHistory) {
        return this.any.type();
    }

    private static boolean isArray(Any any) {
        boolean bl = true;
        try {
            TypeCode typeCode = any.type();
            TypeCode typeCode2 = typeCode.content_type();
            typeCode2.content_type();
        }
        catch (BadKind badKind) {
            bl = false;
        }
        return bl;
    }

    private boolean isArray() {
        return DeviceDataHistoryDAODefaultImpl.isArray(this.any);
    }

    public int getType(DeviceDataHistory deviceDataHistory) throws DevFailed {
        if (this.setType != -1) {
            return this.setType;
        }
        int n = -1;
        try {
            TypeCode typeCode = this.attrval.value.type();
            if (typeCode.kind().value() == 0) {
                return 0;
            }
            if (typeCode.kind().value() == 17) {
                return 19;
            }
            TypeCode typeCode2 = typeCode.content_type();
            TypeCode typeCode3 = typeCode2.content_type();
            TCKind tCKind = typeCode3.kind();
            switch (tCKind.value()) {
                case 1: {
                    n = 0;
                    break;
                }
                case 8: {
                    n = 1;
                    break;
                }
                case 9: {
                    n = 21;
                    break;
                }
                case 10: {
                    n = 22;
                    break;
                }
                case 2: {
                    n = 2;
                    break;
                }
                case 4: {
                    n = 6;
                    break;
                }
                case 3: {
                    n = 3;
                    break;
                }
                case 5: {
                    n = 7;
                    break;
                }
                case 6: {
                    n = 4;
                    break;
                }
                case 7: {
                    n = 5;
                    break;
                }
                case 18: {
                    n = 8;
                    break;
                }
                case 17: {
                    n = 19;
                    break;
                }
                case 15: {
                    n = 28;
                }
            }
        }
        catch (BadKind badKind) {
            Except.throw_wrong_data_exception("Api_TypeCodePackage.BadKind", "Bad or unknown type ", "DeviceDataHistory.getType()");
        }
        return n;
    }

    public int getDataLength(DeviceDataHistory deviceDataHistory) throws DevFailed {
        int n = deviceDataHistory.getDimX();
        int n2 = deviceDataHistory.getDimY();
        int n3 = n2 == 0 ? n : n * n2;
        if (deviceDataHistory.source == 1) {
            int n4 = deviceDataHistory.getWrittenDimX();
            int n5 = deviceDataHistory.getWrittenDimY();
            n3 = n5 == 0 ? (n3 += n4) : (n3 += n4 * n5);
        }
        return n3;
    }

    public int insert(DeviceDataHistory deviceDataHistory, boolean[] blArray, int n) throws DevFailed {
        if (deviceDataHistory.failed || deviceDataHistory.source == 1 && deviceDataHistory.getAttrQuality() == AttrQuality.ATTR_INVALID) {
            return n;
        }
        int n2 = deviceDataHistory.getDataLength();
        this.bool_data = new boolean[n2];
        for (int i = 0; i < n2; ++i) {
            this.bool_data[i] = blArray[n - n2 + i];
        }
        this.setType = 1;
        return n - n2;
    }

    public int insert(DeviceDataHistory deviceDataHistory, short[] sArray, int n) throws DevFailed {
        if (deviceDataHistory.failed || deviceDataHistory.source == 1 && deviceDataHistory.getAttrQuality() == AttrQuality.ATTR_INVALID) {
            return n;
        }
        int n2 = deviceDataHistory.getDataLength();
        this.short_data = new short[n2];
        for (int i = 0; i < n2; ++i) {
            this.short_data[i] = sArray[n - n2 + i];
        }
        this.setType = 2;
        if (deviceDataHistory.source == 0 && n2 > 1) {
            this.setType = 10;
        }
        return n - n2;
    }

    public int insert(DeviceDataHistory deviceDataHistory, int[] nArray, int n) throws DevFailed {
        if (deviceDataHistory.failed || deviceDataHistory.source == 1 && deviceDataHistory.getAttrQuality() == AttrQuality.ATTR_INVALID) {
            return n;
        }
        int n2 = deviceDataHistory.getDataLength();
        this.int_data = new int[n2];
        for (int i = 0; i < n2; ++i) {
            this.int_data[i] = nArray[n - n2 + i];
        }
        this.setType = 3;
        if (deviceDataHistory.source == 0 && n2 > 1) {
            this.setType = 11;
        }
        return n - n2;
    }

    public int insert(DeviceDataHistory deviceDataHistory, long[] lArray, int n) throws DevFailed {
        if (deviceDataHistory.failed || deviceDataHistory.source == 1 && deviceDataHistory.getAttrQuality() == AttrQuality.ATTR_INVALID) {
            return n;
        }
        int n2 = deviceDataHistory.getDataLength();
        this.long_data = new long[n2];
        for (int i = 0; i < n2; ++i) {
            this.long_data[i] = lArray[n - n2 + i];
        }
        this.setType = 23;
        if (deviceDataHistory.source == 0 && n2 > 1) {
            this.setType = 25;
        }
        return n - n2;
    }

    public int insert(DeviceDataHistory deviceDataHistory, float[] fArray, int n) throws DevFailed {
        if (deviceDataHistory.failed || deviceDataHistory.source == 1 && deviceDataHistory.getAttrQuality() == AttrQuality.ATTR_INVALID) {
            return n;
        }
        int n2 = deviceDataHistory.getDataLength();
        this.float_data = new float[n2];
        for (int i = 0; i < n2; ++i) {
            this.float_data[i] = fArray[n - n2 + i];
        }
        this.setType = 4;
        if (deviceDataHistory.source == 0 && n2 > 1) {
            this.setType = 12;
        }
        return n - n2;
    }

    public int insert(DeviceDataHistory deviceDataHistory, double[] dArray, int n) throws DevFailed {
        if (deviceDataHistory.failed || deviceDataHistory.source == 1 && deviceDataHistory.getAttrQuality() == AttrQuality.ATTR_INVALID) {
            return n;
        }
        int n2 = deviceDataHistory.getDataLength();
        this.double_data = new double[n2];
        for (int i = 0; i < n2; ++i) {
            this.double_data[i] = dArray[n - n2 + i];
        }
        this.setType = 5;
        if (deviceDataHistory.source == 0 && n2 > 1) {
            this.setType = 13;
        }
        return n - n2;
    }

    public int insert(DeviceDataHistory deviceDataHistory, String[] stringArray, int n) throws DevFailed {
        if (deviceDataHistory.failed || deviceDataHistory.source == 1 && deviceDataHistory.getAttrQuality() == AttrQuality.ATTR_INVALID) {
            return n;
        }
        int n2 = deviceDataHistory.getDataLength();
        this.string_data = new String[n2];
        for (int i = 0; i < n2; ++i) {
            this.string_data[i] = stringArray[n - n2 + i];
        }
        this.setType = 8;
        if (deviceDataHistory.source == 0 && n2 > 1) {
            this.setType = 16;
        }
        return n - n2;
    }

    public int insert(DeviceDataHistory deviceDataHistory, DevState[] devStateArray, int n) throws DevFailed {
        if (deviceDataHistory.failed || deviceDataHistory.source == 1 && deviceDataHistory.getAttrQuality() == AttrQuality.ATTR_INVALID) {
            return n;
        }
        int n2 = deviceDataHistory.getDataLength();
        this.state_data = new DevState[n2];
        for (int i = 0; i < n2; ++i) {
            this.state_data[i] = devStateArray[n - n2 + i];
        }
        this.setType = 19;
        return n - n2;
    }

    public int insert(DeviceDataHistory deviceDataHistory, DevEncoded[] devEncodedArray, int n) throws DevFailed {
        if (deviceDataHistory.failed || deviceDataHistory.source == 1 && deviceDataHistory.getAttrQuality() == AttrQuality.ATTR_INVALID) {
            return n;
        }
        int n2 = deviceDataHistory.getDataLength();
        this.enc_data = new DevEncoded[n2];
        for (int i = 0; i < n2; ++i) {
            this.enc_data[i] = devEncodedArray[n - n2 + i];
        }
        this.setType = 28;
        return n - n2;
    }

    public int[] insert(DeviceDataHistory deviceDataHistory, DevVarLongStringArray devVarLongStringArray, int[] nArray) throws DevFailed {
        int n;
        if (deviceDataHistory.failed || deviceDataHistory.source == 1 && deviceDataHistory.getAttrQuality() == AttrQuality.ATTR_INVALID) {
            return nArray;
        }
        int n2 = nArray[0];
        int n3 = nArray[1];
        int n4 = deviceDataHistory.getDimX();
        int n5 = deviceDataHistory.getDimY();
        this.long_string_data = new DevVarLongStringArray();
        this.long_string_data.svalue = new String[n4];
        this.long_string_data.lvalue = new int[n5];
        for (n = 0; n < n4; ++n) {
            this.long_string_data.svalue[n] = devVarLongStringArray.svalue[n2 - n4 + n];
        }
        for (n = 0; n < n5; ++n) {
            this.long_string_data.lvalue[n] = devVarLongStringArray.lvalue[n3 - n5 + n];
        }
        this.setType = 17;
        nArray[0] = n2 - n4;
        nArray[1] = n3 - n5;
        return nArray;
    }

    public int[] insert(DeviceDataHistory deviceDataHistory, DevVarDoubleStringArray devVarDoubleStringArray, int[] nArray) throws DevFailed {
        int n;
        if (deviceDataHistory.failed || deviceDataHistory.source == 1 && deviceDataHistory.getAttrQuality() == AttrQuality.ATTR_INVALID) {
            return nArray;
        }
        int n2 = nArray[0];
        int n3 = nArray[1];
        int n4 = deviceDataHistory.getDimX();
        int n5 = deviceDataHistory.getDimY();
        this.double_string_data = new DevVarDoubleStringArray();
        this.double_string_data.svalue = new String[n4];
        this.double_string_data.dvalue = new double[n5];
        for (n = 0; n < n4; ++n) {
            this.double_string_data.svalue[n] = devVarDoubleStringArray.svalue[n2 - n4 + n];
        }
        for (n = 0; n < n5; ++n) {
            this.double_string_data.dvalue[n] = devVarDoubleStringArray.dvalue[n3 - n5 + n];
        }
        this.setType = 18;
        nArray[0] = n2 - n4;
        nArray[1] = n3 - n5;
        return nArray;
    }

    public void insert(DeviceDataHistory deviceDataHistory, double[] dArray) throws DevFailed {
        if (deviceDataHistory.failed || deviceDataHistory.source == 1 && deviceDataHistory.getAttrQuality() == AttrQuality.ATTR_INVALID) {
            return;
        }
        deviceDataHistory.setDimX(dArray.length);
        deviceDataHistory.setDimY(1);
        deviceDataHistory.setWrittenDimX(0);
        deviceDataHistory.setWrittenDimY(0);
        this.double_data = dArray;
        this.setType = 5;
        if (deviceDataHistory.source == 0 && dArray.length > 1) {
            this.setType = 13;
        }
    }

    public void insert(DeviceDataHistory deviceDataHistory, String[] stringArray) throws DevFailed {
        if (deviceDataHistory.failed || deviceDataHistory.source == 1 && deviceDataHistory.getAttrQuality() == AttrQuality.ATTR_INVALID) {
            return;
        }
        deviceDataHistory.setDimX(stringArray.length);
        deviceDataHistory.setDimY(1);
        deviceDataHistory.setWrittenDimX(0);
        deviceDataHistory.setWrittenDimY(0);
        this.string_data = stringArray;
        this.setType = 8;
        if (deviceDataHistory.source == 0 && stringArray.length > 1) {
            this.setType = 16;
        }
    }
}

