/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoApi;

import fr.esrf.Tango.DevCmdInfo;
import fr.esrf.Tango.DevCmdInfo_2;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevInfo;
import fr.esrf.Tango.DevInfo_3;
import fr.esrf.Tango.DevSource;
import fr.esrf.Tango.Device;
import fr.esrf.Tango.DeviceHelper;
import fr.esrf.Tango.Device_2Helper;
import fr.esrf.Tango.Device_3Helper;
import fr.esrf.Tango.Device_4Helper;
import fr.esrf.TangoApi.ApiDefs;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.ApiUtilDAODefaultImpl;
import fr.esrf.TangoApi.CommandInfo;
import fr.esrf.TangoApi.Connection;
import fr.esrf.TangoApi.Database;
import fr.esrf.TangoApi.DbDevImportInfo;
import fr.esrf.TangoApi.DbRedundancy;
import fr.esrf.TangoApi.DevLockManager;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.IConnectionDAO;
import fr.esrf.TangoApi.TacoTangoDevice;
import fr.esrf.TangoApi.TangoUrl;
import fr.esrf.TangoDs.Except;
import org.jacorb.orb.policies.RelativeRoundtripTimeoutPolicy;
import org.omg.CORBA.Any;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Policy;
import org.omg.CORBA.SetOverrideType;
import org.omg.CORBA.SystemException;

public class ConnectionDAODefaultImpl
implements ApiDefs,
IConnectionDAO {
    public Device get_device(Connection connection) {
        return connection.device;
    }

    private String buildUrlName(String string, String string2) {
        return "tango://" + string + ":" + string2;
    }

    private String buildUrlName(String string, String string2, String string3) {
        return "tango://" + string + ":" + string2 + "/" + string3;
    }

    public void init(Connection connection) throws DevFailed {
        connection.url = new TangoUrl();
        connection.setDevice_is_dbase(true);
        connection.transparent_reconnection = true;
        ApiUtil.get_orb();
        this.connect_to_dbase(connection);
        connection.devname = connection.device.name();
        connection.setAlready_connected(true);
    }

    public void init(Connection connection, String string, String string2) throws DevFailed {
        connection.url = new TangoUrl(this.buildUrlName(string, string2));
        connection.setDevice_is_dbase(true);
        connection.transparent_reconnection = true;
        ApiUtil.get_orb();
        this.connect_to_dbase(connection);
        connection.devname = connection.device.name();
        connection.setAlready_connected(true);
    }

    public void init(Connection connection, String string, String string2, boolean bl) throws DevFailed {
        connection.url = new TangoUrl(this.buildUrlName(string, string2));
        connection.setDevice_is_dbase(true);
        connection.transparent_reconnection = bl;
        ApiUtil.get_orb();
        this.connect_to_dbase(connection);
        connection.devname = connection.device.name();
        connection.setAlready_connected(true);
    }

    public void init(Connection connection, String string) throws DevFailed {
        connection.url = new TangoUrl(string);
        connection.setDevice_is_dbase(false);
        connection.devname = connection.url.devname;
        if (connection.url.protocol == 0 && connection.url.use_db) {
            connection.ior = this.get_exported_ior(connection);
        }
    }

    public void init(Connection connection, DbDevImportInfo dbDevImportInfo) throws DevFailed {
        connection.url = new TangoUrl(dbDevImportInfo.name);
        connection.setDevice_is_dbase(false);
        connection.devname = connection.url.devname;
        if (connection.url.protocol == 0 && connection.url.use_db) {
            connection.ior = dbDevImportInfo.ior;
        }
        connection.classname = dbDevImportInfo.classname;
        try {
            this.initCtrlAccess(connection);
        }
        catch (DevFailed devFailed) {
            System.err.println(devFailed.errors[0].desc);
        }
    }

    public void init(Connection connection, String string, boolean bl) throws DevFailed {
        connection.url = new TangoUrl(string);
        connection.setDevice_is_dbase(false);
        connection.devname = connection.url.devname;
        connection.check_access = bl;
        if (connection.url.protocol == 0 && connection.url.use_db) {
            connection.ior = this.get_exported_ior(connection);
        }
    }

    public void init(Connection connection, String string, String string2, int n) throws DevFailed {
        connection.devname = string;
        connection.setDevice_is_dbase(false);
        if (n == 1) {
            connection.ior = string2;
            connection.url = new TangoUrl();
            connection.url.protocol = 0;
        } else {
            Except.throw_wrong_syntax_exception("TangoApi_INVALID_ARGS", "Invalid argument", "Connection.Connemction()");
        }
    }

    public void init(Connection connection, String string, String string2, String string3) throws DevFailed {
        connection.url = new TangoUrl(this.buildUrlName(string2, string3, string));
        connection.devname = connection.url.devname;
        connection.setDevice_is_dbase(false);
        if (connection.url.protocol == 0) {
            connection.ior = this.get_exported_ior(connection);
        }
    }

    public synchronized void build_connection(Connection connection) throws DevFailed {
        if (connection.device == null && connection.device_2 == null && connection.device_3 == null && connection.device_4 == null && connection.devname != null) {
            long l = System.currentTimeMillis();
            long l2 = l - connection.getPrev_failed_t0();
            boolean bl = true;
            if (connection.isDevice_is_dbase()) {
                this.connect_to_dbase(connection);
            } else {
                try {
                    if (connection.url.protocol == 0) {
                        if (connection.isPrev_failed() && l2 < (long)ApiUtil.getReconnectionDelay()) {
                            bl = false;
                            throw connection.getPrev_failed();
                        }
                        connection.setPrev_failed_t0(l);
                        if (connection.url.use_db) {
                            this.dev_import(connection);
                        } else {
                            this.dev_import_without_dbase(connection);
                        }
                        connection.setPrev_failed(null);
                    } else if (connection.url.protocol == 1 && connection.taco_device == null) {
                        connection.taco_device = new TacoTangoDevice(connection.devname, connection.url.host);
                    }
                }
                catch (DevFailed devFailed) {
                    if (bl) {
                        connection.setPrev_failed_t0(l);
                        connection.setPrev_failed(devFailed);
                    }
                    connection.ior = null;
                    Except.throw_communication_failed(devFailed, "TangoApi_CANNOT_IMPORT_DEVICE", "Cannot import " + connection.devname, "Connection.build_connection(" + connection.devname + ")");
                }
            }
        }
    }

    private void createDevice(Connection connection, String string) throws DevFailed {
        Object object;
        try {
            object = ApiUtil.get_orb();
            connection.setObj(((ORB)object).string_to_object(string));
        }
        catch (RuntimeException runtimeException) {
            Except.throw_connection_failed("TangoApi_TANGO_HOST_NOT_VALID", runtimeException.toString().substring(runtimeException.toString().indexOf(":") + 2), "Connection.createDevice()");
        }
        object = ApiUtil.getStrDefaultTimeout();
        if (object == null) {
            object = "3000";
        }
        try {
            connection.setDev_timeout(Integer.parseInt((String)object));
        }
        catch (Exception exception) {
            ApiUtilDAODefaultImpl.removePendingRepliesOfDevice(connection);
            exception.printStackTrace();
        }
        this.set_obj_timeout(connection, connection.getDev_timeout());
        if (connection.getObj()._is_a("IDL:Tango/Device_4:1.0")) {
            connection.device_4 = Device_4Helper.narrow(connection.getObj());
            connection.device_3 = connection.device_4;
            connection.device_2 = connection.device_4;
            connection.device = connection.device_4;
            connection.idl_version = 4;
        } else if (connection.getObj()._is_a("IDL:Tango/Device_3:1.0")) {
            connection.device_4 = null;
            connection.device_3 = Device_3Helper.narrow(connection.getObj());
            connection.device_2 = connection.device_3;
            connection.device = connection.device_3;
            connection.idl_version = 3;
        } else if (connection.getObj()._is_a("IDL:Tango/Device_2:1.0")) {
            connection.device_4 = null;
            connection.device_3 = null;
            connection.device_2 = Device_2Helper.narrow(connection.getObj());
            connection.device = connection.device_2;
            connection.idl_version = 2;
        } else if (connection.getObj()._is_a("IDL:Tango/Device:1.0")) {
            connection.device_4 = null;
            connection.device_3 = null;
            connection.device_2 = null;
            connection.device = DeviceHelper.narrow(connection.getObj());
            connection.idl_version = 1;
        } else {
            System.out.println("TangoApi_DEVICE_IDL_UNKNOWN!");
            Except.throw_non_supported_exception("TangoApi_DEVICE_IDL_UNKNOWN", connection.devname + " has an IDL revision not supported !", "Connection.createDevice(" + connection.devname + ")");
        }
        connection.getObj()._is_a("Dummy");
    }

    public String get_ior(Connection connection) throws DevFailed {
        Database database = connection.url.host == null ? ApiUtil.get_db_obj() : ApiUtil.get_db_obj(connection.url.host, connection.url.strport);
        DbDevImportInfo dbDevImportInfo = database.import_device(connection.devname);
        return dbDevImportInfo.ior;
    }

    public String get_host_name(Connection connection) throws DevFailed {
        Database database = connection.url.host == null ? ApiUtil.get_db_obj() : ApiUtil.get_db_obj(connection.url.host, connection.url.strport);
        DbDevImportInfo dbDevImportInfo = database.import_device(connection.devname);
        return dbDevImportInfo.hostname;
    }

    public String get_server_name(Connection connection) throws DevFailed {
        Database database = connection.url.host == null ? ApiUtil.get_db_obj() : ApiUtil.get_db_obj(connection.url.host, connection.url.strport);
        DbDevImportInfo dbDevImportInfo = database.import_device(connection.devname);
        return dbDevImportInfo.server;
    }

    public String get_class_name(Connection connection) throws DevFailed {
        Database database = connection.url.host == null ? ApiUtil.get_db_obj() : ApiUtil.get_db_obj(connection.url.host, connection.url.strport);
        if (connection.classname == null) {
            DbDevImportInfo dbDevImportInfo = database.import_device(connection.devname);
            connection.classname = dbDevImportInfo.classname;
        }
        return connection.classname;
    }

    private void initCtrlAccess(Connection connection) throws DevFailed {
        connection.access = connection.url.use_db && connection.check_access && !connection.check_access_done ? ApiUtil.get_db_obj(connection.url.host, connection.url.strport).checkAccessControl(connection.devname, connection.url) : 1;
        connection.check_access_done = true;
    }

    private String get_exported_ior(Connection connection) throws DevFailed {
        Database database = connection.url.host == null ? ApiUtil.get_db_obj() : ApiUtil.get_db_obj(connection.url.host, connection.url.strport);
        DbDevImportInfo dbDevImportInfo = database.import_device(connection.devname);
        String string = null;
        if (dbDevImportInfo.exported) {
            string = dbDevImportInfo.ior;
        }
        if (dbDevImportInfo.is_taco) {
            connection.url.protocol = 1;
        } else {
            try {
                this.initCtrlAccess(connection);
            }
            catch (DevFailed devFailed) {
                System.err.println(devFailed.errors[0].desc);
            }
        }
        return string;
    }

    public void dev_import(Connection connection) throws DevFailed {
        Database database = connection.url.host == null ? ApiUtil.get_db_obj() : ApiUtil.get_db_obj(connection.url.host, connection.url.strport);
        String string = null;
        boolean bl = false;
        if (connection.ior == null) {
            DbDevImportInfo dbDevImportInfo = database.import_device(connection.devname);
            if (dbDevImportInfo.exported) {
                string = dbDevImportInfo.ior;
                bl = true;
            } else {
                Except.throw_connection_failed("TangoApi_DEVICE_NOT_EXPORTED", connection.devname + " Not Exported !", "Connection(" + connection.devname + ")");
            }
        } else {
            string = connection.ior;
        }
        try {
            try {
                this.createDevice(connection, string);
            }
            catch (Exception exception) {
                if (bl || connection.isAlready_connected()) {
                    throw exception;
                }
                if (exception.toString().startsWith("org.omg.CORBA.TRANSIENT")) {
                    throw exception;
                }
                connection.ior = null;
                this.dev_import(connection);
            }
            connection.setAlready_connected(true);
            connection.ior = string;
        }
        catch (DevFailed devFailed) {
            connection.device = null;
            connection.device_2 = null;
            connection.device_3 = null;
            connection.device_4 = null;
            connection.ior = null;
            throw devFailed;
        }
        catch (Exception exception) {
            connection.device = null;
            connection.device_2 = null;
            connection.device_3 = null;
            connection.device_4 = null;
            connection.ior = null;
            String string2 = connection.isAlready_connected() ? "Re-" : "";
            String string3 = "Cannot " + string2 + "import " + connection.devname + " :\n\t" + exception.toString();
            String string4 = "Connection.dev_import(" + connection.devname + ")";
            Except.throw_connection_failed("TangoApi_CANNOT_IMPORT_DEVICE", string3, string4);
        }
    }

    private void connect_to_dbase(Connection connection) throws DevFailed {
        if (connection.device == null) {
            try {
                String string = "corbaloc:iiop:" + connection.url.host + ":" + connection.url.strport + "/database";
                this.createDevice(connection, string);
                connection.classname = "Database";
            }
            catch (SystemException systemException) {
                if (connection.transparent_reconnection) {
                    try {
                        DbRedundancy dbRedundancy = DbRedundancy.get_instance();
                        String string = dbRedundancy.get(connection.url.host + ":" + connection.url.port);
                        String string2 = "corbaloc:iiop:" + string + "/database";
                        this.createDevice(connection, string2);
                    }
                    catch (SystemException systemException2) {
                        connection.device = null;
                        connection.ior = null;
                        Except.throw_connection_failed("TangoApi_DATABASE_CONNECTION_FAILED", "Connection to database failed  !\n" + systemException2, "connect_to_dbase(" + connection.url.host + "," + connection.url.strport + ")");
                    }
                }
                connection.device = null;
                connection.ior = null;
                Except.throw_connection_failed("TangoApi_DATABASE_CONNECTION_FAILED", "Connection to database failed  !\n" + systemException, "connect_to_dbase(" + connection.url.host + "," + connection.url.strport + ")");
            }
        }
    }

    private void dev_import_without_dbase(Connection connection) throws DevFailed {
        if (connection.device == null) {
            try {
                String string = "corbaloc:iiop:" + connection.url.host + ":" + connection.url.strport + "/" + connection.devname.toLowerCase();
                this.createDevice(connection, string);
                connection.access = 1;
            }
            catch (SystemException systemException) {
                connection.device = null;
                connection.ior = null;
                Except.throw_connection_failed("TangoApi_DEVICE_CONNECTION_FAILED", "Connection to device without database failed  !\n" + systemException, "Connection.dev_import_without_dbase(" + connection.url.host + "," + connection.url.strport + ")");
            }
        }
    }

    private void set_obj_timeout(Connection connection, int n) {
        RelativeRoundtripTimeoutPolicy relativeRoundtripTimeoutPolicy = new RelativeRoundtripTimeoutPolicy(10000 * n);
        connection.getObj()._set_policy_override(new Policy[]{relativeRoundtripTimeoutPolicy}, SetOverrideType.ADD_OVERRIDE);
        connection.setDev_timeout(n);
    }

    public void set_timeout_millis(Connection connection, int n) throws DevFailed {
        this.build_connection(connection);
        if (connection.url.protocol == 1) {
            connection.taco_device.set_rpc_timeout(n);
            return;
        }
        this.set_obj_timeout(connection, n);
    }

    @Deprecated
    public int get_timeout(Connection connection) {
        return connection.getDev_timeout();
    }

    public int get_timeout_millis(Connection connection) throws DevFailed {
        this.build_connection(connection);
        if (connection.url.protocol == 1) {
            return connection.taco_device.get_rpc_timeout();
        }
        return connection.getDev_timeout();
    }

    public void throw_dev_failed(Connection connection, Exception exception, String string, boolean bl) throws DevFailed {
        String string2;
        if (exception instanceof DevFailed) {
            throw (DevFailed)exception;
        }
        String string3 = string2 = bl ? connection.devname + ".command_inout(" + string + ")" : connection.devname + "." + string + ")";
        if (exception.toString().contains("org.omg.CORBA.NO_RESPONSE") || exception.toString().contains("org.omg.CORBA.TIMEOUT") || exception.toString().contains("org.omg.CORBA.IMP_LIMIT")) {
            String string4 = "Device (" + connection.devname + ") timed out (>" + connection.getDev_timeout() + " ms)!";
            Except.throw_communication_timeout(exception.toString(), string4, string2);
        } else if (exception.toString().contains("org.omg.CORBA.BAD_INV_ORDER")) {
            String string5 = "Lost Connection during command : " + string;
            connection.device = null;
            connection.device_2 = null;
            connection.device_3 = null;
            connection.device_4 = null;
            connection.ior = null;
            Except.throw_connection_failed(exception.toString(), string5, string2);
        } else if (exception.toString().contains("org.omg.CORBA.TRANSIENT") || exception.toString().contains("org.omg.CORBA.UNKNOWN") || exception.toString().contains("org.omg.CORBA.COMM_FAILURE") || exception.toString().contains("org.omg.CORBA.OBJECT_NOT_EXIST")) {
            String string6 = "Lost Connection during command : " + string;
            connection.device = null;
            connection.device_2 = null;
            connection.device_3 = null;
            connection.device_4 = null;
            connection.ior = null;
            Except.throw_connection_failed(exception.toString(), string6, string2);
        } else if (exception.toString().startsWith("java.lang.RuntimeException")) {
            String string7 = "API has catched a RuntimeException" + string;
            connection.device = null;
            connection.device_2 = null;
            connection.device_3 = null;
            connection.device_4 = null;
            connection.ior = null;
            Except.throw_connection_failed(exception.toString(), string7, string2);
        } else {
            System.out.println("API has catched an exception for " + string2 + " : \n" + exception);
            String string8 = exception.getMessage();
            Except.throw_communication_failed(exception.toString(), string8, string2);
        }
    }

    protected void throwNotAuthorizedException(String string, String string2) throws DevFailed {
        Except.throw_connection_failed("TangoApi_READ_ONLY_MODE", string + "   is not authorized for:\n" + ApiUtilDAODefaultImpl.getUser() + "  on   " + ApiUtil.getHostName(), string2);
    }

    public DeviceData command_inout(Connection connection, String string, DeviceData deviceData) throws DevFailed {
        Database database;
        Any any = null;
        this.build_connection(connection);
        if (connection.url.protocol == 1) {
            return connection.taco_device.command_inout(string, deviceData);
        }
        if (connection.access == 0 && !(database = ApiUtil.get_db_obj(connection.url.host, connection.url.strport)).isCommandAllowed(connection.get_class_name(), string)) {
            if (database.access_devfailed != null) {
                throw database.access_devfailed;
            }
            this.ping(connection);
            System.out.println(connection.devname + "." + string + "  -> TangoApi_READ_ONLY_MODE");
            this.throwNotAuthorizedException(connection.devname + ".command_inout(" + string + ")", "Connection.command_inout()");
        }
        boolean bl = false;
        int n = connection.transparent_reconnection ? 2 : 1;
        for (int i = 0; i < n && !bl; ++i) {
            try {
                any = connection.device_4 != null ? connection.device_4.command_inout_4(string, deviceData.extractAny(), connection.dev_src, DevLockManager.getInstance().getClntIdent()) : (connection.device_2 != null ? connection.device_2.command_inout_2(string, deviceData.extractAny(), connection.dev_src) : connection.device.command_inout(string, deviceData.extractAny()));
                bl = true;
                continue;
            }
            catch (DevFailed devFailed) {
                String string2 = "Cannot execute command " + string + " on " + connection.devname;
                if (devFailed.errors[0].reason.equals("DB_DeviceNotDefined")) {
                    String string3 = devFailed.errors[0].desc;
                    int n2 = string3.lastIndexOf("!");
                    if (n2 > 0) {
                        string3 = string3.substring(0, n2);
                    }
                    devFailed.errors[0].desc = string3 = string3 + "  " + connection.url.host + ":" + connection.url.port + " !";
                }
                Except.throw_connection_failed(devFailed, "TangoApi_CANNOT_EXECUTE_COMMAND", string2, "Connection.command_inout()");
                continue;
            }
            catch (Exception exception) {
                this.manageExceptionReconnection(connection, n, i, exception, this.getClass() + ".command_inout");
            }
        }
        return new DeviceData(any);
    }

    public DeviceData command_inout(Connection connection, String string) throws DevFailed {
        DeviceData deviceData = new DeviceData();
        return this.command_inout(connection, string, deviceData);
    }

    public long ping(Connection connection) throws DevFailed {
        long l = 0L;
        int n = connection.transparent_reconnection ? 1 : 0;
        int n2 = 0;
        boolean bl = false;
        do {
            try {
                l = this.doPing(connection);
            }
            catch (DevFailed devFailed) {
                if (n2 >= n) {
                    throw devFailed;
                }
                bl = true;
                ++n2;
            }
        } while (bl);
        return l;
    }

    private long doPing(Connection connection) throws DevFailed {
        this.checkIfTango(connection, "ping");
        this.build_connection(connection);
        long l = System.currentTimeMillis();
        try {
            connection.device.ping();
        }
        catch (DevFailed devFailed) {
            String string = "Cannot ping " + connection.devname;
            Except.throw_connection_failed(devFailed, "TangoApi_CANNOT_PING_DEVICE", string, "Connection.ping()");
        }
        catch (Exception exception) {
            ApiUtilDAODefaultImpl.removePendingRepliesOfDevice(connection);
            this.throw_dev_failed(connection, exception, "ping", false);
        }
        long l2 = System.currentTimeMillis();
        return (int)(l2 - l) * 1000;
    }

    public String[] black_box(Connection connection, int n) throws DevFailed {
        this.checkIfTango(connection, "black_box");
        this.build_connection(connection);
        String[] stringArray = new String[]{};
        try {
            stringArray = connection.device.black_box(n);
        }
        catch (DevFailed devFailed) {
            String string = "Cannot read black box on " + connection.devname;
            Except.throw_connection_failed(devFailed, "TangoApi_CANNOT_READ_BLACK BOX", string, "Connection.black_box()");
        }
        catch (Exception exception) {
            ApiUtilDAODefaultImpl.removePendingRepliesOfDevice(connection);
            this.throw_dev_failed(connection, exception, "black_box", false);
        }
        return stringArray;
    }

    public DevInfo_3 info_3(Connection connection) throws DevFailed {
        this.checkIfTango(connection, "info");
        this.build_connection(connection);
        try {
            DevInfo_3 devInfo_3;
            if (connection.device_3 != null) {
                devInfo_3 = connection.device_3.info_3();
            } else {
                DevInfo devInfo = connection.device.info();
                devInfo_3 = new DevInfo_3(devInfo.dev_class, devInfo.server_id, devInfo.server_host, devInfo.server_version, devInfo.doc_url, "");
            }
            return devInfo_3;
        }
        catch (DevFailed devFailed) {
            String string = "Cannot read device info on " + connection.devname;
            Except.throw_connection_failed(devFailed, "TangoApi_CANNOT_READ _DEVICE_INFO", string, "Connection.info()");
        }
        catch (Exception exception) {
            ApiUtilDAODefaultImpl.removePendingRepliesOfDevice(connection);
            this.throw_dev_failed(connection, exception, "info", false);
        }
        return null;
    }

    public DevInfo info(Connection connection) throws DevFailed {
        this.checkIfTango(connection, "info");
        this.build_connection(connection);
        DevInfo devInfo = null;
        try {
            devInfo = connection.device.info();
        }
        catch (DevFailed devFailed) {
            String string = "Cannot read device info on " + connection.devname;
            Except.throw_connection_failed(devFailed, "TangoApi_CANNOT_READ _DEVICE_INFO", string, "Connection.info()");
        }
        catch (Exception exception) {
            ApiUtilDAODefaultImpl.removePendingRepliesOfDevice(connection);
            this.throw_dev_failed(connection, exception, "info", false);
        }
        return devInfo;
    }

    public CommandInfo[] command_list_query(Connection connection) throws DevFailed {
        this.build_connection(connection);
        try {
            CommandInfo[] commandInfoArray;
            if (connection.url.protocol == 1) {
                commandInfoArray = connection.taco_device.commandListQuery();
            } else if (connection.device_2 != null) {
                DevCmdInfo_2[] devCmdInfo_2Array = connection.device_2.command_list_query_2();
                commandInfoArray = new CommandInfo[devCmdInfo_2Array.length];
                for (int i = 0; i < devCmdInfo_2Array.length; ++i) {
                    commandInfoArray[i] = new CommandInfo(devCmdInfo_2Array[i]);
                }
            } else {
                DevCmdInfo[] devCmdInfoArray = connection.device.command_list_query();
                commandInfoArray = new CommandInfo[devCmdInfoArray.length];
                for (int i = 0; i < devCmdInfoArray.length; ++i) {
                    commandInfoArray[i] = new CommandInfo(devCmdInfoArray[i]);
                }
            }
            return commandInfoArray;
        }
        catch (DevFailed devFailed) {
            String string = "Cannot read command list for " + connection.devname;
            Except.throw_connection_failed(devFailed, "TangoApi_CANNOT__READ_CMD_LIST", string, "Connection.command_list_query()");
        }
        catch (Exception exception) {
            ApiUtilDAODefaultImpl.removePendingRepliesOfDevice(connection);
            this.throw_dev_failed(connection, exception, "command_list_query", false);
        }
        return null;
    }

    public int get_idl_version(Connection connection) throws DevFailed {
        this.build_connection(connection);
        return connection.idl_version;
    }

    public DevSource get_source(Connection connection) throws DevFailed {
        if (this.is_taco(connection)) {
            if (connection.taco_device == null) {
                connection.taco_device = new TacoTangoDevice(connection.devname, connection.url.host);
            }
            return connection.taco_device.get_source();
        }
        return connection.dev_src;
    }

    public void set_source(Connection connection, DevSource devSource) throws DevFailed {
        if (this.is_taco(connection)) {
            if (connection.taco_device == null) {
                connection.taco_device = new TacoTangoDevice(connection.devname, connection.url.host);
            }
            connection.taco_device.set_source(devSource);
        } else {
            connection.dev_src = devSource;
        }
    }

    public String get_name(Connection connection) {
        return connection.devname;
    }

    public String description(Connection connection) throws DevFailed {
        this.build_connection(connection);
        return connection.device.description();
    }

    public String adm_name(Connection connection) throws DevFailed {
        this.checkIfTango(connection, "adm_name");
        this.build_connection(connection);
        String string = null;
        try {
            string = connection.device.adm_name();
        }
        catch (Exception exception) {
            ApiUtilDAODefaultImpl.removePendingRepliesOfDevice(connection);
            this.throw_dev_failed(connection, exception, "adm_name", false);
        }
        if (!connection.url.use_db) {
            string = "tango://" + connection.url.host + ":" + connection.url.port + "/" + string + "#dbase=no";
        }
        return string;
    }

    public String get_tango_host(Connection connection) throws DevFailed {
        this.checkIfTango(connection, "get_tango_host");
        return connection.url.host + ":" + connection.url.strport;
    }

    public boolean is_taco(Connection connection) {
        return connection.url.protocol == 1;
    }

    public void checkIfTaco(Connection connection, String string) throws DevFailed {
        if (!this.is_taco(connection)) {
            Except.throw_non_supported_exception("TangoApi_NOT_TANGO_CMD", string + " is NOT a TANGO command.", string + "()");
        }
    }

    public void checkIfTango(Connection connection, String string) throws DevFailed {
        if (this.is_taco(connection)) {
            Except.throw_non_supported_exception("TangoApi_NOT_TACO_CMD", string + " is NOT a TACO command.", string + "()");
        }
    }

    public boolean get_transparency_reconnection(Connection connection) {
        return connection.transparent_reconnection;
    }

    public void set_transparency_reconnection(Connection connection, boolean bl) {
        connection.transparent_reconnection = bl;
    }

    public int getAccessControl(Connection connection) {
        return connection.access;
    }

    public void setAccessControl(Connection connection, int n) {
        connection.access = n;
    }

    public boolean isAllowedCommand(Connection connection, String string) throws DevFailed {
        Database database = ApiUtil.get_db_obj(connection.url.host, connection.url.strport);
        return database.isCommandAllowed(connection.get_class_name(), string);
    }

    protected void manageExceptionReconnection(Connection connection, int n, int n2, Exception exception, String string) throws DevFailed {
        ApiUtilDAODefaultImpl.removePendingRepliesOfDevice(connection);
        if (n2 == 0 && (exception.toString().contains("org.omg.CORBA.TRANSIENT") || exception.toString().contains("org.omg.CORBA.OBJECT_NOT_EXIST") || exception.toString().contains("org.omg.CORBA.COMM_FAILURE"))) {
            connection.device = null;
            connection.device_2 = null;
            connection.device_3 = null;
            connection.device_4 = null;
            connection.ior = null;
            this.build_connection(connection);
            if (n2 == n - 1) {
                this.throw_dev_failed(connection, exception, string, false);
            }
        } else {
            this.throw_dev_failed(connection, exception, string, false);
        }
    }
}

