/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl.locale;

public final class AsciiUtil {
    public static boolean caseIgnoreMatch(String s1, String s2) {
        if (s1 == s2) {
            return true;
        }
        int len = s1.length();
        if (len != s2.length()) {
            return false;
        }
        int i = 0;
        while (i < len) {
            char c2;
            char c1 = s1.charAt(i);
            if (c1 != (c2 = s2.charAt(i)) && AsciiUtil.toLower(c1) != AsciiUtil.toLower(c2)) break;
            ++i;
        }
        return i == len;
    }

    public static int caseIgnoreCompare(String s1, String s2) {
        if (s1 == s2) {
            return 0;
        }
        return AsciiUtil.toLowerString(s1).compareTo(AsciiUtil.toLowerString(s2));
    }

    public static char toUpper(char c2) {
        if (c2 >= 'a' && c2 <= 'z') {
            c2 = (char)(c2 - 32);
        }
        return c2;
    }

    public static char toLower(char c2) {
        if (c2 >= 'A' && c2 <= 'Z') {
            c2 = (char)(c2 + 32);
        }
        return c2;
    }

    public static String toLowerString(String s) {
        int idx = 0;
        while (idx < s.length()) {
            char c2 = s.charAt(idx);
            if (c2 >= 'A' && c2 <= 'Z') break;
            ++idx;
        }
        if (idx == s.length()) {
            return s;
        }
        StringBuilder buf = new StringBuilder(s.substring(0, idx));
        while (idx < s.length()) {
            buf.append(AsciiUtil.toLower(s.charAt(idx)));
            ++idx;
        }
        return buf.toString();
    }

    public static String toUpperString(String s) {
        int idx = 0;
        while (idx < s.length()) {
            char c2 = s.charAt(idx);
            if (c2 >= 'a' && c2 <= 'z') break;
            ++idx;
        }
        if (idx == s.length()) {
            return s;
        }
        StringBuilder buf = new StringBuilder(s.substring(0, idx));
        while (idx < s.length()) {
            buf.append(AsciiUtil.toUpper(s.charAt(idx)));
            ++idx;
        }
        return buf.toString();
    }

    public static String toTitleString(String s) {
        if (s.length() == 0) {
            return s;
        }
        int idx = 0;
        char c2 = s.charAt(idx);
        if (c2 < 'a' || c2 > 'z') {
            idx = 1;
            while (idx < s.length()) {
                if (c2 >= 'A' && c2 <= 'Z') break;
                ++idx;
            }
        }
        if (idx == s.length()) {
            return s;
        }
        StringBuilder buf = new StringBuilder(s.substring(0, idx));
        if (idx == 0) {
            buf.append(AsciiUtil.toUpper(s.charAt(idx)));
            ++idx;
        }
        while (idx < s.length()) {
            buf.append(AsciiUtil.toLower(s.charAt(idx)));
            ++idx;
        }
        return buf.toString();
    }

    public static boolean isAlpha(char c2) {
        return c2 >= 'A' && c2 <= 'Z' || c2 >= 'a' && c2 <= 'z';
    }

    public static boolean isAlphaString(String s) {
        boolean b2 = true;
        int i = 0;
        while (i < s.length()) {
            if (!AsciiUtil.isAlpha(s.charAt(i))) {
                b2 = false;
                break;
            }
            ++i;
        }
        return b2;
    }

    public static boolean isNumeric(char c2) {
        return c2 >= '0' && c2 <= '9';
    }

    public static boolean isNumericString(String s) {
        boolean b2 = true;
        int i = 0;
        while (i < s.length()) {
            if (!AsciiUtil.isNumeric(s.charAt(i))) {
                b2 = false;
                break;
            }
            ++i;
        }
        return b2;
    }

    public static boolean isAlphaNumeric(char c2) {
        return AsciiUtil.isAlpha(c2) || AsciiUtil.isNumeric(c2);
    }

    public static boolean isAlphaNumericString(String s) {
        boolean b2 = true;
        int i = 0;
        while (i < s.length()) {
            if (!AsciiUtil.isAlphaNumeric(s.charAt(i))) {
                b2 = false;
                break;
            }
            ++i;
        }
        return b2;
    }

    public static class CaseInsensitiveKey {
        private String _key;
        private int _hash;

        public CaseInsensitiveKey(String key) {
            this._key = key;
            this._hash = AsciiUtil.toLowerString(key).hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof CaseInsensitiveKey) {
                return AsciiUtil.caseIgnoreMatch(this._key, ((CaseInsensitiveKey)o)._key);
            }
            return false;
        }

        public int hashCode() {
            return this._hash;
        }
    }
}

